<?php
// $Id$
/**
 * @file
 * Callbacks der Administrationsseite fuer das price Modul
 */

/**
 *Formular wird erstellt
 * 
 * @ingroup forms
 * @see system_settings_form
 */
function price_admin_settings(){
	$form['form'] = array(
		'#type' => 'fieldset',
		'#title' => t('Settings'),
		
	);
	$form['form']['price_comment'] = array(
		'#type' => 'textarea',
		'#title' => t('Comment'),
		'#default_value' => variable_get('price_comment', '')
	);
	$form['form']['price_comment2'] = array(
		'#type' => 'textarea',
		'#title' => t('Comment 2'),
		'#default_value' => variable_get('price_comment2', '')
	);
	$form['form']['price_film_extra'] = array(
		'#type' => 'textarea',
		'#title' => t('Extras for film thicknesses'),
		'#default_value' => variable_get('price_film_extra', ''),
		'#description' => t('Every value in a new row.<br>(value | charge | quantity limit)<br>Example: m24w|0.7|0')
	);
	return system_settings_form($form);
}

function price_admin_relations(){
	$sql_m = "select * from {price_materials} order by weight";
	$sql_d = "select * from {price_dimensions} order by value";
	$sql_n = "select * from {price_numbers} order by value";
	$sql_c = "select * from {price_colors} order by value";
	$result_m = db_query($sql_m);
	$result_d = db_query($sql_d);
	$result_n = db_query($sql_n);
	$result_c = db_query($sql_c);
	$options_m = array();
	while($data_m = db_fetch_object($result_m)){
		$options_m[$data_m->value] = $data_m->label;
	}
	$options_d = array();
	while($data_d = db_fetch_object($result_d)){
		$options_d[$data_d->value] = $data_d->label;
	}
	$options_n = array();
	while($data_n = db_fetch_object($result_n)){
		$options_n[$data_n->value] = $data_n->label;
	}
	$options_c = array();
	while($data_c = db_fetch_object($result_c)){
		$options_c[$data_c->value] = $data_c->label;
	}
	$structure = new product_structure('backend');
	$structure->fill();
	$products = new products($structure);
	$data_list = $products->ausgabe();
	/*
	$form['new'] = array(
		'#type' => 'fieldset',
		'#title' => t('Create new relation'),
	);
	*/
	$form['materials'] = array(
		'#id' => 'price-admin-materials',
		'#type' => 'select',
		'#title' => t('Material'),
		'#options' => $options_m,
		'#size' => 10,
		'#required' => TRUE,
		'#description' => '<input type="button" class="form-submit" value="+" title="'.t('Insert material').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/materials/insert\'">'
	);
	$form['dimensions'] = array(
		'#id' => 'price-admin-dimensions',
		'#type' => 'select',
		'#title' => t('Dimensions'),
		'#options' => $options_d,
		'#size' => 10,
		'#required' => TRUE,
		'#description' => '<input type="button" class="form-submit" value="+" title="'.t('Insert dimension').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/dimensions/insert\'">'
	);
	$form['numbers'] = array(
		'#id' => 'price-admin-numbers',
		'#type' => 'select',
		'#title' => t('Numbers'),
		'#options' => $options_n,
		'#size' => 10,
		'#required' => TRUE,
		'#description' => '<input type="button" class="form-submit" value="+" title="'.t('Insert number').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/numbers/insert\'">'
	);
	$form['colors'] = array(
		'#id' => 'price-admin-colors',
		'#type' => 'select',
		'#title' => t('Colors'),
		'#options' => $options_c,
		'#size' => 10,
		'#required' => TRUE,
		'#description' => '<input type="button" class="form-submit" value="+" title="'.t('Insert color').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/colors/insert\'">'
	);
	$form['price'] = array(
		'#type' => 'textfield',
		'#title' => t('Price'),
		'#size' => 6,
		'#maxlength' => 6,
		'#required' => TRUE,
		'#description' => t('Please in the format:').' XXX.XX<br /><br /><font class="warning">* '.t('All values are required').'</font>',
		'#prefix' => '<div class="price-price">',
		'#suffix' => '</div>'
	);
	$form['submit'] = array(
		'#prefix' => '<div class="price-submit">',
		'#type' => 'submit',
		'#value' => t('Create'),
		'#suffix' => '</div><div>&nbsp;</div>'
	);
	$form['list'] = array(
		'#type' => 'fieldset',
		'#title' => t('Existing relations'),
		'#collapsible' => TRUE,
		'#collapsed' => FALSE
	);
	$form['list']['list'] = array(
		'#value' => $data_list
	);
	return $form;
}

function price_admin_relations_validate($form, &$form_state){
	$price = $form_state['values']['price'];
	$price_mp = str_replace(',','.',$price);
	$price_array = explode('.',$price_mp);
	$price_wo = str_replace('.','',$price_mp);
	if(!is_numeric($price_wo))form_set_error('price',t('Only numbers are allowed'));
	if(count($price_array)>2)form_set_error('price',t('There are allowed only one delimiter'));
	if($price_array[1]>99)form_set_error('price',t('Please respect the format'));
	//form_set_error('price','Neuer Preis: '.$price_wo);
}

function price_admin_relations_submit($form, &$form_state){
	$m = $form_state['values']['materials'];
	$d = $form_state['values']['dimensions'];
	$n = $form_state['values']['numbers'];
	$c = $form_state['values']['colors'];
	$p = $form_state['values']['price'];
	
	$price_mp = str_replace(',','.',$p);
	$price_array = explode('.',$price_mp);
	$price=$price_mp;
		
	$sql_m = "select mid from {price_materials} where value='%s'";
	$result_m = db_query($sql_m,$m);
	$data_m = db_fetch_object($result_m);
	
	$sql_d = "select did from {price_dimensions} where value='%s'";
	$result_d = db_query($sql_d,$d);
	$data_d = db_fetch_object($result_d);
	
	$sql_n = "select nid from {price_numbers} where value='%s'";
	$result_n = db_query($sql_n,$n);
	$data_n = db_fetch_object($result_n);
	
	$sql_c = "select cid from {price_colors} where value='%s'";
	$result_c = db_query($sql_c,$c);
	$data_c = db_fetch_object($result_c);
	
	$anz = db_fetch_array(db_query('SELECT COUNT(rid) as rid FROM {price_relations} where mid=%d and did=%d and nid=%d and cid=%d',$data_m->mid,$data_d->did,$data_n->nid,$data_c->cid));
	
	if($anz['rid']>0){
		form_set_error('',t('This combination already exists'));
	}else{
		$l = db_fetch_array(db_query("select max(weight) AS weight from {price_relations}"));
		$last = $l['weight'];
		$last++;
		db_query("insert into {price_relations} (mid,did,nid,cid,price,weight) values (%d,%d,%d,%d,'%s',%d)",$data_m->mid,$data_d->did,$data_n->nid,$data_c->cid,$price,$last);
	}
}

function price_admin_relations_up($rid){
	$sql = "select * from {price_relations} where rid=%d";
	$result = db_query($sql,$rid);
	$data = db_fetch_object($result);
	
	$weight = $data->weight;
	$weight--;
	
	$sql_last = "select * from {price_relations} where weight=%d";
	$result_last = db_query($sql_last,$weight);
	$data_last = db_fetch_object($result_last);
	
	db_query("update {price_relations} set weight=weight-1 where rid=%d",$rid);
	db_query("update {price_relations} set weight=weight+1 where rid=%d",$data_last->rid);
	
	drupal_goto('admin/price');	
}

function price_admin_relations_down($rid){
	$sql = "select * from {price_relations} where rid=%d";
	$result = db_query($sql,$rid);
	$data = db_fetch_object($result);
	
	$weight = $data->weight;
	$weight++;
	
	$sql_next = "select * from {price_relations} where weight=%d";
	$result_next = db_query($sql_next,$weight);
	$data_next = db_fetch_object($result_next);
	
	db_query("update {price_relations} set weight=weight+1 where rid=%d",$rid);
	db_query("update {price_relations} set weight=weight-1 where rid=%d",$data_next->rid);
	
	drupal_goto('admin/price');	
}

function price_admin_relations_default($rid){
	db_query('update {price_relations} set start=0');
	db_query('update {price_relations} set start=1 where rid=%d',$rid);
	drupal_goto('admin/price');	
}

function price_admin_relations_delete($rid){
	if(arg(5)=='yes'){
		$sql = "select * from {price_relations} where rid=%d";
		$result = db_query($sql,$rid);
		$data = db_fetch_object($result);
		db_query("update {price_relations} set weight=weight-1 where weight>%d",$data->weight);
		db_query('delete from {price_relations} where rid=%d LIMIT 1',$rid);
		drupal_set_message(t('Entry successfully deleted'));
		drupal_goto('admin/price');
	}else{
		$output = '<div class="messages warning">
		'.t('Are you sure that the entry to be deleted').'
		</div>
		<div><input class="form-submit" type="button" value="'.t('Yes').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/relations/delete/'.$rid.'/yes\'"><input class="form-submit" type="button" value="'.t('No').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/relations\'"></div>';
	}
	return $output;
}

function price_admin_materials(){
	$output = "";
	$header = array(
		t('Label'),
		t('Description'),
		array(
			'data' => t('Options'),
			'colspan'=>2
		)
	);
	$sql = "select * from {price_materials} order by weight";
	$result = db_query($sql);
	while($data = db_fetch_object($result)){
		$rows[] = array(
			$data->label,
			$data->description,
			array(
				'data' => l(t('Edit'),'admin/price/materials/edit/'.$data->mid),
				'width' => 100 
			),
			array(
				'data' => l(t('Delete'),'admin/price/materials/delete/'.$data->mid),
				'width' => 80 
			)
		);
	}
	$output .= theme('table',$header,$rows);
	$output .= '<input type="button" value="'.t('Insert material').'" class="form-submit" onclick="javascript:self.location.href=\''.base_path().'admin/price/materials/insert\'">';
	return $output;
}

function price_admin_materials_edit(){
	$mid = arg(4);
	
	$sql = "select * from {price_materials} where mid=%d";
	$result = db_query($sql,$mid);
	$data = db_fetch_object($result);
	if($data->label){
		$form['label'] = array(
			'#type' => 'textfield',
			'#title' => t('Label'),
			'#default_value' => $data->label,
			'#required' => TRUE
		);
		$form['value'] = array(
			'#type' => 'textfield',
			'#default_value' => $data->value,
			'#title' => t('Value'),
			'#required' => TRUE
		);
		$form['description'] = array(
			'#type' => 'textarea',
			'#default_value' => $data->description,
			'#title' => t('Description'),
		);
		$form['mid'] = array(
			'#type' => 'hidden',
			'#value' => $mid,
		);
		$form['submit'] = array(
			'#type' => 'submit',
			'#value' => t('Save'),
		);
		$form['reset'] = array(
			'#type' => 'reset',
			'#value' => t('Reset')
		);
		$form['cancel'] = array(
			'#value' => '<input type="button" class="form-submit" value="'.t('Cancel').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/materials\'">'
		);
		return $form;
	}else{
		form_set_error('',t('Choice of material is not available'));
		drupal_goto('admin/price/materials');
	}
}

function price_admin_materials_edit_submit($form, &$form_state){
	$mid = $form_state['values']['mid'];
	$value = $form_state['values']['value'];
	$label = $form_state['values']['label'];
	$description = $form_state['values']['description'];
	db_query("update {price_materials} set value='%s',label='%s',description='%s' where mid=%d",$value,$label,$description,$mid) ? drupal_set_message('Material saved successfully') : form_set_error('','Material could not be saved');
	drupal_goto('admin/price/materials');
}


function price_admin_materials_delete($mid){
	if(arg(5)=='yes'){
		$sql = "select * from {price_materials} where mid=%d";
		$result = db_query($sql,$mid);
		$data = db_fetch_object($result);
		db_query("update {price_materials} set weight=weight-1 where weight>%d",$data->weight);
		db_query('delete from {price_materials} where mid=%d LIMIT 1',$mid);
		drupal_set_message(t('Material successfully deleted'));
		drupal_goto('admin/price/materials');
	}else{
		$output = '<div class="messages warning">
		'.t('Are you sure that the material to be deleted').'
		</div>
		<div><input class="form-submit" type="button" value="'.t('Yes').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/materials/delete/'.$mid.'/yes\'"><input class="form-submit" type="button" value="'.t('No').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/materials\'"></div>';
	}
	return $output;
}

function price_admin_materials_insert(){
	$form['label'] = array(
		'#type' => 'textfield',
		'#title' => t('Label'),
		'#required' => TRUE
	);
	$form['value'] = array(
		'#type' => 'textfield',
		'#title' => t('Value'),
		'#required' => TRUE
	);
	$form['description'] = array(
		'#type' => 'textarea',
		'#title' => t('Description'),
	);
	
	$form['submit'] = array(
		'#type' => 'submit',
		'#value' => t('Save'),
	);
	$form['reset'] = array(
		'#type' => 'reset',
		'#value' => t('Reset')
	);
	$form['cancel'] = array(
		'#value' => '<input type="button" class="form-submit" value="'.t('Cancel').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/materials\'">'
	);
	return $form;
}

function price_admin_materials_insert_validate($form, &$form_state){
	$label = $form_state['values']['label'];
	$anz = db_fetch_array(db_query("SELECT COUNT(mid) as mid FROM {price_materials} where label='%s'",$label));
	if($anz['mid']>0){
		form_set_error('label',t('This material already exists'));
	}
}

function price_admin_materials_insert_submit($form, &$form_state){
	$value = $form_state['values']['value'];
	$label = $form_state['values']['label'];
	$description = $form_state['values']['description'];
	$l = db_fetch_array(db_query("select max(weight) AS weight from {price_materials}"));
	$last = $l['weight'];
	$last++;
	db_query("insert into {price_materials} (value,label,description,weight) values ('%s','%s','%s',%d)",$value,$label,$description,$last);
	drupal_goto('admin/price/materials');
}

function price_admin_dimensions(){
	$output = "";
	$header = array(
		t('Label'),
		t('Description'),
		array(
			'data' => t('Options'),
			'colspan'=>2
		)
	);
	$sql = "select * from {price_dimensions} order by weight";
	$result = db_query($sql);
	while($data = db_fetch_object($result)){
		$rows[] = array(
			$data->label,
			$data->description,
			array(
				'data' => l(t('Edit'),'admin/price/dimensions/edit/'.$data->did),
				'width' => 100 
			),
			array(
				'data' => l(t('Delete'),'admin/price/dimensions/delete/'.$data->did),
				'width' => 80 
			)
		);
	}
	$output .= theme('table',$header,$rows);
	$output .= '<input type="button" value="'.t('Insert dimension').'" class="form-submit" onclick="javascript:self.location.href=\''.base_path().'admin/price/dimensions/insert\'">';
	return $output;
}

function price_admin_dimensions_insert(){
	$form['label'] = array(
		'#type' => 'textfield',
		'#title' => t('Label'),
		'#required' => TRUE
	);
	$form['value'] = array(
		'#type' => 'textfield',
		'#title' => t('Value'),
		'#required' => TRUE
	);
	$form['description'] = array(
		'#type' => 'textarea',
		'#title' => t('Description'),
	);
	$form['submit'] = array(
		'#type' => 'submit',
		'#value' => t('Save'),
	);
	$form['reset'] = array(
		'#type' => 'reset',
		'#value' => t('Reset')
	);
	$form['cancel'] = array(
		'#value' => '<input type="button" class="form-submit" value="'.t('Cancel').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/dimensions\'">'
	);
	return $form;
}

function price_admin_dimensions_insert_validate($form, &$form_state){
	$label = $form_state['values']['label'];
	$anz = db_fetch_array(db_query("SELECT COUNT(did) as did FROM {price_dimensions} where label='%s'",$label));
	if($anz['did']>0){
		form_set_error('label',t('This dimension already exists'));
	}
}

function price_admin_dimensions_insert_submit($form, &$form_state){
	$value = $form_state['values']['value'];
	$label = $form_state['values']['label'];
	$description = $form_state['values']['description'];
	$l = db_fetch_array(db_query("select max(weight) AS weight from {price_dimensions}"));
	$last = $l['weight'];
	$last++;
	db_query("insert into {price_dimensions} (value,label,description,weight) values ('%s','%s','%s',%d)",$value,$label,$description,$last);
	drupal_goto('admin/price/dimensions');
}

function price_admin_dimensions_edit(){
	$did = arg(4);
	
	$sql = "select * from {price_dimensions} where did=%d";
	$result = db_query($sql,$did);
	$data = db_fetch_object($result);
	if($data->label){
		$form['label'] = array(
			'#type' => 'textfield',
			'#title' => t('Label'),
			'#default_value' => $data->label,
			'#required' => TRUE
		);
		$form['value'] = array(
			'#type' => 'textfield',
			'#default_value' => $data->value,
			'#title' => t('Value'),
			'#required' => TRUE
		);
		$form['description'] = array(
			'#type' => 'textarea',
			'#default_value' => $data->description,
			'#title' => t('Description'),
		);
		$form['did'] = array(
			'#type' => 'hidden',
			'#value' => $did,
		);
		$form['submit'] = array(
			'#type' => 'submit',
			'#value' => t('Save'),
		);
		$form['reset'] = array(
			'#type' => 'reset',
			'#value' => t('Reset')
		);
		$form['cancel'] = array(
			'#value' => '<input type="button" class="form-submit" value="'.t('Cancel').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/dimensions\'">'
		);
		return $form;
	}else{
		form_set_error('',t('Choice of dimension is not available'));
		drupal_goto('admin/price/dimensions');
	}
}

function price_admin_dimensions_edit_submit($form, &$form_state){
	$did = $form_state['values']['did'];
	$value = $form_state['values']['value'];
	$label = $form_state['values']['label'];
	$description = $form_state['values']['description'];
	db_query("update {price_dimensions} set value='%s',label='%s',description='%s' where did=%d",$value,$label,$description,$did) ? drupal_set_message('Dimension saved successfully') : form_set_error('','Dimension could not be saved');
	drupal_goto('admin/price/dimensions');
}

function price_admin_dimensions_delete($did){
	if(arg(5)=='yes'){
		$sql = "select * from {price_dimensions} where did=%d";
		$result = db_query($sql,$mid);
		$data = db_fetch_object($result);
		db_query("update {price_dimensions} set weight=weight-1 where weight>%d",$data->weight);
		db_query('delete from {price_dimensions} where did=%d LIMIT 1',$did);
		drupal_set_message(t('Dimension successfully deleted'));
		drupal_goto('admin/price/dimensions');
	}else{
		$output = '<div class="messages warning">
		'.t('Are you sure that the dimension to be deleted').'
		</div>
		<div><input class="form-submit" type="button" value="'.t('Yes').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/dimensions/delete/'.$did.'/yes\'"><input class="form-submit" type="button" value="'.t('No').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/dimensions\'"></div>';
	}
	return $output;
}

function price_admin_numbers(){
	$output = "";
	$header = array(
		t('Label'),
		t('Description'),
		array(
			'data' => t('Options'),
			'colspan'=>2
		)
	);
	$sql = "select * from {price_numbers} order by weight";
	$result = db_query($sql);
	while($data = db_fetch_object($result)){
		$rows[] = array(
			$data->label,
			$data->description,
			array(
				'data' => l(t('Edit'),'admin/price/numbers/edit/'.$data->nid),
				'width' => 100 
			),
			array(
				'data' => l(t('Delete'),'admin/price/numbers/delete/'.$data->nid),
				'width' => 80 
			)
		);
	}
	$output .= theme('table',$header,$rows);
	$output .= '<input type="button" value="'.t('Insert number').'" class="form-submit" onclick="javascript:self.location.href=\''.base_path().'admin/price/numbers/insert\'">';
	return $output;
}

function price_admin_numbers_insert(){
	$form['label'] = array(
		'#type' => 'textfield',
		'#title' => t('Label'),
		'#required' => TRUE
	);
	$form['value'] = array(
		'#type' => 'textfield',
		'#title' => t('Value'),
		'#required' => TRUE
	);
	$form['description'] = array(
		'#type' => 'textarea',
		'#title' => t('Description'),
	);
	$form['submit'] = array(
		'#type' => 'submit',
		'#value' => t('Save'),
	);
	$form['reset'] = array(
		'#type' => 'reset',
		'#value' => t('Reset')
	);
	$form['cancel'] = array(
		'#value' => '<input type="button" class="form-submit" value="'.t('Cancel').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/numbers\'">'
	);
	return $form;
}

function price_admin_numbers_insert_validate($form, &$form_state){
	$label = $form_state['values']['label'];
	$anz = db_fetch_array(db_query("SELECT COUNT(nid) as nid FROM {price_numbers} where label='%s'",$label));
	if($anz['nid']>0){
		form_set_error('label',t('This number already exists'));
	}
}

function price_admin_numbers_insert_submit($form, &$form_state){
	$value = $form_state['values']['value'];
	$label = $form_state['values']['label'];
	$description = $form_state['values']['description'];
	$l = db_fetch_array(db_query("select max(weight) AS weight from {price_numbers}"));
	$last = $l['weight'];
	$last++;
	db_query("insert into {price_numbers} (value,label,description,weight) values ('%s','%s','%s',%d)",$value,$label,$description,$last);
	drupal_goto('admin/price/numbers');
}

function price_admin_numbers_edit(){
	$nid = arg(4);
	
	$sql = "select * from {price_numbers} where nid=%d";
	$result = db_query($sql,$nid);
	$data = db_fetch_object($result);
	if($data->label){
		$form['label'] = array(
			'#type' => 'textfield',
			'#title' => t('Label'),
			'#default_value' => $data->label,
			'#required' => TRUE
		);
		$form['value'] = array(
			'#type' => 'textfield',
			'#default_value' => $data->value,
			'#title' => t('Value'),
			'#required' => TRUE
		);
		$form['description'] = array(
			'#type' => 'textarea',
			'#default_value' => $data->description,
			'#title' => t('Description'),
		);
		$form['nid'] = array(
			'#type' => 'hidden',
			'#value' => $nid,
		);
		$form['submit'] = array(
			'#type' => 'submit',
			'#value' => t('Save'),
		);
		$form['reset'] = array(
			'#type' => 'reset',
			'#value' => t('Reset')
		);
		$form['cancel'] = array(
			'#value' => '<input type="button" class="form-submit" value="'.t('Cancel').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/numbers\'">'
		);
		return $form;
	}else{
		form_set_error('',t('Choice of number is not available'));
		drupal_goto('admin/price/numbers');
	}
}

function price_admin_numbers_edit_submit($form, &$form_state){
	$nid = $form_state['values']['nid'];
	$value = $form_state['values']['value'];
	$label = $form_state['values']['label'];
	$description = $form_state['values']['description'];
	db_query("update {price_numbers} set value='%s',label='%s',description='%s' where nid=%d",$value,$label,$description,$nid) ? drupal_set_message('Number saved successfully') : form_set_error('','Number could not be saved');
	drupal_goto('admin/price/numbers');
}

function price_admin_numbers_delete($nid){
	if(arg(5)=='yes'){
		$sql = "select * from {price_numbers} where nid=%d";
		$result = db_query($sql,$nid);
		$data = db_fetch_object($result);
		db_query("update {price_numbers} set weight=weight-1 where weight>%d",$data->weight);
		db_query('delete from {price_numbers} where nid=%d LIMIT 1',$nid);
		drupal_set_message(t('Dimension successfully deleted'));
		drupal_goto('admin/price/dimensions');
	}else{
		$output = '<div class="messages warning">
		'.t('Are you sure that the dimension to be deleted').'
		</div>
		<div><input class="form-submit" type="button" value="'.t('Yes').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/numbers/delete/'.$did.'/yes\'"><input class="form-submit" type="button" value="'.t('No').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/numbers\'"></div>';
	}
	return $output;
}

function price_admin_colors(){
	$output = "";
	$header = array(
		t('Label'),
		t('Description'),
		array(
			'data' => t('Options'),
			'colspan'=>2
		)
	);
	$sql = "select * from {price_colors} order by weight";
	$result = db_query($sql);
	while($data = db_fetch_object($result)){
		$rows[] = array(
			$data->label,
			$data->description,
			array(
				'data' => l(t('Edit'),'admin/price/colors/edit/'.$data->cid),
				'width' => 100 
			),
			array(
				'data' => l(t('Delete'),'admin/price/colors/delete/'.$data->cid),
				'width' => 80 
			)
		);
	}
	$output .= theme('table',$header,$rows);
	$output .= '<input type="button" value="'.t('Insert color').'" class="form-submit" onclick="javascript:self.location.href=\''.base_path().'admin/price/colors/insert\'">';
	return $output;
}

function price_admin_colors_insert(){
	$form['label'] = array(
		'#type' => 'textfield',
		'#title' => t('Label'),
		'#required' => TRUE
	);
	$form['value'] = array(
		'#type' => 'textfield',
		'#title' => t('Value'),
		'#required' => TRUE
	);
	$form['description'] = array(
		'#type' => 'textarea',
		'#title' => t('Description'),
	);
	$form['submit'] = array(
		'#type' => 'submit',
		'#value' => t('Save'),
	);
	$form['reset'] = array(
		'#type' => 'reset',
		'#value' => t('Reset')
	);
	$form['cancel'] = array(
		'#value' => '<input type="button" class="form-submit" value="'.t('Cancel').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/colors\'">'
	);
	return $form;
}

function price_admin_colors_insert_validate($form, &$form_state){
	$label = $form_state['values']['label'];
	$anz = db_fetch_array(db_query("SELECT COUNT(cid) as cid FROM {price_colors} where label='%s'",$label));
	if($anz['cid']>0){
		form_set_error('label',t('This color already exists'));
	}
}

function price_admin_colors_insert_submit($form, &$form_state){
	$value = $form_state['values']['value'];
	$label = $form_state['values']['label'];
	$description = $form_state['values']['description'];
	$l = db_fetch_array(db_query("select max(weight) AS weight from {price_colors}"));
	$last = $l['weight'];
	$last++;
	db_query("insert into {price_colors} (value,label,description,weight) values ('%s','%s','%s',%d)",$value,$label,$description,$last);
	drupal_goto('admin/price');
}

function price_admin_colors_edit(){
	$cid = arg(4);
	
	$sql = "select * from {price_colors} where cid=%d";
	$result = db_query($sql,$cid);
	$data = db_fetch_object($result);
	if($data->label){
		$form['label'] = array(
			'#type' => 'textfield',
			'#title' => t('Label'),
			'#default_value' => $data->label,
			'#required' => TRUE
		);
		$form['value'] = array(
			'#type' => 'textfield',
			'#default_value' => $data->value,
			'#title' => t('Value'),
			'#required' => TRUE
		);
		$form['description'] = array(
			'#type' => 'textarea',
			'#default_value' => $data->description,
			'#title' => t('Description'),
		);
		$form['cid'] = array(
			'#type' => 'hidden',
			'#value' => $cid,
		);
		$form['submit'] = array(
			'#type' => 'submit',
			'#value' => t('Save'),
		);
		$form['reset'] = array(
			'#type' => 'reset',
			'#value' => t('Reset')
		);
		$form['cancel'] = array(
			'#value' => '<input type="button" class="form-submit" value="'.t('Cancel').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/colors\'">'
		);
		return $form;
	}else{
		form_set_error('',t('Choice of color is not available'));
		drupal_goto('admin/price/colors');
	}
}

function price_admin_colors_edit_submit($form, &$form_state){
	$cid = $form_state['values']['cid'];
	$value = $form_state['values']['value'];
	$label = $form_state['values']['label'];
	$description = $form_state['values']['description'];
	db_query("update {price_colors} set value='%s',label='%s',description='%s' where cid=%d",$value,$label,$description,$cid) ? drupal_set_message('Color saved successfully') : form_set_error('','Color could not be saved');
	drupal_goto('admin/price/colors');
}

function price_admin_colors_delete($cid){
	if(arg(5)=='yes'){
		$sql = "select * from {price_colors} where cid=%d";
		$result = db_query($sql,$cid);
		$data = db_fetch_object($result);
		db_query("update {price_colors} set weight=weight-1 where weight>%d",$data->weight);
		db_query('delete from {price_colors} where cid=%d LIMIT 1',$cid);
		drupal_set_message(t('Color successfully deleted'));
		drupal_goto('admin/price/colors');
	}else{
		$output = '<div class="messages warning">
		'.t('Are you sure that the color to be deleted').'
		</div>
		<div><input class="form-submit" type="button" value="'.t('Yes').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/colors/delete/'.$cid.'/yes\'"><input class="form-submit" type="button" value="'.t('No').'" onclick="javascript:self.location.href=\''.base_path().'admin/price/colors\'"></div>';
	}
	return $output;
}

function price_admin_import(){
	$form['info'] = array(
		'#type' => 'markup',
		'#value' => t('Select a file to import.<br>
		Permitted formats are SQL, XLS, CSV and ZIP<br>
		The format of the file is automatically detected. In a ZIP file only CSV files will be accepted.'),
		'#prefix' => '<div class="price_admin_import_info">',
		'#suffix' => '</div>'
	);
	$form['file'] = array(
		'#type' => 'file',
		'#title' => t('Import file'),
		'#description' => t('Currently only supports CSV files. (Alternatively, several files packed in ZIP format)')
	);
	$form['submit'] = array(
		'#type' => 'submit',
		'#value' => t('Import')
	);
	$form['#attributes'] = array(
		'enctype'=>'multipart/form-data'
	);
	return $form;
}

function price_admin_import_validate($form, &$form_state){
	//
}

function price_admin_import_submit($form, &$form_state){
	$type = $_FILES['files']['type']['file'];
	//Tabellenname generieren
	$file_array = explode('.',$_FILES['files']['name']['file']);
	array_pop($file_array);
	$table = '{price_'.implode('.',$file_array).'}';
	if($type=='application/zip'){
		parse_csv($zipfile,'zip',TRUE);
	}elseif($type=='text/csv'){
		parse_csv($table,'csv',FALSE);	
	}else{
		form_set_error('','File not identified or incorrect file type');
	}
}

function parse_csv($table,$type,$delete=FALSE){
	$nl = chr(13).chr(10);
		if($type=='csv'){
		
			if(db_table_exists($table)){
				if($delete){
					$sql = "TRUNCATE TABLE ".$table;
					db_query($sql);
				}
				$handle = fopen($_FILES['files']['tmp_name']['file'],"r");
				$row_count=0;
				$count = 0;
				while ($data = @fgetcsv ($handle, @filesize($_FILES['files']['tmp_name']['file']), ';')) {
					if($row_count==0){
						$key_array = $data;
					}else{
						$data_array = array();
						foreach($data as $da){
							is_numeric($da) ? $data_string = $da : $data_string = "'".$da."'";
							array_push($data_array,str_replace(',','.',$data_string));
						}
						$sql_string = @implode(',',$data_array);
						$sql_check = "SELECT * FROM ".$table." where ".$key_array[0]."=".$data[0];
						$result_check = @db_query($sql_check);
						$data_check = @db_fetch_object($result_check);
						if(!$data_check->$key_array[0]){
							$sql = "insert into ".$table." (".@implode(',',$key_array).") value (".$sql_string.")";
							@db_query($sql);
							$count++;
						}
					}
					$row_count++;
				}
				drupal_set_message(t('@records of @records_total Records were updated.',array('@records'=>$count,'@records_total'=>$row_count-1)));
				@fclose($handle);
			}else{
				$table_name = str_replace('{price_','',$table);
				$table_name = str_replace('}','',$table_name);
				form_set_error('',t('The selected table "@table_name" does not exist.<br>Check the file name.',array('@table_name'=>$table_name)));
			}
		
		}elseif($type=='zip'){
			$zip = zip_open($_FILES['files']['tmp_name']['file']);
			while ($zip_entry = zip_read($zip)){
	            $completeName = zip_entry_name($zip_entry);
	           
	            if (zip_entry_open($zip, $zip_entry, "r")){
	            	$table_array = explode('.',$completeName);
					array_pop($table_array);
					$table = '{price_'.implode('.',$table_array).'}';
	            	
					if(db_table_exists($table)){
						$table_name = str_replace('{price_','',$table);
						$table_name = str_replace('}','',$table_name);
						if($delete){
							$sql = "TRUNCATE TABLE ".$table;
							db_query($sql) ? drupal_set_message(t('Table "<b>@table_name</b>" has been emptied',array('@table_name'=>$table_name))) : NULL;
						}
						$inhalt = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));
		            	$content_array = explode($nl,$inhalt);
		            	$row_count=0;
		            	$count=0;
		            	foreach($content_array as $tmp){
		            		$data = explode(';',$tmp);
		            		if($row_count==0){
								$key_array = $data;
								$row_count++;
							}else{
								if($data[0]!=""){
									$data_array = array();
									foreach($data as $da){
										is_numeric($da) ? $data_string = $da : $data_string = "'".$da."'";
										array_push($data_array,str_replace(',','.',$data_string));
									}
									$sql_string = @implode(',',$data_array);
									$sql_check = "SELECT * FROM ".$table." where ".$key_array[0]."=".$data[0];
									$result_check = @db_query($sql_check);
									$data_check = @db_fetch_object($result_check);
									if(!$data_check->$key_array[0]){
										$sql = "insert into ".$table." (".@implode(',',$key_array).") value (".$sql_string.")";
										@db_query($sql);
										$count++;
									}
									$row_count++;
								}
							}
		            	}
		            	drupal_set_message(t('@records of @records_total Records were updated in Table @table_name.',array('@records'=>$count,'@records_total'=>$row_count-1,'@table_name'=>$table_name)));
	            	}else{
						drupal_set_message(t('The selected table "@table_name" does not exist.<br>Check the file name.',array('@table_name'=>$table_name)));
					}
	                zip_entry_close($zip_entry);
	            }
	        }
	        zip_close($zip);
		}
}

function price_admin_export(){
	$sql_r = "select count(rid) as rid from {price_relations}";
	$sql_m = "select count(mid) as mid from {price_materials}";
	$sql_d = "select count(did) as did from {price_dimensions}";
	$sql_n = "select count(nid) as nid from {price_numbers}";
	$sql_c = "select count(cid) as cid from {price_colors}";
	$result_r = db_query($sql_r);
	$result_m = db_query($sql_m);
	$result_d = db_query($sql_d);
	$result_n = db_query($sql_n);
	$result_c = db_query($sql_c);
	$data_r = db_fetch_object($result_r);
	$data_m = db_fetch_object($result_m);
	$data_d = db_fetch_object($result_d);
	$data_n = db_fetch_object($result_n);
	$data_c = db_fetch_object($result_c);
	$form['relations'] = array(
		'#type' => 'fieldset',
		'#title' => t('Relations'),
		
	);
	$form['content'] = array(
		'#type' => 'fieldset',
		'#title' => t('Content'),
		
	);
	$form['relations']['relations'] = array(
		'#type' => 'markup',
		'#value' => $data_r->rid.t(' relations are available.').'&nbsp;'.l(t('Show relations'),'admin/price/relations'),
		'#prefix' => '<div>',
		'#suffix' => '</div>'
	);
	$form['content']['materials'] = array(
		'#type' => 'markup',
		'#value' => $data_m->mid.t(' materials are available.').'&nbsp;'.l(t('Show materials'),'admin/price/materials'),
		'#prefix' => '<div>',
		'#suffix' => '</div>'
	);
	$form['content']['dimensions'] = array(
		'#type' => 'markup',
		'#value' => $data_d->did.t(' dimensions are available.').'&nbsp;'.l(t('Show dimensions'),'admin/price/dimensions'),
		'#prefix' => '<div>',
		'#suffix' => '</div>'
	);
	$form['content']['numbers'] = array(
		'#type' => 'markup',
		'#value' => $data_n->nid.t(' numbers are available.').'&nbsp;'.l(t('Show numbers'),'admin/price/numbers'),
		'#prefix' => '<div>',
		'#suffix' => '</div>'
	);
	$form['content']['colors'] = array(
		'#type' => 'markup',
		'#value' => $data_c->cid.t(' colors are available.').'&nbsp;'.l(t('Show colors'),'admin/price/colors'),
		'#prefix' => '<div>',
		'#suffix' => '</div>'
	);
	//$options = array('sql'=>'SQL','csv'=>'CSV','xls'=>'Excel');
	$options = array('csv'=>'CSV');
	$form['art'] = array(
		'#type' => 'radios',
		'#title' => t('Export format'),
		'#options' => $options,
		'#required' => TRUE,
		'#description' => t('Currently only supports CSV files. (Multiple files packed in ZIP format)'),
		'#default_value' => 'csv'
	);
	$form['submit'] = array(
		'#type' => 'submit',
		'#value' => t('Export')
	);
	//$form = array();
	return $form;
}

function price_admin_export_submit($form, &$form_state){
	$nl = chr(13).chr(10);
	$art = "csv";
	if($art == "sql"){
		//Header festlegen
		$head_main = "SET SQL_MODE=\"NO_AUTO_VALUE_ON_ZERO\";".$nl.$nl.$nl."/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;".$nl."/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;".$nl."/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;".$nl."/*!40101 SET NAMES utf8 */;".$nl.$nl."-- --------------------------------------------------------".$nl.$nl;
		$head_colors = "--".$nl."-- Tabellenstruktur fr Tabelle `price_colors`".$nl."--".$nl.$nl.
		"DROP TABLE IF EXISTS `price_colors`;".$nl."CREATE TABLE IF NOT EXISTS `price_colors` (".$nl."`cid` int(10) unsigned NOT NULL auto_increment,".$nl."`label` varchar(50) NOT NULL default '',".$nl."`value` varchar(50) NOT NULL default '',".$nl."`description` text,".$nl."`weight` int(11) NOT NULL default '0',".$nl."PRIMARY KEY  (`cid`)".$nl.") ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;".$nl.$nl;
		$head_dimensions = "--".$nl."-- Tabellenstruktur fr Tabelle `price_dimensions`".$nl."--".$nl.$nl.
		"DROP TABLE IF EXISTS `price_dimensions`;".$nl."CREATE TABLE IF NOT EXISTS `price_dimensions` (".$nl."`did` int(10) unsigned NOT NULL auto_increment,".$nl."`label` varchar(50) NOT NULL default '',".$nl."`value` varchar(50) NOT NULL default '',".$nl."`description` text,".$nl."`weight` int(11) NOT NULL default '0',".$nl."PRIMARY KEY  (`did`)".$nl.") ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;".$nl.$nl;
		$head_materials = "--".$nl."-- Tabellenstruktur fr Tabelle `price_materials`".$nl."--".$nl.$nl.
		"DROP TABLE IF EXISTS `price_materials`;".$nl."CREATE TABLE IF NOT EXISTS `price_materials` (".$nl."`mid` int(10) unsigned NOT NULL auto_increment,".$nl."`label` varchar(50) NOT NULL default '',".$nl."`value` varchar(50) NOT NULL default '',".$nl."`description` text,".$nl."`weight` int(11) NOT NULL default '0',".$nl."PRIMARY KEY  (`mid`)".$nl.") ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;".$nl.$nl;
		$head_numbers = "--".$nl."-- Tabellenstruktur fr Tabelle `price_numbers`".$nl."--".$nl.$nl.
		"DROP TABLE IF EXISTS `price_numbers`;".$nl."CREATE TABLE IF NOT EXISTS `price_numbers` (".$nl."`nid` int(10) unsigned NOT NULL auto_increment,".$nl."`label` varchar(50) NOT NULL default '',".$nl."`value` varchar(50) NOT NULL default '',".$nl."`description` text,".$nl."`weight` int(11) NOT NULL default '0',".$nl."PRIMARY KEY  (`nid`)".$nl.") ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;".$nl.$nl;
		$head_relations = "--".$nl."-- Tabellenstruktur fr Tabelle `price_relations`".$nl."--".$nl.$nl.
		"DROP TABLE IF EXISTS `price_relations`;".$nl."CREATE TABLE IF NOT EXISTS `price_relations` (".$nl."`rid` int(10) unsigned NOT NULL auto_increment,".$nl."`mid` int(11) NOT NULL default '0',".$nl."`did` int(11) NOT NULL default '0',".$nl."`nid` int(11) NOT NULL default '0',".$nl."`cid` int(11) NOT NULL default '0',".$nl."`price` float NOT NULL default '0',".$nl."`start` int(1) NOT NULL default '0',".$nl."`weight` int(10) NOT NULL,".$nl."PRIMARY KEY  (`rid`)".$nl.") ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;".$nl.$nl;
		//Colors
		$sql_colors = "select * from {price_colors} order by cid";
		$result_colors = db_query($sql_colors);
		$content_colors = array();
		while($data_colors = db_fetch_object($result_colors)){
			array_push($content_colors,"(".$data_colors->cid.", '".$data_colors->label."', '".$data_colors->value."', '".$data_colors->description."', ".$data_colors->weight.")");
		}
		//Dimensions
		$sql_dimensions = "select * from {price_dimensions} order by did";
		$result_dimensions = db_query($sql_dimensions);
		$content_dimensions = array();
		while($data_dimensions = db_fetch_object($result_dimensions)){
			array_push($content_dimensions,"(".$data_dimensions->did.", '".$data_dimensions->label."', '".$data_dimensions->value."', '".$data_dimensions->description."', ".$data_dimensions->weight.")");
		}
		//Materials
		$sql_materials = "select * from {price_materials} order by mid";
		$result_materials = db_query($sql_materials);
		$content_materials = array();
		while($data_materials = db_fetch_object($result_materials)){
			array_push($content_materials,"(".$data_materials->mid.", '".$data_materials->label."', '".$data_materials->value."', '".$data_materials->description."', ".$data_materials->weight.")");
		}
		//Numbers
		$sql_numbers = "select * from {price_numbers} order by nid";
		$result_numbers = db_query($sql_numbers);
		$content_numbers = array();
		while($data_numbers = db_fetch_object($result_numbers)){
			array_push($content_numbers,"(".$data_numbers->nid.", '".$data_numbers->label."', '".$data_numbers->value."', '".$data_numbers->description."', ".$data_numbers->weight.")");
		}
		//Relationen
		$sql_relations = "select * from {price_relations} order by rid";
		$result_relations = db_query($sql_relations);
		$content_relations = array();
		while($data_relations = db_fetch_object($result_relations)){
			array_push($content_relations,"(".$data_relations->rid.", ".$data_relations->mid.", ".$data_relations->did.", ".$data_relations->nid.", ".$data_relations->cid.", ".$data_relations->price.", ".$data_relations->start.", ".$data_relations->weight.")");
		}
		//ZIP Datei zusammenstellen
		$filename = "PriceCalculatorExport_".date('d-m-Y_H-i-s').".sql";
		$file .= $head_main.$head_colors;
		$file .= "--".$nl."-- Daten fr Tabelle `price_colors`".$nl."--".$nl.$nl;
		$file .= "INSERT INTO `price_colors` (`cid`, `label`, `value`, `description`, `weight`) VALUES ".$nl;
		$file .= implode(','.$nl,$content_colors);
		$file .= ';';
		
		$file .= $nl.$nl.$head_dimensions;
		$file .= "--".$nl."-- Daten fr Tabelle `price_dimensions`".$nl."--".$nl.$nl;
		$file .= "INSERT INTO `price_dimensions` (`did`, `label`, `value`, `description`, `weight`) VALUES ".$nl;
		$file .= implode(','.$nl,$content_dimensions);
		$file .= ';';
		
		$file .= $nl.$nl.$head_materials;
		$file .= "--".$nl."-- Daten fr Tabelle `price_materials`".$nl."--".$nl.$nl;
		$file .= "INSERT INTO `price_materials` (`mid`, `label`, `value`, `description`, `weight`) VALUES ".$nl;
		$file .= implode(','.$nl,$content_materials);
		$file .= ';';
		
		$file .= $nl.$nl.$head_numbers;
		$file .= "--".$nl."-- Daten fr Tabelle `price_numbers`".$nl."--".$nl.$nl;
		$file .= "INSERT INTO `price_numbers` (`nid`, `label`, `value`, `description`, `weight`) VALUES ".$nl;
		$file .= implode(','.$nl,$content_numbers);
		$file .= ';';
		
		$file .= $nl.$nl.$head_relations;
		$file .= "--".$nl."-- Daten fr Tabelle `price_relations`".$nl."--".$nl.$nl;
		$file .= "INSERT INTO `price_relations` (`rid`, `mid`, `did`, `nid`, `cid`, `price`, `start`, `weight`) VALUES ".$nl;
		$file .= implode(','.$nl,$content_relations);
		$file .= ';';
		
		//Datei in ZIP-Archiv packen
		header("HTTP/1.1 200 OK");
		header("Content-Type: application/force-download");
		header('Content-Disposition: attachment; filename="'.$filename.'"');
		header("Content-Transfer-Encoding: binary");
		print $file;
		die();
	}elseif($art=="csv"){
		$zipfile = new zipfile();
		$zip_filename = 'PriceCalculatorExport_'.date('d-m-Y_H-i-s').'.zip';
		
		$head_relations = array('rid','mid','did','nid','cid','price','start','weight');
		$head_colors = array('cid','label','value','description','weight');
		$head_dimensions = array('did','label','value','description','weight');
		$head_materials = array('mid','label','value','description','weight');
		$head_numbers = array('nid','label','value','description','weight');
		
		$header_relations = implode(';',$head_relations);
		$header_colors = implode(';',$head_colors);
		$header_dimensions = implode(';',$head_dimensions);
		$header_materials = implode(';',$head_materials);
		$header_numbers = implode(';',$head_numbers);
		
		//Relations
		$sql = "SELECT * FROM {price_relations} ORDER BY rid";
		$result = db_query($sql);
		$content = array();
		while($data = db_fetch_object($result)){
			$content[] = array($data->rid,$data->mid,$data->did,$data->nid,$data->cid,str_replace('.',',',$data->price),$data->start,$data->weight);
		}
		$file = $header_relations.$nl;
		foreach ($content as $row) {
			$file .= implode(';',$row).$nl;
	  	}
		$zipfile->addFile($file, 'relations.csv', NULL);
		
		//Colors
		$sql = "SELECT * FROM {price_colors} ORDER BY cid";
		$result = db_query($sql);
		$content = array();
		while($data = db_fetch_object($result)){
			$content[] = array($data->cid,$data->label,$data->value,$data->description,$data->weight);
		}
		$file = $header_colors.$nl;
		foreach ($content as $row) {
			$file .= implode(';',$row).$nl;
	  	}
		$zipfile->addFile($file, 'colors.csv', NULL);
		
		//Dimensions
		$sql = "SELECT * FROM {price_dimensions} ORDER BY did";
		$result = db_query($sql);
		$content = array();
		while($data = db_fetch_object($result)){
			$content[] = array($data->did,$data->label,$data->value,$data->description,$data->weight);
		}
		$file = $header_dimensions.$nl;
		foreach ($content as $row) {
			$file .= implode(';',$row).$nl;
	  	}
		$zipfile->addFile($file, 'dimensions.csv', NULL);
		
		//Materials
		$sql = "SELECT * FROM {price_materials} ORDER BY mid";
		$result = db_query($sql);
		$content = array();
		while($data = db_fetch_object($result)){
			$content[] = array($data->mid,$data->label,$data->value,$data->description,$data->weight);
		}
		$file = $header_materials.$nl;
		foreach ($content as $row) {
			$file .= implode(';',$row).$nl;
	  	}
		$zipfile->addFile($file, 'materials.csv', NULL);
		
		//Numbers
		$sql = "SELECT * FROM {price_numbers} ORDER BY nid";
		$result = db_query($sql);
		$content = array();
		while($data = db_fetch_object($result)){
			$content[] = array($data->nid,$data->label,$data->value,$data->description,$data->weight);
		}
		$file = $header_numbers.$nl;
		foreach ($content as $row) {
			$file .= implode(';',$row).$nl;
	  	}
		$zipfile->addFile($file, 'numbers.csv', NULL);
		
		//Header fr ZIP File generieren
		header("HTTP/1.1 200 OK");
		header("Content-Type: application/force-download");
		header('Content-Disposition: attachment; filename="'.$zip_filename.'"');
		header("Content-Transfer-Encoding: binary");
		//Zip File senden
		print $zipfile->file();
		die();
	}elseif($art=="xls"){
		require_once (drupal_get_path('module', 'price') .'/inc/PHPExcel.php');
		// Create new PHPExcel object
		$XLS = new PHPExcel();
		// Set properties
		
		$XLS->getProperties()->setCreator("Harold")
									 ->setLastModifiedBy("Harold")
									 ->setTitle("Export")
									 ->setSubject("Export")
									 ->setDescription("Aktuelle Datenbanken exportieren.")
									 ->setKeywords("Harold Export Datenbank Tabellen")
									 ->setCategory("Exports");
		
		$XLS->getActiveSheet()->setTitle('Relations');
		$XLS->setActiveSheetIndex(0);
		
		$colors_sheet = $XLS->createSheet();
		$colors_sheet->setTitle('Colors');
		
		$dimensions_sheet = $XLS->createSheet();
		$dimensions_sheet->setTitle('Dimensions');
		
		$materials_sheet = $XLS->createSheet();
		$materials_sheet->setTitle('Materials');
		
		$numbers_sheet = $XLS->createSheet();
		$numbers_sheet->setTitle('Numbers');
		
		//Relations
		$XLS->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'rid')
		            ->setCellValue('B1', 'mid')
		            ->setCellValue('C1', 'did')
		            ->setCellValue('D1', 'nid')
		            ->setCellValue('E1', 'cid')
		            ->setCellValue('F1', 'price')
		            ->setCellValue('G1', 'start')
		            ->setCellValue('H1', 'weight');
		$cnt=2;
		$sql = "select * from {price_relations} order by cid";
		$result = db_query($sql);
		while($data = db_fetch_object($result)){
			$XLS->setActiveSheetIndex(0)
		            ->setCellValue('A'.$cnt, $data->rid)
		            ->setCellValue('B'.$cnt, $data->mid)
		            ->setCellValue('C'.$cnt, $data->did)
		            ->setCellValue('D'.$cnt, $data->nid)
		            ->setCellValue('E'.$cnt, $data->cid)
		            ->setCellValue('F'.$cnt, $data->price)
		            ->setCellValue('G'.$cnt, $data->start)
		            ->setCellValue('H'.$cnt, $data->weight);
		    $cnt++;
		}
		//Colors
		$XLS->setActiveSheetIndex(1)
		            ->setCellValue('A1', 'cid')
		            ->setCellValue('B1', 'label')
		            ->setCellValue('C1', 'value')
		            ->setCellValue('D1', 'description')
		            ->setCellValue('E1', 'weight');
		$cnt=2;
		$sql = "select * from {price_colors} order by cid";
		$result = db_query($sql);
		while($data = db_fetch_object($result)){
			$XLS->setActiveSheetIndex(1)
		            ->setCellValue('A'.$cnt, $data->cid)
		            ->setCellValue('B'.$cnt, $data->label)
		            ->setCellValue('C'.$cnt, $data->value)
		            ->setCellValue('D'.$cnt, $data->description)
		            ->setCellValue('E'.$cnt, $data->weight);
		    $cnt++;
		}
		//Dimensions
		$XLS->setActiveSheetIndex(2)
		            ->setCellValue('A1', 'did')
		            ->setCellValue('B1', 'label')
		            ->setCellValue('C1', 'value')
		            ->setCellValue('D1', 'description')
		            ->setCellValue('E1', 'weight');
		$cnt=2;
		$sql = "select * from {price_dimensions} order by did";
		$result = db_query($sql);
		while($data = db_fetch_object($result)){
			$XLS->setActiveSheetIndex(2)
		            ->setCellValue('A'.$cnt, $data->did)
		            ->setCellValue('B'.$cnt, $data->label)
		            ->setCellValue('C'.$cnt, $data->value)
		            ->setCellValue('D'.$cnt, $data->description)
		            ->setCellValue('E'.$cnt, $data->weight);
		    $cnt++;
		}
		//Materials
		$XLS->setActiveSheetIndex(3)
		            ->setCellValue('A1', 'mid')
		            ->setCellValue('B1', 'label')
		            ->setCellValue('C1', 'value')
		            ->setCellValue('D1', 'description')
		            ->setCellValue('E1', 'weight');
		$cnt=2;
		$sql = "select * from {price_materials} order by mid";
		$result = db_query($sql);
		while($data = db_fetch_object($result)){
			$XLS->setActiveSheetIndex(3)
		            ->setCellValue('A'.$cnt, $data->mid)
		            ->setCellValue('B'.$cnt, $data->label)
		            ->setCellValue('C'.$cnt, $data->value)
		            ->setCellValue('D'.$cnt, $data->description)
		            ->setCellValue('E'.$cnt, $data->weight);
		    $cnt++;
		}
		//Numbers
		$XLS->setActiveSheetIndex(4)
		            ->setCellValue('A1', 'nid')
		            ->setCellValue('B1', 'label')
		            ->setCellValue('C1', 'value')
		            ->setCellValue('D1', 'description')
		            ->setCellValue('E1', 'weight');
		$cnt=2;
		$sql = "select * from {price_numbers} order by nid";
		$result = db_query($sql);
		while($data = db_fetch_object($result)){
			$XLS->setActiveSheetIndex(4)
		            ->setCellValue('A'.$cnt, $data->nid)
		            ->setCellValue('B'.$cnt, $data->label)
		            ->setCellValue('C'.$cnt, $data->value)
		            ->setCellValue('D'.$cnt, $data->description)
		            ->setCellValue('E'.$cnt, $data->weight);
		    $cnt++;
		}
		$XLS->setActiveSheetIndex(0);
		//Excel Datei ausgeben
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="PriceCalculatorExport_'.date('d-m-Y_H-i-s').'.xls"');
		header('Cache-Control: max-age=0');
		$objWriter = PHPExcel_IOFactory::createWriter($XLS, 'Excel5');
		$objWriter->save('php://output');
		die();
	}else{
		die();
	}
}