
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE=NO_AUTO_VALUE_ON_ZERO */;

SET NAMES utf8;
DROP TABLE IF EXISTS `access`;
CREATE TABLE `access` (   `aid` int(11) NOT NULL auto_increment,   `mask` varchar(255) NOT NULL default '',   `type` varchar(255) NOT NULL default '',   `status` tinyint(4) NOT NULL default '0',   PRIMARY KEY  (`aid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `actions`;
CREATE TABLE `actions` (   `aid` varchar(255) NOT NULL default '0',   `type` varchar(32) NOT NULL default '',   `callback` varchar(255) NOT NULL default '',   `parameters` longtext NOT NULL,   `description` varchar(255) NOT NULL default '0',   PRIMARY KEY  (`aid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `actions` VALUES ('backup_migrate_backup_action','system','backup_migrate_backup_action','','Backup the database with the default settings');
INSERT INTO `actions` VALUES ('comment_publish_action','comment','comment_publish_action','','Kommentar veröffentlichen');
INSERT INTO `actions` VALUES ('comment_unpublish_action','comment','comment_unpublish_action','','Kommentar zurücknehmen');
INSERT INTO `actions` VALUES ('node_make_sticky_action','node','node_make_sticky_action','','Beitrag an den Anfang von Listen setzen');
INSERT INTO `actions` VALUES ('node_make_unsticky_action','node','node_make_unsticky_action','','Beitrag nicht mehr am Anfang von Listen anzeigen');
INSERT INTO `actions` VALUES ('node_promote_action','node','node_promote_action','','Beitrag auf der Startseite anzeigen');
INSERT INTO `actions` VALUES ('node_publish_action','node','node_publish_action','','Beitrag veröffentlichen');
INSERT INTO `actions` VALUES ('node_save_action','node','node_save_action','','Beitrag speichern');
INSERT INTO `actions` VALUES ('node_unpromote_action','node','node_unpromote_action','','Beitrag von der Startseite entfernen');
INSERT INTO `actions` VALUES ('node_unpublish_action','node','node_unpublish_action','','Beitragsveröffentlichung zurückziehen');
INSERT INTO `actions` VALUES ('user_block_ip_action','user','user_block_ip_action','','IP Adresse des aktuellen Benutzers bannen');
INSERT INTO `actions` VALUES ('user_block_user_action','user','user_block_user_action','','Aktuellen Benutzer sperren');
INSERT INTO `actions` VALUES ('views_bulk_operations_delete_comment_action','comment','views_bulk_operations_delete_comment_action','','Kommentar löschen');
INSERT INTO `actions` VALUES ('views_bulk_operations_delete_node_action','node','views_bulk_operations_delete_node_action','','Delete node');
INSERT INTO `actions` VALUES ('views_bulk_operations_delete_user_action','user','views_bulk_operations_delete_user_action','','Delete user');
INSERT INTO `actions` VALUES ('views_bulk_operations_ruleset_action_rules_set_1','node','views_bulk_operations_ruleset_action_rules_set_1','','Example: Empty rule set working with content');
DROP TABLE IF EXISTS `actions_aid`;
CREATE TABLE `actions_aid` (   `aid` int(10) unsigned NOT NULL auto_increment,   PRIMARY KEY  (`aid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `authmap`;
CREATE TABLE `authmap` (   `aid` int(10) unsigned NOT NULL auto_increment,   `uid` int(11) NOT NULL default '0',   `authname` varchar(128) NOT NULL default '',   `module` varchar(128) NOT NULL default '',   PRIMARY KEY  (`aid`),   UNIQUE KEY `authname` (`authname`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `batch`;
CREATE TABLE `batch` (   `bid` int(10) unsigned NOT NULL auto_increment,   `token` varchar(64) NOT NULL,   `timestamp` int(11) NOT NULL,   `batch` longtext,   PRIMARY KEY  (`bid`),   KEY `token` (`token`) ) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 AUTO_INCREMENT=14;
INSERT INTO `batch` VALUES ('5','','1280320679',null);
INSERT INTO `batch` VALUES ('6','','1280322572',null);
INSERT INTO `batch` VALUES ('8','','1280324025',null);
INSERT INTO `batch` VALUES ('9','','1280497875',null);
INSERT INTO `batch` VALUES ('10','','1280499978',null);
INSERT INTO `batch` VALUES ('11','','1280923228',null);
INSERT INTO `batch` VALUES ('12','','1280940511',null);
INSERT INTO `batch` VALUES ('13','','1280946286',null);
DROP TABLE IF EXISTS `blocks`;
CREATE TABLE `blocks` (   `bid` int(11) NOT NULL auto_increment,   `module` varchar(64) NOT NULL default '',   `delta` varchar(32) NOT NULL default '0',   `theme` varchar(64) NOT NULL default '',   `status` tinyint(4) NOT NULL default '0',   `weight` tinyint(4) NOT NULL default '0',   `region` varchar(64) NOT NULL default '',   `custom` tinyint(4) NOT NULL default '0',   `throttle` tinyint(4) NOT NULL default '0',   `visibility` tinyint(4) NOT NULL default '0',   `pages` text NOT NULL,   `title` varchar(64) NOT NULL default '',   `cache` tinyint(4) NOT NULL default '1',   PRIMARY KEY  (`bid`),   UNIQUE KEY `tmd` (`theme`,`module`,`delta`),   KEY `list` (`theme`,`status`,`region`,`weight`,`module`) ) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 AUTO_INCREMENT=66;
INSERT INTO `blocks` VALUES ('1','user','0','garland','1','0','left','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('2','user','1','garland','1','0','left','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('3','system','0','garland','1','10','footer','0','0','0','','<none>','-1');
INSERT INTO `blocks` VALUES ('4','system','0','rootcandy','1','10','footer','0','0','0','','<none>','-1');
INSERT INTO `blocks` VALUES ('5','user','0','rootcandy','1','-10','admin_left','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('6','user','1','rootcandy','1','-9','admin_left','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('7','user','0','harold','0','-9','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('8','user','1','harold','1','-10','left','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('9','system','0','harold','0','-11','','0','0','0','','<none>','-1');
INSERT INTO `blocks` VALUES ('10','system','0','minnelli','1','10','footer','0','0','0','','<none>','-1');
INSERT INTO `blocks` VALUES ('11','user','0','minnelli','1','0','left','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('12','user','1','minnelli','1','0','left','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('13','comment','0','garland','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('14','locale','0','garland','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('15','menu','devel','garland','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('16','menu','primary-links','garland','0','0','','0','0','0','','<none>','-1');
INSERT INTO `blocks` VALUES ('17','menu','secondary-links','garland','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('18','node','0','garland','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('19','user','2','garland','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('20','user','3','garland','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('21','devel','0','garland','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('22','devel','2','garland','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('23','comment','0','harold','0','-6','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('24','locale','0','harold','0','1','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('25','menu','devel','harold','0','-5','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('26','menu','primary-links','harold','0','-8','','0','0','0','','<none>','-1');
INSERT INTO `blocks` VALUES ('27','menu','secondary-links','harold','0','-4','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('28','node','0','harold','0','-1','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('29','user','2','harold','0','-7','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('30','user','3','harold','0','4','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('31','devel','0','harold','0','2','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('32','devel','2','harold','0','-10','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('33','menu_block','1','harold','1','-8','header','0','0','0','','<none>','-1');
INSERT INTO `blocks` VALUES ('34','menu_block','2','harold','1','-12','left','0','0','0','','<none>','-1');
INSERT INTO `blocks` VALUES ('35','addtoany','0','harold','0','-15','','0','0','0','','<none>','1');
INSERT INTO `blocks` VALUES ('36','block','1','harold','0','3','','0','0','0','','<none>','-1');
INSERT INTO `blocks` VALUES ('37','views','slideshow-block_1','harold','1','-9','slide','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('38','devel_node_access','0','harold','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('39','devel_node_access','1','harold','0','-3','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('40','block','1','rootcandy','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('41','comment','0','rootcandy','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('42','locale','0','rootcandy','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('43','menu','devel','rootcandy','1','0','admin_left','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('44','menu','primary-links','rootcandy','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('45','menu','secondary-links','rootcandy','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('46','node','0','rootcandy','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('47','user','2','rootcandy','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('48','user','3','rootcandy','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('49','addtoany','0','rootcandy','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('50','devel_node_access','0','rootcandy','1','0','footer','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('51','devel_node_access','1','rootcandy','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('52','menu_block','1','rootcandy','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('53','menu_block','2','rootcandy','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('54','views','slideshow-block_1','rootcandy','0','0','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('55','devel','0','rootcandy','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('56','devel','2','rootcandy','0','0','','0','0','0','','','1');
INSERT INTO `blocks` VALUES ('57','views','slideshow-block_2','harold','0','-12','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('58','views','slideshow-block_3','harold','0','-15','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('59','views','slideshow-block_4','harold','0','-14','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('60','views','slideshow-block_5','harold','0','-13','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('61','block','2','harold','0','-2','','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('62','views','Referenzen-block_1','harold','1','-13','left','0','0','1','*referenzen*','Referenzen','-1');
INSERT INTO `blocks` VALUES ('63','menu_block','3','harold','1','-14','left','0','0','1','<front>','<none>','-1');
INSERT INTO `blocks` VALUES ('64','menu','menu-verwaltung','harold','1','-11','left','0','0','0','','','-1');
INSERT INTO `blocks` VALUES ('65','service_links','0','harold','1','0','footer','0','0','0','','<none>','1');
DROP TABLE IF EXISTS `blocks_roles`;
CREATE TABLE `blocks_roles` (   `module` varchar(64) NOT NULL,   `delta` varchar(32) NOT NULL,   `rid` int(10) unsigned NOT NULL,   PRIMARY KEY  (`module`,`delta`,`rid`),   KEY `rid` (`rid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `blocks_roles` VALUES ('menu','menu-verwaltung','2');
INSERT INTO `blocks_roles` VALUES ('user','1','2');
INSERT INTO `blocks_roles` VALUES ('menu','menu-verwaltung','3');
DROP TABLE IF EXISTS `boxes`;
CREATE TABLE `boxes` (   `bid` int(10) unsigned NOT NULL auto_increment,   `body` longtext,   `info` varchar(128) NOT NULL default '',   `format` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`bid`),   UNIQUE KEY `info` (`info`) ) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 AUTO_INCREMENT=3;
INSERT INTO `boxes` VALUES ('1','<div class=\"a2a_kit a2a_default_style\">\r\n    <a class=\"a2a_button_facebook\"></a>\r\n    <a class=\"a2a_button_twitter\"></a>\r\n    <a class=\"a2a_button_delicious\"></a>\r\n    <a class=\"a2a_dd\" href=\"http://www.addtoany.com/share_save\">\r\n        <img src=\"http://static.addtoany.com/buttons/share_save_171_16.png\" border=\"0\" alt=\"Share\"/>\r\n    </a>\r\n</div>','social','1');
INSERT INTO `boxes` VALUES ('2','<?print views_embed_view(\'slideshow\');?>','php','3');
DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cache_block`;
CREATE TABLE `cache_block` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cache_content`;
CREATE TABLE `cache_content` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `cache_content` VALUES ('content:10:10','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";N;}}}','0','1281004232','','1');
INSERT INTO `cache_content` VALUES ('content:11:11','a:5:{s:11:\"field_slide\";a:4:{i:0;a:10:{s:3:\"fid\";s:2:\"18\";s:4:\"list\";s:1:\"1\";s:4:\"data\";a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:16:\"DSC05472_710.JPG\";s:8:\"filepath\";s:36:\"sites/default/files/DSC05472_710.JPG\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"86606\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1280932101\";}i:1;a:10:{s:3:\"fid\";s:2:\"21\";s:4:\"list\";s:1:\"1\";s:4:\"data\";a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:19:\"Stoffbutton_710.jpg\";s:8:\"filepath\";s:39:\"sites/default/files/Stoffbutton_710.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"83369\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1280932127\";}i:2;a:10:{s:3:\"fid\";s:2:\"25\";s:4:\"list\";s:1:\"1\";s:4:\"data\";a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:18:\"DSC01354_710_2.JPG\";s:8:\"filepath\";s:38:\"sites/default/files/DSC01354_710_2.JPG\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"74314\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1280933045\";}i:3;a:10:{s:3:\"fid\";s:2:\"22\";s:4:\"list\";s:1:\"1\";s:4:\"data\";a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:20:\"Buttons 03_710_2.jpg\";s:8:\"filepath\";s:40:\"sites/default/files/Buttons 03_710_2.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"69104\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1280932135\";}}s:13:\"field_slide_2\";a:2:{i:0;a:10:{s:3:\"fid\";s:2:\"23\";s:4:\"list\";s:1:\"1\";s:4:\"data\";a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:18:\"Druckbutton 04.jpg\";s:8:\"filepath\";s:38:\"sites/default/files/Druckbutton 04.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:7:\"1758502\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1280932169\";}i:1;a:10:{s:3:\"fid\";s:2:\"24\";s:4:\"list\";s:1:\"1\";s:4:\"data\";a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:12:\"DSC05472.JPG\";s:8:\"filepath\";s:32:\"sites/default/files/DSC05472.JPG\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:7:\"2425462\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1280932222\";}}s:13:\"field_slide_3\";a:1:{i:0;N;}s:13:\"field_slide_4\";a:1:{i:0;N;}s:13:\"field_slide_5\";a:1:{i:0;N;}}','0','1281003626','','1');
INSERT INTO `cache_content` VALUES ('content:12:12','a:1:{s:11:\"field_image\";a:1:{i:0;a:10:{s:3:\"fid\";s:2:\"26\";s:4:\"list\";s:1:\"1\";s:4:\"data\";a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:21:\"Druckbutton 05_70.jpg\";s:8:\"filepath\";s:41:\"sites/default/files/Druckbutton 05_70.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10911\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1280999736\";}}}','0','1281012359','','1');
INSERT INTO `cache_content` VALUES ('content:15:15','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";N;}}}','0','1281007597','','1');
INSERT INTO `cache_content` VALUES ('content:18:18','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"1 \";}}}','0','1281003993','','1');
INSERT INTO `cache_content` VALUES ('content:19:19','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"1 \";}}}','0','1281004252','','1');
INSERT INTO `cache_content` VALUES ('content:1:1','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"1 \";}}}','0','1281003989','','1');
INSERT INTO `cache_content` VALUES ('content:23:23','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"1 \";}}}','0','1281003982','','1');
INSERT INTO `cache_content` VALUES ('content:24:24','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"1 \";}}}','0','1281008159','','1');
INSERT INTO `cache_content` VALUES ('content:25:25','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"1 \";}}}','0','1281011959','','1');
INSERT INTO `cache_content` VALUES ('content:2:2','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"2 \";}}}','0','1281004371','','1');
INSERT INTO `cache_content` VALUES ('content:5:5','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";N;}}}','0','1281008374','','1');
INSERT INTO `cache_content` VALUES ('content:6:6','a:1:{s:17:\"field_slid_select\";a:1:{i:0;a:1:{s:5:\"value\";N;}}}','0','1281003991','','1');
INSERT INTO `cache_content` VALUES ('content_type_info','a:4:{s:11:\"field types\";a:9:{s:13:\"nodereference\";a:4:{s:5:\"label\";s:14:\"Node reference\";s:11:\"description\";s:51:\"Store the ID of a related node as an integer value.\";s:6:\"module\";s:13:\"nodereference\";s:10:\"formatters\";a:4:{s:7:\"default\";a:4:{s:5:\"label\";s:12:\"Title (link)\";s:11:\"field types\";a:1:{i:0;s:13:\"nodereference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"nodereference\";}s:5:\"plain\";a:4:{s:5:\"label\";s:15:\"Title (no link)\";s:11:\"field types\";a:1:{i:0;s:13:\"nodereference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"nodereference\";}s:4:\"full\";a:4:{s:5:\"label\";s:9:\"Full node\";s:11:\"field types\";a:1:{i:0;s:13:\"nodereference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"nodereference\";}s:6:\"teaser\";a:4:{s:5:\"label\";s:10:\"Anrisstext\";s:11:\"field types\";a:1:{i:0;s:13:\"nodereference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"nodereference\";}}}s:14:\"number_integer\";a:4:{s:5:\"label\";s:7:\"Integer\";s:11:\"description\";s:45:\"Store a number in the database as an integer.\";s:6:\"module\";s:6:\"number\";s:10:\"formatters\";a:5:{s:7:\"default\";a:4:{s:5:\"label\";s:4:\"9999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"us_0\";a:4:{s:5:\"label\";s:5:\"9,999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"be_0\";a:4:{s:5:\"label\";s:5:\"9.999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"fr_0\";a:4:{s:5:\"label\";s:5:\"9 999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:11:\"unformatted\";a:4:{s:5:\"label\";s:11:\"unformatted\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}}}s:14:\"number_decimal\";a:4:{s:5:\"label\";s:7:\"Decimal\";s:11:\"description\";s:57:\"Store a number in the database in a fixed decimal format.\";s:6:\"module\";s:6:\"number\";s:10:\"formatters\";a:11:{s:7:\"default\";a:4:{s:5:\"label\";s:4:\"9999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"us_0\";a:4:{s:5:\"label\";s:5:\"9,999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"us_1\";a:4:{s:5:\"label\";s:7:\"9,999.9\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"us_2\";a:4:{s:5:\"label\";s:8:\"9,999.99\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"be_0\";a:4:{s:5:\"label\";s:5:\"9.999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"be_1\";a:4:{s:5:\"label\";s:7:\"9.999,9\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"be_2\";a:4:{s:5:\"label\";s:8:\"9.999,99\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"fr_0\";a:4:{s:5:\"label\";s:5:\"9 999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"fr_1\";a:4:{s:5:\"label\";s:8:\"9 999, 9\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"fr_2\";a:4:{s:5:\"label\";s:9:\"9 999, 99\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:11:\"unformatted\";a:4:{s:5:\"label\";s:11:\"unformatted\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}}}s:12:\"number_float\";a:4:{s:5:\"label\";s:5:\"Float\";s:11:\"description\";s:58:\"Store a number in the database in a floating point format.\";s:6:\"module\";s:6:\"number\";s:10:\"formatters\";a:11:{s:7:\"default\";a:4:{s:5:\"label\";s:4:\"9999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"us_0\";a:4:{s:5:\"label\";s:5:\"9,999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"us_1\";a:4:{s:5:\"label\";s:7:\"9,999.9\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"us_2\";a:4:{s:5:\"label\";s:8:\"9,999.99\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"be_0\";a:4:{s:5:\"label\";s:5:\"9.999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"be_1\";a:4:{s:5:\"label\";s:7:\"9.999,9\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"be_2\";a:4:{s:5:\"label\";s:8:\"9.999,99\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"fr_0\";a:4:{s:5:\"label\";s:5:\"9 999\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"fr_1\";a:4:{s:5:\"label\";s:8:\"9 999, 9\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:4:\"fr_2\";a:4:{s:5:\"label\";s:9:\"9 999, 99\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}s:11:\"unformatted\";a:4:{s:5:\"label\";s:11:\"unformatted\";s:15:\"multiple values\";i:1;s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:6:\"module\";s:6:\"number\";}}}s:4:\"text\";a:4:{s:5:\"label\";s:4:\"Text\";s:11:\"description\";s:27:\"Store text in the database.\";s:6:\"module\";s:4:\"text\";s:10:\"formatters\";a:3:{s:7:\"default\";a:4:{s:5:\"label\";s:8:\"Standard\";s:11:\"field types\";a:1:{i:0;s:4:\"text\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"text\";}s:5:\"plain\";a:4:{s:5:\"label\";s:10:\"Plain text\";s:11:\"field types\";a:1:{i:0;s:4:\"text\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"text\";}s:7:\"trimmed\";a:4:{s:5:\"label\";s:7:\"Trimmed\";s:11:\"field types\";a:1:{i:0;s:4:\"text\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"text\";}}}s:13:\"userreference\";a:4:{s:5:\"label\";s:14:\"User reference\";s:11:\"description\";s:51:\"Store the ID of a related user as an integer value.\";s:6:\"module\";s:13:\"userreference\";s:10:\"formatters\";a:2:{s:7:\"default\";a:4:{s:5:\"label\";s:8:\"Standard\";s:11:\"field types\";a:1:{i:0;s:13:\"userreference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"userreference\";}s:5:\"plain\";a:4:{s:5:\"label\";s:10:\"Plain text\";s:11:\"field types\";a:1:{i:0;s:13:\"userreference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"userreference\";}}}s:9:\"filefield\";a:4:{s:5:\"label\";s:4:\"File\";s:11:\"description\";s:24:\"Store an arbitrary file.\";s:6:\"module\";s:9:\"filefield\";s:10:\"formatters\";a:16:{s:7:\"default\";a:5:{s:5:\"label\";s:13:\"Generic files\";s:11:\"field types\";a:1:{i:0;s:9:\"filefield\";}s:15:\"multiple values\";i:1;s:11:\"description\";s:71:\"Displays all kinds of files with an icon and a linked file description.\";s:6:\"module\";s:9:\"filefield\";}s:10:\"path_plain\";a:4:{s:5:\"label\";s:12:\"Path to file\";s:11:\"field types\";a:1:{i:0;s:9:\"filefield\";}s:11:\"description\";s:42:\"Displays the file system path to the file.\";s:6:\"module\";s:9:\"filefield\";}s:9:\"url_plain\";a:4:{s:5:\"label\";s:11:\"URL to file\";s:11:\"field types\";a:1:{i:0;s:9:\"filefield\";}s:11:\"description\";s:32:\"Displays a full URL to the file.\";s:6:\"module\";s:9:\"filefield\";}s:12:\"logo_default\";a:3:{s:5:\"label\";s:10:\"logo image\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:11:\"logo_linked\";a:3:{s:5:\"label\";s:25:\"logo image linked to node\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:14:\"logo_imagelink\";a:3:{s:5:\"label\";s:26:\"logo image linked to image\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:9:\"logo_path\";a:3:{s:5:\"label\";s:14:\"logo file path\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:8:\"logo_url\";a:3:{s:5:\"label\";s:8:\"logo URL\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:13:\"slide_default\";a:3:{s:5:\"label\";s:11:\"slide image\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:12:\"slide_linked\";a:3:{s:5:\"label\";s:26:\"slide image linked to node\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:15:\"slide_imagelink\";a:3:{s:5:\"label\";s:27:\"slide image linked to image\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:10:\"slide_path\";a:3:{s:5:\"label\";s:15:\"slide file path\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:9:\"slide_url\";a:3:{s:5:\"label\";s:9:\"slide URL\";s:11:\"field types\";a:2:{i:0;s:5:\"image\";i:1;s:9:\"filefield\";}s:6:\"module\";s:10:\"imagecache\";}s:11:\"image_plain\";a:4:{s:5:\"label\";s:5:\"Image\";s:11:\"field types\";a:1:{i:0;s:9:\"filefield\";}s:11:\"description\";s:44:\"Displays image files in their original size.\";s:6:\"module\";s:10:\"imagefield\";}s:14:\"image_nodelink\";a:4:{s:5:\"label\";s:20:\"Image linked to node\";s:11:\"field types\";a:1:{i:0;s:9:\"filefield\";}s:11:\"description\";s:44:\"Displays image files in their original size.\";s:6:\"module\";s:10:\"imagefield\";}s:15:\"image_imagelink\";a:4:{s:5:\"label\";s:20:\"Image linked to file\";s:11:\"field types\";a:1:{i:0;s:9:\"filefield\";}s:11:\"description\";s:44:\"Displays image files in their original size.\";s:6:\"module\";s:10:\"imagefield\";}}}s:4:\"link\";a:4:{s:5:\"label\";s:4:\"Link\";s:11:\"description\";s:71:\"Store a title, href, and attributes in the database to assemble a link.\";s:6:\"module\";s:4:\"link\";s:10:\"formatters\";a:6:{s:7:\"default\";a:4:{s:5:\"label\";s:24:\"Title, as link (default)\";s:11:\"field types\";a:1:{i:0;s:4:\"link\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"link\";}s:3:\"url\";a:4:{s:5:\"label\";s:12:\"URL, as link\";s:11:\"field types\";a:1:{i:0;s:4:\"link\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"link\";}s:5:\"plain\";a:4:{s:5:\"label\";s:18:\"URL, as plain text\";s:11:\"field types\";a:1:{i:0;s:4:\"link\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"link\";}s:5:\"short\";a:4:{s:5:\"label\";s:32:\"Short, as link with title \"Link\"\";s:11:\"field types\";a:1:{i:0;s:4:\"link\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"link\";}s:5:\"label\";a:4:{s:5:\"label\";s:34:\"Label, as link with label as title\";s:11:\"field types\";a:1:{i:0;s:4:\"link\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"link\";}s:8:\"separate\";a:4:{s:5:\"label\";s:22:\"Separate title and URL\";s:11:\"field types\";a:1:{i:0;s:4:\"link\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"link\";}}}s:13:\"viewreference\";a:5:{s:5:\"label\";s:14:\"View reference\";s:11:\"description\";s:67:\"Store an internal identifer for a related view as an integer value.\";s:9:\"callbacks\";a:2:{s:6:\"tables\";i:2;s:9:\"arguments\";i:2;}s:6:\"module\";s:13:\"viewreference\";s:10:\"formatters\";a:4:{s:7:\"default\";a:4:{s:5:\"label\";s:14:\"Default (view)\";s:11:\"field types\";a:1:{i:0;s:13:\"viewreference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"viewreference\";}s:4:\"full\";a:4:{s:5:\"label\";s:21:\"Full (title and view)\";s:11:\"field types\";a:1:{i:0;s:13:\"viewreference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"viewreference\";}s:5:\"plain\";a:4:{s:5:\"label\";s:15:\"Title (no link)\";s:11:\"field types\";a:1:{i:0;s:13:\"viewreference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"viewreference\";}s:4:\"link\";a:4:{s:5:\"label\";s:12:\"Title (link)\";s:11:\"field types\";a:1:{i:0;s:13:\"viewreference\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:13:\"viewreference\";}}}}s:12:\"widget types\";a:17:{s:20:\"nodereference_select\";a:5:{s:5:\"label\";s:11:\"Select list\";s:11:\"field types\";a:1:{i:0;s:13:\"nodereference\";}s:15:\"multiple values\";i:2;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"nodereference\";}s:21:\"nodereference_buttons\";a:5:{s:5:\"label\";s:25:\"Check boxes/radio buttons\";s:11:\"field types\";a:1:{i:0;s:13:\"nodereference\";}s:15:\"multiple values\";i:2;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"nodereference\";}s:26:\"nodereference_autocomplete\";a:5:{s:5:\"label\";s:23:\"Autocomplete text field\";s:11:\"field types\";a:1:{i:0;s:13:\"nodereference\";}s:15:\"multiple values\";i:1;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"nodereference\";}s:6:\"number\";a:5:{s:5:\"label\";s:10:\"Text field\";s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:15:\"multiple values\";i:1;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:6:\"number\";}s:20:\"optionwidgets_select\";a:5:{s:5:\"label\";s:11:\"Select list\";s:11:\"field types\";a:4:{i:0;s:4:\"text\";i:1;s:14:\"number_integer\";i:2;s:14:\"number_decimal\";i:3;s:12:\"number_float\";}s:15:\"multiple values\";i:2;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"optionwidgets\";}s:21:\"optionwidgets_buttons\";a:5:{s:5:\"label\";s:25:\"Check boxes/radio buttons\";s:11:\"field types\";a:4:{i:0;s:4:\"text\";i:1;s:14:\"number_integer\";i:2;s:14:\"number_decimal\";i:3;s:12:\"number_float\";}s:15:\"multiple values\";i:2;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"optionwidgets\";}s:19:\"optionwidgets_onoff\";a:5:{s:5:\"label\";s:22:\"Single on/off checkbox\";s:11:\"field types\";a:4:{i:0;s:4:\"text\";i:1;s:14:\"number_integer\";i:2;s:14:\"number_decimal\";i:3;s:12:\"number_float\";}s:15:\"multiple values\";i:2;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"optionwidgets\";}s:14:\"text_textfield\";a:5:{s:5:\"label\";s:10:\"Text field\";s:11:\"field types\";a:1:{i:0;s:4:\"text\";}s:15:\"multiple values\";i:1;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:4:\"text\";}s:13:\"text_textarea\";a:5:{s:5:\"label\";s:25:\"Text area (multiple rows)\";s:11:\"field types\";a:1:{i:0;s:4:\"text\";}s:15:\"multiple values\";i:1;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:4:\"text\";}s:20:\"userreference_select\";a:5:{s:5:\"label\";s:11:\"Select list\";s:11:\"field types\";a:1:{i:0;s:13:\"userreference\";}s:15:\"multiple values\";i:2;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"userreference\";}s:21:\"userreference_buttons\";a:5:{s:5:\"label\";s:25:\"Check boxes/radio buttons\";s:11:\"field types\";a:1:{i:0;s:13:\"userreference\";}s:15:\"multiple values\";i:2;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"userreference\";}s:26:\"userreference_autocomplete\";a:5:{s:5:\"label\";s:23:\"Autocomplete text field\";s:11:\"field types\";a:1:{i:0;s:13:\"userreference\";}s:15:\"multiple values\";i:1;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"userreference\";}s:16:\"filefield_widget\";a:6:{s:5:\"label\";s:11:\"File Upload\";s:11:\"field types\";a:1:{i:0;s:9:\"filefield\";}s:15:\"multiple values\";i:1;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:4;}s:11:\"description\";s:27:\"A plain file upload widget.\";s:6:\"module\";s:9:\"filefield\";}s:17:\"imagefield_widget\";a:6:{s:5:\"label\";s:5:\"Image\";s:11:\"field types\";a:1:{i:0;s:9:\"filefield\";}s:15:\"multiple values\";i:1;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:4;}s:11:\"description\";s:65:\"An edit widget for image files, including a preview of the image.\";s:6:\"module\";s:10:\"imagefield\";}s:4:\"link\";a:4:{s:5:\"label\";s:4:\"Link\";s:11:\"field types\";a:1:{i:0;s:4:\"link\";}s:15:\"multiple values\";i:1;s:6:\"module\";s:4:\"link\";}s:20:\"viewreference_select\";a:5:{s:5:\"label\";s:11:\"Select list\";s:11:\"field types\";a:1:{i:0;s:13:\"viewreference\";}s:15:\"multiple values\";i:1;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"viewreference\";}s:26:\"viewreference_autocomplete\";a:5:{s:5:\"label\";s:23:\"Autocomplete text field\";s:11:\"field types\";a:1:{i:0;s:13:\"viewreference\";}s:15:\"multiple values\";i:1;s:9:\"callbacks\";a:1:{s:13:\"default value\";i:2;}s:6:\"module\";s:13:\"viewreference\";}}s:6:\"fields\";a:7:{s:17:\"field_slid_select\";a:35:{s:10:\"field_name\";s:17:\"field_slid_select\";s:9:\"type_name\";s:4:\"page\";s:16:\"display_settings\";a:6:{s:6:\"weight\";s:2:\"31\";s:6:\"parent\";s:0:\"\";s:5:\"label\";a:1:{s:6:\"format\";s:6:\"hidden\";}s:6:\"teaser\";a:2:{s:6:\"format\";s:6:\"hidden\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:6:\"hidden\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:4:\"text\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"0\";s:10:\"db_storage\";s:1:\"1\";s:6:\"module\";s:4:\"text\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:1:{s:5:\"value\";a:5:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;s:8:\"sortable\";b:1;s:5:\"views\";b:1;}}s:15:\"text_processing\";s:1:\"0\";s:10:\"max_length\";s:0:\"\";s:14:\"allowed_values\";s:63:\"1 | slide 1\r\n2 | slide 2\r\n3 | slide 3\r\n4 | slide 4\r\n5 | slide 5\";s:18:\"allowed_values_php\";s:0:\"\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:3:\"div\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:2:\"h3\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:1:\":\";s:33:\"semantic_cck_label_element_inline\";s:4:\"span\";s:35:\"semantic_cck_multiple_items_element\";s:3:\"div\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:3:\"div\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:3:\"div\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:5:\"first\";s:23:\"semantic_cck_last_class\";s:4:\"last\";s:29:\"semantic_cck_striping_classes\";s:8:\"odd even\";s:6:\"widget\";a:8:{s:34:\"semantic_cck_use_semantic_instance\";i:0;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"1 \";}}s:17:\"default_value_php\";N;s:5:\"label\";s:17:\"Slideshow Auswahl\";s:6:\"weight\";s:2:\"31\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:21:\"optionwidgets_buttons\";s:6:\"module\";s:13:\"optionwidgets\";}}s:11:\"field_image\";a:34:{s:10:\"field_name\";s:11:\"field_image\";s:9:\"type_name\";s:3:\"ref\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"0\";s:10:\"db_storage\";s:1:\"1\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:5:\"image\";s:6:\"weight\";s:2:\"31\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}s:11:\"field_slide\";a:34:{s:10:\"field_name\";s:11:\"field_slide\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:9:\"slideshow\";s:6:\"weight\";s:2:\"31\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}s:13:\"field_slide_2\";a:34:{s:10:\"field_name\";s:13:\"field_slide_2\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:3:\"div\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:2:\"h3\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:1:\":\";s:33:\"semantic_cck_label_element_inline\";s:4:\"span\";s:35:\"semantic_cck_multiple_items_element\";s:3:\"div\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:3:\"div\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:3:\"div\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:5:\"first\";s:23:\"semantic_cck_last_class\";s:4:\"last\";s:29:\"semantic_cck_striping_classes\";s:8:\"odd even\";s:6:\"widget\";a:19:{s:15:\"file_extensions\";s:12:\"gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:34:\"semantic_cck_use_semantic_instance\";i:0;s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:17:\"use_default_image\";i:0;s:5:\"label\";s:11:\"slideshow_2\";s:6:\"weight\";s:2:\"32\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}s:13:\"field_slide_3\";a:34:{s:10:\"field_name\";s:13:\"field_slide_3\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:11:\"slideshow_3\";s:6:\"weight\";s:2:\"33\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}s:13:\"field_slide_4\";a:34:{s:10:\"field_name\";s:13:\"field_slide_4\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:11:\"slideshow_4\";s:6:\"weight\";s:2:\"34\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}s:13:\"field_slide_5\";a:34:{s:10:\"field_name\";s:13:\"field_slide_5\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:11:\"slideshow_5\";s:6:\"weight\";s:2:\"35\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}}s:13:\"content types\";a:6:{s:7:\"webform\";a:19:{s:4:\"name\";s:7:\"Webform\";s:6:\"module\";s:7:\"webform\";s:11:\"description\";s:138:\"Create a new form or questionnaire accessible to users. Submission results and statistics are recorded and accessible to privileged users.\";s:4:\"type\";s:7:\"webform\";s:9:\"has_title\";b:1;s:11:\"title_label\";s:5:\"Titel\";s:8:\"has_body\";b:1;s:10:\"body_label\";s:11:\"Textkörper\";s:4:\"help\";s:0:\"\";s:14:\"min_word_count\";i:0;s:6:\"custom\";b:0;s:8:\"modified\";b:0;s:6:\"locked\";b:1;s:9:\"orig_type\";s:7:\"webform\";s:6:\"is_new\";b:1;s:7:\"url_str\";s:7:\"webform\";s:6:\"fields\";a:0:{}s:6:\"tables\";a:0:{}s:5:\"extra\";a:7:{s:7:\"webform\";a:3:{s:5:\"label\";s:7:\"Webform\";s:11:\"description\";s:29:\"Webform settings and display.\";s:6:\"weight\";i:1;}s:5:\"title\";a:3:{s:5:\"label\";s:5:\"Titel\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";i:-5;}s:10:\"body_field\";a:4:{s:5:\"label\";s:11:\"Textkörper\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";i:0;s:4:\"view\";s:4:\"body\";}s:20:\"revision_information\";a:3:{s:5:\"label\";s:19:\"Versionsinformation\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";i:20;}s:16:\"comment_settings\";a:3:{s:5:\"label\";s:22:\"Kommentareinstellungen\";s:11:\"description\";s:20:\"Comment module form.\";s:6:\"weight\";i:30;}s:4:\"menu\";a:3:{s:5:\"label\";s:18:\"Menüeinstellungen\";s:11:\"description\";s:17:\"Menu module form.\";s:6:\"weight\";i:-2;}s:4:\"path\";a:3:{s:5:\"label\";s:13:\"Path settings\";s:11:\"description\";s:17:\"Path module form.\";s:6:\"weight\";i:30;}}}s:5:\"panel\";a:18:{s:4:\"type\";s:5:\"panel\";s:4:\"name\";s:5:\"Panel\";s:6:\"module\";s:11:\"panels_node\";s:11:\"description\";s:60:\"Ein Panel-Layout, dass in Reihen und Spalten aufgeteilt ist.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Titel\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:10:\"Anrisstext\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"0\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"1\";s:9:\"orig_type\";s:5:\"panel\";s:7:\"url_str\";s:5:\"panel\";s:6:\"fields\";a:0:{}s:6:\"tables\";a:0:{}s:5:\"extra\";a:6:{s:5:\"title\";a:3:{s:5:\"label\";s:5:\"Titel\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";i:-5;}s:10:\"body_field\";a:4:{s:5:\"label\";s:10:\"Anrisstext\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";i:0;s:4:\"view\";s:4:\"body\";}s:20:\"revision_information\";a:3:{s:5:\"label\";s:19:\"Versionsinformation\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";i:20;}s:16:\"comment_settings\";a:3:{s:5:\"label\";s:22:\"Kommentareinstellungen\";s:11:\"description\";s:20:\"Comment module form.\";s:6:\"weight\";i:30;}s:4:\"menu\";a:3:{s:5:\"label\";s:18:\"Menüeinstellungen\";s:11:\"description\";s:17:\"Menu module form.\";s:6:\"weight\";i:-2;}s:4:\"path\";a:3:{s:5:\"label\";s:13:\"Path settings\";s:11:\"description\";s:17:\"Path module form.\";s:6:\"weight\";i:30;}}}s:4:\"page\";a:18:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:5:\"Seite\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:347:\"Eine <em>Seite</em> ist in ihrer Form einem <em>Artikel</em> ähnlich und eine einfache Methode sich selten ändernde Informationen zu erstellen und anzuzeigen, wie etwa ein „Über uns“-Bereich einer Website. Eine <em>Seite</em> kann nach den Voreinstellungen von Besuchern nicht kommentiert werden und wird nicht auf der Startseite angezeigt.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Titel\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:11:\"Textkörper\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";s:7:\"url_str\";s:4:\"page\";s:6:\"fields\";a:1:{s:17:\"field_slid_select\";a:35:{s:10:\"field_name\";s:17:\"field_slid_select\";s:9:\"type_name\";s:4:\"page\";s:16:\"display_settings\";a:6:{s:6:\"weight\";s:2:\"31\";s:6:\"parent\";s:0:\"\";s:5:\"label\";a:1:{s:6:\"format\";s:6:\"hidden\";}s:6:\"teaser\";a:2:{s:6:\"format\";s:6:\"hidden\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:6:\"hidden\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:4:\"text\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"0\";s:10:\"db_storage\";s:1:\"1\";s:6:\"module\";s:4:\"text\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:1:{s:5:\"value\";a:5:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;s:8:\"sortable\";b:1;s:5:\"views\";b:1;}}s:15:\"text_processing\";s:1:\"0\";s:10:\"max_length\";s:0:\"\";s:14:\"allowed_values\";s:63:\"1 | slide 1\r\n2 | slide 2\r\n3 | slide 3\r\n4 | slide 4\r\n5 | slide 5\";s:18:\"allowed_values_php\";s:0:\"\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:3:\"div\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:2:\"h3\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:1:\":\";s:33:\"semantic_cck_label_element_inline\";s:4:\"span\";s:35:\"semantic_cck_multiple_items_element\";s:3:\"div\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:3:\"div\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:3:\"div\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:5:\"first\";s:23:\"semantic_cck_last_class\";s:4:\"last\";s:29:\"semantic_cck_striping_classes\";s:8:\"odd even\";s:6:\"widget\";a:8:{s:34:\"semantic_cck_use_semantic_instance\";i:0;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"1 \";}}s:17:\"default_value_php\";N;s:5:\"label\";s:17:\"Slideshow Auswahl\";s:6:\"weight\";s:2:\"31\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:21:\"optionwidgets_buttons\";s:6:\"module\";s:13:\"optionwidgets\";}}}s:6:\"tables\";a:1:{s:17:\"content_type_page\";s:17:\"content_type_page\";}s:5:\"extra\";a:6:{s:5:\"title\";a:3:{s:5:\"label\";s:5:\"Titel\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";s:2:\"-5\";}s:10:\"body_field\";a:4:{s:5:\"label\";s:11:\"Textkörper\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";s:1:\"0\";s:4:\"view\";s:4:\"body\";}s:20:\"revision_information\";a:3:{s:5:\"label\";s:19:\"Versionsinformation\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";s:2:\"20\";}s:16:\"comment_settings\";a:3:{s:5:\"label\";s:22:\"Kommentareinstellungen\";s:11:\"description\";s:20:\"Comment module form.\";s:6:\"weight\";s:2:\"30\";}s:4:\"menu\";a:3:{s:5:\"label\";s:18:\"Menüeinstellungen\";s:11:\"description\";s:17:\"Menu module form.\";s:6:\"weight\";s:2:\"-2\";}s:4:\"path\";a:3:{s:5:\"label\";s:13:\"Path settings\";s:11:\"description\";s:17:\"Path module form.\";s:6:\"weight\";s:2:\"30\";}}}s:3:\"ref\";a:18:{s:4:\"type\";s:3:\"ref\";s:4:\"name\";s:10:\"Referenzen\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Titel\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:0:\"\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:0:\"\";s:7:\"url_str\";s:3:\"ref\";s:6:\"fields\";a:1:{s:11:\"field_image\";a:34:{s:10:\"field_name\";s:11:\"field_image\";s:9:\"type_name\";s:3:\"ref\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"0\";s:10:\"db_storage\";s:1:\"1\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:5:\"image\";s:6:\"weight\";s:2:\"31\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}}s:6:\"tables\";a:1:{s:16:\"content_type_ref\";s:16:\"content_type_ref\";}s:5:\"extra\";a:5:{s:5:\"title\";a:3:{s:5:\"label\";s:5:\"Titel\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";s:2:\"-5\";}s:20:\"revision_information\";a:3:{s:5:\"label\";s:19:\"Versionsinformation\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";s:2:\"20\";}s:16:\"comment_settings\";a:3:{s:5:\"label\";s:22:\"Kommentareinstellungen\";s:11:\"description\";s:20:\"Comment module form.\";s:6:\"weight\";s:2:\"30\";}s:4:\"menu\";a:3:{s:5:\"label\";s:18:\"Menüeinstellungen\";s:11:\"description\";s:17:\"Menu module form.\";s:6:\"weight\";s:2:\"-2\";}s:4:\"path\";a:3:{s:5:\"label\";s:13:\"Path settings\";s:11:\"description\";s:17:\"Path module form.\";s:6:\"weight\";s:2:\"30\";}}}s:5:\"slide\";a:18:{s:4:\"type\";s:5:\"slide\";s:4:\"name\";s:9:\"Slideshow\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Titel\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:11:\"Textkörper\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:0:\"\";s:7:\"url_str\";s:5:\"slide\";s:6:\"fields\";a:5:{s:11:\"field_slide\";a:34:{s:10:\"field_name\";s:11:\"field_slide\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:9:\"slideshow\";s:6:\"weight\";s:2:\"31\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}s:13:\"field_slide_2\";a:34:{s:10:\"field_name\";s:13:\"field_slide_2\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:3:\"div\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:2:\"h3\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:1:\":\";s:33:\"semantic_cck_label_element_inline\";s:4:\"span\";s:35:\"semantic_cck_multiple_items_element\";s:3:\"div\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:3:\"div\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:3:\"div\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:5:\"first\";s:23:\"semantic_cck_last_class\";s:4:\"last\";s:29:\"semantic_cck_striping_classes\";s:8:\"odd even\";s:6:\"widget\";a:19:{s:15:\"file_extensions\";s:12:\"gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:34:\"semantic_cck_use_semantic_instance\";i:0;s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:17:\"use_default_image\";i:0;s:5:\"label\";s:11:\"slideshow_2\";s:6:\"weight\";s:2:\"32\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}s:13:\"field_slide_3\";a:34:{s:10:\"field_name\";s:13:\"field_slide_3\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:11:\"slideshow_3\";s:6:\"weight\";s:2:\"33\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}s:13:\"field_slide_4\";a:34:{s:10:\"field_name\";s:13:\"field_slide_4\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:11:\"slideshow_4\";s:6:\"weight\";s:2:\"34\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}s:13:\"field_slide_5\";a:34:{s:10:\"field_name\";s:13:\"field_slide_5\";s:9:\"type_name\";s:5:\"slide\";s:16:\"display_settings\";a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}s:13:\"widget_active\";s:1:\"1\";s:4:\"type\";s:9:\"filefield\";s:8:\"required\";s:1:\"0\";s:8:\"multiple\";s:1:\"1\";s:10:\"db_storage\";s:1:\"0\";s:6:\"module\";s:9:\"filefield\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:7:\"columns\";a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";s:6:\"widget\";a:20:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;s:5:\"label\";s:11:\"slideshow_5\";s:6:\"weight\";s:2:\"35\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:17:\"imagefield_widget\";s:6:\"module\";s:10:\"imagefield\";}}}s:6:\"tables\";a:6:{s:19:\"content_field_slide\";s:19:\"content_field_slide\";s:21:\"content_field_slide_2\";s:21:\"content_field_slide_2\";s:21:\"content_field_slide_3\";s:21:\"content_field_slide_3\";s:21:\"content_field_slide_4\";s:21:\"content_field_slide_4\";s:21:\"content_field_slide_5\";s:21:\"content_field_slide_5\";s:18:\"content_type_slide\";s:18:\"content_type_slide\";}s:5:\"extra\";a:6:{s:5:\"title\";a:3:{s:5:\"label\";s:5:\"Titel\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";s:2:\"-5\";}s:10:\"body_field\";a:4:{s:5:\"label\";s:11:\"Textkörper\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";s:1:\"0\";s:4:\"view\";s:4:\"body\";}s:20:\"revision_information\";a:3:{s:5:\"label\";s:19:\"Versionsinformation\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";s:2:\"20\";}s:16:\"comment_settings\";a:3:{s:5:\"label\";s:22:\"Kommentareinstellungen\";s:11:\"description\";s:20:\"Comment module form.\";s:6:\"weight\";s:2:\"30\";}s:4:\"menu\";a:3:{s:5:\"label\";s:18:\"Menüeinstellungen\";s:11:\"description\";s:17:\"Menu module form.\";s:6:\"weight\";s:2:\"-2\";}s:4:\"path\";a:3:{s:5:\"label\";s:13:\"Path settings\";s:11:\"description\";s:17:\"Path module form.\";s:6:\"weight\";s:2:\"30\";}}}s:5:\"story\";a:18:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:7:\"Artikel\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:469:\"Ein <em>Artikel</em> ähnelt in seiner Form einer <em>Seite</em> und ist für das Erstellen und Anzeigen von Inhalten geeignet, die Website-Besucher informieren oder zur Teilnahme anregen sollen. Pressemitteilungen, Website-Ankündigungen und informelle Blog-ähnliche Einträge können als <em>Artikel</em> erstellt werden. Nach den Voreinstellungen wird ein <em>Artikel</em> automatisch auf der Startseite angerissen und bietet die Möglichkeit kommentiert zu werden.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Titel\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:11:\"Textkörper\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";s:7:\"url_str\";s:5:\"story\";s:6:\"fields\";a:0:{}s:6:\"tables\";a:0:{}s:5:\"extra\";a:6:{s:5:\"title\";a:3:{s:5:\"label\";s:5:\"Titel\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";i:-5;}s:10:\"body_field\";a:4:{s:5:\"label\";s:11:\"Textkörper\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";i:0;s:4:\"view\";s:4:\"body\";}s:20:\"revision_information\";a:3:{s:5:\"label\";s:19:\"Versionsinformation\";s:11:\"description\";s:17:\"Node module form.\";s:6:\"weight\";i:20;}s:16:\"comment_settings\";a:3:{s:5:\"label\";s:22:\"Kommentareinstellungen\";s:11:\"description\";s:20:\"Comment module form.\";s:6:\"weight\";i:30;}s:4:\"menu\";a:3:{s:5:\"label\";s:18:\"Menüeinstellungen\";s:11:\"description\";s:17:\"Menu module form.\";s:6:\"weight\";i:-2;}s:4:\"path\";a:3:{s:5:\"label\";s:13:\"Path settings\";s:11:\"description\";s:17:\"Path module form.\";s:6:\"weight\";i:30;}}}}}','0','1281003614','','1');
INSERT INTO `cache_content` VALUES ('fieldgroup_data','a:2:{s:6:\"groups\";a:0:{}s:13:\"groups_sorted\";a:0:{}}','0','1281003955','','1');
DROP TABLE IF EXISTS `cache_filter`;
CREATE TABLE `cache_filter` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cache_form`;
CREATE TABLE `cache_form` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cache_menu`;
CREATE TABLE `cache_menu` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cache_page`;
CREATE TABLE `cache_page` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cache_rules`;
CREATE TABLE `cache_rules` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `cache_rules` VALUES ('include_rules','a:17:{i:0;s:50:\"sites/all/modules/rules/rules/rules.data_types.inc\";i:1;s:49:\"sites/all/modules/rules/rules/rules.variables.inc\";i:2;s:56:\"sites/all/modules/rules/rules/rules.input_evaluators.inc\";i:3;s:57:\"./sites/all/modules/rules/rules/modules/comment.rules.inc\";i:4;s:54:\"./sites/all/modules/rules/rules/modules/node.rules.inc\";i:5;s:54:\"./sites/all/modules/rules/rules/modules/path.rules.inc\";i:6;s:53:\"./sites/all/modules/rules/rules/modules/php.rules.inc\";i:7;s:56:\"./sites/all/modules/rules/rules/modules/system.rules.inc\";i:8;s:58:\"./sites/all/modules/rules/rules/modules/taxonomy.rules.inc\";i:9;s:54:\"./sites/all/modules/rules/rules/modules/user.rules.inc\";i:10;s:50:\"./sites/all/modules/cck/includes/content.rules.inc\";i:11;s:69:\"./sites/all/modules/cck/modules/nodereference/nodereference.rules.inc\";i:12;s:69:\"./sites/all/modules/cck/modules/userreference/userreference.rules.inc\";i:13;s:59:\"./sites/all/modules/rules/rules_forms/rules_forms.rules.inc\";i:14;s:67:\"./sites/all/modules/rules/rules_scheduler/rules_scheduler.rules.inc\";i:15;s:41:\"./sites/all/modules/token/token.rules.inc\";i:16;s:55:\"./sites/all/modules/rules/rules/modules/rules.rules.inc\";}','0','1281003568','','1');
INSERT INTO `cache_rules` VALUES ('include_rules_defaults','a:0:{}','0','1281003568','','1');
DROP TABLE IF EXISTS `cache_update`;
CREATE TABLE `cache_update` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `cache_update` VALUES ('update_available_releases','a:38:{s:8:\"addtoany\";a:10:{s:5:\"title\";s:30:\"AddToAny Share/Bookmark Button\";s:10:\"short_name\";s:8:\"addtoany\";s:10:\"dc:creator\";s:8:\"micropat\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:34:\"http://drupal.org/project/addtoany\";s:8:\"releases\";a:17:{s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/850002\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1278719704\";s:6:\"mdhash\";s:32:\"2749a475df074c866f019c6e1a033fbf\";s:8:\"filesize\";s:5:\"15802\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/842398\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1277970605\";s:6:\"mdhash\";s:32:\"926cf3baf1e758c0e36219316853834d\";s:8:\"filesize\";s:5:\"15608\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/839040\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1277687705\";s:6:\"mdhash\";s:32:\"79024e5fd843763c441e1259bf6feab6\";s:8:\"filesize\";s:5:\"15443\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/838878\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1277665811\";s:6:\"mdhash\";s:32:\"d9407ea1c79e255dd0a7c44476d3c03c\";s:8:\"filesize\";s:4:\"9808\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:20:\"addtoany 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/838616\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833329\";s:6:\"mdhash\";s:32:\"514c1b0ae476441d7e3c77ac02f32c72\";s:8:\"filesize\";s:5:\"15810\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/601110\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1255206003\";s:6:\"mdhash\";s:32:\"9486fdbe364504b27bd5dfb291542f6e\";s:8:\"filesize\";s:5:\"14168\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/431152\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1239487222\";s:6:\"mdhash\";s:32:\"21e80d36e13fcce20236330866450601\";s:8:\"filesize\";s:5:\"14856\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/415386\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1238146502\";s:6:\"mdhash\";s:32:\"3352e1f160b54410f7d3b05640f38faa\";s:8:\"filesize\";s:5:\"14829\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/414318\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1238061628\";s:6:\"mdhash\";s:32:\"d2020f6d230d6b1744e380e77bc807cb\";s:8:\"filesize\";s:5:\"14472\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/361313\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1232418604\";s:6:\"mdhash\";s:32:\"32ff06b0cd2320b47cfef8554d6ef2a0\";s:8:\"filesize\";s:5:\"14386\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:8:\"6.x-1.36\";a:12:{s:4:\"name\";s:17:\"addtoany 6.x-1.36\";s:7:\"version\";s:8:\"6.x-1.36\";s:3:\"tag\";s:14:\"DRUPAL-6--1-36\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"36\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/249274\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.36.tar.gz\";s:4:\"date\";s:10:\"1208782203\";s:6:\"mdhash\";s:32:\"2f40a87e75befb3e96843842f0601a76\";s:8:\"filesize\";s:4:\"7114\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.35\";a:12:{s:4:\"name\";s:17:\"addtoany 6.x-1.35\";s:7:\"version\";s:8:\"6.x-1.35\";s:3:\"tag\";s:14:\"DRUPAL-6--1-35\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"35\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/249140\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.35.tar.gz\";s:4:\"date\";s:10:\"1208747705\";s:6:\"mdhash\";s:32:\"585d728018b1aeb583afff496bbdec50\";s:8:\"filesize\";s:4:\"7106\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/249115\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1208742001\";s:6:\"mdhash\";s:32:\"55077e53ce3370e8083729cff5970afa\";s:8:\"filesize\";s:4:\"7104\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/248414\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1208551202\";s:6:\"mdhash\";s:32:\"f402eb45fe2092d188dd3e6f2794b898\";s:8:\"filesize\";s:4:\"7046\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/248253\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1208518802\";s:6:\"mdhash\";s:32:\"5aed8951c0670755021660c2419bca36\";s:8:\"filesize\";s:4:\"6878\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:16:\"addtoany 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/247774\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1208420701\";s:6:\"mdhash\";s:32:\"6a7993d9637d51cbad55760ba945ddc7\";s:8:\"filesize\";s:4:\"6880\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:20:\"addtoany 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/247216\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833329\";s:6:\"mdhash\";s:32:\"376e6ec69e5167569a00852b2d24e2fb\";s:8:\"filesize\";s:4:\"8714\";}}}s:10:\"admin_menu\";a:10:{s:5:\"title\";s:19:\"Administration menu\";s:10:\"short_name\";s:10:\"admin_menu\";s:10:\"dc:creator\";s:3:\"sun\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,3\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/admin_menu\";s:8:\"releases\";a:13:{s:14:\"6.x-3.0-alpha4\";a:13:{s:4:\"name\";s:25:\"admin_menu 6.x-3.0-alpha4\";s:7:\"version\";s:14:\"6.x-3.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/739026\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1268274904\";s:6:\"mdhash\";s:32:\"ba93c801409700854965f87b5df72817\";s:8:\"filesize\";s:5:\"69865\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:25:\"admin_menu 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/550878\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1250462403\";s:6:\"mdhash\";s:32:\"ca00ce1b53f3d6ac8d53773d9dd66378\";s:8:\"filesize\";s:5:\"60772\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:25:\"admin_menu 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/537782\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1249183202\";s:6:\"mdhash\";s:32:\"92a1a99f3cfa3cdbc2d2436166e37ea1\";s:8:\"filesize\";s:5:\"51545\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:25:\"admin_menu 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/488202\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1244680505\";s:6:\"mdhash\";s:32:\"088c382dbbdf4cbfa627e9f0f02aa65c\";s:8:\"filesize\";s:5:\"49388\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:22:\"admin_menu 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/373515\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280620899\";s:6:\"mdhash\";s:32:\"043b2aa35840ee78a8d0e3075bb3aca1\";s:8:\"filesize\";s:5:\"71235\";}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/508148\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1246537502\";s:6:\"mdhash\";s:32:\"efa340632c9fd0b9a964671bed27a722\";s:8:\"filesize\";s:5:\"45284\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/464048\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1242422411\";s:6:\"mdhash\";s:32:\"fcfc4cd0d2a2c2ab5d7d800701f9bcbe\";s:8:\"filesize\";s:5:\"44300\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/363483\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1232775903\";s:6:\"mdhash\";s:32:\"aba88a427c52fb9f2d0501dd51141331\";s:8:\"filesize\";s:5:\"38411\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/361251\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1232406902\";s:6:\"mdhash\";s:32:\"27c92c7059018edf27f8df748883e3d4\";s:8:\"filesize\";s:5:\"37659\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/307590\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1221237902\";s:6:\"mdhash\";s:32:\"da106dcfefddf490c06091c0a2c99a28\";s:8:\"filesize\";s:5:\"27351\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275429\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1214512502\";s:6:\"mdhash\";s:32:\"0112456abb83fcd7bae339b3311b03ff\";s:8:\"filesize\";s:5:\"26040\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:12:\"6.x-1.0-beta\";a:13:{s:4:\"name\";s:23:\"admin_menu 6.x-1.0-beta\";s:7:\"version\";s:12:\"6.x-1.0-beta\";s:3:\"tag\";s:18:\"DRUPAL-6--1-0-BETA\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:4:\"beta\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/268075\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.0-beta.tar.gz\";s:4:\"date\";s:10:\"1212913502\";s:6:\"mdhash\";s:32:\"e299f946fe29a3b8159c65c1751c796a\";s:8:\"filesize\";s:5:\"24230\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:22:\"admin_menu 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/251566\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280318473\";s:6:\"mdhash\";s:32:\"92ff6fe3b3464cfe2a89d61420e8a760\";s:8:\"filesize\";s:5:\"52459\";}}}s:14:\"backup_migrate\";a:10:{s:5:\"title\";s:18:\"Backup and Migrate\";s:10:\"short_name\";s:14:\"backup_migrate\";s:10:\"dc:creator\";s:5:\"ronan\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:40:\"http://drupal.org/project/backup_migrate\";s:8:\"releases\";a:8:{s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/659078\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1260768003\";s:6:\"mdhash\";s:32:\"d718f2d4a1bddcdc1c81123dfbe39d53\";s:8:\"filesize\";s:5:\"65975\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/652788\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1260138903\";s:6:\"mdhash\";s:32:\"a8d107707be398aa768a47e8407bec65\";s:8:\"filesize\";s:5:\"66106\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/652370\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1260071104\";s:6:\"mdhash\";s:32:\"c761362f91173fdf14be3c28952800c9\";s:8:\"filesize\";s:5:\"54015\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:26:\"backup_migrate 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/303112\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833497\";s:6:\"mdhash\";s:32:\"4fa29ccb83055cbe4f6ef740ff27ea37\";s:8:\"filesize\";s:5:\"78879\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/826444\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1276470903\";s:6:\"mdhash\";s:32:\"a2eb5cc60875594d5c3c08248f295f8a\";s:8:\"filesize\";s:5:\"25865\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/360452\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1232247609\";s:6:\"mdhash\";s:32:\"15e9e33a226411fbe2b2b89fbb90d99e\";s:8:\"filesize\";s:5:\"25385\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295106\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1218681903\";s:6:\"mdhash\";s:32:\"0fabd2518a276f0f0e636dbca06c67e4\";s:8:\"filesize\";s:5:\"17163\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:26:\"backup_migrate 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/231755\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833499\";s:6:\"mdhash\";s:32:\"6e344f542f4929d36ed2f98a8e7f128b\";s:8:\"filesize\";s:5:\"32019\";}}}s:6:\"drupal\";a:10:{s:5:\"title\";s:11:\"Drupal core\";s:10:\"short_name\";s:6:\"drupal\";s:10:\"dc:creator\";s:6:\"Drupal\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"6\";s:16:\"supported_majors\";s:1:\"6\";s:13:\"default_major\";s:1:\"6\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:32:\"http://drupal.org/project/drupal\";s:8:\"releases\";a:27:{s:4:\"6.17\";a:12:{s:4:\"name\";s:11:\"drupal 6.17\";s:7:\"version\";s:4:\"6.17\";s:3:\"tag\";s:11:\"DRUPAL-6-17\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/816290\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.17.tar.gz\";s:4:\"date\";s:10:\"1275505219\";s:6:\"mdhash\";s:32:\"14f936496d1f927d9b65e3849d7274f4\";s:8:\"filesize\";s:7:\"1093157\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:4:\"6.16\";a:12:{s:4:\"name\";s:11:\"drupal 6.16\";s:7:\"version\";s:4:\"6.16\";s:3:\"tag\";s:11:\"DRUPAL-6-16\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/732000\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.16.tar.gz\";s:4:\"date\";s:10:\"1267662009\";s:6:\"mdhash\";s:32:\"bb27c1f90680b86df2c535b2d52e8021\";s:8:\"filesize\";s:7:\"1090616\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.15\";a:12:{s:4:\"name\";s:11:\"drupal 6.15\";s:7:\"version\";s:4:\"6.15\";s:3:\"tag\";s:11:\"DRUPAL-6-15\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/661600\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.15.tar.gz\";s:4:\"date\";s:10:\"1260996917\";s:6:\"mdhash\";s:32:\"43c60bde08d6ea67682a998c2804c357\";s:8:\"filesize\";s:7:\"1085634\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.14\";a:12:{s:4:\"name\";s:11:\"drupal 6.14\";s:7:\"version\";s:4:\"6.14\";s:3:\"tag\";s:11:\"DRUPAL-6-14\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/579476\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.14.tar.gz\";s:4:\"date\";s:10:\"1253130028\";s:6:\"mdhash\";s:32:\"014bb453a8d0adb0233c763e40d63859\";s:8:\"filesize\";s:7:\"1082687\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.13\";a:12:{s:4:\"name\";s:11:\"drupal 6.13\";s:7:\"version\";s:4:\"6.13\";s:3:\"tag\";s:11:\"DRUPAL-6-13\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/507568\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.13.tar.gz\";s:4:\"date\";s:10:\"1246481720\";s:6:\"mdhash\";s:32:\"76dcb6e311fbb98ca3322fd1413f4a04\";s:8:\"filesize\";s:7:\"1080373\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.12\";a:12:{s:4:\"name\";s:11:\"drupal 6.12\";s:7:\"version\";s:4:\"6.12\";s:3:\"tag\";s:11:\"DRUPAL-6-12\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/461882\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.12.tar.gz\";s:4:\"date\";s:10:\"1242243955\";s:6:\"mdhash\";s:32:\"82e2517f175320cffe20997333b3a33a\";s:8:\"filesize\";s:7:\"1079251\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.11\";a:12:{s:4:\"name\";s:11:\"drupal 6.11\";s:7:\"version\";s:4:\"6.11\";s:3:\"tag\";s:11:\"DRUPAL-6-11\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/449114\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.11.tar.gz\";s:4:\"date\";s:10:\"1241050842\";s:6:\"mdhash\";s:32:\"6a341807b83c4e48f50ce7921562402c\";s:8:\"filesize\";s:7:\"1078966\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.10\";a:12:{s:4:\"name\";s:11:\"drupal 6.10\";s:7:\"version\";s:4:\"6.10\";s:3:\"tag\";s:11:\"DRUPAL-6-10\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/383918\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.10.tar.gz\";s:4:\"date\";s:10:\"1235596219\";s:6:\"mdhash\";s:32:\"d8f222c260556b5d7c3ff41bdd251b3c\";s:8:\"filesize\";s:7:\"1076404\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.9\";a:12:{s:4:\"name\";s:10:\"drupal 6.9\";s:7:\"version\";s:3:\"6.9\";s:3:\"tag\";s:10:\"DRUPAL-6-9\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/358987\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.9.tar.gz\";s:4:\"date\";s:10:\"1231976414\";s:6:\"mdhash\";s:32:\"5c682a4709f4632febbe7617a784a01a\";s:8:\"filesize\";s:7:\"1075558\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.8\";a:12:{s:4:\"name\";s:10:\"drupal 6.8\";s:7:\"version\";s:3:\"6.8\";s:3:\"tag\";s:10:\"DRUPAL-6-8\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/345833\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.8.tar.gz\";s:4:\"date\";s:10:\"1229018429\";s:6:\"mdhash\";s:32:\"561f281b2dbee8310293a61443bdfbc7\";s:8:\"filesize\";s:7:\"1074294\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:3:\"6.7\";a:12:{s:4:\"name\";s:10:\"drupal 6.7\";s:7:\"version\";s:3:\"6.7\";s:3:\"tag\";s:10:\"DRUPAL-6-7\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/345462\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.7.tar.gz\";s:4:\"date\";s:10:\"1228948512\";s:6:\"mdhash\";s:32:\"c9e8e5a9892538d355c62bd17b95b3a9\";s:8:\"filesize\";s:7:\"1074300\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.6\";a:12:{s:4:\"name\";s:10:\"drupal 6.6\";s:7:\"version\";s:3:\"6.6\";s:3:\"tag\";s:10:\"DRUPAL-6-6\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/324832\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.6.tar.gz\";s:4:\"date\";s:10:\"1224703817\";s:6:\"mdhash\";s:32:\"caaa55d1990b34dee48f5047ce98e2bb\";s:8:\"filesize\";s:7:\"1071507\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.5\";a:12:{s:4:\"name\";s:10:\"drupal 6.5\";s:7:\"version\";s:3:\"6.5\";s:3:\"tag\";s:10:\"DRUPAL-6-5\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318701\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.5.tar.gz\";s:4:\"date\";s:10:\"1223497211\";s:6:\"mdhash\";s:32:\"a88c561f0e61168b6ac710de55b6f91f\";s:8:\"filesize\";s:7:\"1071036\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.4\";a:12:{s:4:\"name\";s:10:\"Drupal 6.4\";s:7:\"version\";s:3:\"6.4\";s:3:\"tag\";s:10:\"DRUPAL-6-4\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295065\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.4.tar.gz\";s:4:\"date\";s:10:\"1218672611\";s:6:\"mdhash\";s:32:\"497b537285ad5847c1d3cb2f98ccf88c\";s:8:\"filesize\";s:7:\"1068473\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.3\";a:12:{s:4:\"name\";s:10:\"drupal 6.3\";s:7:\"version\";s:3:\"6.3\";s:3:\"tag\";s:10:\"DRUPAL-6-3\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/280583\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.3.tar.gz\";s:4:\"date\";s:10:\"1215640510\";s:6:\"mdhash\";s:32:\"f6a23149b906048d8a2dce1bad0e11a7\";s:8:\"filesize\";s:7:\"1061653\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.2\";a:12:{s:4:\"name\";s:10:\"drupal 6.2\";s:7:\"version\";s:3:\"6.2\";s:3:\"tag\";s:10:\"DRUPAL-6-2\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/244667\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.2.tar.gz\";s:4:\"date\";s:10:\"1207776009\";s:6:\"mdhash\";s:32:\"4c5af590b42b5a8e826177119c7e73b3\";s:8:\"filesize\";s:7:\"1058550\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.1\";a:12:{s:4:\"name\";s:10:\"drupal 6.1\";s:7:\"version\";s:3:\"6.1\";s:3:\"tag\";s:10:\"DRUPAL-6-1\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/227618\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.1.tar.gz\";s:4:\"date\";s:10:\"1204142109\";s:6:\"mdhash\";s:32:\"32bfd0b3a8a48e3f631e0a396ec96f68\";s:8:\"filesize\";s:7:\"1057213\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.0\";a:12:{s:4:\"name\";s:10:\"drupal 6.0\";s:7:\"version\";s:3:\"6.0\";s:3:\"tag\";s:10:\"DRUPAL-6-0\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/221219\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.0.tar.gz\";s:4:\"date\";s:10:\"1202913008\";s:6:\"mdhash\";s:32:\"2138bd9f79906bd39c5dcc5289446c01\";s:8:\"filesize\";s:7:\"1057166\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.0-rc4\";a:13:{s:4:\"name\";s:14:\"drupal 6.0-rc4\";s:7:\"version\";s:7:\"6.0-rc4\";s:3:\"tag\";s:15:\"DRUPAL-6-0-RC-4\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/219510\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1202511908\";s:6:\"mdhash\";s:32:\"35f04f54be270cfe55ea19b249c40c36\";s:8:\"filesize\";s:7:\"1057236\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.0-rc3\";a:13:{s:4:\"name\";s:14:\"drupal 6.0-rc3\";s:7:\"version\";s:7:\"6.0-rc3\";s:3:\"tag\";s:15:\"DRUPAL-6-0-RC-3\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/216077\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1201733406\";s:6:\"mdhash\";s:32:\"c7deaf2f7d3a4d89cf2413fcc5bb728a\";s:8:\"filesize\";s:7:\"1052926\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.0-rc2\";a:13:{s:4:\"name\";s:14:\"drupal 6.0-rc2\";s:7:\"version\";s:7:\"6.0-rc2\";s:3:\"tag\";s:15:\"DRUPAL-6-0-RC-2\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/208616\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1200005705\";s:6:\"mdhash\";s:32:\"75962b1deeac60d12c2ba03a04e588c9\";s:8:\"filesize\";s:7:\"1046845\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.0-rc1\";a:13:{s:4:\"name\";s:14:\"drupal 6.0-rc1\";s:7:\"version\";s:7:\"6.0-rc1\";s:3:\"tag\";s:15:\"DRUPAL-6-0-RC-1\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/202820\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1198191308\";s:6:\"mdhash\";s:32:\"36102983c0be837ee4b15090557efbcc\";s:8:\"filesize\";s:7:\"1040654\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.0-beta4\";a:13:{s:4:\"name\";s:16:\"drupal 6.0-beta4\";s:7:\"version\";s:9:\"6.0-beta4\";s:3:\"tag\";s:17:\"DRUPAL-6-0-BETA-4\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/198188\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/drupal-6.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1196889906\";s:6:\"mdhash\";s:32:\"0747d613bb08471285da71fd5e8eb0d4\";s:8:\"filesize\";s:7:\"1025760\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.0-beta3\";a:13:{s:4:\"name\";s:16:\"drupal 6.0-beta3\";s:7:\"version\";s:9:\"6.0-beta3\";s:3:\"tag\";s:17:\"DRUPAL-6-0-BETA-3\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/194287\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/drupal-6.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1195684804\";s:6:\"mdhash\";s:32:\"2af78e20c98c2425ec71dcead90359d7\";s:8:\"filesize\";s:7:\"1010222\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.0-beta2\";a:13:{s:4:\"name\";s:16:\"drupal 6.0-beta2\";s:7:\"version\";s:9:\"6.0-beta2\";s:3:\"tag\";s:17:\"DRUPAL-6-0-BETA-2\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/184399\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/drupal-6.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1192658104\";s:6:\"mdhash\";s:32:\"dc95c3ffa6739273e34194a5be240738\";s:8:\"filesize\";s:6:\"991798\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.0-beta1\";a:13:{s:4:\"name\";s:16:\"drupal 6.0-beta1\";s:7:\"version\";s:9:\"6.0-beta1\";s:3:\"tag\";s:17:\"DRUPAL-6-0-BETA-1\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/175832\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/drupal-6.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1189840804\";s:6:\"mdhash\";s:32:\"a50471f2a835bcbd8324ef4d64201987\";s:8:\"filesize\";s:6:\"957946\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-dev\";a:12:{s:4:\"name\";s:14:\"Drupal 6.x-dev\";s:7:\"version\";s:7:\"6.x-dev\";s:3:\"tag\";s:8:\"DRUPAL-6\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/97368\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278802408\";s:6:\"mdhash\";s:32:\"03b41123afb1f0e7990c5aac6a272c31\";s:8:\"filesize\";s:7:\"1093558\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}}}s:7:\"captcha\";a:10:{s:5:\"title\";s:7:\"CAPTCHA\";s:10:\"short_name\";s:7:\"captcha\";s:10:\"dc:creator\";s:5:\"wundo\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:33:\"http://drupal.org/project/captcha\";s:8:\"releases\";a:17:{s:11:\"6.x-2.3-rc2\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.3-rc2\";s:7:\"version\";s:11:\"6.x-2.3-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-3-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/859690\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.3-rc2.tar.gz\";s:4:\"date\";s:10:\"1279649705\";s:6:\"mdhash\";s:32:\"7e47b896f4d986290df6b51c6207798c\";s:8:\"filesize\";s:6:\"183471\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.3-rc1\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.3-rc1\";s:7:\"version\";s:11:\"6.x-2.3-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-3-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/843974\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.3-rc1.tar.gz\";s:4:\"date\";s:10:\"1278105005\";s:6:\"mdhash\";s:32:\"b156b238554770858a47c0cb64ba3d82\";s:8:\"filesize\";s:6:\"183457\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:15:\"captcha 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/802896\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1274250303\";s:6:\"mdhash\";s:32:\"8cc53444b1dcaea980f388240129ac4e\";s:8:\"filesize\";s:6:\"176535\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:15:\"captcha 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/672304\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1262396711\";s:6:\"mdhash\";s:32:\"093c16ce18dca0f60181db75bd500b0c\";s:8:\"filesize\";s:6:\"165067\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:15:\"captcha 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/586144\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1253743243\";s:6:\"mdhash\";s:32:\"a10e9524369a07f71195da84f80816ba\";s:8:\"filesize\";s:6:\"152230\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.0-rc3\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.0-rc3\";s:7:\"version\";s:11:\"6.x-2.0-rc3\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/561696\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1251415515\";s:6:\"mdhash\";s:32:\"5cca375c55696cf2919dd3b2fbb89f8f\";s:8:\"filesize\";s:5:\"97621\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc2\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.0-rc2\";s:7:\"version\";s:11:\"6.x-2.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/509348\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1246629317\";s:6:\"mdhash\";s:32:\"f04af543c77026d74c743abc794e92f9\";s:8:\"filesize\";s:5:\"82113\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/490958\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1244932228\";s:6:\"mdhash\";s:32:\"31411d9551200ff5422876aac96069d9\";s:8:\"filesize\";s:5:\"85018\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta5\";a:12:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta5\";s:7:\"version\";s:13:\"6.x-2.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/465306\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1242580821\";s:6:\"mdhash\";s:32:\"31fc5556501b097035aac48ae85b0150\";s:8:\"filesize\";s:5:\"67564\";}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/444424\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1240614311\";s:6:\"mdhash\";s:32:\"bf6fae015f39c393960dd95749d26a2d\";s:8:\"filesize\";s:5:\"53568\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/425826\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1239066050\";s:6:\"mdhash\";s:32:\"5330c966dbe920b6b6def3f9cc909df8\";s:8:\"filesize\";s:5:\"52998\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/368111\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1233604214\";s:6:\"mdhash\";s:32:\"5fc64168bb386816f73f066d7cd04a6d\";s:8:\"filesize\";s:5:\"42308\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354009\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1231021814\";s:6:\"mdhash\";s:32:\"2c403c3df398ee453682a0ec29db216e\";s:8:\"filesize\";s:5:\"41884\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:19:\"captcha 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/94922\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833636\";s:6:\"mdhash\";s:32:\"dec5a0766724238daba9e80cd18dbc46\";s:8:\"filesize\";s:6:\"183466\";}s:11:\"6.x-1.0-rc2\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-1.0-rc2\";s:7:\"version\";s:11:\"6.x-1.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/245354\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1207904704\";s:6:\"mdhash\";s:32:\"6f079f0572fe55e4b1a69cf7fda85ebd\";s:8:\"filesize\";s:5:\"47539\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc1\";a:12:{s:4:\"name\";s:19:\"captcha 6.x-1.0-rc1\";s:7:\"version\";s:11:\"6.x-1.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/222188\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1203092404\";s:6:\"mdhash\";s:32:\"fe7173cc04b745fd9af092fbbfc4fd0b\";s:8:\"filesize\";s:5:\"40500\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:19:\"captcha 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/214492\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833637\";s:6:\"mdhash\";s:32:\"f90f229a4c770968d93903a1af35e49b\";s:8:\"filesize\";s:5:\"87879\";}}}s:3:\"cck\";a:10:{s:5:\"title\";s:30:\"Content Construction Kit (CCK)\";s:10:\"short_name\";s:3:\"cck\";s:10:\"dc:creator\";s:5:\"yched\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:29:\"http://drupal.org/project/cck\";s:8:\"releases\";a:23:{s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:15:\"cck 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/484068\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278806577\";s:6:\"mdhash\";s:32:\"036fe7b45f255b889a132cdcde61cfbe\";s:8:\"filesize\";s:6:\"466006\";}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/828988\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1276685406\";s:6:\"mdhash\";s:32:\"79e7f184ba68f5bf09eb8fde872572b8\";s:8:\"filesize\";s:6:\"440542\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/624868\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1257464737\";s:6:\"mdhash\";s:32:\"3e719a786f7fed2c6e7bd341a508ca60\";s:8:\"filesize\";s:6:\"423510\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/539128\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1249334429\";s:6:\"mdhash\";s:32:\"d20669111ff3e528a233a14247df42de\";s:8:\"filesize\";s:6:\"417417\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/494022\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1245237621\";s:6:\"mdhash\";s:32:\"e37388bf9061fa24df62e269a5c64fed\";s:8:\"filesize\";s:6:\"412002\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/482540\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1244163643\";s:6:\"mdhash\";s:32:\"7f60a6bbaba40059562a87fb33203197\";s:8:\"filesize\";s:6:\"410591\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/406534\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1237410615\";s:6:\"mdhash\";s:32:\"0fe5f8e6d1292fcfe98530a3dea0a1a1\";s:8:\"filesize\";s:6:\"357660\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/333173\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1226449204\";s:6:\"mdhash\";s:32:\"6036acde1dbc0bad62681de5f94bc912\";s:8:\"filesize\";s:6:\"318865\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/330573\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1225914304\";s:6:\"mdhash\";s:32:\"ea2a47052833892030541464ad6609a9\";s:8:\"filesize\";s:6:\"318588\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:12:\"6.x-2.0-rc10\";a:13:{s:4:\"name\";s:16:\"cck 6.x-2.0-rc10\";s:7:\"version\";s:12:\"6.x-2.0-rc10\";s:3:\"tag\";s:18:\"DRUPAL-6--2-0-RC10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:4:\"rc10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318642\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc10.tar.gz\";s:4:\"date\";s:10:\"1223488806\";s:6:\"mdhash\";s:32:\"1fbf5c09c881fe44ec09fff61d26aef9\";s:8:\"filesize\";s:6:\"248939\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc9\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc9\";s:7:\"version\";s:11:\"6.x-2.0-rc9\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/317796\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc9.tar.gz\";s:4:\"date\";s:10:\"1223325604\";s:6:\"mdhash\";s:32:\"9beefdfbf85f8a5e8b73235574d636a8\";s:8:\"filesize\";s:6:\"227274\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc8\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc8\";s:7:\"version\";s:11:\"6.x-2.0-rc8\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/316249\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc8.tar.gz\";s:4:\"date\";s:10:\"1222958408\";s:6:\"mdhash\";s:32:\"dd633f983e4a43bb9da7bd40e1d81682\";s:8:\"filesize\";s:6:\"226701\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc7\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc7\";s:7:\"version\";s:11:\"6.x-2.0-rc7\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/306274\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc7.tar.gz\";s:4:\"date\";s:10:\"1221003605\";s:6:\"mdhash\";s:32:\"b1024f15ca41f0cac9c521ba81fcb1ff\";s:8:\"filesize\";s:6:\"210995\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc6\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc6\";s:7:\"version\";s:11:\"6.x-2.0-rc6\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295736\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc6.tar.gz\";s:4:\"date\";s:10:\"1218809704\";s:6:\"mdhash\";s:32:\"ddcc92a076b4aacbf97f4b11ba58f2aa\";s:8:\"filesize\";s:6:\"206891\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc5\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc5\";s:7:\"version\";s:11:\"6.x-2.0-rc5\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295416\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc5.tar.gz\";s:4:\"date\";s:10:\"1218735306\";s:6:\"mdhash\";s:32:\"05c3d43fcf0e64c4277cf162693b1934\";s:8:\"filesize\";s:6:\"206821\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc4\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc4\";s:7:\"version\";s:11:\"6.x-2.0-rc4\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/280821\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1215694806\";s:6:\"mdhash\";s:32:\"b0805a344cdee93fa0d9388160c5fac2\";s:8:\"filesize\";s:6:\"189040\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc3\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc3\";s:7:\"version\";s:11:\"6.x-2.0-rc3\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/278309\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1215117305\";s:6:\"mdhash\";s:32:\"564f1bd699786d73710078ec45ffa70b\";s:8:\"filesize\";s:6:\"180693\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc2\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc2\";s:7:\"version\";s:11:\"6.x-2.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277906\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1215035705\";s:6:\"mdhash\";s:32:\"c0a8c02429c603a29efb08e497a9e3f7\";s:8:\"filesize\";s:6:\"168747\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277894\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1215033603\";s:6:\"mdhash\";s:32:\"bf8b7810e31d7dff3261125d64ef1c00\";s:8:\"filesize\";s:6:\"168714\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:12:\"6.x-2.0-beta\";a:13:{s:4:\"name\";s:16:\"cck 6.x-2.0-beta\";s:7:\"version\";s:12:\"6.x-2.0-beta\";s:3:\"tag\";s:18:\"DRUPAL-6--2-0-BETA\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:4:\"beta\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/266143\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-beta.tar.gz\";s:4:\"date\";s:10:\"1212504904\";s:6:\"mdhash\";s:32:\"28c5e224ea6b5bce864f315e07e788b2\";s:8:\"filesize\";s:6:\"145561\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:15:\"cck 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/266142\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278806575\";s:6:\"mdhash\";s:32:\"5eb30e6c2b323402b175320b38456d94\";s:8:\"filesize\";s:6:\"440567\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:13:\"6.x-1.0-alpha\";a:13:{s:4:\"name\";s:17:\"cck 6.x-1.0-alpha\";s:7:\"version\";s:13:\"6.x-1.0-alpha\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-ALPHA\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"alpha\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/250976\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/cck-6.x-1.0-alpha.tar.gz\";s:4:\"date\";s:10:\"1209089705\";s:6:\"mdhash\";s:32:\"5d5924ab9cbf5d7b9a0ed4b405659c44\";s:8:\"filesize\";s:6:\"132004\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:15:\"cck 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/96064\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278806576\";s:6:\"mdhash\";s:32:\"607c17f207a8986d5c32656bf915bf09\";s:8:\"filesize\";s:6:\"176631\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}}s:3:\"ctm\";a:10:{s:5:\"title\";s:30:\"Menu Settings per Content Type\";s:10:\"short_name\";s:3:\"ctm\";s:10:\"dc:creator\";s:6:\"vasike\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:29:\"http://drupal.org/project/ctm\";s:8:\"releases\";a:2:{s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:11:\"ctm 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/338444\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/ctm-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1227532508\";s:6:\"mdhash\";s:32:\"9b3979939277c1b8decdeb7a4b4ee074\";s:8:\"filesize\";s:4:\"6961\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:15:\"ctm 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/338405\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/ctm-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833848\";s:6:\"mdhash\";s:32:\"9ffea47b5a482d217fef1db1db0c2019\";s:8:\"filesize\";s:4:\"6972\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}}s:6:\"ctools\";a:10:{s:5:\"title\";s:16:\"Chaos tool suite\";s:10:\"short_name\";s:6:\"ctools\";s:10:\"dc:creator\";s:13:\"merlinofchaos\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:32:\"http://drupal.org/project/ctools\";s:8:\"releases\";a:17:{s:7:\"6.x-1.7\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/865580\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1280189116\";s:6:\"mdhash\";s:32:\"33e01a3ea69f3529b25bd89bbb71b6b5\";s:8:\"filesize\";s:6:\"465667\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/815542\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1275441008\";s:6:\"mdhash\";s:32:\"e66289bd55a88f6613520a1c5c19b110\";s:8:\"filesize\";s:6:\"411831\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812450\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1275094506\";s:6:\"mdhash\";s:32:\"15e0cd9559927280b5a5f9fc4a659e32\";s:8:\"filesize\";s:6:\"411611\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/803912\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1274320505\";s:6:\"mdhash\";s:32:\"48733a28fdb6745d597b8fece736b5b0\";s:8:\"filesize\";s:6:\"411312\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-1.3\";a:11:{s:4:\"name\";s:14:\"ctools 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/701808\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1265065810\";s:6:\"mdhash\";s:32:\"f3cfab0b951c6e63b8b1d31e969518b7\";s:8:\"filesize\";s:6:\"382191\";}s:7:\"6.x-1.2\";a:11:{s:4:\"name\";s:14:\"ctools 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/611098\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1256162716\";s:6:\"mdhash\";s:32:\"96c17a48adf85b4ddc704dbc6e1978d5\";s:8:\"filesize\";s:6:\"306141\";}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/605838\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1255638634\";s:6:\"mdhash\";s:32:\"396e10932942e3b72b140787f8e588ff\";s:8:\"filesize\";s:6:\"305914\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/554222\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1250724632\";s:6:\"mdhash\";s:32:\"4332c9a6d9b7d3b4068c594f8068c8db\";s:8:\"filesize\";s:6:\"318156\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc1\";a:13:{s:4:\"name\";s:18:\"ctools 6.x-1.0-rc1\";s:7:\"version\";s:11:\"6.x-1.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/528132\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1248309035\";s:6:\"mdhash\";s:32:\"442ac724b717d2fb8daf3b9209f72933\";s:8:\"filesize\";s:6:\"216456\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta4\";a:13:{s:4:\"name\";s:20:\"ctools 6.x-1.0-beta4\";s:7:\"version\";s:13:\"6.x-1.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/517084\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1247424021\";s:6:\"mdhash\";s:32:\"725b6b5964e80e1f2e5c352ce634d5f4\";s:8:\"filesize\";s:6:\"209089\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta3\";a:13:{s:4:\"name\";s:20:\"ctools 6.x-1.0-beta3\";s:7:\"version\";s:13:\"6.x-1.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/468642\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1242863124\";s:6:\"mdhash\";s:32:\"90ecfe732ba5f27dd45564d310feadd1\";s:8:\"filesize\";s:6:\"198268\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta2\";a:13:{s:4:\"name\";s:20:\"ctools 6.x-1.0-beta2\";s:7:\"version\";s:13:\"6.x-1.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/457546\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1241799644\";s:6:\"mdhash\";s:32:\"4a033a5d775e651a311fbe8751b47910\";s:8:\"filesize\";s:6:\"192866\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta1\";a:13:{s:4:\"name\";s:20:\"ctools 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/450242\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1241139920\";s:6:\"mdhash\";s:32:\"2329348c4925d41855bcf2b397ca1307\";s:8:\"filesize\";s:6:\"190957\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha3\";a:13:{s:4:\"name\";s:21:\"ctools 6.x-1.0-alpha3\";s:7:\"version\";s:14:\"6.x-1.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/418638\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1238444421\";s:6:\"mdhash\";s:32:\"6555ee952901ef8728f19a0b5b80b8b4\";s:8:\"filesize\";s:6:\"135311\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha2\";a:13:{s:4:\"name\";s:21:\"ctools 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/366426\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1233270625\";s:6:\"mdhash\";s:32:\"684b6aaf8b522f9e43222972846a9611\";s:8:\"filesize\";s:6:\"130835\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:21:\"ctools 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/352586\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1230663018\";s:6:\"mdhash\";s:32:\"5abae4dc22c8d7dea17d34d0260b7916\";s:8:\"filesize\";s:6:\"115136\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:18:\"ctools 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/352590\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280880327\";s:6:\"mdhash\";s:32:\"18e6defd3116cb025becb88a10da19bb\";s:8:\"filesize\";s:6:\"465319\";}}}s:5:\"devel\";a:10:{s:5:\"title\";s:5:\"Devel\";s:10:\"short_name\";s:5:\"devel\";s:10:\"dc:creator\";s:14:\"moshe weitzman\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:31:\"http://drupal.org/project/devel\";s:8:\"releases\";a:24:{s:8:\"6.x-1.21\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.21\";s:7:\"version\";s:8:\"6.x-1.21\";s:3:\"tag\";s:14:\"DRUPAL-6--1-21\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"21\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/874116\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.21.tar.gz\";s:4:\"date\";s:10:\"1280961079\";s:6:\"mdhash\";s:32:\"15bf95b8c3fbe3f570f3f7b590f52ded\";s:8:\"filesize\";s:6:\"175008\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:8:\"6.x-1.20\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.20\";s:7:\"version\";s:8:\"6.x-1.20\";s:3:\"tag\";s:14:\"DRUPAL-6--1-20\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"20\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/777998\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.20.tar.gz\";s:4:\"date\";s:10:\"1271886306\";s:6:\"mdhash\";s:32:\"b605d6a42e430660ef3418541d711c1c\";s:8:\"filesize\";s:6:\"174042\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.19\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.19\";s:7:\"version\";s:8:\"6.x-1.19\";s:3:\"tag\";s:14:\"DRUPAL-6--1-19\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"19\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/746888\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.19.tar.gz\";s:4:\"date\";s:10:\"1268976904\";s:6:\"mdhash\";s:32:\"375c3b79e9e74fb636bf8a6d2fde87d6\";s:8:\"filesize\";s:6:\"173570\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.18\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.18\";s:7:\"version\";s:8:\"6.x-1.18\";s:3:\"tag\";s:14:\"DRUPAL-6--1-18\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/585982\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.18.tar.gz\";s:4:\"date\";s:10:\"1253731829\";s:6:\"mdhash\";s:32:\"5f2b9e5f4b74beec35a1d1cff379ab5c\";s:8:\"filesize\";s:6:\"165785\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:8:\"6.x-1.17\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.17\";s:7:\"version\";s:8:\"6.x-1.17\";s:3:\"tag\";s:14:\"DRUPAL-6--1-17\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/554032\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.17.tar.gz\";s:4:\"date\";s:10:\"1250713853\";s:6:\"mdhash\";s:32:\"31b2cbea82226a729b11bbc91920a7cd\";s:8:\"filesize\";s:6:\"163024\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.16\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.16\";s:7:\"version\";s:8:\"6.x-1.16\";s:3:\"tag\";s:14:\"DRUPAL-6--1-16\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/430072\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.16.tar.gz\";s:4:\"date\";s:10:\"1239375932\";s:6:\"mdhash\";s:32:\"6dc83de5de101460f8eee2db3ea4b7d9\";s:8:\"filesize\";s:6:\"163998\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.15\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.15\";s:7:\"version\";s:8:\"6.x-1.15\";s:3:\"tag\";s:14:\"DRUPAL-6--1-15\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/419014\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.15.tar.gz\";s:4:\"date\";s:10:\"1238471715\";s:6:\"mdhash\";s:32:\"e7cd175671ed62a95bab7093c636e663\";s:8:\"filesize\";s:6:\"163945\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.14\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.14\";s:7:\"version\";s:8:\"6.x-1.14\";s:3:\"tag\";s:14:\"DRUPAL-6--1-14\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/368174\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.14.tar.gz\";s:4:\"date\";s:10:\"1233610814\";s:6:\"mdhash\";s:32:\"11af2d7fa3050febfe3def770683f173\";s:8:\"filesize\";s:6:\"162780\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.13\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.13\";s:7:\"version\";s:8:\"6.x-1.13\";s:3:\"tag\";s:14:\"DRUPAL-6--1-13\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/353382\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.13.tar.gz\";s:4:\"date\";s:10:\"1230872109\";s:6:\"mdhash\";s:32:\"669870433908fccd31e7de9b57434c64\";s:8:\"filesize\";s:6:\"161893\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.12\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.12\";s:7:\"version\";s:8:\"6.x-1.12\";s:3:\"tag\";s:14:\"DRUPAL-6--1-12\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/319216\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.12.tar.gz\";s:4:\"date\";s:10:\"1223583012\";s:6:\"mdhash\";s:32:\"69b345c09ece34812b04e7ccbc2cdf23\";s:8:\"filesize\";s:6:\"146188\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.11\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.11\";s:7:\"version\";s:8:\"6.x-1.11\";s:3:\"tag\";s:14:\"DRUPAL-6--1-11\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/310335\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.11.tar.gz\";s:4:\"date\";s:10:\"1221759046\";s:6:\"mdhash\";s:32:\"93bc2cc8da26d759e46b24f1b9d4e3e2\";s:8:\"filesize\";s:6:\"145693\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.10\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.10\";s:7:\"version\";s:8:\"6.x-1.10\";s:3:\"tag\";s:14:\"DRUPAL-6--1-10\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/283183\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.10.tar.gz\";s:4:\"date\";s:10:\"1216171206\";s:6:\"mdhash\";s:32:\"688ed33b3a2a63bc1bce9da3c2d104de\";s:8:\"filesize\";s:6:\"145188\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.9\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.9\";s:7:\"version\";s:7:\"6.x-1.9\";s:3:\"tag\";s:13:\"DRUPAL-6--1-9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/270064\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1213331113\";s:6:\"mdhash\";s:32:\"8b88659f45e31d8c05fd6990c491ea2a\";s:8:\"filesize\";s:6:\"145153\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.8\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.8\";s:7:\"version\";s:7:\"6.x-1.8\";s:3:\"tag\";s:13:\"DRUPAL-6--1-8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/259615\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1211039106\";s:6:\"mdhash\";s:32:\"d8d8f4ee8dd61ccad625443ebafbe421\";s:8:\"filesize\";s:5:\"76796\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.7\";a:11:{s:4:\"name\";s:13:\"devel 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/237840\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1206300306\";s:6:\"mdhash\";s:32:\"b63eba9e1588baa2f8031589897eb376\";s:8:\"filesize\";s:5:\"72504\";}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/229249\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1204515005\";s:6:\"mdhash\";s:32:\"dc2fd4030922e17258a0fa886557aa9f\";s:8:\"filesize\";s:5:\"72109\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/227742\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1204163705\";s:6:\"mdhash\";s:32:\"4755dc85712f86c24a7615c83bf2d587\";s:8:\"filesize\";s:5:\"72424\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/224889\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1203609008\";s:6:\"mdhash\";s:32:\"9361284333474368c49b807943e7eb09\";s:8:\"filesize\";s:5:\"72289\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/223052\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1203291304\";s:6:\"mdhash\";s:32:\"5dbb78276404810a219395d790bb349d\";s:8:\"filesize\";s:5:\"72231\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/223032\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1203288005\";s:6:\"mdhash\";s:32:\"ec2d609a553289636f2388c54fc69e8b\";s:8:\"filesize\";s:5:\"72232\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/222919\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1203267606\";s:6:\"mdhash\";s:32:\"2d1065298518decda8eb0d0473851ed1\";s:8:\"filesize\";s:5:\"72225\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/208665\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1200012604\";s:6:\"mdhash\";s:32:\"3dbd3cd4c15f001c1ac7067ca58c74ff\";s:8:\"filesize\";s:5:\"53802\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:17:\"devel 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/224617\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/devel-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280966851\";s:6:\"mdhash\";s:32:\"29ff89633eb69d2876620780b589e0b3\";s:8:\"filesize\";s:6:\"175006\";}s:7:\"6.x-0.2\";a:10:{s:4:\"name\";s:13:\"devel 6.x-0.2\";s:7:\"version\";s:7:\"6.x-0.2\";s:3:\"tag\";s:13:\"DRUPAL-6--0-2\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1203287704\";s:6:\"mdhash\";s:32:\"a071278bf76df5acf5320086f80ff4f5\";s:8:\"filesize\";s:5:\"72235\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}}}s:9:\"filefield\";a:10:{s:5:\"title\";s:9:\"FileField\";s:10:\"short_name\";s:9:\"filefield\";s:10:\"dc:creator\";s:11:\"quicksketch\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:35:\"http://drupal.org/project/filefield\";s:8:\"releases\";a:26:{s:7:\"6.x-3.7\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.7\";s:7:\"version\";s:7:\"6.x-3.7\";s:3:\"tag\";s:13:\"DRUPAL-6--3-7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/842206\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.7.tar.gz\";s:4:\"date\";s:10:\"1277943013\";s:6:\"mdhash\";s:32:\"a48dc8f803db538777cc3ba2764e7e17\";s:8:\"filesize\";s:5:\"98840\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.6\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.6\";s:7:\"version\";s:7:\"6.x-3.6\";s:3:\"tag\";s:13:\"DRUPAL-6--3-6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/841158\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.6.tar.gz\";s:4:\"date\";s:10:\"1277870108\";s:6:\"mdhash\";s:32:\"8ca21de2ae336bd6fafbafddb3cf2ea9\";s:8:\"filesize\";s:5:\"98819\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.5\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.5\";s:7:\"version\";s:7:\"6.x-3.5\";s:3:\"tag\";s:13:\"DRUPAL-6--3-5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/830742\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.5.tar.gz\";s:4:\"date\";s:10:\"1276804208\";s:6:\"mdhash\";s:32:\"e4ba04b779224db4a190ace6188e5e08\";s:8:\"filesize\";s:5:\"98760\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.4\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.4\";s:7:\"version\";s:7:\"6.x-3.4\";s:3:\"tag\";s:13:\"DRUPAL-6--3-4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/829754\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.4.tar.gz\";s:4:\"date\";s:10:\"1276734010\";s:6:\"mdhash\";s:32:\"bac8f7cdf325d83a13693508892c8db8\";s:8:\"filesize\";s:5:\"98649\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/791032\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1273102210\";s:6:\"mdhash\";s:32:\"f83dc6f4e69c6518a9f57622d5e5e4b7\";s:8:\"filesize\";s:5:\"92322\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/609874\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1256070656\";s:6:\"mdhash\";s:32:\"bd52f35628e2a5f12b7cde25e654d71e\";s:8:\"filesize\";s:5:\"81900\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/509792\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1246665925\";s:6:\"mdhash\";s:32:\"ef284d4c00c11a3a150950431268b763\";s:8:\"filesize\";s:5:\"77310\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/439772\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1240272650\";s:6:\"mdhash\";s:32:\"ad963dc2c37c651c1b2565009ebd6333\";s:8:\"filesize\";s:5:\"66677\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.0-rc1\";a:13:{s:4:\"name\";s:21:\"filefield 6.x-3.0-rc1\";s:7:\"version\";s:11:\"6.x-3.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--3-0-RC1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/420990\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1238617254\";s:6:\"mdhash\";s:32:\"591ac9f233ca87f88ee81cef5f076055\";s:8:\"filesize\";s:5:\"56677\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:13:\"6.x-3.0-beta3\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-3.0-beta3\";s:7:\"version\";s:13:\"6.x-3.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/408062\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1237533921\";s:6:\"mdhash\";s:32:\"654c7ad272808eaf641964b15ad0d85b\";s:8:\"filesize\";s:5:\"49519\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta2\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-3.0-beta2\";s:7:\"version\";s:13:\"6.x-3.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/406852\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1237435521\";s:6:\"mdhash\";s:32:\"09be0dbd401144a78ad77261c8ad155a\";s:8:\"filesize\";s:5:\"46433\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/402448\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1237111249\";s:6:\"mdhash\";s:32:\"d292c013882d570db8d76fa0dfaf1956\";s:8:\"filesize\";s:5:\"45950\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha7\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha7\";s:7:\"version\";s:14:\"6.x-3.0-alpha7\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/368981\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha7.tar.gz\";s:4:\"date\";s:10:\"1233743443\";s:6:\"mdhash\";s:32:\"e90f5370ae92654f54c55a464ba1902d\";s:8:\"filesize\";s:5:\"42425\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha6\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha6\";s:7:\"version\";s:14:\"6.x-3.0-alpha6\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/357999\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha6.tar.gz\";s:4:\"date\";s:10:\"1231820418\";s:6:\"mdhash\";s:32:\"7b0083a13ea5550fd4238e995d3cc383\";s:8:\"filesize\";s:5:\"42003\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha5\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha5\";s:7:\"version\";s:14:\"6.x-3.0-alpha5\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318257\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1223412645\";s:6:\"mdhash\";s:32:\"b7426b0dcf5d5b81d267d63508da7853\";s:8:\"filesize\";s:5:\"31976\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha4\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha4\";s:7:\"version\";s:14:\"6.x-3.0-alpha4\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/300633\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1219850117\";s:6:\"mdhash\";s:32:\"efbc5f890b1517b346c9232f6ecae390\";s:8:\"filesize\";s:5:\"33924\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295582\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1218762612\";s:6:\"mdhash\";s:32:\"12b651ba7344cf12df6d012bfad6bad9\";s:8:\"filesize\";s:5:\"33822\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292970\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1218219614\";s:6:\"mdhash\";s:32:\"103b43ece002904b595292d43d3824ca\";s:8:\"filesize\";s:5:\"33022\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/289874\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1217572520\";s:6:\"mdhash\";s:32:\"3baa71f7474c685981e4bb21dfea0f2f\";s:8:\"filesize\";s:5:\"33001\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:21:\"filefield 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/96616\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834247\";s:6:\"mdhash\";s:32:\"73d17f0154f925610f26e4f5afa7144a\";s:8:\"filesize\";s:5:\"98847\";}s:13:\"6.x-1.0-beta3\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-1.0-beta3\";s:7:\"version\";s:13:\"6.x-1.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/282502\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1216052708\";s:6:\"mdhash\";s:32:\"16d7dc669271b9ded8d709a03f46a12e\";s:8:\"filesize\";s:5:\"36534\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta2\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-1.0-beta2\";s:7:\"version\";s:13:\"6.x-1.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/276520\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1214786709\";s:6:\"mdhash\";s:32:\"337a36de008d2adba4e241700dfc7835\";s:8:\"filesize\";s:5:\"33771\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta1\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/276020\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1214646309\";s:6:\"mdhash\";s:32:\"f55c8088212c8ef790128d672ea63d3c\";s:8:\"filesize\";s:5:\"30229\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha3\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-1.0-alpha3\";s:7:\"version\";s:14:\"6.x-1.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275237\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1214484311\";s:6:\"mdhash\";s:32:\"35edea2e3c2d7586c9efe7bde7d89875\";s:8:\"filesize\";s:5:\"28409\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha2\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/274537\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1214353208\";s:6:\"mdhash\";s:32:\"fad99b3ccc10d1c7185e05190c18b2e2\";s:8:\"filesize\";s:5:\"27684\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/274307\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1214320524\";s:6:\"mdhash\";s:32:\"71cd35da51661f17a066f68dc47ab471\";s:8:\"filesize\";s:5:\"26177\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}}}s:19:\"hierarchical_select\";a:10:{s:5:\"title\";s:19:\"Hierarchical Select\";s:10:\"short_name\";s:19:\"hierarchical_select\";s:10:\"dc:creator\";s:9:\"Wim Leers\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:45:\"http://drupal.org/project/hierarchical_select\";s:8:\"releases\";a:5:{s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:27:\"hierarchical_select 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/848264\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1278589208\";s:6:\"mdhash\";s:32:\"4c3ef9fb34b0369881f12beccd9f46fc\";s:8:\"filesize\";s:5:\"94417\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:27:\"hierarchical_select 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/847284\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1278508810\";s:6:\"mdhash\";s:32:\"78700af5e807a5a934d03dc12b5b9e9e\";s:8:\"filesize\";s:5:\"94416\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:27:\"hierarchical_select 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/763856\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1270586711\";s:6:\"mdhash\";s:32:\"e7ec20b004fe37d46b8f461f96437f29\";s:8:\"filesize\";s:5:\"93356\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:27:\"hierarchical_select 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/671504\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1262263536\";s:6:\"mdhash\";s:32:\"0d1f8d0e0f63950593cd6df6513b4d65\";s:8:\"filesize\";s:5:\"92143\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:31:\"hierarchical_select 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/341008\";s:13:\"download_link\";s:75:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834480\";s:6:\"mdhash\";s:32:\"229eb8a5a2ab8b7e5443ac091e73eebb\";s:8:\"filesize\";s:5:\"94428\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}}s:8:\"imageapi\";a:10:{s:5:\"title\";s:8:\"ImageAPI\";s:10:\"short_name\";s:8:\"imageapi\";s:10:\"dc:creator\";s:7:\"drewish\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:34:\"http://drupal.org/project/imageapi\";s:8:\"releases\";a:12:{s:7:\"6.x-1.8\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.8\";s:7:\"version\";s:7:\"6.x-1.8\";s:3:\"tag\";s:13:\"DRUPAL-6--1-8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/786824\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1272675611\";s:6:\"mdhash\";s:32:\"94a681c95ad69160b6f10975b09bf2c1\";s:8:\"filesize\";s:5:\"32757\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.7\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/786762\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1272667207\";s:6:\"mdhash\";s:32:\"19a84e16371e4db2873ca9b0af5308c7\";s:8:\"filesize\";s:5:\"30193\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/436964\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1239992203\";s:6:\"mdhash\";s:32:\"f37907f3b3189f8ed964ee2a16218f03\";s:8:\"filesize\";s:5:\"23769\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/405820\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1237371335\";s:6:\"mdhash\";s:32:\"0127a0556a4261f906538f4211b8650e\";s:8:\"filesize\";s:5:\"23813\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/398654\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1236792328\";s:6:\"mdhash\";s:32:\"cffb8c9b3de4bbae7860df1cbe1c55c7\";s:8:\"filesize\";s:5:\"23850\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370133\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1233920429\";s:6:\"mdhash\";s:32:\"8f1ee8d4cf7ae9e590406dd209b32117\";s:8:\"filesize\";s:5:\"22816\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354868\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1231215617\";s:6:\"mdhash\";s:32:\"41bf47a306b1cdf0a611800ba6f210cc\";s:8:\"filesize\";s:5:\"22754\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:10:{s:4:\"name\";s:16:\"imageapi 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1226821512\";s:6:\"mdhash\";s:32:\"d8f08b6ffc6c2f08701bb553c317ac93\";s:8:\"filesize\";s:5:\"22491\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:16:\"imageapi 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/313564\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1222378231\";s:6:\"mdhash\";s:32:\"d2e6ecdfcda91ce87037899af1a42a48\";s:8:\"filesize\";s:5:\"18843\";}s:14:\"6.x-1.0-alpha2\";a:13:{s:4:\"name\";s:23:\"imageapi 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292966\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1218219019\";s:6:\"mdhash\";s:32:\"e5e1723c878b372e0f71a54deade2759\";s:8:\"filesize\";s:5:\"18832\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:23:\"imageapi 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275936\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1214610910\";s:6:\"mdhash\";s:32:\"35bc5ec06dbfa7cf88f55223b161e8d9\";s:8:\"filesize\";s:5:\"16813\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:20:\"imageapi 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/257609\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834535\";s:6:\"mdhash\";s:32:\"2f59ebc1980e002d4ceac5f203be217f\";s:8:\"filesize\";s:5:\"32928\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}}s:10:\"imagecache\";a:10:{s:5:\"title\";s:10:\"ImageCache\";s:10:\"short_name\";s:10:\"imagecache\";s:10:\"dc:creator\";s:7:\"drewish\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/imagecache\";s:8:\"releases\";a:13:{s:14:\"6.x-2.0-beta10\";a:13:{s:4:\"name\";s:25:\"imagecache 6.x-2.0-beta10\";s:7:\"version\";s:14:\"6.x-2.0-beta10\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-BETA10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"beta10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/554090\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta10.tar.gz\";s:4:\"date\";s:10:\"1250716281\";s:6:\"mdhash\";s:32:\"70b0132f0f8506a42d7e4481802b87af\";s:8:\"filesize\";s:5:\"67482\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:13:\"6.x-2.0-beta9\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta9\";s:7:\"version\";s:13:\"6.x-2.0-beta9\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/436974\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta9.tar.gz\";s:4:\"date\";s:10:\"1239992507\";s:6:\"mdhash\";s:32:\"ba1ff29cde2680fc4530ec03bb314f40\";s:8:\"filesize\";s:5:\"63999\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta8\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta8\";s:7:\"version\";s:13:\"6.x-2.0-beta8\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/375944\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta8.tar.gz\";s:4:\"date\";s:10:\"1234908073\";s:6:\"mdhash\";s:32:\"da2a33a8b515aa24a8968e8c900ede29\";s:8:\"filesize\";s:5:\"57863\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta7\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta7\";s:7:\"version\";s:13:\"6.x-2.0-beta7\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/375935\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta7.tar.gz\";s:4:\"date\";s:10:\"1234907441\";s:6:\"mdhash\";s:32:\"2fc3ec524113c7f25f60343d80e9ef2c\";s:8:\"filesize\";s:5:\"57868\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta6\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta6\";s:7:\"version\";s:13:\"6.x-2.0-beta6\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370142\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta6.tar.gz\";s:4:\"date\";s:10:\"1233921654\";s:6:\"mdhash\";s:32:\"37aeefc218c3c67f2669bb31ae70ec04\";s:8:\"filesize\";s:5:\"56280\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta5\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta5\";s:7:\"version\";s:13:\"6.x-2.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/355169\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1231271425\";s:6:\"mdhash\";s:32:\"fec1fb74904033c1bfe296edfaeaf475\";s:8:\"filesize\";s:5:\"56246\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354866\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1231215019\";s:6:\"mdhash\";s:32:\"91a36885a8e13a6c2a33aa5ed351cdda\";s:8:\"filesize\";s:5:\"56233\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/349938\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1229907316\";s:6:\"mdhash\";s:32:\"1c7df03f8e9d6035550d08e670482318\";s:8:\"filesize\";s:5:\"29771\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/327844\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1225317623\";s:6:\"mdhash\";s:32:\"38b7b964197263d2c23094ed0ce82e1d\";s:8:\"filesize\";s:5:\"24920\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318352\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1223430312\";s:6:\"mdhash\";s:32:\"dd23eb6c526a9c700218e9ee9f27837e\";s:8:\"filesize\";s:5:\"24918\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:22:\"imagecache 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/96391\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834538\";s:6:\"mdhash\";s:32:\"e2180ee4e02dd3bf314ef8f224caed8e\";s:8:\"filesize\";s:6:\"235406\";}s:14:\"6.x-1.0-alpha2\";a:13:{s:4:\"name\";s:25:\"imagecache 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292975\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagecache-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1218219914\";s:6:\"mdhash\";s:32:\"dd6f9663370215c513f5f0f12dc9e0aa\";s:8:\"filesize\";s:5:\"24806\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:25:\"imagecache 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275934\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagecache-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1214610910\";s:6:\"mdhash\";s:32:\"17e0a01b206046a1c84d3341797bcd40\";s:8:\"filesize\";s:5:\"23765\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}}s:18:\"imagecache_actions\";a:10:{s:5:\"title\";s:18:\"ImageCache Actions\";s:10:\"short_name\";s:18:\"imagecache_actions\";s:10:\"dc:creator\";s:4:\"dman\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:44:\"http://drupal.org/project/imagecache_actions\";s:8:\"releases\";a:10:{s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/808754\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1274793008\";s:6:\"mdhash\";s:32:\"e6caba0f70ffa1eea1609db0acadd1db\";s:8:\"filesize\";s:7:\"2195813\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:30:\"imagecache_actions 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/740560\";s:13:\"download_link\";s:74:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280189301\";s:6:\"mdhash\";s:32:\"e40a229563d5f0977a5b80d9b13c8498\";s:8:\"filesize\";s:7:\"2182820\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.7\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/808820\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1274796307\";s:6:\"mdhash\";s:32:\"980f3932545cfff5341e6137ea40cad7\";s:8:\"filesize\";s:7:\"1382694\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/487042\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1244598933\";s:6:\"mdhash\";s:32:\"acdaa251329c91292686ec24c5cc7946\";s:8:\"filesize\";s:7:\"1000474\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/413948\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1238018466\";s:6:\"mdhash\";s:32:\"2ba9c6f6a3bd2f7490c13d28bbffc891\";s:8:\"filesize\";s:7:\"1515895\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/400274\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1236900027\";s:6:\"mdhash\";s:32:\"5670d298e6cae58d16094b7a745f9b9f\";s:8:\"filesize\";s:7:\"1156857\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370821\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1234044626\";s:6:\"mdhash\";s:32:\"7d5b7e4fceb331265c4947b83594767f\";s:8:\"filesize\";s:6:\"798364\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/332112\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1226245516\";s:6:\"mdhash\";s:32:\"d2b17bba4e951a54ad68c2e41f27df5a\";s:8:\"filesize\";s:6:\"935928\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/321971\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1224146419\";s:6:\"mdhash\";s:32:\"b4aa4dff119f3295f4ec419bbebc655d\";s:8:\"filesize\";s:6:\"577632\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:30:\"imagecache_actions 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318918\";s:13:\"download_link\";s:74:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834539\";s:6:\"mdhash\";s:32:\"391e098e7a9465f7645f211ec0add4a3\";s:8:\"filesize\";s:7:\"1394890\";}}}s:18:\"imagecache_effects\";a:10:{s:5:\"title\";s:18:\"Imagecache Effects\";s:10:\"short_name\";s:18:\"imagecache_effects\";s:10:\"dc:creator\";s:10:\"evil_marty\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:44:\"http://drupal.org/project/imagecache_effects\";s:8:\"releases\";a:2:{s:7:\"6.x-1.1\";a:11:{s:4:\"name\";s:26:\"imagecache_effects 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354402\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_effects-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1231131919\";s:6:\"mdhash\";s:32:\"05790530422f4b745d86af890028cba5\";s:8:\"filesize\";s:5:\"10985\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:30:\"imagecache_effects 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354312\";s:13:\"download_link\";s:74:\"http://ftp.drupal.org/files/projects/imagecache_effects-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834541\";s:6:\"mdhash\";s:32:\"117a9a54bd7edf4a15127bfe27b34a3f\";s:8:\"filesize\";s:5:\"10992\";}}}s:10:\"imagefield\";a:10:{s:5:\"title\";s:10:\"ImageField\";s:10:\"short_name\";s:10:\"imagefield\";s:10:\"dc:creator\";s:11:\"quicksketch\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/imagefield\";s:8:\"releases\";a:15:{s:7:\"6.x-3.7\";a:11:{s:4:\"name\";s:18:\"imagefield 6.x-3.7\";s:7:\"version\";s:7:\"6.x-3.7\";s:3:\"tag\";s:13:\"DRUPAL-6--3-7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/842202\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.7.tar.gz\";s:4:\"date\";s:10:\"1277942710\";s:6:\"mdhash\";s:32:\"3fe5ea1f1709775c4542871cb3b12c9a\";s:8:\"filesize\";s:5:\"36360\";}s:7:\"6.x-3.6\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.6\";s:7:\"version\";s:7:\"6.x-3.6\";s:3:\"tag\";s:13:\"DRUPAL-6--3-6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/841160\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.6.tar.gz\";s:4:\"date\";s:10:\"1277870109\";s:6:\"mdhash\";s:32:\"c53d67ca6a594c7b02a40581403d9dd1\";s:8:\"filesize\";s:5:\"36360\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/791030\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1273102211\";s:6:\"mdhash\";s:32:\"c75dfd4912e569868a9bb8fef447f66a\";s:8:\"filesize\";s:5:\"35520\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/609878\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1256070937\";s:6:\"mdhash\";s:32:\"6e5700f65209708913c389c075b0ebe7\";s:8:\"filesize\";s:5:\"30534\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/509788\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1246665655\";s:6:\"mdhash\";s:32:\"8aee5d27405bb818da9e53dff52fea03\";s:8:\"filesize\";s:5:\"27258\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/439776\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1240272934\";s:6:\"mdhash\";s:32:\"518413c94a2b60ebbee2527a175ce828\";s:8:\"filesize\";s:5:\"25309\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.0-rc1\";a:13:{s:4:\"name\";s:22:\"imagefield 6.x-3.0-rc1\";s:7:\"version\";s:11:\"6.x-3.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--3-0-RC1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/421006\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1238618152\";s:6:\"mdhash\";s:32:\"408e3510544987622a38dcb5a9222a24\";s:8:\"filesize\";s:5:\"25076\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta3\";a:13:{s:4:\"name\";s:24:\"imagefield 6.x-3.0-beta3\";s:7:\"version\";s:13:\"6.x-3.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/408064\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1237534251\";s:6:\"mdhash\";s:32:\"dce14931da48a5db72e71e2a7239526a\";s:8:\"filesize\";s:5:\"21839\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta2\";a:13:{s:4:\"name\";s:24:\"imagefield 6.x-3.0-beta2\";s:7:\"version\";s:13:\"6.x-3.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/406846\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1237435254\";s:6:\"mdhash\";s:32:\"2ff6ec9186edba9705a06fb2e6c4d868\";s:8:\"filesize\";s:5:\"21932\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:24:\"imagefield 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/402452\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1237112123\";s:6:\"mdhash\";s:32:\"0ca7d8c0e59154d6c02a9b6e3451a4b3\";s:8:\"filesize\";s:5:\"21651\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha4\";a:13:{s:4:\"name\";s:25:\"imagefield 6.x-3.0-alpha4\";s:7:\"version\";s:14:\"6.x-3.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/357439\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1231716017\";s:6:\"mdhash\";s:32:\"9d4e3efe3a2f1380880cb3581e39867d\";s:8:\"filesize\";s:5:\"19371\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:25:\"imagefield 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/352408\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1230629116\";s:6:\"mdhash\";s:32:\"c686ef38ac5754b448e0083e869b5df2\";s:8:\"filesize\";s:5:\"19165\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:25:\"imagefield 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/300636\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1219850122\";s:6:\"mdhash\";s:32:\"01a404bac9ad55f5cfff5312ac480a77\";s:8:\"filesize\";s:5:\"17205\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:25:\"imagefield 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292981\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1218220514\";s:6:\"mdhash\";s:32:\"0ec96da0b37dc803e2bc9c49541b5617\";s:8:\"filesize\";s:5:\"17286\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:22:\"imagefield 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/96519\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834544\";s:6:\"mdhash\";s:32:\"f6344692bdeca3cee9545c1c4ad0c1b5\";s:8:\"filesize\";s:5:\"36360\";}}}s:4:\"imce\";a:10:{s:5:\"title\";s:4:\"IMCE\";s:10:\"short_name\";s:4:\"imce\";s:10:\"dc:creator\";s:4:\"ufku\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:30:\"http://drupal.org/project/imce\";s:8:\"releases\";a:11:{s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:16:\"imce 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/865140\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imce-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1280160060\";s:6:\"mdhash\";s:32:\"f1c695c58761698e31f509dbf645222c\";s:8:\"filesize\";s:5:\"58307\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:18:\"imce 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812926\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imce-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1275171908\";s:6:\"mdhash\";s:32:\"902202ccc74238467f1d684ec8e22776\";s:8:\"filesize\";s:5:\"57975\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:18:\"imce 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812592\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imce-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1275124808\";s:6:\"mdhash\";s:32:\"d6b3421b73d93804615878ff526dbf1f\";s:8:\"filesize\";s:5:\"57957\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:18:\"imce 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/745524\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imce-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1268868008\";s:6:\"mdhash\";s:32:\"57650c4154c7a787cd1014a0c3ef6acc\";s:8:\"filesize\";s:5:\"55910\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:16:\"imce 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/745638\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imce-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279800550\";s:6:\"mdhash\";s:32:\"23a083cc5d2bb6e55b249a523d321bcd\";s:8:\"filesize\";s:5:\"58308\";}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:12:\"imce 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812472\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1275099908\";s:6:\"mdhash\";s:32:\"173671054e8831c5e19f784cc5dc413d\";s:8:\"filesize\";s:6:\"110091\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:12:\"imce 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/587952\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1253890535\";s:6:\"mdhash\";s:32:\"f09555cd6454d1623c29258ab27525f9\";s:8:\"filesize\";s:5:\"98382\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:12:\"imce 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/379266\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1235227525\";s:6:\"mdhash\";s:32:\"0045f383acf0d49538ea74fe9c832d2c\";s:8:\"filesize\";s:5:\"69523\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:12:\"imce 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/286385\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1216839313\";s:6:\"mdhash\";s:32:\"f630895cbbeddeb8ddbdf034e378897c\";s:8:\"filesize\";s:5:\"61264\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:12:\"imce 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/254557\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1209915610\";s:6:\"mdhash\";s:32:\"e7d80f9f2d55225ecdcca2ab590d1601\";s:8:\"filesize\";s:5:\"52832\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:16:\"imce 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/238016\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imce-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834565\";s:6:\"mdhash\";s:32:\"7e55f7af0171f599ba34536f1d657b2d\";s:8:\"filesize\";s:6:\"110105\";}}}s:12:\"imce_wysiwyg\";a:10:{s:5:\"title\";s:19:\"IMCE Wysiwyg bridge\";s:10:\"short_name\";s:12:\"imce_wysiwyg\";s:10:\"dc:creator\";s:3:\"sun\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:38:\"http://drupal.org/project/imce_wysiwyg\";s:8:\"releases\";a:3:{s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:20:\"imce_wysiwyg 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/741170\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/imce_wysiwyg-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1268433606\";s:6:\"mdhash\";s:32:\"3fd03f7e05e058d0fbd22e3e6d5573d7\";s:8:\"filesize\";s:4:\"8756\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:20:\"imce_wysiwyg 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/390960\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/imce_wysiwyg-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1236182123\";s:6:\"mdhash\";s:32:\"1b1c172985c6de7dd1dd013b46d62fc4\";s:8:\"filesize\";s:4:\"7690\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:24:\"imce_wysiwyg 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/383902\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imce_wysiwyg-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834569\";s:6:\"mdhash\";s:32:\"63e7ddc4ef0d31515b6adc52c47bdc07\";s:8:\"filesize\";s:4:\"8768\";}}}s:10:\"jquerymenu\";a:10:{s:5:\"title\";s:11:\"JQuery menu\";s:10:\"short_name\";s:10:\"jquerymenu\";s:10:\"dc:creator\";s:13:\"Aaron Hawkins\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/jquerymenu\";s:8:\"releases\";a:17:{s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/799538\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1273902007\";s:6:\"mdhash\";s:32:\"e3a615f3c0104006324fb8369b83eddd\";s:8:\"filesize\";s:5:\"14157\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.2\";a:11:{s:4:\"name\";s:18:\"jquerymenu 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/790206\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1273046107\";s:6:\"mdhash\";s:32:\"895316145b0480bce1282ddec5e31d45\";s:8:\"filesize\";s:5:\"13287\";}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/633816\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1258361451\";s:6:\"mdhash\";s:32:\"5dcec1c8906fa7a806f9e0fe80dbe5ab\";s:8:\"filesize\";s:5:\"13280\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/375939\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1234907752\";s:6:\"mdhash\";s:32:\"7c008f95c6f95f22ccc0e6e30ab08fcb\";s:8:\"filesize\";s:5:\"11430\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/375176\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1234799154\";s:6:\"mdhash\";s:32:\"6b6a8ca9139ac2efeffdf28d800e392b\";s:8:\"filesize\";s:5:\"11408\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370608\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1234008044\";s:6:\"mdhash\";s:32:\"66c6aa9e3cf748edfc78e2a101e52c54\";s:8:\"filesize\";s:5:\"11372\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/369325\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1233784975\";s:6:\"mdhash\";s:32:\"2291fd5923b941d56c3f8012f937cfc7\";s:8:\"filesize\";s:5:\"10500\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.9\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.9\";s:7:\"version\";s:7:\"6.x-1.9\";s:3:\"tag\";s:13:\"DRUPAL-6--1-9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354524\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1231161626\";s:6:\"mdhash\";s:32:\"3d08e06f70404a4d7872f4b75055554e\";s:8:\"filesize\";s:5:\"10520\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.8\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.8\";s:7:\"version\";s:7:\"6.x-1.8\";s:3:\"tag\";s:13:\"DRUPAL-6--1-8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/351854\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1230492629\";s:6:\"mdhash\";s:32:\"4e309dc67b84e3c827b829f48155c09c\";s:8:\"filesize\";s:5:\"10337\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.7\";a:11:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/349054\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1229683222\";s:6:\"mdhash\";s:32:\"76802b1c93b82a5a5f5075416f213b03\";s:8:\"filesize\";s:5:\"10219\";}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/348466\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1229561728\";s:6:\"mdhash\";s:32:\"405e894548c5d8e530040c8049e50d40\";s:8:\"filesize\";s:5:\"10244\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/343942\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1228659637\";s:6:\"mdhash\";s:32:\"55bb3176a7f2ad48440c887b248aef1d\";s:8:\"filesize\";s:5:\"10226\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:11:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/343931\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1228656325\";s:6:\"mdhash\";s:32:\"d23bb0bc1164f23a430b6aac465a76c2\";s:8:\"filesize\";s:5:\"10190\";}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/340795\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1228053916\";s:6:\"mdhash\";s:32:\"5bfb1ad68f657a7a173562cd31ad2ae8\";s:8:\"filesize\";s:5:\"10242\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/334431\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1226694016\";s:6:\"mdhash\";s:32:\"13600a256557fb04e1079772478451bb\";s:8:\"filesize\";s:5:\"10116\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/334295\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1226673317\";s:6:\"mdhash\";s:32:\"7cafd7ca8a5e21e60eb5336a07171645\";s:8:\"filesize\";s:4:\"9976\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/333384\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1226502027\";s:6:\"mdhash\";s:32:\"8371399bff4c647a94699b52edbe5aa6\";s:8:\"filesize\";s:4:\"9849\";}}}s:4:\"link\";a:10:{s:5:\"title\";s:4:\"Link\";s:10:\"short_name\";s:4:\"link\";s:10:\"dc:creator\";s:7:\"jcfiala\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:30:\"http://drupal.org/project/link\";s:8:\"releases\";a:18:{s:7:\"6.x-2.9\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.9\";s:7:\"version\";s:7:\"6.x-2.9\";s:3:\"tag\";s:13:\"DRUPAL-6--2-9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/827200\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1276539609\";s:6:\"mdhash\";s:32:\"4ded032cae71f43174f70f70ecd57471\";s:8:\"filesize\";s:5:\"40597\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.8\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.8\";s:7:\"version\";s:7:\"6.x-2.8\";s:3:\"tag\";s:13:\"DRUPAL-6--2-8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/623932\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1257394550\";s:6:\"mdhash\";s:32:\"54bf94310938c8000eb80c22464ba2d8\";s:8:\"filesize\";s:5:\"24911\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/620668\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1257135943\";s:6:\"mdhash\";s:32:\"960d3e01365529c1fcae95039e9e7dc9\";s:8:\"filesize\";s:5:\"24902\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/512554\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1246976471\";s:6:\"mdhash\";s:32:\"e9dbc3209f93f78ec14dd8a48c5fb8d6\";s:8:\"filesize\";s:5:\"22630\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:13:\"6.x-2.6-beta3\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.6-beta3\";s:7:\"version\";s:13:\"6.x-2.6-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-6-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/510266\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.6-beta3.tar.gz\";s:4:\"date\";s:10:\"1246734941\";s:6:\"mdhash\";s:32:\"16ad8ed0d366777bbaf02195dee4f010\";s:8:\"filesize\";s:5:\"22631\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.6-beta2\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.6-beta2\";s:7:\"version\";s:13:\"6.x-2.6-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-6-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/507690\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.6-beta2.tar.gz\";s:4:\"date\";s:10:\"1246488355\";s:6:\"mdhash\";s:32:\"76db909e8b2621c9377bfd7060ba339a\";s:8:\"filesize\";s:5:\"23690\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.6-beta1\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.6-beta1\";s:7:\"version\";s:13:\"6.x-2.6-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-6-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/438778\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.6-beta1.tar.gz\";s:4:\"date\";s:10:\"1240201545\";s:6:\"mdhash\";s:32:\"5c7795e16074a0368a50a454eba9ec7c\";s:8:\"filesize\";s:5:\"22117\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/311640\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1222062031\";s:6:\"mdhash\";s:32:\"152beeb2451a532e2f7123ba10cb1866\";s:8:\"filesize\";s:5:\"26255\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/311636\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1222061435\";s:6:\"mdhash\";s:32:\"e038edae40617ed573c3cefb10caac3f\";s:8:\"filesize\";s:5:\"21682\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.x-2.3.1\";a:13:{s:4:\"name\";s:14:\"link 6.x-2.3.1\";s:7:\"version\";s:9:\"6.x-2.3.1\";s:3:\"tag\";s:15:\"DRUPAL-6--2-3-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/284503\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/link-6.x-2.3.1.tar.gz\";s:4:\"date\";s:10:\"1216417210\";s:6:\"mdhash\";s:32:\"51be611f4b6325f0e62ae8da61a22fbc\";s:8:\"filesize\";s:5:\"20500\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/276477\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1214777711\";s:6:\"mdhash\";s:32:\"3fb0a05406086be6a1b65f320d431f34\";s:8:\"filesize\";s:5:\"20495\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/267399\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1212735317\";s:6:\"mdhash\";s:32:\"8856fc24bacd5198cffd46061541473b\";s:8:\"filesize\";s:5:\"18792\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.1-beta4\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.1-beta4\";s:7:\"version\";s:13:\"6.x-2.1-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-1-beta4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/249022\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.1-beta4.tar.gz\";s:4:\"date\";s:10:\"1208720713\";s:6:\"mdhash\";s:32:\"87ffef5ddba6eb90f4fdd2d135399358\";s:8:\"filesize\";s:5:\"16750\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.1-beta2\";a:12:{s:4:\"name\";s:18:\"link 6.x-2.1-beta2\";s:7:\"version\";s:13:\"6.x-2.1-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-1-beta2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/240739\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.1-beta2.tar.gz\";s:4:\"date\";s:10:\"1206952509\";s:6:\"mdhash\";s:32:\"f34f19c3e9d862705d61e4cc1905ffd6\";s:8:\"filesize\";s:5:\"16786\";}s:13:\"6.x-2.1-beta3\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.1-beta3\";s:7:\"version\";s:13:\"6.x-2.1-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-1-beta3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/240740\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.1-beta3.tar.gz\";s:4:\"date\";s:10:\"1206952509\";s:6:\"mdhash\";s:32:\"26cbeb74c30390dba9dd3c97cf83166a\";s:8:\"filesize\";s:5:\"16777\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.1-beta1\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.1-beta1\";s:7:\"version\";s:13:\"6.x-2.1-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-1-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/240723\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.1-beta1.tar.gz\";s:4:\"date\";s:10:\"1206946811\";s:6:\"mdhash\";s:32:\"b2f0d3de0b8135053d8559d36dd41ff7\";s:8:\"filesize\";s:5:\"16773\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:16:\"link 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/580990\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/link-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834740\";s:6:\"mdhash\";s:32:\"360cbbf71f3142a51e6689512c153770\";s:8:\"filesize\";s:5:\"40614\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:16:\"link 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/240722\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/link-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834740\";s:6:\"mdhash\";s:32:\"928e74fb61f369ab6ec4a4a72c1302bb\";s:8:\"filesize\";s:5:\"23692\";}}}s:15:\"menu_attributes\";a:10:{s:5:\"title\";s:15:\"Menu Attributes\";s:10:\"short_name\";s:15:\"menu_attributes\";s:10:\"dc:creator\";s:9:\"Schoonzie\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:41:\"http://drupal.org/project/menu_attributes\";s:8:\"releases\";a:7:{s:7:\"6.x-1.4\";a:11:{s:4:\"name\";s:23:\"menu_attributes 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/440928\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1240350367\";s:6:\"mdhash\";s:32:\"a713995aeb5a99f8cae40890fffdf093\";s:8:\"filesize\";s:4:\"8339\";}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:23:\"menu_attributes 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/440904\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1240349511\";s:6:\"mdhash\";s:32:\"fd0064507f27d04e8d86c4e5ede2c803\";s:8:\"filesize\";s:4:\"8324\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:23:\"menu_attributes 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/364152\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1232933723\";s:6:\"mdhash\";s:32:\"db3c41b196e33f9527050937ee566813\";s:8:\"filesize\";s:4:\"7191\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:23:\"menu_attributes 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/358964\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1231973730\";s:6:\"mdhash\";s:32:\"1fb163bc559ba27c0387be9d38e701d1\";s:8:\"filesize\";s:4:\"7094\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc1\";a:12:{s:4:\"name\";s:27:\"menu_attributes 6.x-1.0-rc1\";s:7:\"version\";s:11:\"6.x-1.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/353372\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1230870022\";s:6:\"mdhash\";s:32:\"1e9b4b7d17fad14ae89fffda0429f19e\";s:8:\"filesize\";s:4:\"6881\";}s:13:\"6.x-1.0-beta1\";a:12:{s:4:\"name\";s:29:\"menu_attributes 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/351982\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1230530724\";s:6:\"mdhash\";s:32:\"bf3e01357b899cf3ee37c1ee9c692324\";s:8:\"filesize\";s:4:\"6965\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:27:\"menu_attributes 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/863620\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280016729\";s:6:\"mdhash\";s:32:\"93d3fa0a8d8a591e8202e26a8ff67d49\";s:8:\"filesize\";s:4:\"8614\";}}}s:10:\"menu_block\";a:10:{s:5:\"title\";s:10:\"Menu block\";s:10:\"short_name\";s:10:\"menu_block\";s:10:\"dc:creator\";s:9:\"JohnAlbin\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/menu_block\";s:8:\"releases\";a:5:{s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:18:\"menu_block 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/752248\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1269474612\";s:6:\"mdhash\";s:32:\"2b220e5dc87e0c85308ec92c7c93bd26\";s:8:\"filesize\";s:5:\"34639\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:18:\"menu_block 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/347427\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1229377222\";s:6:\"mdhash\";s:32:\"f00b51d3ac68f1c95260652f55c4e883\";s:8:\"filesize\";s:5:\"20104\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:18:\"menu_block 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/341098\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1228126522\";s:6:\"mdhash\";s:32:\"3bbfaf58017af2c8144cf5c10aec0e96\";s:8:\"filesize\";s:5:\"19904\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:18:\"menu_block 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/299622\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1219656627\";s:6:\"mdhash\";s:32:\"8285859ad904e0f5113008a6761401ba\";s:8:\"filesize\";s:5:\"13820\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:22:\"menu_block 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/299623\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834864\";s:6:\"mdhash\";s:32:\"7e81149693574036b2476a27870c060c\";s:8:\"filesize\";s:5:\"34689\";}}}s:11:\"menu_editor\";a:10:{s:5:\"title\";s:11:\"Menu Editor\";s:10:\"short_name\";s:11:\"menu_editor\";s:10:\"dc:creator\";s:10:\"donquixote\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:37:\"http://drupal.org/project/menu_editor\";s:8:\"releases\";a:18:{s:17:\"6.x-3.0-unstable3\";a:13:{s:4:\"name\";s:29:\"menu_editor 6.x-3.0-unstable3\";s:7:\"version\";s:17:\"6.x-3.0-unstable3\";s:3:\"tag\";s:23:\"DRUPAL-6--3-0-UNSTABLE3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:9:\"unstable3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/855168\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-3.0-unstable3.tar.gz\";s:4:\"date\";s:10:\"1279205110\";s:6:\"mdhash\";s:32:\"aea612722f5661c125fab8af453c2897\";s:8:\"filesize\";s:5:\"19145\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:17:\"6.x-3.0-unstable2\";a:13:{s:4:\"name\";s:29:\"menu_editor 6.x-3.0-unstable2\";s:7:\"version\";s:17:\"6.x-3.0-unstable2\";s:3:\"tag\";s:23:\"DRUPAL-6--3-0-UNSTABLE2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:9:\"unstable2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/821842\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-3.0-unstable2.tar.gz\";s:4:\"date\";s:10:\"1276014308\";s:6:\"mdhash\";s:32:\"64af081c0e61aa948199dd66dfa7e379\";s:8:\"filesize\";s:5:\"19115\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:17:\"6.x-3.0-unstable1\";a:13:{s:4:\"name\";s:29:\"menu_editor 6.x-3.0-unstable1\";s:7:\"version\";s:17:\"6.x-3.0-unstable1\";s:3:\"tag\";s:23:\"DRUPAL-6--3-0-UNSTABLE1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:9:\"unstable1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/821082\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-3.0-unstable1.tar.gz\";s:4:\"date\";s:10:\"1275960308\";s:6:\"mdhash\";s:32:\"1cd40ad3e34a5f538f15953a3d774c15\";s:8:\"filesize\";s:5:\"18576\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/821076\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279239044\";s:6:\"mdhash\";s:32:\"0beed3f32f316d83e9675f983e3a791d\";s:8:\"filesize\";s:5:\"19142\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:19:\"menu_editor 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/855016\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1279195215\";s:6:\"mdhash\";s:32:\"e6a1570c7f94211a4771873fa63918a0\";s:8:\"filesize\";s:5:\"16412\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:11:{s:4:\"name\";s:19:\"menu_editor 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/821074\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1275959408\";s:6:\"mdhash\";s:32:\"affd13aafd9367dab94ca0b7916de42e\";s:8:\"filesize\";s:5:\"16180\";}s:11:\"6.x-2.0-rc2\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-2.0-rc2\";s:7:\"version\";s:11:\"6.x-2.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/803064\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1274265607\";s:6:\"mdhash\";s:32:\"3dd9e5c9d5967a1bfbec9b2fd8918b09\";s:8:\"filesize\";s:5:\"16173\";}s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:23:\"menu_editor 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/802976\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1274259907\";s:6:\"mdhash\";s:32:\"4e976de9a55024fbcc5aed8d5919f95e\";s:8:\"filesize\";s:5:\"16181\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:25:\"menu_editor 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/781118\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1272201609\";s:6:\"mdhash\";s:32:\"0a97b870edf1a72cf87bf50776f0d652\";s:8:\"filesize\";s:5:\"16066\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:25:\"menu_editor 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/759000\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1270089010\";s:6:\"mdhash\";s:32:\"60f91f4abd9ebc007e6a0634626b753e\";s:8:\"filesize\";s:5:\"15822\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:14:\"6.x-2.0-alpha1\";a:13:{s:4:\"name\";s:26:\"menu_editor 6.x-2.0-alpha1\";s:7:\"version\";s:14:\"6.x-2.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/741990\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1268565906\";s:6:\"mdhash\";s:32:\"71c224f5e3dd73147561e83048650634\";s:8:\"filesize\";s:5:\"15197\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/741988\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279195819\";s:6:\"mdhash\";s:32:\"504045c135e1713c286f957e603ec439\";s:8:\"filesize\";s:5:\"16416\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.3-alpha1\";a:13:{s:4:\"name\";s:26:\"menu_editor 6.x-1.3-alpha1\";s:7:\"version\";s:14:\"6.x-1.3-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-3-ALPHA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/741978\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.3-alpha1.tar.gz\";s:4:\"date\";s:10:\"1268564707\";s:6:\"mdhash\";s:32:\"e8b11710a5afa069e6596ff325148426\";s:8:\"filesize\";s:5:\"15097\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:19:\"menu_editor 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/695478\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1264481106\";s:6:\"mdhash\";s:32:\"06bd1f420b16f85aae97560559e75ded\";s:8:\"filesize\";s:5:\"12622\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:11:{s:4:\"name\";s:19:\"menu_editor 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/695426\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1264476908\";s:6:\"mdhash\";s:32:\"43a2dc46f2827507a13560d2c32b7d7c\";s:8:\"filesize\";s:5:\"14347\";}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:19:\"menu_editor 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/670480\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1262148044\";s:6:\"mdhash\";s:32:\"b33bf71ca80eab5592d670b87641930d\";s:8:\"filesize\";s:5:\"12620\";}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/695406\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834866\";s:6:\"mdhash\";s:32:\"6ba4e6abfe0a87f797989f1aa8e75314\";s:8:\"filesize\";s:5:\"15097\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-0.x-dev\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-0.x-dev\";s:7:\"version\";s:11:\"6.x-0.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/646364\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-0.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834865\";s:6:\"mdhash\";s:32:\"e04539447713e06dd67ba2a5b94892bb\";s:8:\"filesize\";s:5:\"14842\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}}s:6:\"panels\";a:10:{s:5:\"title\";s:6:\"Panels\";s:10:\"short_name\";s:6:\"panels\";s:10:\"dc:creator\";s:13:\"merlinofchaos\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:32:\"http://drupal.org/project/panels\";s:8:\"releases\";a:20:{s:7:\"6.x-3.7\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.7\";s:7:\"version\";s:7:\"6.x-3.7\";s:3:\"tag\";s:13:\"DRUPAL-6--3-7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/865584\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.7.tar.gz\";s:4:\"date\";s:10:\"1280189119\";s:6:\"mdhash\";s:32:\"e3a45d1e4085e4dc7736f20de9d209f7\";s:8:\"filesize\";s:6:\"382477\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.5\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.5\";s:7:\"version\";s:7:\"6.x-3.5\";s:3:\"tag\";s:13:\"DRUPAL-6--3-5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812452\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.5.tar.gz\";s:4:\"date\";s:10:\"1275094509\";s:6:\"mdhash\";s:32:\"f713545b0a818271a43ffc10c9e192bd\";s:8:\"filesize\";s:6:\"348703\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.4\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.4\";s:7:\"version\";s:7:\"6.x-3.4\";s:3:\"tag\";s:13:\"DRUPAL-6--3-4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/803916\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.4.tar.gz\";s:4:\"date\";s:10:\"1274320813\";s:6:\"mdhash\";s:32:\"6fc2170843269a05f65bc22155aa0d97\";s:8:\"filesize\";s:6:\"372024\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/701812\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1265065814\";s:6:\"mdhash\";s:32:\"46285850574246604750def846433e05\";s:8:\"filesize\";s:6:\"348175\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/611096\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1256162761\";s:6:\"mdhash\";s:32:\"9b7a53d7892f202bfb4463a5b4b7e7b7\";s:8:\"filesize\";s:6:\"336144\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/605840\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1255638659\";s:6:\"mdhash\";s:32:\"3533d26f01302b98487f087fafb07580\";s:8:\"filesize\";s:6:\"335965\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/554226\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1250724669\";s:6:\"mdhash\";s:32:\"2bfa7f119253533dcbefa100bf354b61\";s:8:\"filesize\";s:6:\"322329\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.0-rc1\";a:13:{s:4:\"name\";s:18:\"panels 6.x-3.0-rc1\";s:7:\"version\";s:11:\"6.x-3.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--3-0-RC1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/528134\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1248309076\";s:6:\"mdhash\";s:32:\"e86ae024f95f29cf8e1ff9a52394982d\";s:8:\"filesize\";s:6:\"355424\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta4\";a:13:{s:4:\"name\";s:20:\"panels 6.x-3.0-beta4\";s:7:\"version\";s:13:\"6.x-3.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/517088\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1247424051\";s:6:\"mdhash\";s:32:\"705d1347895ad47daed06cefb7d22ce3\";s:8:\"filesize\";s:6:\"337007\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta2\";a:13:{s:4:\"name\";s:20:\"panels 6.x-3.0-beta2\";s:7:\"version\";s:13:\"6.x-3.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/468632\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1242862539\";s:6:\"mdhash\";s:32:\"2e26b928b8c3de8d651fea7fd8e6d63d\";s:8:\"filesize\";s:6:\"339504\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:20:\"panels 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/450240\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1241139940\";s:6:\"mdhash\";s:32:\"403e3907c9b38ccf76b5281b6643861a\";s:8:\"filesize\";s:6:\"337251\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha4\";a:13:{s:4:\"name\";s:21:\"panels 6.x-3.0-alpha4\";s:7:\"version\";s:14:\"6.x-3.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/421994\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1238697971\";s:6:\"mdhash\";s:32:\"f27d2b25d17ce8f065e5dd432f8a1a86\";s:8:\"filesize\";s:6:\"367906\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:21:\"panels 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/418640\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1238444751\";s:6:\"mdhash\";s:32:\"44693a0b993cfccb881c123d13a6f776\";s:8:\"filesize\";s:6:\"367243\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:21:\"panels 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/366425\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1233270339\";s:6:\"mdhash\";s:32:\"5641b7a35fa62580b116c97d5408249e\";s:8:\"filesize\";s:6:\"354040\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:21:\"panels 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/352589\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1230663323\";s:6:\"mdhash\";s:32:\"284d81a8550d65e1a4958e5c84ebba10\";s:8:\"filesize\";s:6:\"400176\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:18:\"panels 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/366922\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/panels-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280967484\";s:6:\"mdhash\";s:32:\"cb25005406e127140a3443589b9f4f5f\";s:8:\"filesize\";s:6:\"382708\";}s:14:\"6.x-2.0-alpha3\";a:11:{s:4:\"name\";s:21:\"panels 6.x-2.0-alpha3\";s:7:\"version\";s:14:\"6.x-2.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1230669628\";s:6:\"mdhash\";s:32:\"af08bf2c2b739341add3723b759a8d3c\";s:8:\"filesize\";s:6:\"418513\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha2\";a:11:{s:4:\"name\";s:21:\"panels 6.x-2.0-alpha2\";s:7:\"version\";s:14:\"6.x-2.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1223825423\";s:6:\"mdhash\";s:32:\"84813abb46ea70be8ab09711edcc007e\";s:8:\"filesize\";s:6:\"399737\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha1\";a:11:{s:4:\"name\";s:21:\"panels 6.x-2.0-alpha1\";s:7:\"version\";s:14:\"6.x-2.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1220497215\";s:6:\"mdhash\";s:32:\"f06c1a814d13dd7becff85a9c7078e3e\";s:8:\"filesize\";s:6:\"356885\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:9:{s:4:\"name\";s:18:\"panels 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1234656855\";s:6:\"mdhash\";s:32:\"c1ff3908e47d5f4f9cfba6077cd8fb4a\";s:8:\"filesize\";s:6:\"416317\";}}}s:8:\"pathauto\";a:10:{s:5:\"title\";s:8:\"Pathauto\";s:10:\"short_name\";s:8:\"pathauto\";s:10:\"dc:creator\";s:8:\"greggles\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:34:\"http://drupal.org/project/pathauto\";s:8:\"releases\";a:6:{s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:20:\"pathauto 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/710692\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/pathauto-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708032\";s:6:\"mdhash\";s:32:\"5fe0342a4d7a329f79d35dcb93880389\";s:8:\"filesize\";s:6:\"130703\";}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:16:\"pathauto 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/727806\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1267299906\";s:6:\"mdhash\";s:32:\"9d612b248ba1de5887ee52b69cbd1ad3\";s:8:\"filesize\";s:6:\"138251\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:16:\"pathauto 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/610622\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1256137878\";s:6:\"mdhash\";s:32:\"e27d8578aa485a68e9cc48d150d24dcc\";s:8:\"filesize\";s:6:\"127507\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:16:\"pathauto 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275258\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1214487317\";s:6:\"mdhash\";s:32:\"1c6e0ef50e5cd3685bff7652c5cd4886\";s:8:\"filesize\";s:6:\"103474\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:16:\"pathauto 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/252930\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1209519916\";s:6:\"mdhash\";s:32:\"c9355aae82a7547c1f601c93d4598732\";s:8:\"filesize\";s:5:\"63114\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:20:\"pathauto 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/95354\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708031\";s:6:\"mdhash\";s:32:\"60f99056d68e951cd3455403fb6c33c1\";s:8:\"filesize\";s:6:\"142048\";}}}s:5:\"rules\";a:10:{s:5:\"title\";s:5:\"Rules\";s:10:\"short_name\";s:5:\"rules\";s:10:\"dc:creator\";s:4:\"fago\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:31:\"http://drupal.org/project/rules\";s:8:\"releases\";a:19:{s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:13:\"rules 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/753980\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/rules-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1269612911\";s:6:\"mdhash\";s:32:\"34227cfdf9213d0ac1c0b1649cd980ab\";s:8:\"filesize\";s:6:\"208913\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:13:\"rules 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/562108\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/rules-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1251458464\";s:6:\"mdhash\";s:32:\"8f83c170841851694acb1af5de997d7b\";s:8:\"filesize\";s:6:\"166265\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:13:\"rules 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/465836\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1242650813\";s:6:\"mdhash\";s:32:\"943345c90a3c7eff49f46c7750e3d562\";s:8:\"filesize\";s:6:\"146811\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc2\";a:13:{s:4:\"name\";s:17:\"rules 6.x-1.0-rc2\";s:7:\"version\";s:11:\"6.x-1.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/449640\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1241101332\";s:6:\"mdhash\";s:32:\"31a63253c533f2ab2148998c953a09ba\";s:8:\"filesize\";s:6:\"143768\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc1\";a:13:{s:4:\"name\";s:17:\"rules 6.x-1.0-rc1\";s:7:\"version\";s:11:\"6.x-1.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/439102\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1240230556\";s:6:\"mdhash\";s:32:\"e63772f0d98db9f839cd150126c0bfea\";s:8:\"filesize\";s:6:\"130322\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta5\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta5\";s:7:\"version\";s:13:\"6.x-1.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/383944\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1235598068\";s:6:\"mdhash\";s:32:\"a1eba007e3cb75195aa8589c37ec4739\";s:8:\"filesize\";s:6:\"124218\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta4\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta4\";s:7:\"version\";s:13:\"6.x-1.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370130\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1233920142\";s:6:\"mdhash\";s:32:\"7a691487316109c85633556cb358438a\";s:8:\"filesize\";s:6:\"123209\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta3\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta3\";s:7:\"version\";s:13:\"6.x-1.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/314905\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1222706456\";s:6:\"mdhash\";s:32:\"68ef6eb274cd27b2c113d527d3e8cedc\";s:8:\"filesize\";s:5:\"84390\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta2\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta2\";s:7:\"version\";s:13:\"6.x-1.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/303578\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1220461524\";s:6:\"mdhash\";s:32:\"31d6bc69b5815be4e7b9b8a930eb0cb5\";s:8:\"filesize\";s:5:\"84209\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta1\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/300060\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1219747215\";s:6:\"mdhash\";s:32:\"612419679c1b2b4225c025c372e1cae4\";s:8:\"filesize\";s:5:\"76064\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha8\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha8\";s:7:\"version\";s:14:\"6.x-1.0-alpha8\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/298161\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha8.tar.gz\";s:4:\"date\";s:10:\"1219329315\";s:6:\"mdhash\";s:32:\"1f0ba2f290f134bb7ce393a0e907ef72\";s:8:\"filesize\";s:5:\"76141\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha7\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha7\";s:7:\"version\";s:14:\"6.x-1.0-alpha7\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/297201\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha7.tar.gz\";s:4:\"date\";s:10:\"1219159830\";s:6:\"mdhash\";s:32:\"cc0ce1603e873640785a19b47d6cbd76\";s:8:\"filesize\";s:5:\"73242\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha6\";a:12:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha6\";s:7:\"version\";s:14:\"6.x-1.0-alpha6\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295256\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha6.tar.gz\";s:4:\"date\";s:10:\"1218713720\";s:6:\"mdhash\";s:32:\"a0b47d1f3622417a2ba44e760b351ce8\";s:8:\"filesize\";s:5:\"70995\";}s:14:\"6.x-1.0-alpha5\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha5\";s:7:\"version\";s:14:\"6.x-1.0-alpha5\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/294355\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1218555034\";s:6:\"mdhash\";s:32:\"0f5aa61494d81cef84e583640060bda7\";s:8:\"filesize\";s:5:\"63255\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha4\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha4\";s:7:\"version\";s:14:\"6.x-1.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/290916\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1217854827\";s:6:\"mdhash\";s:32:\"9253303e9ff2696a24c0d2c133240366\";s:8:\"filesize\";s:5:\"56611\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:14:\"6.x-1.0-alpha3\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha3\";s:7:\"version\";s:14:\"6.x-1.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/289966\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1217592379\";s:6:\"mdhash\";s:32:\"6c41cd855069d476917701b6ea929cda\";s:8:\"filesize\";s:5:\"55100\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:14:\"6.x-1.0-alpha2\";a:12:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/286338\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1216830913\";s:6:\"mdhash\";s:32:\"e5dc9cec039ee903394f56120138f9fc\";s:8:\"filesize\";s:5:\"51848\";}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/282792\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1216110312\";s:6:\"mdhash\";s:32:\"8b2f1616704124c5a0032a63992b7f88\";s:8:\"filesize\";s:5:\"39621\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:17:\"rules 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/271195\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/rules-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708155\";s:6:\"mdhash\";s:32:\"f0873ed1a925d663a3c904103d042230\";s:8:\"filesize\";s:6:\"212068\";}}}s:12:\"semantic_cck\";a:10:{s:5:\"title\";s:12:\"Semantic CCK\";s:10:\"short_name\";s:12:\"semantic_cck\";s:10:\"dc:creator\";s:6:\"rhache\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:38:\"http://drupal.org/project/semantic_cck\";s:8:\"releases\";a:3:{s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:20:\"semantic_cck 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/827500\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/semantic_cck-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1276563009\";s:6:\"mdhash\";s:32:\"a68096d44626a95aaffd6313e987427e\";s:8:\"filesize\";s:5:\"11244\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:20:\"semantic_cck 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/827010\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/semantic_cck-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1276527308\";s:6:\"mdhash\";s:32:\"973e2be59d79c75f1b638970da82198e\";s:8:\"filesize\";s:5:\"11248\";}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:24:\"semantic_cck 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/829408\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/semantic_cck-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279541839\";s:6:\"mdhash\";s:32:\"7eec37bbe04150fd1af2584dd84731bb\";s:8:\"filesize\";s:5:\"11303\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}}}s:13:\"semanticviews\";a:10:{s:5:\"title\";s:14:\"Semantic Views\";s:10:\"short_name\";s:13:\"semanticviews\";s:10:\"dc:creator\";s:9:\"bangpound\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"http://drupal.org/project/semanticviews\";s:8:\"releases\";a:4:{s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:21:\"semanticviews 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/774916\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/semanticviews-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1271635509\";s:6:\"mdhash\";s:32:\"926a4ed32135b9ae7b2e927a538daa1b\";s:8:\"filesize\";s:6:\"226207\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:21:\"semanticviews 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/720070\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/semanticviews-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1266646506\";s:6:\"mdhash\";s:32:\"22e390bb5a863e097a4639732f451dc7\";s:8:\"filesize\";s:6:\"225166\";}s:13:\"6.x-1.0-beta1\";a:12:{s:4:\"name\";s:27:\"semanticviews 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/618466\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/semanticviews-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1256853959\";s:6:\"mdhash\";s:32:\"84b3972fcc36bfd8d501c2f48b46d1ee\";s:8:\"filesize\";s:6:\"224094\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:25:\"semanticviews 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/572328\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/semanticviews-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278835613\";s:6:\"mdhash\";s:32:\"0bcd48fc3f214439b617a6381dbfb65f\";s:8:\"filesize\";s:6:\"226206\";}}}s:13:\"service_links\";a:10:{s:5:\"title\";s:13:\"Service links\";s:10:\"short_name\";s:13:\"service_links\";s:10:\"dc:creator\";s:7:\"TheCrow\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"http://drupal.org/project/service_links\";s:8:\"releases\";a:3:{s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:25:\"service_links 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/423572\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/service_links-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278835625\";s:6:\"mdhash\";s:32:\"5a89a368f30774401672dccd41df7e0b\";s:8:\"filesize\";s:5:\"97165\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:21:\"service_links 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/242700\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/service_links-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1207327212\";s:6:\"mdhash\";s:32:\"5313414dbb7429c17fdf6fa299b5e4a7\";s:8:\"filesize\";s:5:\"22428\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:25:\"service_links 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/234270\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/service_links-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278807395\";s:6:\"mdhash\";s:32:\"fdf9b7d83b6b5ab0ea8ffb95f2b955b1\";s:8:\"filesize\";s:5:\"31188\";}}}s:5:\"token\";a:10:{s:5:\"title\";s:5:\"Token\";s:10:\"short_name\";s:5:\"token\";s:10:\"dc:creator\";s:5:\"eaton\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:31:\"http://drupal.org/project/token\";s:8:\"releases\";a:5:{s:8:\"6.x-1.13\";a:12:{s:4:\"name\";s:14:\"token 6.x-1.13\";s:7:\"version\";s:8:\"6.x-1.13\";s:3:\"tag\";s:14:\"DRUPAL-6--1-13\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/820600\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/token-6.x-1.13.tar.gz\";s:4:\"date\";s:10:\"1275922818\";s:6:\"mdhash\";s:32:\"c640dd34d3d25c0f7079d959bea2a650\";s:8:\"filesize\";s:5:\"61986\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.12\";a:12:{s:4:\"name\";s:14:\"token 6.x-1.12\";s:7:\"version\";s:8:\"6.x-1.12\";s:3:\"tag\";s:14:\"DRUPAL-6--1-12\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/479142\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/token-6.x-1.12.tar.gz\";s:4:\"date\";s:10:\"1243895498\";s:6:\"mdhash\";s:32:\"413e7d796066118f9ba78aaaa2974d80\";s:8:\"filesize\";s:5:\"47427\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.11\";a:12:{s:4:\"name\";s:14:\"token 6.x-1.11\";s:7:\"version\";s:8:\"6.x-1.11\";s:3:\"tag\";s:14:\"DRUPAL-6--1-11\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/290380\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/token-6.x-1.11.tar.gz\";s:4:\"date\";s:10:\"1217698238\";s:6:\"mdhash\";s:32:\"9abb50dec933520496b549d6ef95c1d9\";s:8:\"filesize\";s:5:\"33151\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.10\";a:11:{s:4:\"name\";s:14:\"token 6.x-1.10\";s:7:\"version\";s:8:\"6.x-1.10\";s:3:\"tag\";s:14:\"DRUPAL-6--1-10\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/225619\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/token-6.x-1.10.tar.gz\";s:4:\"date\";s:10:\"1203741911\";s:6:\"mdhash\";s:32:\"262848c39c75a7f832856ba6bc4713ea\";s:8:\"filesize\";s:5:\"17219\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:17:\"token 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/208375\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/token-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280103500\";s:6:\"mdhash\";s:32:\"ae0c57386c656f9ad10b0624766b5c99\";s:8:\"filesize\";s:5:\"68033\";}}}s:13:\"viewreference\";a:10:{s:5:\"title\";s:14:\"View Reference\";s:10:\"short_name\";s:13:\"viewreference\";s:10:\"dc:creator\";s:7:\"danielb\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"http://drupal.org/project/viewreference\";s:8:\"releases\";a:30:{s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:27:\"viewreference 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/793430\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/viewreference-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1273320912\";s:6:\"mdhash\";s:32:\"e07a6259efa2b28f96018cc6f3793437\";s:8:\"filesize\";s:5:\"12510\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:25:\"viewreference 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/793406\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/viewreference-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836264\";s:6:\"mdhash\";s:32:\"b1d38316bf832fc508a50eaf4074ebe9\";s:8:\"filesize\";s:5:\"12520\";}s:8:\"6.x-2.24\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.24\";s:7:\"version\";s:8:\"6.x-2.24\";s:3:\"tag\";s:14:\"DRUPAL-6--2-24\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"24\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/686526\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.24.tar.gz\";s:4:\"date\";s:10:\"1263636305\";s:6:\"mdhash\";s:32:\"8433e82d6320cd9d140cade05fe719d3\";s:8:\"filesize\";s:5:\"12687\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.23\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.23\";s:7:\"version\";s:8:\"6.x-2.23\";s:3:\"tag\";s:14:\"DRUPAL-6--2-23\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"23\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/582604\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.23.tar.gz\";s:4:\"date\";s:10:\"1253441788\";s:6:\"mdhash\";s:32:\"988cac43cec98a5ad45ccc4a71b2cc16\";s:8:\"filesize\";s:5:\"12636\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:8:\"6.x-2.22\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.22\";s:7:\"version\";s:8:\"6.x-2.22\";s:3:\"tag\";s:14:\"DRUPAL-6--2-22\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"22\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/571272\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.22.tar.gz\";s:4:\"date\";s:10:\"1252400493\";s:6:\"mdhash\";s:32:\"74368d691ab5b1bcad7ba94863e4c952\";s:8:\"filesize\";s:5:\"12569\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.21\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.21\";s:7:\"version\";s:8:\"6.x-2.21\";s:3:\"tag\";s:14:\"DRUPAL-6--2-21\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"21\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/511060\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.21.tar.gz\";s:4:\"date\";s:10:\"1246847508\";s:6:\"mdhash\";s:32:\"f9c04100ec4d84485e15588832477bfe\";s:8:\"filesize\";s:5:\"12558\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.20\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.20\";s:7:\"version\";s:8:\"6.x-2.20\";s:3:\"tag\";s:14:\"DRUPAL-6--2-20\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"20\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/511050\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.20.tar.gz\";s:4:\"date\";s:10:\"1246846949\";s:6:\"mdhash\";s:32:\"fdd59708369b49cd6b0ad014ebc3fe62\";s:8:\"filesize\";s:5:\"12579\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.19\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.19\";s:7:\"version\";s:8:\"6.x-2.19\";s:3:\"tag\";s:14:\"DRUPAL-6--2-19\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"19\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/511018\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.19.tar.gz\";s:4:\"date\";s:10:\"1246841759\";s:6:\"mdhash\";s:32:\"03f225817bdbed49f771935e0867499d\";s:8:\"filesize\";s:5:\"12562\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.18\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.18\";s:7:\"version\";s:8:\"6.x-2.18\";s:3:\"tag\";s:14:\"DRUPAL-6--2-18\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/505828\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.18.tar.gz\";s:4:\"date\";s:10:\"1246325158\";s:6:\"mdhash\";s:32:\"9ef6ece555e580a90dcf9988b04925fe\";s:8:\"filesize\";s:5:\"12494\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.17\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.17\";s:7:\"version\";s:8:\"6.x-2.17\";s:3:\"tag\";s:14:\"DRUPAL-6--2-17\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/497676\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.17.tar.gz\";s:4:\"date\";s:10:\"1245565252\";s:6:\"mdhash\";s:32:\"e55862cc785541305fd239c00ca60810\";s:8:\"filesize\";s:5:\"12431\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.16\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.16\";s:7:\"version\";s:8:\"6.x-2.16\";s:3:\"tag\";s:14:\"DRUPAL-6--2-16\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/496870\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.16.tar.gz\";s:4:\"date\";s:10:\"1245453970\";s:6:\"mdhash\";s:32:\"c5cfbb405c535920e0459600b75cbc28\";s:8:\"filesize\";s:5:\"12428\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.15\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.15\";s:7:\"version\";s:8:\"6.x-2.15\";s:3:\"tag\";s:14:\"DRUPAL-6--2-15\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/494838\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.15.tar.gz\";s:4:\"date\";s:10:\"1245290486\";s:6:\"mdhash\";s:32:\"799b3a401186447b19bf240dc2c8f923\";s:8:\"filesize\";s:5:\"12483\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:8:\"6.x-2.14\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.14\";s:7:\"version\";s:8:\"6.x-2.14\";s:3:\"tag\";s:14:\"DRUPAL-6--2-14\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/457978\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.14.tar.gz\";s:4:\"date\";s:10:\"1241835358\";s:6:\"mdhash\";s:32:\"587a2759d0606be79a3d40ec420496fd\";s:8:\"filesize\";s:5:\"12243\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.13\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.13\";s:7:\"version\";s:8:\"6.x-2.13\";s:3:\"tag\";s:14:\"DRUPAL-6--2-13\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/386680\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.13.tar.gz\";s:4:\"date\";s:10:\"1235826657\";s:6:\"mdhash\";s:32:\"56d81a854f6b3df4f3f13079934dafed\";s:8:\"filesize\";s:5:\"12234\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.12\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.12\";s:7:\"version\";s:8:\"6.x-2.12\";s:3:\"tag\";s:14:\"DRUPAL-6--2-12\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/386676\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.12.tar.gz\";s:4:\"date\";s:10:\"1235826352\";s:6:\"mdhash\";s:32:\"22d6fe445e4d68b894e3e3a751334e6f\";s:8:\"filesize\";s:5:\"12222\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.11\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.11\";s:7:\"version\";s:8:\"6.x-2.11\";s:3:\"tag\";s:14:\"DRUPAL-6--2-11\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/339616\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.11.tar.gz\";s:4:\"date\";s:10:\"1227744354\";s:6:\"mdhash\";s:32:\"b5771241b07d87f7a53fa1b2c403be31\";s:8:\"filesize\";s:5:\"12120\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.10\";a:11:{s:4:\"name\";s:22:\"viewreference 6.x-2.10\";s:7:\"version\";s:8:\"6.x-2.10\";s:3:\"tag\";s:14:\"DRUPAL-6--2-10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/339282\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.10.tar.gz\";s:4:\"date\";s:10:\"1227682230\";s:6:\"mdhash\";s:32:\"2fccbdbac4162d6af99d9dbc0d2f4a17\";s:8:\"filesize\";s:5:\"12113\";}s:7:\"6.x-2.9\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.9\";s:7:\"version\";s:7:\"6.x-2.9\";s:3:\"tag\";s:13:\"DRUPAL-6--2-9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/339217\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1227664532\";s:6:\"mdhash\";s:32:\"2ae69c74294061b7923404465d3f806d\";s:8:\"filesize\";s:5:\"12161\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.8\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.8\";s:7:\"version\";s:7:\"6.x-2.8\";s:3:\"tag\";s:13:\"DRUPAL-6--2-8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/324481\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1224643222\";s:6:\"mdhash\";s:32:\"445ca2b9009f8a325bba01202f5c8c43\";s:8:\"filesize\";s:5:\"12152\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/323619\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1224500432\";s:6:\"mdhash\";s:32:\"a9d0a972c048d3d582be59513ccc99a7\";s:8:\"filesize\";s:5:\"12178\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/322977\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1224326420\";s:6:\"mdhash\";s:32:\"8c8c7bd8709ca583c16d85542bae7a53\";s:8:\"filesize\";s:5:\"12157\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/319854\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1223695236\";s:6:\"mdhash\";s:32:\"4e8c60a656590c1c7914e0e08417370a\";s:8:\"filesize\";s:5:\"12135\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/303257\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1220396434\";s:6:\"mdhash\";s:32:\"9843dd99523a78c6ce078af61876b27f\";s:8:\"filesize\";s:5:\"12121\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/302987\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1220349327\";s:6:\"mdhash\";s:32:\"b6c5e65cfe1b1b3c2004c2a6197dfb68\";s:8:\"filesize\";s:5:\"12124\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/302978\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1220347231\";s:6:\"mdhash\";s:32:\"0360b74cca544119e609343c2a14accd\";s:8:\"filesize\";s:5:\"12128\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/302969\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1220345725\";s:6:\"mdhash\";s:32:\"95a3676faa0eead6d8b87f336dbf6104\";s:8:\"filesize\";s:5:\"12143\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/301806\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1220072716\";s:6:\"mdhash\";s:32:\"cdf9a55977a6f0df345a499f54b55a6e\";s:8:\"filesize\";s:5:\"12133\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/298921\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1219465521\";s:6:\"mdhash\";s:32:\"294461e614244099546287c163f49fa9\";s:8:\"filesize\";s:5:\"11287\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277922\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1215038744\";s:6:\"mdhash\";s:32:\"4ca4826f1ea042452a48eb77836d3162\";s:8:\"filesize\";s:5:\"11319\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:21:\"viewreference 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277491\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1214958630\";s:6:\"mdhash\";s:32:\"c9fdc434d7afb168cc360ebad37b1b1c\";s:8:\"filesize\";s:5:\"11301\";}}}s:5:\"views\";a:10:{s:5:\"title\";s:5:\"Views\";s:10:\"short_name\";s:5:\"views\";s:10:\"dc:creator\";s:13:\"merlinofchaos\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:31:\"http://drupal.org/project/views\";s:8:\"releases\";a:31:{s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:20:\"views 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/765092\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1270684212\";s:6:\"mdhash\";s:32:\"fe7b96742eb7d8f62f011f9106896256\";s:8:\"filesize\";s:7:\"1639781\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:20:\"views 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/695302\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1264463413\";s:6:\"mdhash\";s:32:\"6549c80d447a4fa7f8071dfe69fed6fd\";s:8:\"filesize\";s:7:\"1584488\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:20:\"views 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/629202\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1257895600\";s:6:\"mdhash\";s:32:\"0cb60791933141335a7f5032de687004\";s:8:\"filesize\";s:7:\"1552538\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:17:\"views 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/467670\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708445\";s:6:\"mdhash\";s:32:\"91eebe3d4a20e983fb64942062ccfd9d\";s:8:\"filesize\";s:7:\"1645005\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:8:\"6.x-2.11\";a:12:{s:4:\"name\";s:14:\"views 6.x-2.11\";s:7:\"version\";s:8:\"6.x-2.11\";s:3:\"tag\";s:14:\"DRUPAL-6--2-11\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/829846\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/views-6.x-2.11.tar.gz\";s:4:\"date\";s:10:\"1276743616\";s:6:\"mdhash\";s:32:\"ea5ef15e0d03c03627f7c5ea2350d78d\";s:8:\"filesize\";s:7:\"1662750\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:8:\"6.x-2.10\";a:12:{s:4:\"name\";s:14:\"views 6.x-2.10\";s:7:\"version\";s:8:\"6.x-2.10\";s:3:\"tag\";s:14:\"DRUPAL-6--2-10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/766164\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/views-6.x-2.10.tar.gz\";s:4:\"date\";s:10:\"1270766109\";s:6:\"mdhash\";s:32:\"a5868e2316ed2b920d621602b0ee78b3\";s:8:\"filesize\";s:7:\"1655007\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.9\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.9\";s:7:\"version\";s:7:\"6.x-2.9\";s:3:\"tag\";s:13:\"DRUPAL-6--2-9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/765088\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1270683914\";s:6:\"mdhash\";s:32:\"81534c4df203820488063ddba3892886\";s:8:\"filesize\";s:7:\"1654130\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-2.8\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.8\";s:7:\"version\";s:7:\"6.x-2.8\";s:3:\"tag\";s:13:\"DRUPAL-6--2-8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/649642\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1259799378\";s:6:\"mdhash\";s:32:\"70c2e02d6f7288e3979108ab96966ef6\";s:8:\"filesize\";s:7:\"1553915\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/621428\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1257197511\";s:6:\"mdhash\";s:32:\"993a4ce82f5eb6f3f2166de7aa5edbce\";s:8:\"filesize\";s:7:\"1551476\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/488082\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1244671916\";s:6:\"mdhash\";s:32:\"a39827a5430373ab8508f2773b0bc6ea\";s:8:\"filesize\";s:7:\"1534198\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/431016\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1239478365\";s:6:\"mdhash\";s:32:\"2098b66ccb996c38463bc1f276e2c5e4\";s:8:\"filesize\";s:7:\"1421005\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/426916\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1239147355\";s:6:\"mdhash\";s:32:\"7da75bea2204e45cc1c31379ed8c10ac\";s:8:\"filesize\";s:7:\"1419570\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370526\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1233981351\";s:6:\"mdhash\";s:32:\"582bde5b7a68357c026a2bee689fe3cb\";s:8:\"filesize\";s:7:\"1365883\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/347831\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1229455243\";s:6:\"mdhash\";s:32:\"71a5f10609c8cce32bae5a09a2913ba5\";s:8:\"filesize\";s:7:\"1315921\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/323897\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1224538829\";s:6:\"mdhash\";s:32:\"46b80d1acfdd785720de91330c770980\";s:8:\"filesize\";s:7:\"1304664\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/322829\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1224280828\";s:6:\"mdhash\";s:32:\"879ac52df90bf18d1c9d3d454febf609\";s:8:\"filesize\";s:7:\"1304512\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc5\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc5\";s:7:\"version\";s:11:\"6.x-2.0-rc5\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318786\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc5.tar.gz\";s:4:\"date\";s:10:\"1223507724\";s:6:\"mdhash\";s:32:\"f425efe6979c32e7de3cfdc5c6f01a28\";s:8:\"filesize\";s:7:\"1303138\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc4\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc4\";s:7:\"version\";s:11:\"6.x-2.0-rc4\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/315506\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1222819523\";s:6:\"mdhash\";s:32:\"11e1fae3b6ec5b05abdf7bd3f4148628\";s:8:\"filesize\";s:7:\"1301241\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc3\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc3\";s:7:\"version\";s:11:\"6.x-2.0-rc3\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/309397\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1221602125\";s:6:\"mdhash\";s:32:\"f80c1846f8b53961b940c75cb2e19cdc\";s:8:\"filesize\";s:7:\"1292652\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc2\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc2\";s:7:\"version\";s:11:\"6.x-2.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/307230\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1221173427\";s:6:\"mdhash\";s:32:\"e6abdee467e234d63fcb815c3156ee4c\";s:8:\"filesize\";s:7:\"1324961\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277862\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1215030345\";s:6:\"mdhash\";s:32:\"7968787a990c56061aa99ec08231f543\";s:8:\"filesize\";s:7:\"2796661\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:19:\"views 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/270323\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1213384535\";s:6:\"mdhash\";s:32:\"7c69feceffdef7e12ca42a479335f2bc\";s:8:\"filesize\";s:7:\"2762695\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:19:\"views 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/260452\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1211247918\";s:6:\"mdhash\";s:32:\"cb558adc81c9e823c10bd19f7f32680d\";s:8:\"filesize\";s:6:\"246695\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:19:\"views 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/251422\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1209167713\";s:6:\"mdhash\";s:32:\"f11cc711db983d6b8be55df473f3e440\";s:8:\"filesize\";s:6:\"226958\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:19:\"views 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/250924\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1209076839\";s:6:\"mdhash\";s:32:\"abf2a3fc0ec77ed4ca641bfbcd0a577a\";s:8:\"filesize\";s:6:\"216246\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha5\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha5\";s:7:\"version\";s:14:\"6.x-2.0-alpha5\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/245993\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1208050514\";s:6:\"mdhash\";s:32:\"4a0ab2a45188bb205a69d7319bfa0103\";s:8:\"filesize\";s:6:\"293424\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha4\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha4\";s:7:\"version\";s:14:\"6.x-2.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/239997\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1206753612\";s:6:\"mdhash\";s:32:\"3b60a384ff4bf4559e15530e4b68728d\";s:8:\"filesize\";s:6:\"259834\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha3\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha3\";s:7:\"version\";s:14:\"6.x-2.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/234752\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1205632511\";s:6:\"mdhash\";s:32:\"378cf25063ed356d973612ffb16c06ba\";s:8:\"filesize\";s:6:\"233853\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha2\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha2\";s:7:\"version\";s:14:\"6.x-2.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/223163\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1203316508\";s:6:\"mdhash\";s:32:\"168b56a4ae8de81460ff5b9cc48a2233\";s:8:\"filesize\";s:6:\"196366\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha1\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha1\";s:7:\"version\";s:14:\"6.x-2.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/222747\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1203222009\";s:6:\"mdhash\";s:32:\"f836b5c79c2ad78cac252135febffdab\";s:8:\"filesize\";s:6:\"195064\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:17:\"Views 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/95897\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708447\";s:6:\"mdhash\";s:32:\"3c97b73162b31fb54fcd1097d5c12e48\";s:8:\"filesize\";s:7:\"1664861\";}}}s:21:\"views_bulk_operations\";a:10:{s:5:\"title\";s:27:\"Views Bulk Operations (VBO)\";s:10:\"short_name\";s:21:\"views_bulk_operations\";s:10:\"dc:creator\";s:10:\"infojunkie\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,3\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:47:\"http://drupal.org/project/views_bulk_operations\";s:8:\"releases\";a:12:{s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:33:\"views_bulk_operations 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/705744\";s:13:\"download_link\";s:77:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836278\";s:6:\"mdhash\";s:32:\"2d8ff50f8ae1f88ea596e72fbddea2a3\";s:8:\"filesize\";s:5:\"44567\";}s:7:\"6.x-1.9\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.9\";s:7:\"version\";s:7:\"6.x-1.9\";s:3:\"tag\";s:13:\"DRUPAL-6--1-9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/704134\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1265245814\";s:6:\"mdhash\";s:32:\"4f5e1a46648d22241a16eeeda5c1d8ae\";s:8:\"filesize\";s:5:\"41384\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.8\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.8\";s:7:\"version\";s:7:\"6.x-1.8\";s:3:\"tag\";s:13:\"DRUPAL-6--1-8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/573318\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1252556168\";s:6:\"mdhash\";s:32:\"f63816b17ea62832c9c36fa6176138d8\";s:8:\"filesize\";s:5:\"35423\";}s:7:\"6.x-1.7\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/468366\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1242845770\";s:6:\"mdhash\";s:32:\"7f416fe95d84c693d0bd8bab4d1138f8\";s:8:\"filesize\";s:5:\"29357\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/456994\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1241746598\";s:6:\"mdhash\";s:32:\"56676bfc273d20ffd6d9b93b5901a414\";s:8:\"filesize\";s:5:\"28317\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/385040\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1235685696\";s:6:\"mdhash\";s:32:\"823836a57b015cbdaf308d212e3609b0\";s:8:\"filesize\";s:5:\"19583\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/369243\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1233774350\";s:6:\"mdhash\";s:32:\"dcab763ae8e027e4297435fbcc1bb97f\";s:8:\"filesize\";s:5:\"17772\";}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/353139\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1230812434\";s:6:\"mdhash\";s:32:\"47a327267976a872ec61441d1c424a20\";s:8:\"filesize\";s:5:\"17416\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/319383\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1223611236\";s:6:\"mdhash\";s:32:\"c73b2af02669b02cd5b0e59b51cec9a6\";s:8:\"filesize\";s:5:\"14784\";}s:7:\"6.x-1.1\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/316955\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1223088323\";s:6:\"mdhash\";s:32:\"e58bc2c0a9cac134c0d1acefd08892bd\";s:8:\"filesize\";s:5:\"14659\";}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/305205\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1220814320\";s:6:\"mdhash\";s:32:\"e743364599f81ce7776964e1fe17e65b\";s:8:\"filesize\";s:5:\"13399\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:33:\"views_bulk_operations 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/286876\";s:13:\"download_link\";s:77:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279412331\";s:6:\"mdhash\";s:32:\"68099dbd611feeb0401dd56ab5ea75b4\";s:8:\"filesize\";s:5:\"51825\";}}}s:22:\"views_exclude_previous\";a:10:{s:5:\"title\";s:22:\"Views exclude previous\";s:10:\"short_name\";s:22:\"views_exclude_previous\";s:10:\"dc:creator\";s:13:\"Anselm Heaton\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:48:\"http://drupal.org/project/views_exclude_previous\";s:8:\"releases\";a:2:{s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:30:\"views_exclude_previous 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/369047\";s:13:\"download_link\";s:74:\"http://ftp.drupal.org/files/projects/views_exclude_previous-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1233753530\";s:6:\"mdhash\";s:32:\"36ed2c09317e75224d79b5f261c60538\";s:8:\"filesize\";s:4:\"7639\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:34:\"views_exclude_previous 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/306874\";s:13:\"download_link\";s:78:\"http://ftp.drupal.org/files/projects/views_exclude_previous-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836284\";s:6:\"mdhash\";s:32:\"38864b4534fb13d5b1df7b52d56d3719\";s:8:\"filesize\";s:4:\"7642\";}}}s:15:\"views_php_array\";a:10:{s:5:\"title\";s:15:\"Views PHP Array\";s:10:\"short_name\";s:15:\"views_php_array\";s:10:\"dc:creator\";s:8:\"adityakg\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:41:\"http://drupal.org/project/views_php_array\";s:8:\"releases\";a:1:{s:13:\"6.x-1.0.x-dev\";a:11:{s:4:\"name\";s:29:\"views_php_array 6.x-1.0.x-dev\";s:7:\"version\";s:13:\"6.x-1.0.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/813138\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_php_array-6.x-1.0.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708461\";s:6:\"mdhash\";s:32:\"f9769548fbbbc1569bdc196e76d1f8fa\";s:8:\"filesize\";s:5:\"11039\";}}}s:15:\"views_slideshow\";a:10:{s:5:\"title\";s:15:\"Views Slideshow\";s:10:\"short_name\";s:15:\"views_slideshow\";s:10:\"dc:creator\";s:5:\"aaron\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:41:\"http://drupal.org/project/views_slideshow\";s:8:\"releases\";a:14:{s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:27:\"views_slideshow 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/776914\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708463\";s:6:\"mdhash\";s:32:\"0c676780f3a7c6ba83a196ab30ea51b2\";s:8:\"filesize\";s:6:\"284906\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:23:\"views_slideshow 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/860042\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1279683019\";s:6:\"mdhash\";s:32:\"e5def512a5dd0039a2e748559d0930b9\";s:8:\"filesize\";s:6:\"274658\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:23:\"views_slideshow 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/833078\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1277071511\";s:6:\"mdhash\";s:32:\"9eef38cdf7ee0ae18558de72641dbe7d\";s:8:\"filesize\";s:6:\"271304\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:23:\"views_slideshow 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/804646\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1274374814\";s:6:\"mdhash\";s:32:\"3b42e4dccb80d49b32f884f3afb1b3e2\";s:8:\"filesize\";s:6:\"270802\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:23:\"views_slideshow 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/776658\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1271785815\";s:6:\"mdhash\";s:32:\"95a50d0896d322d86738cd6a8a602a21\";s:8:\"filesize\";s:6:\"269245\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta5\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta5\";s:7:\"version\";s:13:\"6.x-2.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/773756\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1271479812\";s:6:\"mdhash\";s:32:\"111c49b5abaee79e7b22e6299269e239\";s:8:\"filesize\";s:6:\"269140\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/769738\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1271144712\";s:6:\"mdhash\";s:32:\"c48b0aec9d47c2c1826a9e9d8d72cd35\";s:8:\"filesize\";s:6:\"268126\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/769710\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1271141413\";s:6:\"mdhash\";s:32:\"397cb287c36bc01e901352f0f5d416e9\";s:8:\"filesize\";s:6:\"268113\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/591500\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1254260517\";s:6:\"mdhash\";s:32:\"4b9e9a6365929ab4ac5e09633a8ccaaf\";s:8:\"filesize\";s:5:\"27661\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/559240\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1251224822\";s:6:\"mdhash\";s:32:\"a0bcfa4073bbd5e885d3305b84d83b9f\";s:8:\"filesize\";s:5:\"23741\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:27:\"views_slideshow 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/558296\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279715144\";s:6:\"mdhash\";s:32:\"c4021ac9b1f9095c88ff7882998da98b\";s:8:\"filesize\";s:6:\"274659\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta2\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-1.0-beta2\";s:7:\"version\";s:13:\"6.x-1.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/434966\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1239848004\";s:6:\"mdhash\";s:32:\"bc36a1d6e5df5988772ac2b1ab4c528a\";s:8:\"filesize\";s:5:\"19875\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta1\";a:12:{s:4:\"name\";s:29:\"views_slideshow 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/315433\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1222806026\";s:6:\"mdhash\";s:32:\"38700e2527956edf44fe84a57688f455\";s:8:\"filesize\";s:5:\"12485\";}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:27:\"views_slideshow 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/315432\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836301\";s:6:\"mdhash\";s:32:\"be91bdac33c61d8df0f11f0530c61eb6\";s:8:\"filesize\";s:5:\"23643\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}}}s:7:\"webform\";a:10:{s:5:\"title\";s:7:\"Webform\";s:10:\"short_name\";s:7:\"webform\";s:10:\"dc:creator\";s:11:\"quicksketch\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:33:\"http://drupal.org/project/webform\";s:8:\"releases\";a:26:{s:13:\"6.x-3.0-beta6\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta6\";s:7:\"version\";s:13:\"6.x-3.0-beta6\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/833242\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta6.tar.gz\";s:4:\"date\";s:10:\"1277096710\";s:6:\"mdhash\";s:32:\"d16966c8a72a6e7c6b72d630970e884e\";s:8:\"filesize\";s:6:\"341700\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta5\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta5\";s:7:\"version\";s:13:\"6.x-3.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/770254\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1271177415\";s:6:\"mdhash\";s:32:\"fe68f0a7d5f9f1f67417769da96b163b\";s:8:\"filesize\";s:6:\"340456\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta4\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta4\";s:7:\"version\";s:13:\"6.x-3.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/760868\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1270268111\";s:6:\"mdhash\";s:32:\"02672a67c0c2eb7bc12df6e424f005a4\";s:8:\"filesize\";s:6:\"338625\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta3\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta3\";s:7:\"version\";s:13:\"6.x-3.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/760848\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1270265709\";s:6:\"mdhash\";s:32:\"68fb2e724fe453f6cab3defe5f1d70d1\";s:8:\"filesize\";s:6:\"338566\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta2\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta2\";s:7:\"version\";s:13:\"6.x-3.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/729372\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1267464309\";s:6:\"mdhash\";s:32:\"15002887b5eeafae70cd726adb589acc\";s:8:\"filesize\";s:6:\"335562\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/713184\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1266026709\";s:6:\"mdhash\";s:32:\"d69c6eee7d7dad6a5995d6d192fd8470\";s:8:\"filesize\";s:6:\"335389\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:19:\"webform 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/730872\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/webform-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708483\";s:6:\"mdhash\";s:32:\"660f7c865d6a4af768187ea97ed3d112\";s:8:\"filesize\";s:6:\"341816\";}s:7:\"6.x-2.9\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.9\";s:7:\"version\";s:7:\"6.x-2.9\";s:3:\"tag\";s:13:\"DRUPAL-6--2-9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/624964\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1257475622\";s:6:\"mdhash\";s:32:\"11fc58301b7f1cc38989cc39a77b4722\";s:8:\"filesize\";s:6:\"291979\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.8\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.8\";s:7:\"version\";s:7:\"6.x-2.8\";s:3:\"tag\";s:13:\"DRUPAL-6--2-8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/604920\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1255570893\";s:6:\"mdhash\";s:32:\"c908306a1ef0ee6d9294f7877775b175\";s:8:\"filesize\";s:6:\"265930\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/481258\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1244059025\";s:6:\"mdhash\";s:32:\"7bd1634ec1e4ac2393cbda7fa2fc6eec\";s:8:\"filesize\";s:6:\"254954\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/374985\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1234762850\";s:6:\"mdhash\";s:32:\"996946e00335273a6c28438ef5b98b5a\";s:8:\"filesize\";s:6:\"248747\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/374541\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1234651250\";s:6:\"mdhash\";s:32:\"cda473f662876293d11abba386294f99\";s:8:\"filesize\";s:6:\"248750\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/357445\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1231716643\";s:6:\"mdhash\";s:32:\"a1f5c75a3d943544b60f8ddc10d019f2\";s:8:\"filesize\";s:6:\"231162\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/324841\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1224704730\";s:6:\"mdhash\";s:32:\"20a979dfdbbb57b4855d335374c318a5\";s:8:\"filesize\";s:6:\"194566\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/317490\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1223275521\";s:6:\"mdhash\";s:32:\"59c3a17257f183d3e59a5cb4ea041db7\";s:8:\"filesize\";s:6:\"183501\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:9:\"6.x-2.1.3\";a:13:{s:4:\"name\";s:17:\"webform 6.x-2.1.3\";s:7:\"version\";s:9:\"6.x-2.1.3\";s:3:\"tag\";s:15:\"DRUPAL-6--2-1-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292747\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/webform-6.x-2.1.3.tar.gz\";s:4:\"date\";s:10:\"1218174017\";s:6:\"mdhash\";s:32:\"8d0dcc14f6d5943da93e7511785915b8\";s:8:\"filesize\";s:6:\"176024\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.x-2.1.2\";a:13:{s:4:\"name\";s:17:\"webform 6.x-2.1.2\";s:7:\"version\";s:9:\"6.x-2.1.2\";s:3:\"tag\";s:15:\"DRUPAL-6--2-1-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/285341\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/webform-6.x-2.1.2.tar.gz\";s:4:\"date\";s:10:\"1216653317\";s:6:\"mdhash\";s:32:\"26b457f340264e997b1ea93c4beb3ac0\";s:8:\"filesize\";s:6:\"175644\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.x-2.1.1\";a:13:{s:4:\"name\";s:17:\"webform 6.x-2.1-1\";s:7:\"version\";s:9:\"6.x-2.1.1\";s:3:\"tag\";s:15:\"DRUPAL-6--2-1-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277305\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/webform-6.x-2.1.1.tar.gz\";s:4:\"date\";s:10:\"1214931323\";s:6:\"mdhash\";s:32:\"19ee46cd2d4ea3771220419ac5078a39\";s:8:\"filesize\";s:6:\"180831\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/276518\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1214786414\";s:6:\"mdhash\";s:32:\"112942c62278acfdf61829e3e5118869\";s:8:\"filesize\";s:6:\"180782\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta6\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta6\";s:7:\"version\";s:13:\"6.x-2.0-beta6\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/256459\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta6.tar.gz\";s:4:\"date\";s:10:\"1210307418\";s:6:\"mdhash\";s:32:\"1889dd81d6310a25b6323b65143b9e6b\";s:8:\"filesize\";s:6:\"155293\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta5\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta5\";s:7:\"version\";s:13:\"6.x-2.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/246706\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1208222114\";s:6:\"mdhash\";s:32:\"4a8693658f31c528f6ba679001ec5f93\";s:8:\"filesize\";s:6:\"155204\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/246041\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1208075712\";s:6:\"mdhash\";s:32:\"3e4229c3edcc3f5b72ee3649645ea034\";s:8:\"filesize\";s:6:\"155186\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/242055\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1207195820\";s:6:\"mdhash\";s:32:\"127ad8d7e9e5352e9c344b7f3196e3d5\";s:8:\"filesize\";s:6:\"155178\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/237420\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1206165914\";s:6:\"mdhash\";s:32:\"4bce334b79fd4c32627bb0efe6936072\";s:8:\"filesize\";s:6:\"144543\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/235014\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1205696119\";s:6:\"mdhash\";s:32:\"9dead3fa91ce0bfc4fd92f21229d3ec8\";s:8:\"filesize\";s:6:\"143962\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:19:\"webform 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/235004\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/webform-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708483\";s:6:\"mdhash\";s:32:\"eaca075829ce568a489249c7c21a7ec4\";s:8:\"filesize\";s:6:\"307502\";}}}s:7:\"wysiwyg\";a:10:{s:5:\"title\";s:7:\"Wysiwyg\";s:10:\"short_name\";s:7:\"wysiwyg\";s:10:\"dc:creator\";s:3:\"sun\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:33:\"http://drupal.org/project/wysiwyg\";s:8:\"releases\";a:11:{s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:15:\"wysiwyg 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/736112\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/wysiwyg-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1268063714\";s:6:\"mdhash\";s:32:\"8a3ee47e20e9008c40ae96a6e4747a4f\";s:8:\"filesize\";s:6:\"108490\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:15:\"wysiwyg 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/487044\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/wysiwyg-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1244598972\";s:6:\"mdhash\";s:32:\"0dcc5b435b6698e61a336d32f280ed95\";s:8:\"filesize\";s:5:\"89627\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha1\";a:13:{s:4:\"name\";s:22:\"wysiwyg 6.x-2.0-alpha1\";s:7:\"version\";s:14:\"6.x-2.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/464872\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/wysiwyg-6.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1242523576\";s:6:\"mdhash\";s:32:\"a745141da5436606e8bdf848cfd6da20\";s:8:\"filesize\";s:5:\"80232\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:19:\"wysiwyg 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/365590\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/wysiwyg-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836393\";s:6:\"mdhash\";s:32:\"629a59a77571b5c17beeaef323e34e2d\";s:8:\"filesize\";s:6:\"113097\";}s:7:\"6.x-1.2\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1242522960\";s:6:\"mdhash\";s:32:\"4d4e038fb609ad57b7430a563f03fd09\";s:8:\"filesize\";s:5:\"65875\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1236562853\";s:6:\"mdhash\";s:32:\"e0d84b73c7f903d9f50e96ff39e15c4a\";s:8:\"filesize\";s:5:\"65534\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1234552285\";s:6:\"mdhash\";s:32:\"47f4db6f8b9f711835203a1a04c4c287\";s:8:\"filesize\";s:5:\"59227\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.x-dev\";a:9:{s:4:\"name\";s:19:\"wysiwyg 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1244161854\";s:6:\"mdhash\";s:32:\"88d40ccdebd0bb3dd21f6890adf60bfd\";s:8:\"filesize\";s:5:\"71871\";}s:7:\"6.x-0.5\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-0.5\";s:7:\"version\";s:7:\"6.x-0.5\";s:3:\"tag\";s:13:\"DRUPAL-6--0-5\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1228142425\";s:6:\"mdhash\";s:32:\"dfc9b006642cda543fd17c841462cee2\";s:8:\"filesize\";s:5:\"54206\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-0.4\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-0.4\";s:7:\"version\";s:7:\"6.x-0.4\";s:3:\"tag\";s:13:\"DRUPAL-6--0-4\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1224021920\";s:6:\"mdhash\";s:32:\"db01863f705e57477d6508bd083c75f2\";s:8:\"filesize\";s:5:\"50865\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-0.3\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-0.3\";s:7:\"version\";s:7:\"6.x-0.3\";s:3:\"tag\";s:13:\"DRUPAL-6--0-3\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1221251441\";s:6:\"mdhash\";s:32:\"3fd04f042435a957e4abed89ab71e4ea\";s:8:\"filesize\";s:5:\"45967\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}}}}','1281092427','1281006027',null,'1');
INSERT INTO `cache_update` VALUES ('update_project_data','a:38:{s:8:\"addtoany\";a:23:{s:4:\"name\";s:8:\"addtoany\";s:4:\"info\";a:5:{s:4:\"name\";s:8:\"AddToAny\";s:7:\"version\";s:7:\"6.x-3.3\";s:7:\"project\";s:8:\"addtoany\";s:9:\"datestamp\";s:10:\"1278719704\";s:16:\"_info_file_ctime\";i:1280942999;}s:9:\"datestamp\";s:10:\"1278719704\";s:8:\"includes\";a:1:{s:8:\"addtoany\";s:8:\"AddToAny\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-3.3\";s:14:\"existing_major\";s:1:\"3\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:30:\"AddToAny Share/Bookmark Button\";s:10:\"short_name\";s:8:\"addtoany\";s:10:\"dc:creator\";s:8:\"micropat\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:34:\"http://drupal.org/project/addtoany\";s:8:\"releases\";a:17:{s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/850002\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1278719704\";s:6:\"mdhash\";s:32:\"2749a475df074c866f019c6e1a033fbf\";s:8:\"filesize\";s:5:\"15802\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/842398\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1277970605\";s:6:\"mdhash\";s:32:\"926cf3baf1e758c0e36219316853834d\";s:8:\"filesize\";s:5:\"15608\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/839040\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1277687705\";s:6:\"mdhash\";s:32:\"79024e5fd843763c441e1259bf6feab6\";s:8:\"filesize\";s:5:\"15443\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/838878\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1277665811\";s:6:\"mdhash\";s:32:\"d9407ea1c79e255dd0a7c44476d3c03c\";s:8:\"filesize\";s:4:\"9808\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:20:\"addtoany 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/838616\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/addtoany-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833329\";s:6:\"mdhash\";s:32:\"514c1b0ae476441d7e3c77ac02f32c72\";s:8:\"filesize\";s:5:\"15810\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/601110\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1255206003\";s:6:\"mdhash\";s:32:\"9486fdbe364504b27bd5dfb291542f6e\";s:8:\"filesize\";s:5:\"14168\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/431152\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1239487222\";s:6:\"mdhash\";s:32:\"21e80d36e13fcce20236330866450601\";s:8:\"filesize\";s:5:\"14856\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/415386\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1238146502\";s:6:\"mdhash\";s:32:\"3352e1f160b54410f7d3b05640f38faa\";s:8:\"filesize\";s:5:\"14829\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/414318\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1238061628\";s:6:\"mdhash\";s:32:\"d2020f6d230d6b1744e380e77bc807cb\";s:8:\"filesize\";s:5:\"14472\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/361313\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1232418604\";s:6:\"mdhash\";s:32:\"32ff06b0cd2320b47cfef8554d6ef2a0\";s:8:\"filesize\";s:5:\"14386\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:8:\"6.x-1.36\";a:12:{s:4:\"name\";s:17:\"addtoany 6.x-1.36\";s:7:\"version\";s:8:\"6.x-1.36\";s:3:\"tag\";s:14:\"DRUPAL-6--1-36\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"36\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/249274\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.36.tar.gz\";s:4:\"date\";s:10:\"1208782203\";s:6:\"mdhash\";s:32:\"2f40a87e75befb3e96843842f0601a76\";s:8:\"filesize\";s:4:\"7114\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.35\";a:12:{s:4:\"name\";s:17:\"addtoany 6.x-1.35\";s:7:\"version\";s:8:\"6.x-1.35\";s:3:\"tag\";s:14:\"DRUPAL-6--1-35\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"35\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/249140\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.35.tar.gz\";s:4:\"date\";s:10:\"1208747705\";s:6:\"mdhash\";s:32:\"585d728018b1aeb583afff496bbdec50\";s:8:\"filesize\";s:4:\"7106\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/249115\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1208742001\";s:6:\"mdhash\";s:32:\"55077e53ce3370e8083729cff5970afa\";s:8:\"filesize\";s:4:\"7104\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/248414\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1208551202\";s:6:\"mdhash\";s:32:\"f402eb45fe2092d188dd3e6f2794b898\";s:8:\"filesize\";s:4:\"7046\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:16:\"addtoany 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/248253\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1208518802\";s:6:\"mdhash\";s:32:\"5aed8951c0670755021660c2419bca36\";s:8:\"filesize\";s:4:\"6878\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:16:\"addtoany 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/247774\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1208420701\";s:6:\"mdhash\";s:32:\"6a7993d9637d51cbad55760ba945ddc7\";s:8:\"filesize\";s:4:\"6880\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:20:\"addtoany 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/247216\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/addtoany-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833329\";s:6:\"mdhash\";s:32:\"376e6ec69e5167569a00852b2d24e2fb\";s:8:\"filesize\";s:4:\"8714\";}}s:14:\"latest_version\";s:7:\"6.x-3.3\";s:11:\"recommended\";s:7:\"6.x-3.3\";s:6:\"status\";i:5;}s:10:\"admin_menu\";a:24:{s:4:\"name\";s:10:\"admin_menu\";s:4:\"info\";a:6:{s:4:\"name\";s:19:\"Administration menu\";s:7:\"package\";s:14:\"Administration\";s:7:\"version\";s:7:\"6.x-1.5\";s:7:\"project\";s:10:\"admin_menu\";s:9:\"datestamp\";s:10:\"1246537502\";s:16:\"_info_file_ctime\";i:1280942999;}s:9:\"datestamp\";s:10:\"1246537502\";s:8:\"includes\";a:1:{s:10:\"admin_menu\";s:19:\"Administration menu\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.5\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:19:\"Administration menu\";s:10:\"short_name\";s:10:\"admin_menu\";s:10:\"dc:creator\";s:3:\"sun\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,3\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/admin_menu\";s:8:\"releases\";a:13:{s:14:\"6.x-3.0-alpha4\";a:13:{s:4:\"name\";s:25:\"admin_menu 6.x-3.0-alpha4\";s:7:\"version\";s:14:\"6.x-3.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/739026\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1268274904\";s:6:\"mdhash\";s:32:\"ba93c801409700854965f87b5df72817\";s:8:\"filesize\";s:5:\"69865\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:25:\"admin_menu 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/550878\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1250462403\";s:6:\"mdhash\";s:32:\"ca00ce1b53f3d6ac8d53773d9dd66378\";s:8:\"filesize\";s:5:\"60772\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:25:\"admin_menu 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/537782\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1249183202\";s:6:\"mdhash\";s:32:\"92a1a99f3cfa3cdbc2d2436166e37ea1\";s:8:\"filesize\";s:5:\"51545\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:25:\"admin_menu 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/488202\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1244680505\";s:6:\"mdhash\";s:32:\"088c382dbbdf4cbfa627e9f0f02aa65c\";s:8:\"filesize\";s:5:\"49388\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:22:\"admin_menu 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/373515\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280620899\";s:6:\"mdhash\";s:32:\"043b2aa35840ee78a8d0e3075bb3aca1\";s:8:\"filesize\";s:5:\"71235\";}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/508148\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1246537502\";s:6:\"mdhash\";s:32:\"efa340632c9fd0b9a964671bed27a722\";s:8:\"filesize\";s:5:\"45284\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/464048\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1242422411\";s:6:\"mdhash\";s:32:\"fcfc4cd0d2a2c2ab5d7d800701f9bcbe\";s:8:\"filesize\";s:5:\"44300\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/363483\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1232775903\";s:6:\"mdhash\";s:32:\"aba88a427c52fb9f2d0501dd51141331\";s:8:\"filesize\";s:5:\"38411\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/361251\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1232406902\";s:6:\"mdhash\";s:32:\"27c92c7059018edf27f8df748883e3d4\";s:8:\"filesize\";s:5:\"37659\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/307590\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1221237902\";s:6:\"mdhash\";s:32:\"da106dcfefddf490c06091c0a2c99a28\";s:8:\"filesize\";s:5:\"27351\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:18:\"admin_menu 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275429\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1214512502\";s:6:\"mdhash\";s:32:\"0112456abb83fcd7bae339b3311b03ff\";s:8:\"filesize\";s:5:\"26040\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:12:\"6.x-1.0-beta\";a:13:{s:4:\"name\";s:23:\"admin_menu 6.x-1.0-beta\";s:7:\"version\";s:12:\"6.x-1.0-beta\";s:3:\"tag\";s:18:\"DRUPAL-6--1-0-BETA\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:4:\"beta\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/268075\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.0-beta.tar.gz\";s:4:\"date\";s:10:\"1212913502\";s:6:\"mdhash\";s:32:\"e299f946fe29a3b8159c65c1751c796a\";s:8:\"filesize\";s:5:\"24230\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:22:\"admin_menu 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/251566\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/admin_menu-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280318473\";s:6:\"mdhash\";s:32:\"92ff6fe3b3464cfe2a89d61420e8a760\";s:8:\"filesize\";s:5:\"52459\";}}s:4:\"also\";a:1:{i:3;s:14:\"6.x-3.0-alpha4\";}s:14:\"latest_version\";s:7:\"6.x-1.5\";s:11:\"recommended\";s:7:\"6.x-1.5\";s:6:\"status\";i:5;}s:14:\"backup_migrate\";a:24:{s:4:\"name\";s:14:\"backup_migrate\";s:4:\"info\";a:5:{s:4:\"name\";s:18:\"Backup and Migrate\";s:7:\"version\";s:7:\"6.x-1.2\";s:7:\"project\";s:14:\"backup_migrate\";s:9:\"datestamp\";s:10:\"1232247609\";s:16:\"_info_file_ctime\";i:1280943010;}s:9:\"datestamp\";s:10:\"1232247609\";s:8:\"includes\";a:1:{s:14:\"backup_migrate\";s:18:\"Backup and Migrate\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.2\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:18:\"Backup and Migrate\";s:10:\"short_name\";s:14:\"backup_migrate\";s:10:\"dc:creator\";s:5:\"ronan\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:40:\"http://drupal.org/project/backup_migrate\";s:8:\"releases\";a:8:{s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/659078\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1260768003\";s:6:\"mdhash\";s:32:\"d718f2d4a1bddcdc1c81123dfbe39d53\";s:8:\"filesize\";s:5:\"65975\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/652788\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1260138903\";s:6:\"mdhash\";s:32:\"a8d107707be398aa768a47e8407bec65\";s:8:\"filesize\";s:5:\"66106\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/652370\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1260071104\";s:6:\"mdhash\";s:32:\"c761362f91173fdf14be3c28952800c9\";s:8:\"filesize\";s:5:\"54015\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:26:\"backup_migrate 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/303112\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833497\";s:6:\"mdhash\";s:32:\"4fa29ccb83055cbe4f6ef740ff27ea37\";s:8:\"filesize\";s:5:\"78879\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/826444\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1276470903\";s:6:\"mdhash\";s:32:\"a2eb5cc60875594d5c3c08248f295f8a\";s:8:\"filesize\";s:5:\"25865\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/360452\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1232247609\";s:6:\"mdhash\";s:32:\"15e9e33a226411fbe2b2b89fbb90d99e\";s:8:\"filesize\";s:5:\"25385\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:22:\"backup_migrate 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295106\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1218681903\";s:6:\"mdhash\";s:32:\"0fabd2518a276f0f0e636dbca06c67e4\";s:8:\"filesize\";s:5:\"17163\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:26:\"backup_migrate 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/231755\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/backup_migrate-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833499\";s:6:\"mdhash\";s:32:\"6e344f542f4929d36ed2f98a8e7f128b\";s:8:\"filesize\";s:5:\"32019\";}}s:4:\"also\";a:1:{i:2;s:7:\"6.x-2.2\";}s:14:\"latest_version\";s:7:\"6.x-1.3\";s:11:\"recommended\";s:7:\"6.x-1.3\";s:6:\"status\";i:4;}s:6:\"drupal\";a:23:{s:4:\"name\";s:6:\"drupal\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Block\";s:7:\"package\";s:15:\"Core - required\";s:7:\"version\";s:4:\"6.17\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1275505216\";s:16:\"_info_file_ctime\";i:1280943179;}s:9:\"datestamp\";s:10:\"1275505216\";s:8:\"includes\";a:16:{s:5:\"block\";s:5:\"Block\";s:5:\"color\";s:5:\"Color\";s:7:\"comment\";s:7:\"Comment\";s:5:\"dblog\";s:16:\"Database logging\";s:6:\"filter\";s:6:\"Filter\";s:4:\"help\";s:4:\"Help\";s:6:\"locale\";s:6:\"Locale\";s:4:\"menu\";s:4:\"Menu\";s:4:\"node\";s:4:\"Node\";s:4:\"path\";s:4:\"Path\";s:3:\"php\";s:10:\"PHP filter\";s:6:\"system\";s:6:\"System\";s:8:\"taxonomy\";s:8:\"Taxonomy\";s:6:\"update\";s:13:\"Update status\";s:4:\"user\";s:4:\"User\";s:6:\"harold\";s:6:\"harold\";}s:12:\"project_type\";s:4:\"core\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:4:\"6.17\";s:14:\"existing_major\";s:1:\"6\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:11:\"Drupal core\";s:10:\"short_name\";s:6:\"drupal\";s:10:\"dc:creator\";s:6:\"Drupal\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"6\";s:16:\"supported_majors\";s:1:\"6\";s:13:\"default_major\";s:1:\"6\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:32:\"http://drupal.org/project/drupal\";s:8:\"releases\";a:27:{s:4:\"6.17\";a:12:{s:4:\"name\";s:11:\"drupal 6.17\";s:7:\"version\";s:4:\"6.17\";s:3:\"tag\";s:11:\"DRUPAL-6-17\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/816290\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.17.tar.gz\";s:4:\"date\";s:10:\"1275505219\";s:6:\"mdhash\";s:32:\"14f936496d1f927d9b65e3849d7274f4\";s:8:\"filesize\";s:7:\"1093157\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:4:\"6.16\";a:12:{s:4:\"name\";s:11:\"drupal 6.16\";s:7:\"version\";s:4:\"6.16\";s:3:\"tag\";s:11:\"DRUPAL-6-16\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/732000\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.16.tar.gz\";s:4:\"date\";s:10:\"1267662009\";s:6:\"mdhash\";s:32:\"bb27c1f90680b86df2c535b2d52e8021\";s:8:\"filesize\";s:7:\"1090616\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.15\";a:12:{s:4:\"name\";s:11:\"drupal 6.15\";s:7:\"version\";s:4:\"6.15\";s:3:\"tag\";s:11:\"DRUPAL-6-15\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/661600\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.15.tar.gz\";s:4:\"date\";s:10:\"1260996917\";s:6:\"mdhash\";s:32:\"43c60bde08d6ea67682a998c2804c357\";s:8:\"filesize\";s:7:\"1085634\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.14\";a:12:{s:4:\"name\";s:11:\"drupal 6.14\";s:7:\"version\";s:4:\"6.14\";s:3:\"tag\";s:11:\"DRUPAL-6-14\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/579476\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.14.tar.gz\";s:4:\"date\";s:10:\"1253130028\";s:6:\"mdhash\";s:32:\"014bb453a8d0adb0233c763e40d63859\";s:8:\"filesize\";s:7:\"1082687\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.13\";a:12:{s:4:\"name\";s:11:\"drupal 6.13\";s:7:\"version\";s:4:\"6.13\";s:3:\"tag\";s:11:\"DRUPAL-6-13\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/507568\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.13.tar.gz\";s:4:\"date\";s:10:\"1246481720\";s:6:\"mdhash\";s:32:\"76dcb6e311fbb98ca3322fd1413f4a04\";s:8:\"filesize\";s:7:\"1080373\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.12\";a:12:{s:4:\"name\";s:11:\"drupal 6.12\";s:7:\"version\";s:4:\"6.12\";s:3:\"tag\";s:11:\"DRUPAL-6-12\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/461882\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.12.tar.gz\";s:4:\"date\";s:10:\"1242243955\";s:6:\"mdhash\";s:32:\"82e2517f175320cffe20997333b3a33a\";s:8:\"filesize\";s:7:\"1079251\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.11\";a:12:{s:4:\"name\";s:11:\"drupal 6.11\";s:7:\"version\";s:4:\"6.11\";s:3:\"tag\";s:11:\"DRUPAL-6-11\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/449114\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.11.tar.gz\";s:4:\"date\";s:10:\"1241050842\";s:6:\"mdhash\";s:32:\"6a341807b83c4e48f50ce7921562402c\";s:8:\"filesize\";s:7:\"1078966\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:4:\"6.10\";a:12:{s:4:\"name\";s:11:\"drupal 6.10\";s:7:\"version\";s:4:\"6.10\";s:3:\"tag\";s:11:\"DRUPAL-6-10\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/383918\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/drupal-6.10.tar.gz\";s:4:\"date\";s:10:\"1235596219\";s:6:\"mdhash\";s:32:\"d8f222c260556b5d7c3ff41bdd251b3c\";s:8:\"filesize\";s:7:\"1076404\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.9\";a:12:{s:4:\"name\";s:10:\"drupal 6.9\";s:7:\"version\";s:3:\"6.9\";s:3:\"tag\";s:10:\"DRUPAL-6-9\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/358987\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.9.tar.gz\";s:4:\"date\";s:10:\"1231976414\";s:6:\"mdhash\";s:32:\"5c682a4709f4632febbe7617a784a01a\";s:8:\"filesize\";s:7:\"1075558\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.8\";a:12:{s:4:\"name\";s:10:\"drupal 6.8\";s:7:\"version\";s:3:\"6.8\";s:3:\"tag\";s:10:\"DRUPAL-6-8\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/345833\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.8.tar.gz\";s:4:\"date\";s:10:\"1229018429\";s:6:\"mdhash\";s:32:\"561f281b2dbee8310293a61443bdfbc7\";s:8:\"filesize\";s:7:\"1074294\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:3:\"6.7\";a:12:{s:4:\"name\";s:10:\"drupal 6.7\";s:7:\"version\";s:3:\"6.7\";s:3:\"tag\";s:10:\"DRUPAL-6-7\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/345462\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.7.tar.gz\";s:4:\"date\";s:10:\"1228948512\";s:6:\"mdhash\";s:32:\"c9e8e5a9892538d355c62bd17b95b3a9\";s:8:\"filesize\";s:7:\"1074300\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.6\";a:12:{s:4:\"name\";s:10:\"drupal 6.6\";s:7:\"version\";s:3:\"6.6\";s:3:\"tag\";s:10:\"DRUPAL-6-6\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/324832\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.6.tar.gz\";s:4:\"date\";s:10:\"1224703817\";s:6:\"mdhash\";s:32:\"caaa55d1990b34dee48f5047ce98e2bb\";s:8:\"filesize\";s:7:\"1071507\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.5\";a:12:{s:4:\"name\";s:10:\"drupal 6.5\";s:7:\"version\";s:3:\"6.5\";s:3:\"tag\";s:10:\"DRUPAL-6-5\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318701\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.5.tar.gz\";s:4:\"date\";s:10:\"1223497211\";s:6:\"mdhash\";s:32:\"a88c561f0e61168b6ac710de55b6f91f\";s:8:\"filesize\";s:7:\"1071036\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.4\";a:12:{s:4:\"name\";s:10:\"Drupal 6.4\";s:7:\"version\";s:3:\"6.4\";s:3:\"tag\";s:10:\"DRUPAL-6-4\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295065\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.4.tar.gz\";s:4:\"date\";s:10:\"1218672611\";s:6:\"mdhash\";s:32:\"497b537285ad5847c1d3cb2f98ccf88c\";s:8:\"filesize\";s:7:\"1068473\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.3\";a:12:{s:4:\"name\";s:10:\"drupal 6.3\";s:7:\"version\";s:3:\"6.3\";s:3:\"tag\";s:10:\"DRUPAL-6-3\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/280583\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.3.tar.gz\";s:4:\"date\";s:10:\"1215640510\";s:6:\"mdhash\";s:32:\"f6a23149b906048d8a2dce1bad0e11a7\";s:8:\"filesize\";s:7:\"1061653\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.2\";a:12:{s:4:\"name\";s:10:\"drupal 6.2\";s:7:\"version\";s:3:\"6.2\";s:3:\"tag\";s:10:\"DRUPAL-6-2\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/244667\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.2.tar.gz\";s:4:\"date\";s:10:\"1207776009\";s:6:\"mdhash\";s:32:\"4c5af590b42b5a8e826177119c7e73b3\";s:8:\"filesize\";s:7:\"1058550\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.1\";a:12:{s:4:\"name\";s:10:\"drupal 6.1\";s:7:\"version\";s:3:\"6.1\";s:3:\"tag\";s:10:\"DRUPAL-6-1\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/227618\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.1.tar.gz\";s:4:\"date\";s:10:\"1204142109\";s:6:\"mdhash\";s:32:\"32bfd0b3a8a48e3f631e0a396ec96f68\";s:8:\"filesize\";s:7:\"1057213\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:3:\"6.0\";a:12:{s:4:\"name\";s:10:\"drupal 6.0\";s:7:\"version\";s:3:\"6.0\";s:3:\"tag\";s:10:\"DRUPAL-6-0\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/221219\";s:13:\"download_link\";s:54:\"http://ftp.drupal.org/files/projects/drupal-6.0.tar.gz\";s:4:\"date\";s:10:\"1202913008\";s:6:\"mdhash\";s:32:\"2138bd9f79906bd39c5dcc5289446c01\";s:8:\"filesize\";s:7:\"1057166\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.0-rc4\";a:13:{s:4:\"name\";s:14:\"drupal 6.0-rc4\";s:7:\"version\";s:7:\"6.0-rc4\";s:3:\"tag\";s:15:\"DRUPAL-6-0-RC-4\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/219510\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1202511908\";s:6:\"mdhash\";s:32:\"35f04f54be270cfe55ea19b249c40c36\";s:8:\"filesize\";s:7:\"1057236\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.0-rc3\";a:13:{s:4:\"name\";s:14:\"drupal 6.0-rc3\";s:7:\"version\";s:7:\"6.0-rc3\";s:3:\"tag\";s:15:\"DRUPAL-6-0-RC-3\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/216077\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1201733406\";s:6:\"mdhash\";s:32:\"c7deaf2f7d3a4d89cf2413fcc5bb728a\";s:8:\"filesize\";s:7:\"1052926\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.0-rc2\";a:13:{s:4:\"name\";s:14:\"drupal 6.0-rc2\";s:7:\"version\";s:7:\"6.0-rc2\";s:3:\"tag\";s:15:\"DRUPAL-6-0-RC-2\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/208616\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1200005705\";s:6:\"mdhash\";s:32:\"75962b1deeac60d12c2ba03a04e588c9\";s:8:\"filesize\";s:7:\"1046845\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.0-rc1\";a:13:{s:4:\"name\";s:14:\"drupal 6.0-rc1\";s:7:\"version\";s:7:\"6.0-rc1\";s:3:\"tag\";s:15:\"DRUPAL-6-0-RC-1\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/202820\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1198191308\";s:6:\"mdhash\";s:32:\"36102983c0be837ee4b15090557efbcc\";s:8:\"filesize\";s:7:\"1040654\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.0-beta4\";a:13:{s:4:\"name\";s:16:\"drupal 6.0-beta4\";s:7:\"version\";s:9:\"6.0-beta4\";s:3:\"tag\";s:17:\"DRUPAL-6-0-BETA-4\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/198188\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/drupal-6.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1196889906\";s:6:\"mdhash\";s:32:\"0747d613bb08471285da71fd5e8eb0d4\";s:8:\"filesize\";s:7:\"1025760\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.0-beta3\";a:13:{s:4:\"name\";s:16:\"drupal 6.0-beta3\";s:7:\"version\";s:9:\"6.0-beta3\";s:3:\"tag\";s:17:\"DRUPAL-6-0-BETA-3\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/194287\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/drupal-6.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1195684804\";s:6:\"mdhash\";s:32:\"2af78e20c98c2425ec71dcead90359d7\";s:8:\"filesize\";s:7:\"1010222\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.0-beta2\";a:13:{s:4:\"name\";s:16:\"drupal 6.0-beta2\";s:7:\"version\";s:9:\"6.0-beta2\";s:3:\"tag\";s:17:\"DRUPAL-6-0-BETA-2\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/184399\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/drupal-6.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1192658104\";s:6:\"mdhash\";s:32:\"dc95c3ffa6739273e34194a5be240738\";s:8:\"filesize\";s:6:\"991798\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.0-beta1\";a:13:{s:4:\"name\";s:16:\"drupal 6.0-beta1\";s:7:\"version\";s:9:\"6.0-beta1\";s:3:\"tag\";s:17:\"DRUPAL-6-0-BETA-1\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/175832\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/drupal-6.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1189840804\";s:6:\"mdhash\";s:32:\"a50471f2a835bcbd8324ef4d64201987\";s:8:\"filesize\";s:6:\"957946\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-dev\";a:12:{s:4:\"name\";s:14:\"Drupal 6.x-dev\";s:7:\"version\";s:7:\"6.x-dev\";s:3:\"tag\";s:8:\"DRUPAL-6\";s:13:\"version_major\";s:1:\"6\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/97368\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/drupal-6.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278802408\";s:6:\"mdhash\";s:32:\"03b41123afb1f0e7990c5aac6a272c31\";s:8:\"filesize\";s:7:\"1093558\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}}s:14:\"latest_version\";s:4:\"6.17\";s:11:\"recommended\";s:4:\"6.17\";s:6:\"status\";i:5;}s:7:\"captcha\";a:23:{s:4:\"name\";s:7:\"captcha\";s:4:\"info\";a:6:{s:4:\"name\";s:7:\"CAPTCHA\";s:7:\"package\";s:12:\"Spam control\";s:7:\"version\";s:7:\"6.x-2.2\";s:7:\"project\";s:7:\"captcha\";s:9:\"datestamp\";s:10:\"1274250303\";s:16:\"_info_file_ctime\";i:1280956197;}s:9:\"datestamp\";s:10:\"1274250303\";s:8:\"includes\";a:2:{s:7:\"captcha\";s:7:\"CAPTCHA\";s:13:\"image_captcha\";s:13:\"Image CAPTCHA\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-2.2\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:7:\"CAPTCHA\";s:10:\"short_name\";s:7:\"captcha\";s:10:\"dc:creator\";s:5:\"wundo\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:33:\"http://drupal.org/project/captcha\";s:8:\"releases\";a:17:{s:11:\"6.x-2.3-rc2\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.3-rc2\";s:7:\"version\";s:11:\"6.x-2.3-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-3-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/859690\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.3-rc2.tar.gz\";s:4:\"date\";s:10:\"1279649705\";s:6:\"mdhash\";s:32:\"7e47b896f4d986290df6b51c6207798c\";s:8:\"filesize\";s:6:\"183471\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.3-rc1\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.3-rc1\";s:7:\"version\";s:11:\"6.x-2.3-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-3-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/843974\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.3-rc1.tar.gz\";s:4:\"date\";s:10:\"1278105005\";s:6:\"mdhash\";s:32:\"b156b238554770858a47c0cb64ba3d82\";s:8:\"filesize\";s:6:\"183457\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:15:\"captcha 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/802896\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1274250303\";s:6:\"mdhash\";s:32:\"8cc53444b1dcaea980f388240129ac4e\";s:8:\"filesize\";s:6:\"176535\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:15:\"captcha 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/672304\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1262396711\";s:6:\"mdhash\";s:32:\"093c16ce18dca0f60181db75bd500b0c\";s:8:\"filesize\";s:6:\"165067\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:15:\"captcha 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/586144\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1253743243\";s:6:\"mdhash\";s:32:\"a10e9524369a07f71195da84f80816ba\";s:8:\"filesize\";s:6:\"152230\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.0-rc3\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.0-rc3\";s:7:\"version\";s:11:\"6.x-2.0-rc3\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/561696\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1251415515\";s:6:\"mdhash\";s:32:\"5cca375c55696cf2919dd3b2fbb89f8f\";s:8:\"filesize\";s:5:\"97621\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc2\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.0-rc2\";s:7:\"version\";s:11:\"6.x-2.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/509348\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1246629317\";s:6:\"mdhash\";s:32:\"f04af543c77026d74c743abc794e92f9\";s:8:\"filesize\";s:5:\"82113\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/490958\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1244932228\";s:6:\"mdhash\";s:32:\"31411d9551200ff5422876aac96069d9\";s:8:\"filesize\";s:5:\"85018\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta5\";a:12:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta5\";s:7:\"version\";s:13:\"6.x-2.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/465306\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1242580821\";s:6:\"mdhash\";s:32:\"31fc5556501b097035aac48ae85b0150\";s:8:\"filesize\";s:5:\"67564\";}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/444424\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1240614311\";s:6:\"mdhash\";s:32:\"bf6fae015f39c393960dd95749d26a2d\";s:8:\"filesize\";s:5:\"53568\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/425826\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1239066050\";s:6:\"mdhash\";s:32:\"5330c966dbe920b6b6def3f9cc909df8\";s:8:\"filesize\";s:5:\"52998\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/368111\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1233604214\";s:6:\"mdhash\";s:32:\"5fc64168bb386816f73f066d7cd04a6d\";s:8:\"filesize\";s:5:\"42308\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:21:\"captcha 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354009\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1231021814\";s:6:\"mdhash\";s:32:\"2c403c3df398ee453682a0ec29db216e\";s:8:\"filesize\";s:5:\"41884\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:19:\"captcha 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/94922\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833636\";s:6:\"mdhash\";s:32:\"dec5a0766724238daba9e80cd18dbc46\";s:8:\"filesize\";s:6:\"183466\";}s:11:\"6.x-1.0-rc2\";a:13:{s:4:\"name\";s:19:\"captcha 6.x-1.0-rc2\";s:7:\"version\";s:11:\"6.x-1.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/245354\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1207904704\";s:6:\"mdhash\";s:32:\"6f079f0572fe55e4b1a69cf7fda85ebd\";s:8:\"filesize\";s:5:\"47539\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc1\";a:12:{s:4:\"name\";s:19:\"captcha 6.x-1.0-rc1\";s:7:\"version\";s:11:\"6.x-1.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/222188\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1203092404\";s:6:\"mdhash\";s:32:\"fe7173cc04b745fd9af092fbbfc4fd0b\";s:8:\"filesize\";s:5:\"40500\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:19:\"captcha 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/214492\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/captcha-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833637\";s:6:\"mdhash\";s:32:\"f90f229a4c770968d93903a1af35e49b\";s:8:\"filesize\";s:5:\"87879\";}}s:14:\"latest_version\";s:11:\"6.x-2.3-rc2\";s:11:\"recommended\";s:7:\"6.x-2.2\";s:6:\"status\";i:5;}s:3:\"cck\";a:25:{s:4:\"name\";s:3:\"cck\";s:4:\"info\";a:6:{s:4:\"name\";s:7:\"Content\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-2.5\";s:7:\"project\";s:3:\"cck\";s:9:\"datestamp\";s:10:\"1249334428\";s:16:\"_info_file_ctime\";i:1280943020;}s:9:\"datestamp\";s:10:\"1249334428\";s:8:\"includes\";a:8:{s:7:\"content\";s:7:\"Content\";s:12:\"content_copy\";s:12:\"Content Copy\";s:10:\"fieldgroup\";s:10:\"Fieldgroup\";s:13:\"nodereference\";s:14:\"Node Reference\";s:6:\"number\";s:6:\"Number\";s:13:\"optionwidgets\";s:14:\"Option Widgets\";s:4:\"text\";s:4:\"Text\";s:13:\"userreference\";s:14:\"User Reference\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-2.5\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:16:\"security updates\";a:1:{i:0;a:12:{s:4:\"name\";s:11:\"cck 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/828988\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1276685406\";s:6:\"mdhash\";s:32:\"79e7f184ba68f5bf09eb8fde872572b8\";s:8:\"filesize\";s:6:\"440542\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}}s:5:\"title\";s:30:\"Content Construction Kit (CCK)\";s:10:\"short_name\";s:3:\"cck\";s:10:\"dc:creator\";s:5:\"yched\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:29:\"http://drupal.org/project/cck\";s:8:\"releases\";a:23:{s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:15:\"cck 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/484068\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278806577\";s:6:\"mdhash\";s:32:\"036fe7b45f255b889a132cdcde61cfbe\";s:8:\"filesize\";s:6:\"466006\";}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/828988\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1276685406\";s:6:\"mdhash\";s:32:\"79e7f184ba68f5bf09eb8fde872572b8\";s:8:\"filesize\";s:6:\"440542\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/624868\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1257464737\";s:6:\"mdhash\";s:32:\"3e719a786f7fed2c6e7bd341a508ca60\";s:8:\"filesize\";s:6:\"423510\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/539128\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1249334429\";s:6:\"mdhash\";s:32:\"d20669111ff3e528a233a14247df42de\";s:8:\"filesize\";s:6:\"417417\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/494022\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1245237621\";s:6:\"mdhash\";s:32:\"e37388bf9061fa24df62e269a5c64fed\";s:8:\"filesize\";s:6:\"412002\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/482540\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1244163643\";s:6:\"mdhash\";s:32:\"7f60a6bbaba40059562a87fb33203197\";s:8:\"filesize\";s:6:\"410591\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/406534\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1237410615\";s:6:\"mdhash\";s:32:\"0fe5f8e6d1292fcfe98530a3dea0a1a1\";s:8:\"filesize\";s:6:\"357660\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/333173\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1226449204\";s:6:\"mdhash\";s:32:\"6036acde1dbc0bad62681de5f94bc912\";s:8:\"filesize\";s:6:\"318865\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:11:\"cck 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/330573\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1225914304\";s:6:\"mdhash\";s:32:\"ea2a47052833892030541464ad6609a9\";s:8:\"filesize\";s:6:\"318588\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:12:\"6.x-2.0-rc10\";a:13:{s:4:\"name\";s:16:\"cck 6.x-2.0-rc10\";s:7:\"version\";s:12:\"6.x-2.0-rc10\";s:3:\"tag\";s:18:\"DRUPAL-6--2-0-RC10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:4:\"rc10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318642\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc10.tar.gz\";s:4:\"date\";s:10:\"1223488806\";s:6:\"mdhash\";s:32:\"1fbf5c09c881fe44ec09fff61d26aef9\";s:8:\"filesize\";s:6:\"248939\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc9\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc9\";s:7:\"version\";s:11:\"6.x-2.0-rc9\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/317796\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc9.tar.gz\";s:4:\"date\";s:10:\"1223325604\";s:6:\"mdhash\";s:32:\"9beefdfbf85f8a5e8b73235574d636a8\";s:8:\"filesize\";s:6:\"227274\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc8\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc8\";s:7:\"version\";s:11:\"6.x-2.0-rc8\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/316249\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc8.tar.gz\";s:4:\"date\";s:10:\"1222958408\";s:6:\"mdhash\";s:32:\"dd633f983e4a43bb9da7bd40e1d81682\";s:8:\"filesize\";s:6:\"226701\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc7\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc7\";s:7:\"version\";s:11:\"6.x-2.0-rc7\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/306274\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc7.tar.gz\";s:4:\"date\";s:10:\"1221003605\";s:6:\"mdhash\";s:32:\"b1024f15ca41f0cac9c521ba81fcb1ff\";s:8:\"filesize\";s:6:\"210995\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc6\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc6\";s:7:\"version\";s:11:\"6.x-2.0-rc6\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295736\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc6.tar.gz\";s:4:\"date\";s:10:\"1218809704\";s:6:\"mdhash\";s:32:\"ddcc92a076b4aacbf97f4b11ba58f2aa\";s:8:\"filesize\";s:6:\"206891\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc5\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc5\";s:7:\"version\";s:11:\"6.x-2.0-rc5\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295416\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc5.tar.gz\";s:4:\"date\";s:10:\"1218735306\";s:6:\"mdhash\";s:32:\"05c3d43fcf0e64c4277cf162693b1934\";s:8:\"filesize\";s:6:\"206821\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc4\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc4\";s:7:\"version\";s:11:\"6.x-2.0-rc4\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/280821\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1215694806\";s:6:\"mdhash\";s:32:\"b0805a344cdee93fa0d9388160c5fac2\";s:8:\"filesize\";s:6:\"189040\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc3\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc3\";s:7:\"version\";s:11:\"6.x-2.0-rc3\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/278309\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1215117305\";s:6:\"mdhash\";s:32:\"564f1bd699786d73710078ec45ffa70b\";s:8:\"filesize\";s:6:\"180693\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc2\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc2\";s:7:\"version\";s:11:\"6.x-2.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277906\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1215035705\";s:6:\"mdhash\";s:32:\"c0a8c02429c603a29efb08e497a9e3f7\";s:8:\"filesize\";s:6:\"168747\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:15:\"cck 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277894\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1215033603\";s:6:\"mdhash\";s:32:\"bf8b7810e31d7dff3261125d64ef1c00\";s:8:\"filesize\";s:6:\"168714\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:12:\"6.x-2.0-beta\";a:13:{s:4:\"name\";s:16:\"cck 6.x-2.0-beta\";s:7:\"version\";s:12:\"6.x-2.0-beta\";s:3:\"tag\";s:18:\"DRUPAL-6--2-0-BETA\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:4:\"beta\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/266143\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/cck-6.x-2.0-beta.tar.gz\";s:4:\"date\";s:10:\"1212504904\";s:6:\"mdhash\";s:32:\"28c5e224ea6b5bce864f315e07e788b2\";s:8:\"filesize\";s:6:\"145561\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:15:\"cck 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/266142\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278806575\";s:6:\"mdhash\";s:32:\"5eb30e6c2b323402b175320b38456d94\";s:8:\"filesize\";s:6:\"440567\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:13:\"6.x-1.0-alpha\";a:13:{s:4:\"name\";s:17:\"cck 6.x-1.0-alpha\";s:7:\"version\";s:13:\"6.x-1.0-alpha\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-ALPHA\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"alpha\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/250976\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/cck-6.x-1.0-alpha.tar.gz\";s:4:\"date\";s:10:\"1209089705\";s:6:\"mdhash\";s:32:\"5d5924ab9cbf5d7b9a0ed4b405659c44\";s:8:\"filesize\";s:6:\"132004\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:15:\"cck 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/96064\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/cck-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278806576\";s:6:\"mdhash\";s:32:\"607c17f207a8986d5c32656bf915bf09\";s:8:\"filesize\";s:6:\"176631\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}s:4:\"also\";a:1:{i:3;s:11:\"6.x-3.x-dev\";}s:14:\"latest_version\";s:7:\"6.x-2.7\";s:11:\"recommended\";s:7:\"6.x-2.7\";s:6:\"status\";i:1;}s:3:\"ctm\";a:23:{s:4:\"name\";s:3:\"ctm\";s:4:\"info\";a:6:{s:4:\"name\";s:30:\"Menu Settings per Content Type\";s:7:\"package\";s:14:\"Administration\";s:7:\"project\";s:3:\"ctm\";s:7:\"version\";s:7:\"6.x-1.0\";s:9:\"datestamp\";s:10:\"1227532508\";s:16:\"_info_file_ctime\";i:1280943054;}s:9:\"datestamp\";s:10:\"1227532508\";s:8:\"includes\";a:1:{s:3:\"ctm\";s:30:\"Menu Settings per Content Type\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.0\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:30:\"Menu Settings per Content Type\";s:10:\"short_name\";s:3:\"ctm\";s:10:\"dc:creator\";s:6:\"vasike\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:29:\"http://drupal.org/project/ctm\";s:8:\"releases\";a:2:{s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:11:\"ctm 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/338444\";s:13:\"download_link\";s:55:\"http://ftp.drupal.org/files/projects/ctm-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1227532508\";s:6:\"mdhash\";s:32:\"9b3979939277c1b8decdeb7a4b4ee074\";s:8:\"filesize\";s:4:\"6961\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:15:\"ctm 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/338405\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/ctm-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278833848\";s:6:\"mdhash\";s:32:\"9ffea47b5a482d217fef1db1db0c2019\";s:8:\"filesize\";s:4:\"6972\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}s:14:\"latest_version\";s:7:\"6.x-1.0\";s:11:\"recommended\";s:7:\"6.x-1.0\";s:6:\"status\";i:5;}s:6:\"ctools\";a:23:{s:4:\"name\";s:6:\"ctools\";s:4:\"info\";a:6:{s:4:\"name\";s:11:\"Chaos tools\";s:7:\"package\";s:16:\"Chaos tool suite\";s:7:\"version\";s:7:\"6.x-1.4\";s:7:\"project\";s:6:\"ctools\";s:9:\"datestamp\";s:10:\"1274320504\";s:16:\"_info_file_ctime\";i:1280943068;}s:9:\"datestamp\";s:10:\"1274320504\";s:8:\"includes\";a:3:{s:6:\"ctools\";s:11:\"Chaos tools\";s:12:\"page_manager\";s:12:\"Page manager\";s:13:\"views_content\";s:19:\"Views content panes\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.4\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:16:\"Chaos tool suite\";s:10:\"short_name\";s:6:\"ctools\";s:10:\"dc:creator\";s:13:\"merlinofchaos\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:32:\"http://drupal.org/project/ctools\";s:8:\"releases\";a:17:{s:7:\"6.x-1.7\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/865580\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1280189116\";s:6:\"mdhash\";s:32:\"33e01a3ea69f3529b25bd89bbb71b6b5\";s:8:\"filesize\";s:6:\"465667\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/815542\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1275441008\";s:6:\"mdhash\";s:32:\"e66289bd55a88f6613520a1c5c19b110\";s:8:\"filesize\";s:6:\"411831\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812450\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1275094506\";s:6:\"mdhash\";s:32:\"15e0cd9559927280b5a5f9fc4a659e32\";s:8:\"filesize\";s:6:\"411611\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/803912\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1274320505\";s:6:\"mdhash\";s:32:\"48733a28fdb6745d597b8fece736b5b0\";s:8:\"filesize\";s:6:\"411312\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-1.3\";a:11:{s:4:\"name\";s:14:\"ctools 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/701808\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1265065810\";s:6:\"mdhash\";s:32:\"f3cfab0b951c6e63b8b1d31e969518b7\";s:8:\"filesize\";s:6:\"382191\";}s:7:\"6.x-1.2\";a:11:{s:4:\"name\";s:14:\"ctools 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/611098\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1256162716\";s:6:\"mdhash\";s:32:\"96c17a48adf85b4ddc704dbc6e1978d5\";s:8:\"filesize\";s:6:\"306141\";}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/605838\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1255638634\";s:6:\"mdhash\";s:32:\"396e10932942e3b72b140787f8e588ff\";s:8:\"filesize\";s:6:\"305914\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:14:\"ctools 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/554222\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1250724632\";s:6:\"mdhash\";s:32:\"4332c9a6d9b7d3b4068c594f8068c8db\";s:8:\"filesize\";s:6:\"318156\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc1\";a:13:{s:4:\"name\";s:18:\"ctools 6.x-1.0-rc1\";s:7:\"version\";s:11:\"6.x-1.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/528132\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1248309035\";s:6:\"mdhash\";s:32:\"442ac724b717d2fb8daf3b9209f72933\";s:8:\"filesize\";s:6:\"216456\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta4\";a:13:{s:4:\"name\";s:20:\"ctools 6.x-1.0-beta4\";s:7:\"version\";s:13:\"6.x-1.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/517084\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1247424021\";s:6:\"mdhash\";s:32:\"725b6b5964e80e1f2e5c352ce634d5f4\";s:8:\"filesize\";s:6:\"209089\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta3\";a:13:{s:4:\"name\";s:20:\"ctools 6.x-1.0-beta3\";s:7:\"version\";s:13:\"6.x-1.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/468642\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1242863124\";s:6:\"mdhash\";s:32:\"90ecfe732ba5f27dd45564d310feadd1\";s:8:\"filesize\";s:6:\"198268\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta2\";a:13:{s:4:\"name\";s:20:\"ctools 6.x-1.0-beta2\";s:7:\"version\";s:13:\"6.x-1.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/457546\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1241799644\";s:6:\"mdhash\";s:32:\"4a033a5d775e651a311fbe8751b47910\";s:8:\"filesize\";s:6:\"192866\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta1\";a:13:{s:4:\"name\";s:20:\"ctools 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/450242\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1241139920\";s:6:\"mdhash\";s:32:\"2329348c4925d41855bcf2b397ca1307\";s:8:\"filesize\";s:6:\"190957\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha3\";a:13:{s:4:\"name\";s:21:\"ctools 6.x-1.0-alpha3\";s:7:\"version\";s:14:\"6.x-1.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/418638\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1238444421\";s:6:\"mdhash\";s:32:\"6555ee952901ef8728f19a0b5b80b8b4\";s:8:\"filesize\";s:6:\"135311\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha2\";a:13:{s:4:\"name\";s:21:\"ctools 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/366426\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1233270625\";s:6:\"mdhash\";s:32:\"684b6aaf8b522f9e43222972846a9611\";s:8:\"filesize\";s:6:\"130835\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:21:\"ctools 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/352586\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1230663018\";s:6:\"mdhash\";s:32:\"5abae4dc22c8d7dea17d34d0260b7916\";s:8:\"filesize\";s:6:\"115136\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:18:\"ctools 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/352590\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/ctools-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280880327\";s:6:\"mdhash\";s:32:\"18e6defd3116cb025becb88a10da19bb\";s:8:\"filesize\";s:6:\"465319\";}}s:14:\"latest_version\";s:7:\"6.x-1.7\";s:11:\"recommended\";s:7:\"6.x-1.7\";s:6:\"status\";i:4;}s:5:\"devel\";a:24:{s:4:\"name\";s:5:\"devel\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Devel\";s:7:\"package\";s:11:\"Development\";s:7:\"version\";s:8:\"6.x-1.16\";s:7:\"project\";s:5:\"devel\";s:9:\"datestamp\";s:10:\"1239375932\";s:16:\"_info_file_ctime\";i:1280943077;}s:9:\"datestamp\";s:10:\"1239375932\";s:8:\"includes\";a:2:{s:5:\"devel\";s:5:\"Devel\";s:17:\"devel_node_access\";s:17:\"Devel node access\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:8:\"6.x-1.16\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:16:\"security updates\";a:2:{i:0;a:12:{s:4:\"name\";s:14:\"devel 6.x-1.21\";s:7:\"version\";s:8:\"6.x-1.21\";s:3:\"tag\";s:14:\"DRUPAL-6--1-21\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"21\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/874116\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.21.tar.gz\";s:4:\"date\";s:10:\"1280961079\";s:6:\"mdhash\";s:32:\"15bf95b8c3fbe3f570f3f7b590f52ded\";s:8:\"filesize\";s:6:\"175008\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}i:1;a:12:{s:4:\"name\";s:14:\"devel 6.x-1.18\";s:7:\"version\";s:8:\"6.x-1.18\";s:3:\"tag\";s:14:\"DRUPAL-6--1-18\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/585982\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.18.tar.gz\";s:4:\"date\";s:10:\"1253731829\";s:6:\"mdhash\";s:32:\"5f2b9e5f4b74beec35a1d1cff379ab5c\";s:8:\"filesize\";s:6:\"165785\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}}s:5:\"title\";s:5:\"Devel\";s:10:\"short_name\";s:5:\"devel\";s:10:\"dc:creator\";s:14:\"moshe weitzman\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:31:\"http://drupal.org/project/devel\";s:8:\"releases\";a:24:{s:8:\"6.x-1.21\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.21\";s:7:\"version\";s:8:\"6.x-1.21\";s:3:\"tag\";s:14:\"DRUPAL-6--1-21\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"21\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/874116\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.21.tar.gz\";s:4:\"date\";s:10:\"1280961079\";s:6:\"mdhash\";s:32:\"15bf95b8c3fbe3f570f3f7b590f52ded\";s:8:\"filesize\";s:6:\"175008\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:8:\"6.x-1.20\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.20\";s:7:\"version\";s:8:\"6.x-1.20\";s:3:\"tag\";s:14:\"DRUPAL-6--1-20\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"20\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/777998\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.20.tar.gz\";s:4:\"date\";s:10:\"1271886306\";s:6:\"mdhash\";s:32:\"b605d6a42e430660ef3418541d711c1c\";s:8:\"filesize\";s:6:\"174042\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.19\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.19\";s:7:\"version\";s:8:\"6.x-1.19\";s:3:\"tag\";s:14:\"DRUPAL-6--1-19\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"19\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/746888\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.19.tar.gz\";s:4:\"date\";s:10:\"1268976904\";s:6:\"mdhash\";s:32:\"375c3b79e9e74fb636bf8a6d2fde87d6\";s:8:\"filesize\";s:6:\"173570\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.18\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.18\";s:7:\"version\";s:8:\"6.x-1.18\";s:3:\"tag\";s:14:\"DRUPAL-6--1-18\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/585982\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.18.tar.gz\";s:4:\"date\";s:10:\"1253731829\";s:6:\"mdhash\";s:32:\"5f2b9e5f4b74beec35a1d1cff379ab5c\";s:8:\"filesize\";s:6:\"165785\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:8:\"6.x-1.17\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.17\";s:7:\"version\";s:8:\"6.x-1.17\";s:3:\"tag\";s:14:\"DRUPAL-6--1-17\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/554032\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.17.tar.gz\";s:4:\"date\";s:10:\"1250713853\";s:6:\"mdhash\";s:32:\"31b2cbea82226a729b11bbc91920a7cd\";s:8:\"filesize\";s:6:\"163024\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.16\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.16\";s:7:\"version\";s:8:\"6.x-1.16\";s:3:\"tag\";s:14:\"DRUPAL-6--1-16\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/430072\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.16.tar.gz\";s:4:\"date\";s:10:\"1239375932\";s:6:\"mdhash\";s:32:\"6dc83de5de101460f8eee2db3ea4b7d9\";s:8:\"filesize\";s:6:\"163998\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.15\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.15\";s:7:\"version\";s:8:\"6.x-1.15\";s:3:\"tag\";s:14:\"DRUPAL-6--1-15\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/419014\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.15.tar.gz\";s:4:\"date\";s:10:\"1238471715\";s:6:\"mdhash\";s:32:\"e7cd175671ed62a95bab7093c636e663\";s:8:\"filesize\";s:6:\"163945\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.14\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.14\";s:7:\"version\";s:8:\"6.x-1.14\";s:3:\"tag\";s:14:\"DRUPAL-6--1-14\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/368174\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.14.tar.gz\";s:4:\"date\";s:10:\"1233610814\";s:6:\"mdhash\";s:32:\"11af2d7fa3050febfe3def770683f173\";s:8:\"filesize\";s:6:\"162780\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.13\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.13\";s:7:\"version\";s:8:\"6.x-1.13\";s:3:\"tag\";s:14:\"DRUPAL-6--1-13\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/353382\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.13.tar.gz\";s:4:\"date\";s:10:\"1230872109\";s:6:\"mdhash\";s:32:\"669870433908fccd31e7de9b57434c64\";s:8:\"filesize\";s:6:\"161893\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.12\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.12\";s:7:\"version\";s:8:\"6.x-1.12\";s:3:\"tag\";s:14:\"DRUPAL-6--1-12\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/319216\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.12.tar.gz\";s:4:\"date\";s:10:\"1223583012\";s:6:\"mdhash\";s:32:\"69b345c09ece34812b04e7ccbc2cdf23\";s:8:\"filesize\";s:6:\"146188\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.11\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.11\";s:7:\"version\";s:8:\"6.x-1.11\";s:3:\"tag\";s:14:\"DRUPAL-6--1-11\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/310335\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.11.tar.gz\";s:4:\"date\";s:10:\"1221759046\";s:6:\"mdhash\";s:32:\"93bc2cc8da26d759e46b24f1b9d4e3e2\";s:8:\"filesize\";s:6:\"145693\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.10\";a:12:{s:4:\"name\";s:14:\"devel 6.x-1.10\";s:7:\"version\";s:8:\"6.x-1.10\";s:3:\"tag\";s:14:\"DRUPAL-6--1-10\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/283183\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/devel-6.x-1.10.tar.gz\";s:4:\"date\";s:10:\"1216171206\";s:6:\"mdhash\";s:32:\"688ed33b3a2a63bc1bce9da3c2d104de\";s:8:\"filesize\";s:6:\"145188\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.9\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.9\";s:7:\"version\";s:7:\"6.x-1.9\";s:3:\"tag\";s:13:\"DRUPAL-6--1-9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/270064\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1213331113\";s:6:\"mdhash\";s:32:\"8b88659f45e31d8c05fd6990c491ea2a\";s:8:\"filesize\";s:6:\"145153\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.8\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.8\";s:7:\"version\";s:7:\"6.x-1.8\";s:3:\"tag\";s:13:\"DRUPAL-6--1-8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/259615\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1211039106\";s:6:\"mdhash\";s:32:\"d8d8f4ee8dd61ccad625443ebafbe421\";s:8:\"filesize\";s:5:\"76796\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.7\";a:11:{s:4:\"name\";s:13:\"devel 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/237840\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1206300306\";s:6:\"mdhash\";s:32:\"b63eba9e1588baa2f8031589897eb376\";s:8:\"filesize\";s:5:\"72504\";}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/229249\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1204515005\";s:6:\"mdhash\";s:32:\"dc2fd4030922e17258a0fa886557aa9f\";s:8:\"filesize\";s:5:\"72109\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/227742\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1204163705\";s:6:\"mdhash\";s:32:\"4755dc85712f86c24a7615c83bf2d587\";s:8:\"filesize\";s:5:\"72424\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/224889\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1203609008\";s:6:\"mdhash\";s:32:\"9361284333474368c49b807943e7eb09\";s:8:\"filesize\";s:5:\"72289\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/223052\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1203291304\";s:6:\"mdhash\";s:32:\"5dbb78276404810a219395d790bb349d\";s:8:\"filesize\";s:5:\"72231\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/223032\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1203288005\";s:6:\"mdhash\";s:32:\"ec2d609a553289636f2388c54fc69e8b\";s:8:\"filesize\";s:5:\"72232\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/222919\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1203267606\";s:6:\"mdhash\";s:32:\"2d1065298518decda8eb0d0473851ed1\";s:8:\"filesize\";s:5:\"72225\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:13:\"devel 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/208665\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/devel-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1200012604\";s:6:\"mdhash\";s:32:\"3dbd3cd4c15f001c1ac7067ca58c74ff\";s:8:\"filesize\";s:5:\"53802\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:17:\"devel 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/224617\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/devel-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280966851\";s:6:\"mdhash\";s:32:\"29ff89633eb69d2876620780b589e0b3\";s:8:\"filesize\";s:6:\"175006\";}s:7:\"6.x-0.2\";a:10:{s:4:\"name\";s:13:\"devel 6.x-0.2\";s:7:\"version\";s:7:\"6.x-0.2\";s:3:\"tag\";s:13:\"DRUPAL-6--0-2\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1203287704\";s:6:\"mdhash\";s:32:\"a071278bf76df5acf5320086f80ff4f5\";s:8:\"filesize\";s:5:\"72235\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}}s:14:\"latest_version\";s:8:\"6.x-1.21\";s:11:\"recommended\";s:8:\"6.x-1.21\";s:6:\"status\";i:1;}s:9:\"filefield\";a:24:{s:4:\"name\";s:9:\"filefield\";s:4:\"info\";a:6:{s:4:\"name\";s:9:\"FileField\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-3.2\";s:7:\"project\";s:9:\"filefield\";s:9:\"datestamp\";s:10:\"1256070656\";s:16:\"_info_file_ctime\";i:1280943082;}s:9:\"datestamp\";s:10:\"1256070656\";s:8:\"includes\";a:1:{s:9:\"filefield\";s:9:\"FileField\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-3.2\";s:14:\"existing_major\";s:1:\"3\";s:12:\"install_type\";s:8:\"official\";s:16:\"security updates\";a:2:{i:0;a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.4\";s:7:\"version\";s:7:\"6.x-3.4\";s:3:\"tag\";s:13:\"DRUPAL-6--3-4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/829754\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.4.tar.gz\";s:4:\"date\";s:10:\"1276734010\";s:6:\"mdhash\";s:32:\"bac8f7cdf325d83a13693508892c8db8\";s:8:\"filesize\";s:5:\"98649\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}i:1;a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/791032\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1273102210\";s:6:\"mdhash\";s:32:\"f83dc6f4e69c6518a9f57622d5e5e4b7\";s:8:\"filesize\";s:5:\"92322\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}}s:5:\"title\";s:9:\"FileField\";s:10:\"short_name\";s:9:\"filefield\";s:10:\"dc:creator\";s:11:\"quicksketch\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:35:\"http://drupal.org/project/filefield\";s:8:\"releases\";a:26:{s:7:\"6.x-3.7\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.7\";s:7:\"version\";s:7:\"6.x-3.7\";s:3:\"tag\";s:13:\"DRUPAL-6--3-7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/842206\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.7.tar.gz\";s:4:\"date\";s:10:\"1277943013\";s:6:\"mdhash\";s:32:\"a48dc8f803db538777cc3ba2764e7e17\";s:8:\"filesize\";s:5:\"98840\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.6\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.6\";s:7:\"version\";s:7:\"6.x-3.6\";s:3:\"tag\";s:13:\"DRUPAL-6--3-6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/841158\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.6.tar.gz\";s:4:\"date\";s:10:\"1277870108\";s:6:\"mdhash\";s:32:\"8ca21de2ae336bd6fafbafddb3cf2ea9\";s:8:\"filesize\";s:5:\"98819\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.5\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.5\";s:7:\"version\";s:7:\"6.x-3.5\";s:3:\"tag\";s:13:\"DRUPAL-6--3-5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/830742\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.5.tar.gz\";s:4:\"date\";s:10:\"1276804208\";s:6:\"mdhash\";s:32:\"e4ba04b779224db4a190ace6188e5e08\";s:8:\"filesize\";s:5:\"98760\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.4\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.4\";s:7:\"version\";s:7:\"6.x-3.4\";s:3:\"tag\";s:13:\"DRUPAL-6--3-4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/829754\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.4.tar.gz\";s:4:\"date\";s:10:\"1276734010\";s:6:\"mdhash\";s:32:\"bac8f7cdf325d83a13693508892c8db8\";s:8:\"filesize\";s:5:\"98649\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/791032\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1273102210\";s:6:\"mdhash\";s:32:\"f83dc6f4e69c6518a9f57622d5e5e4b7\";s:8:\"filesize\";s:5:\"92322\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/609874\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1256070656\";s:6:\"mdhash\";s:32:\"bd52f35628e2a5f12b7cde25e654d71e\";s:8:\"filesize\";s:5:\"81900\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/509792\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1246665925\";s:6:\"mdhash\";s:32:\"ef284d4c00c11a3a150950431268b763\";s:8:\"filesize\";s:5:\"77310\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:17:\"filefield 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/439772\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1240272650\";s:6:\"mdhash\";s:32:\"ad963dc2c37c651c1b2565009ebd6333\";s:8:\"filesize\";s:5:\"66677\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.0-rc1\";a:13:{s:4:\"name\";s:21:\"filefield 6.x-3.0-rc1\";s:7:\"version\";s:11:\"6.x-3.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--3-0-RC1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/420990\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1238617254\";s:6:\"mdhash\";s:32:\"591ac9f233ca87f88ee81cef5f076055\";s:8:\"filesize\";s:5:\"56677\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:13:\"6.x-3.0-beta3\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-3.0-beta3\";s:7:\"version\";s:13:\"6.x-3.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/408062\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1237533921\";s:6:\"mdhash\";s:32:\"654c7ad272808eaf641964b15ad0d85b\";s:8:\"filesize\";s:5:\"49519\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta2\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-3.0-beta2\";s:7:\"version\";s:13:\"6.x-3.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/406852\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1237435521\";s:6:\"mdhash\";s:32:\"09be0dbd401144a78ad77261c8ad155a\";s:8:\"filesize\";s:5:\"46433\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/402448\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1237111249\";s:6:\"mdhash\";s:32:\"d292c013882d570db8d76fa0dfaf1956\";s:8:\"filesize\";s:5:\"45950\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha7\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha7\";s:7:\"version\";s:14:\"6.x-3.0-alpha7\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/368981\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha7.tar.gz\";s:4:\"date\";s:10:\"1233743443\";s:6:\"mdhash\";s:32:\"e90f5370ae92654f54c55a464ba1902d\";s:8:\"filesize\";s:5:\"42425\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha6\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha6\";s:7:\"version\";s:14:\"6.x-3.0-alpha6\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/357999\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha6.tar.gz\";s:4:\"date\";s:10:\"1231820418\";s:6:\"mdhash\";s:32:\"7b0083a13ea5550fd4238e995d3cc383\";s:8:\"filesize\";s:5:\"42003\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha5\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha5\";s:7:\"version\";s:14:\"6.x-3.0-alpha5\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318257\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1223412645\";s:6:\"mdhash\";s:32:\"b7426b0dcf5d5b81d267d63508da7853\";s:8:\"filesize\";s:5:\"31976\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha4\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha4\";s:7:\"version\";s:14:\"6.x-3.0-alpha4\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/300633\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1219850117\";s:6:\"mdhash\";s:32:\"efbc5f890b1517b346c9232f6ecae390\";s:8:\"filesize\";s:5:\"33924\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295582\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1218762612\";s:6:\"mdhash\";s:32:\"12b651ba7344cf12df6d012bfad6bad9\";s:8:\"filesize\";s:5:\"33822\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292970\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1218219614\";s:6:\"mdhash\";s:32:\"103b43ece002904b595292d43d3824ca\";s:8:\"filesize\";s:5:\"33022\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/289874\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1217572520\";s:6:\"mdhash\";s:32:\"3baa71f7474c685981e4bb21dfea0f2f\";s:8:\"filesize\";s:5:\"33001\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:21:\"filefield 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/96616\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/filefield-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834247\";s:6:\"mdhash\";s:32:\"73d17f0154f925610f26e4f5afa7144a\";s:8:\"filesize\";s:5:\"98847\";}s:13:\"6.x-1.0-beta3\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-1.0-beta3\";s:7:\"version\";s:13:\"6.x-1.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/282502\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1216052708\";s:6:\"mdhash\";s:32:\"16d7dc669271b9ded8d709a03f46a12e\";s:8:\"filesize\";s:5:\"36534\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta2\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-1.0-beta2\";s:7:\"version\";s:13:\"6.x-1.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/276520\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1214786709\";s:6:\"mdhash\";s:32:\"337a36de008d2adba4e241700dfc7835\";s:8:\"filesize\";s:5:\"33771\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta1\";a:13:{s:4:\"name\";s:23:\"filefield 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/276020\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1214646309\";s:6:\"mdhash\";s:32:\"f55c8088212c8ef790128d672ea63d3c\";s:8:\"filesize\";s:5:\"30229\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha3\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-1.0-alpha3\";s:7:\"version\";s:14:\"6.x-1.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275237\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1214484311\";s:6:\"mdhash\";s:32:\"35edea2e3c2d7586c9efe7bde7d89875\";s:8:\"filesize\";s:5:\"28409\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha2\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/274537\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1214353208\";s:6:\"mdhash\";s:32:\"fad99b3ccc10d1c7185e05190c18b2e2\";s:8:\"filesize\";s:5:\"27684\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:24:\"filefield 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/274307\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/filefield-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1214320524\";s:6:\"mdhash\";s:32:\"71cd35da51661f17a066f68dc47ab471\";s:8:\"filesize\";s:5:\"26177\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}}s:14:\"latest_version\";s:7:\"6.x-3.7\";s:11:\"recommended\";s:7:\"6.x-3.7\";s:6:\"status\";i:1;}s:19:\"hierarchical_select\";a:23:{s:4:\"name\";s:19:\"hierarchical_select\";s:4:\"info\";a:6:{s:4:\"name\";s:19:\"Hierarchical Select\";s:7:\"package\";s:13:\"Form Elements\";s:7:\"version\";s:7:\"6.x-3.3\";s:7:\"project\";s:19:\"hierarchical_select\";s:9:\"datestamp\";s:10:\"1278589208\";s:16:\"_info_file_ctime\";i:1280943086;}s:9:\"datestamp\";s:10:\"1278589208\";s:8:\"includes\";a:2:{s:19:\"hierarchical_select\";s:19:\"Hierarchical Select\";s:17:\"hs_smallhierarchy\";s:35:\"Hierarchical Select Small Hierarchy\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-3.3\";s:14:\"existing_major\";s:1:\"3\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:19:\"Hierarchical Select\";s:10:\"short_name\";s:19:\"hierarchical_select\";s:10:\"dc:creator\";s:9:\"Wim Leers\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:45:\"http://drupal.org/project/hierarchical_select\";s:8:\"releases\";a:5:{s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:27:\"hierarchical_select 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/848264\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1278589208\";s:6:\"mdhash\";s:32:\"4c3ef9fb34b0369881f12beccd9f46fc\";s:8:\"filesize\";s:5:\"94417\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:27:\"hierarchical_select 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/847284\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1278508810\";s:6:\"mdhash\";s:32:\"78700af5e807a5a934d03dc12b5b9e9e\";s:8:\"filesize\";s:5:\"94416\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:27:\"hierarchical_select 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/763856\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1270586711\";s:6:\"mdhash\";s:32:\"e7ec20b004fe37d46b8f461f96437f29\";s:8:\"filesize\";s:5:\"93356\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:27:\"hierarchical_select 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/671504\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1262263536\";s:6:\"mdhash\";s:32:\"0d1f8d0e0f63950593cd6df6513b4d65\";s:8:\"filesize\";s:5:\"92143\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:31:\"hierarchical_select 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/341008\";s:13:\"download_link\";s:75:\"http://ftp.drupal.org/files/projects/hierarchical_select-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834480\";s:6:\"mdhash\";s:32:\"229eb8a5a2ab8b7e5443ac091e73eebb\";s:8:\"filesize\";s:5:\"94428\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}s:14:\"latest_version\";s:7:\"6.x-3.3\";s:11:\"recommended\";s:7:\"6.x-3.3\";s:6:\"status\";i:5;}s:8:\"imageapi\";a:23:{s:4:\"name\";s:8:\"imageapi\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"ImageAPI\";s:7:\"package\";s:10:\"ImageCache\";s:7:\"version\";s:7:\"6.x-1.6\";s:7:\"project\";s:8:\"imageapi\";s:9:\"datestamp\";s:10:\"1239992203\";s:16:\"_info_file_ctime\";i:1280943092;}s:9:\"datestamp\";s:10:\"1239992203\";s:8:\"includes\";a:3:{s:8:\"imageapi\";s:8:\"ImageAPI\";s:11:\"imageapi_gd\";s:12:\"ImageAPI GD2\";s:20:\"imageapi_imagemagick\";s:20:\"ImageAPI ImageMagick\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.6\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:8:\"ImageAPI\";s:10:\"short_name\";s:8:\"imageapi\";s:10:\"dc:creator\";s:7:\"drewish\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:34:\"http://drupal.org/project/imageapi\";s:8:\"releases\";a:12:{s:7:\"6.x-1.8\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.8\";s:7:\"version\";s:7:\"6.x-1.8\";s:3:\"tag\";s:13:\"DRUPAL-6--1-8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/786824\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1272675611\";s:6:\"mdhash\";s:32:\"94a681c95ad69160b6f10975b09bf2c1\";s:8:\"filesize\";s:5:\"32757\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.7\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/786762\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1272667207\";s:6:\"mdhash\";s:32:\"19a84e16371e4db2873ca9b0af5308c7\";s:8:\"filesize\";s:5:\"30193\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/436964\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1239992203\";s:6:\"mdhash\";s:32:\"f37907f3b3189f8ed964ee2a16218f03\";s:8:\"filesize\";s:5:\"23769\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/405820\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1237371335\";s:6:\"mdhash\";s:32:\"0127a0556a4261f906538f4211b8650e\";s:8:\"filesize\";s:5:\"23813\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/398654\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1236792328\";s:6:\"mdhash\";s:32:\"cffb8c9b3de4bbae7860df1cbe1c55c7\";s:8:\"filesize\";s:5:\"23850\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370133\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1233920429\";s:6:\"mdhash\";s:32:\"8f1ee8d4cf7ae9e590406dd209b32117\";s:8:\"filesize\";s:5:\"22816\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:16:\"imageapi 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354868\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1231215617\";s:6:\"mdhash\";s:32:\"41bf47a306b1cdf0a611800ba6f210cc\";s:8:\"filesize\";s:5:\"22754\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:10:{s:4:\"name\";s:16:\"imageapi 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1226821512\";s:6:\"mdhash\";s:32:\"d8f08b6ffc6c2f08701bb553c317ac93\";s:8:\"filesize\";s:5:\"22491\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:16:\"imageapi 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/313564\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1222378231\";s:6:\"mdhash\";s:32:\"d2e6ecdfcda91ce87037899af1a42a48\";s:8:\"filesize\";s:5:\"18843\";}s:14:\"6.x-1.0-alpha2\";a:13:{s:4:\"name\";s:23:\"imageapi 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292966\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1218219019\";s:6:\"mdhash\";s:32:\"e5e1723c878b372e0f71a54deade2759\";s:8:\"filesize\";s:5:\"18832\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:23:\"imageapi 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275936\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1214610910\";s:6:\"mdhash\";s:32:\"35bc5ec06dbfa7cf88f55223b161e8d9\";s:8:\"filesize\";s:5:\"16813\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:20:\"imageapi 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/257609\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/imageapi-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834535\";s:6:\"mdhash\";s:32:\"2f59ebc1980e002d4ceac5f203be217f\";s:8:\"filesize\";s:5:\"32928\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}s:14:\"latest_version\";s:7:\"6.x-1.8\";s:11:\"recommended\";s:7:\"6.x-1.8\";s:6:\"status\";i:4;}s:10:\"imagecache\";a:23:{s:4:\"name\";s:10:\"imagecache\";s:4:\"info\";a:6:{s:4:\"name\";s:10:\"ImageCache\";s:7:\"package\";s:10:\"ImageCache\";s:7:\"version\";s:14:\"6.x-2.0-beta10\";s:7:\"project\";s:10:\"imagecache\";s:9:\"datestamp\";s:10:\"1250716281\";s:16:\"_info_file_ctime\";i:1280943093;}s:9:\"datestamp\";s:10:\"1250716281\";s:8:\"includes\";a:2:{s:10:\"imagecache\";s:10:\"ImageCache\";s:13:\"imagecache_ui\";s:13:\"ImageCache UI\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:14:\"6.x-2.0-beta10\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:10:\"ImageCache\";s:10:\"short_name\";s:10:\"imagecache\";s:10:\"dc:creator\";s:7:\"drewish\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/imagecache\";s:8:\"releases\";a:13:{s:14:\"6.x-2.0-beta10\";a:13:{s:4:\"name\";s:25:\"imagecache 6.x-2.0-beta10\";s:7:\"version\";s:14:\"6.x-2.0-beta10\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-BETA10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"beta10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/554090\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta10.tar.gz\";s:4:\"date\";s:10:\"1250716281\";s:6:\"mdhash\";s:32:\"70b0132f0f8506a42d7e4481802b87af\";s:8:\"filesize\";s:5:\"67482\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:13:\"6.x-2.0-beta9\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta9\";s:7:\"version\";s:13:\"6.x-2.0-beta9\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/436974\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta9.tar.gz\";s:4:\"date\";s:10:\"1239992507\";s:6:\"mdhash\";s:32:\"ba1ff29cde2680fc4530ec03bb314f40\";s:8:\"filesize\";s:5:\"63999\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta8\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta8\";s:7:\"version\";s:13:\"6.x-2.0-beta8\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/375944\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta8.tar.gz\";s:4:\"date\";s:10:\"1234908073\";s:6:\"mdhash\";s:32:\"da2a33a8b515aa24a8968e8c900ede29\";s:8:\"filesize\";s:5:\"57863\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta7\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta7\";s:7:\"version\";s:13:\"6.x-2.0-beta7\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/375935\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta7.tar.gz\";s:4:\"date\";s:10:\"1234907441\";s:6:\"mdhash\";s:32:\"2fc3ec524113c7f25f60343d80e9ef2c\";s:8:\"filesize\";s:5:\"57868\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta6\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta6\";s:7:\"version\";s:13:\"6.x-2.0-beta6\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370142\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta6.tar.gz\";s:4:\"date\";s:10:\"1233921654\";s:6:\"mdhash\";s:32:\"37aeefc218c3c67f2669bb31ae70ec04\";s:8:\"filesize\";s:5:\"56280\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta5\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta5\";s:7:\"version\";s:13:\"6.x-2.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/355169\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1231271425\";s:6:\"mdhash\";s:32:\"fec1fb74904033c1bfe296edfaeaf475\";s:8:\"filesize\";s:5:\"56246\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354866\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1231215019\";s:6:\"mdhash\";s:32:\"91a36885a8e13a6c2a33aa5ed351cdda\";s:8:\"filesize\";s:5:\"56233\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/349938\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1229907316\";s:6:\"mdhash\";s:32:\"1c7df03f8e9d6035550d08e670482318\";s:8:\"filesize\";s:5:\"29771\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/327844\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1225317623\";s:6:\"mdhash\";s:32:\"38b7b964197263d2c23094ed0ce82e1d\";s:8:\"filesize\";s:5:\"24920\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:24:\"imagecache 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318352\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1223430312\";s:6:\"mdhash\";s:32:\"dd23eb6c526a9c700218e9ee9f27837e\";s:8:\"filesize\";s:5:\"24918\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:22:\"imagecache 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/96391\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/imagecache-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834538\";s:6:\"mdhash\";s:32:\"e2180ee4e02dd3bf314ef8f224caed8e\";s:8:\"filesize\";s:6:\"235406\";}s:14:\"6.x-1.0-alpha2\";a:13:{s:4:\"name\";s:25:\"imagecache 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292975\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagecache-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1218219914\";s:6:\"mdhash\";s:32:\"dd6f9663370215c513f5f0f12dc9e0aa\";s:8:\"filesize\";s:5:\"24806\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:25:\"imagecache 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275934\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagecache-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1214610910\";s:6:\"mdhash\";s:32:\"17e0a01b206046a1c84d3341797bcd40\";s:8:\"filesize\";s:5:\"23765\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}s:14:\"latest_version\";s:14:\"6.x-2.0-beta10\";s:11:\"recommended\";s:14:\"6.x-2.0-beta10\";s:6:\"status\";i:5;}s:18:\"imagecache_actions\";a:24:{s:4:\"name\";s:18:\"imagecache_actions\";s:4:\"info\";a:6:{s:4:\"name\";s:25:\"Imagecache Canvas Actions\";s:7:\"package\";s:10:\"ImageCache\";s:7:\"version\";s:7:\"6.x-1.6\";s:7:\"project\";s:18:\"imagecache_actions\";s:9:\"datestamp\";s:10:\"1244598933\";s:16:\"_info_file_ctime\";i:1280943095;}s:9:\"datestamp\";s:10:\"1244598933\";s:8:\"includes\";a:4:{s:24:\"imagecache_canvasactions\";s:25:\"Imagecache Canvas Actions\";s:23:\"imagecache_coloractions\";s:24:\"Imagecache Color Actions\";s:24:\"imagecache_customactions\";s:25:\"Imagecache Custom Actions\";s:22:\"imagecache_textactions\";s:23:\"Imagecache Text Actions\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.6\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:18:\"ImageCache Actions\";s:10:\"short_name\";s:18:\"imagecache_actions\";s:10:\"dc:creator\";s:4:\"dman\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:44:\"http://drupal.org/project/imagecache_actions\";s:8:\"releases\";a:10:{s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/808754\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1274793008\";s:6:\"mdhash\";s:32:\"e6caba0f70ffa1eea1609db0acadd1db\";s:8:\"filesize\";s:7:\"2195813\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:30:\"imagecache_actions 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/740560\";s:13:\"download_link\";s:74:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280189301\";s:6:\"mdhash\";s:32:\"e40a229563d5f0977a5b80d9b13c8498\";s:8:\"filesize\";s:7:\"2182820\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.7\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/808820\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1274796307\";s:6:\"mdhash\";s:32:\"980f3932545cfff5341e6137ea40cad7\";s:8:\"filesize\";s:7:\"1382694\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/487042\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1244598933\";s:6:\"mdhash\";s:32:\"acdaa251329c91292686ec24c5cc7946\";s:8:\"filesize\";s:7:\"1000474\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/413948\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1238018466\";s:6:\"mdhash\";s:32:\"2ba9c6f6a3bd2f7490c13d28bbffc891\";s:8:\"filesize\";s:7:\"1515895\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/400274\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1236900027\";s:6:\"mdhash\";s:32:\"5670d298e6cae58d16094b7a745f9b9f\";s:8:\"filesize\";s:7:\"1156857\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370821\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1234044626\";s:6:\"mdhash\";s:32:\"7d5b7e4fceb331265c4947b83594767f\";s:8:\"filesize\";s:6:\"798364\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/332112\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1226245516\";s:6:\"mdhash\";s:32:\"d2b17bba4e951a54ad68c2e41f27df5a\";s:8:\"filesize\";s:6:\"935928\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:26:\"imagecache_actions 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/321971\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1224146419\";s:6:\"mdhash\";s:32:\"b4aa4dff119f3295f4ec419bbebc655d\";s:8:\"filesize\";s:6:\"577632\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:30:\"imagecache_actions 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318918\";s:13:\"download_link\";s:74:\"http://ftp.drupal.org/files/projects/imagecache_actions-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834539\";s:6:\"mdhash\";s:32:\"391e098e7a9465f7645f211ec0add4a3\";s:8:\"filesize\";s:7:\"1394890\";}}s:4:\"also\";a:1:{i:2;s:7:\"6.x-2.0\";}s:14:\"latest_version\";s:7:\"6.x-1.7\";s:11:\"recommended\";s:7:\"6.x-1.7\";s:6:\"status\";i:4;}s:18:\"imagecache_effects\";a:23:{s:4:\"name\";s:18:\"imagecache_effects\";s:4:\"info\";a:6:{s:4:\"name\";s:18:\"ImageCache Effects\";s:7:\"package\";s:10:\"ImageCache\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:18:\"imagecache_effects\";s:9:\"datestamp\";s:10:\"1231131919\";s:16:\"_info_file_ctime\";i:1280943096;}s:9:\"datestamp\";s:10:\"1231131919\";s:8:\"includes\";a:1:{s:18:\"imagecache_effects\";s:18:\"ImageCache Effects\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.1\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:18:\"Imagecache Effects\";s:10:\"short_name\";s:18:\"imagecache_effects\";s:10:\"dc:creator\";s:10:\"evil_marty\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:44:\"http://drupal.org/project/imagecache_effects\";s:8:\"releases\";a:2:{s:7:\"6.x-1.1\";a:11:{s:4:\"name\";s:26:\"imagecache_effects 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354402\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/imagecache_effects-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1231131919\";s:6:\"mdhash\";s:32:\"05790530422f4b745d86af890028cba5\";s:8:\"filesize\";s:5:\"10985\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:30:\"imagecache_effects 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354312\";s:13:\"download_link\";s:74:\"http://ftp.drupal.org/files/projects/imagecache_effects-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834541\";s:6:\"mdhash\";s:32:\"117a9a54bd7edf4a15127bfe27b34a3f\";s:8:\"filesize\";s:5:\"10992\";}}s:14:\"latest_version\";s:7:\"6.x-1.1\";s:11:\"recommended\";s:7:\"6.x-1.1\";s:6:\"status\";i:5;}s:10:\"imagefield\";a:24:{s:4:\"name\";s:10:\"imagefield\";s:4:\"info\";a:6:{s:4:\"name\";s:10:\"ImageField\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-3.2\";s:7:\"project\";s:10:\"imagefield\";s:9:\"datestamp\";s:10:\"1256070937\";s:16:\"_info_file_ctime\";i:1280943096;}s:9:\"datestamp\";s:10:\"1256070937\";s:8:\"includes\";a:1:{s:10:\"imagefield\";s:10:\"ImageField\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-3.2\";s:14:\"existing_major\";s:1:\"3\";s:12:\"install_type\";s:8:\"official\";s:16:\"security updates\";a:1:{i:0;a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/791030\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1273102211\";s:6:\"mdhash\";s:32:\"c75dfd4912e569868a9bb8fef447f66a\";s:8:\"filesize\";s:5:\"35520\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}}s:5:\"title\";s:10:\"ImageField\";s:10:\"short_name\";s:10:\"imagefield\";s:10:\"dc:creator\";s:11:\"quicksketch\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/imagefield\";s:8:\"releases\";a:15:{s:7:\"6.x-3.7\";a:11:{s:4:\"name\";s:18:\"imagefield 6.x-3.7\";s:7:\"version\";s:7:\"6.x-3.7\";s:3:\"tag\";s:13:\"DRUPAL-6--3-7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/842202\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.7.tar.gz\";s:4:\"date\";s:10:\"1277942710\";s:6:\"mdhash\";s:32:\"3fe5ea1f1709775c4542871cb3b12c9a\";s:8:\"filesize\";s:5:\"36360\";}s:7:\"6.x-3.6\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.6\";s:7:\"version\";s:7:\"6.x-3.6\";s:3:\"tag\";s:13:\"DRUPAL-6--3-6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/841160\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.6.tar.gz\";s:4:\"date\";s:10:\"1277870109\";s:6:\"mdhash\";s:32:\"c53d67ca6a594c7b02a40581403d9dd1\";s:8:\"filesize\";s:5:\"36360\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/791030\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1273102211\";s:6:\"mdhash\";s:32:\"c75dfd4912e569868a9bb8fef447f66a\";s:8:\"filesize\";s:5:\"35520\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/609878\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1256070937\";s:6:\"mdhash\";s:32:\"6e5700f65209708913c389c075b0ebe7\";s:8:\"filesize\";s:5:\"30534\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/509788\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1246665655\";s:6:\"mdhash\";s:32:\"8aee5d27405bb818da9e53dff52fea03\";s:8:\"filesize\";s:5:\"27258\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:18:\"imagefield 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/439776\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1240272934\";s:6:\"mdhash\";s:32:\"518413c94a2b60ebbee2527a175ce828\";s:8:\"filesize\";s:5:\"25309\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.0-rc1\";a:13:{s:4:\"name\";s:22:\"imagefield 6.x-3.0-rc1\";s:7:\"version\";s:11:\"6.x-3.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--3-0-RC1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/421006\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1238618152\";s:6:\"mdhash\";s:32:\"408e3510544987622a38dcb5a9222a24\";s:8:\"filesize\";s:5:\"25076\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta3\";a:13:{s:4:\"name\";s:24:\"imagefield 6.x-3.0-beta3\";s:7:\"version\";s:13:\"6.x-3.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/408064\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1237534251\";s:6:\"mdhash\";s:32:\"dce14931da48a5db72e71e2a7239526a\";s:8:\"filesize\";s:5:\"21839\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta2\";a:13:{s:4:\"name\";s:24:\"imagefield 6.x-3.0-beta2\";s:7:\"version\";s:13:\"6.x-3.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/406846\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1237435254\";s:6:\"mdhash\";s:32:\"2ff6ec9186edba9705a06fb2e6c4d868\";s:8:\"filesize\";s:5:\"21932\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:24:\"imagefield 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/402452\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1237112123\";s:6:\"mdhash\";s:32:\"0ca7d8c0e59154d6c02a9b6e3451a4b3\";s:8:\"filesize\";s:5:\"21651\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha4\";a:13:{s:4:\"name\";s:25:\"imagefield 6.x-3.0-alpha4\";s:7:\"version\";s:14:\"6.x-3.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/357439\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1231716017\";s:6:\"mdhash\";s:32:\"9d4e3efe3a2f1380880cb3581e39867d\";s:8:\"filesize\";s:5:\"19371\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:25:\"imagefield 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/352408\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1230629116\";s:6:\"mdhash\";s:32:\"c686ef38ac5754b448e0083e869b5df2\";s:8:\"filesize\";s:5:\"19165\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:25:\"imagefield 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/300636\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1219850122\";s:6:\"mdhash\";s:32:\"01a404bac9ad55f5cfff5312ac480a77\";s:8:\"filesize\";s:5:\"17205\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:25:\"imagefield 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:21:\"DRUPAL-6--3-0-ALPHA-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292981\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1218220514\";s:6:\"mdhash\";s:32:\"0ec96da0b37dc803e2bc9c49541b5617\";s:8:\"filesize\";s:5:\"17286\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:22:\"imagefield 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/96519\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/imagefield-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834544\";s:6:\"mdhash\";s:32:\"f6344692bdeca3cee9545c1c4ad0c1b5\";s:8:\"filesize\";s:5:\"36360\";}}s:14:\"latest_version\";s:7:\"6.x-3.7\";s:11:\"recommended\";s:7:\"6.x-3.7\";s:6:\"status\";i:1;}s:4:\"imce\";a:24:{s:4:\"name\";s:4:\"imce\";s:4:\"info\";a:5:{s:4:\"name\";s:4:\"IMCE\";s:7:\"version\";s:7:\"6.x-1.2\";s:7:\"project\";s:4:\"imce\";s:9:\"datestamp\";s:10:\"1235227525\";s:16:\"_info_file_ctime\";i:1280943097;}s:9:\"datestamp\";s:10:\"1235227525\";s:8:\"includes\";a:1:{s:4:\"imce\";s:4:\"IMCE\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.2\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:4:\"IMCE\";s:10:\"short_name\";s:4:\"imce\";s:10:\"dc:creator\";s:4:\"ufku\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:30:\"http://drupal.org/project/imce\";s:8:\"releases\";a:11:{s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:16:\"imce 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/865140\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imce-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1280160060\";s:6:\"mdhash\";s:32:\"f1c695c58761698e31f509dbf645222c\";s:8:\"filesize\";s:5:\"58307\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:18:\"imce 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812926\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imce-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1275171908\";s:6:\"mdhash\";s:32:\"902202ccc74238467f1d684ec8e22776\";s:8:\"filesize\";s:5:\"57975\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:18:\"imce 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812592\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imce-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1275124808\";s:6:\"mdhash\";s:32:\"d6b3421b73d93804615878ff526dbf1f\";s:8:\"filesize\";s:5:\"57957\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:18:\"imce 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/745524\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/imce-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1268868008\";s:6:\"mdhash\";s:32:\"57650c4154c7a787cd1014a0c3ef6acc\";s:8:\"filesize\";s:5:\"55910\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:16:\"imce 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/745638\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imce-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279800550\";s:6:\"mdhash\";s:32:\"23a083cc5d2bb6e55b249a523d321bcd\";s:8:\"filesize\";s:5:\"58308\";}s:7:\"6.x-1.4\";a:12:{s:4:\"name\";s:12:\"imce 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812472\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1275099908\";s:6:\"mdhash\";s:32:\"173671054e8831c5e19f784cc5dc413d\";s:8:\"filesize\";s:6:\"110091\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:12:\"imce 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/587952\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1253890535\";s:6:\"mdhash\";s:32:\"f09555cd6454d1623c29258ab27525f9\";s:8:\"filesize\";s:5:\"98382\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:12:\"imce 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/379266\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1235227525\";s:6:\"mdhash\";s:32:\"0045f383acf0d49538ea74fe9c832d2c\";s:8:\"filesize\";s:5:\"69523\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:12:\"imce 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/286385\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1216839313\";s:6:\"mdhash\";s:32:\"f630895cbbeddeb8ddbdf034e378897c\";s:8:\"filesize\";s:5:\"61264\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:12:\"imce 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/254557\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/imce-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1209915610\";s:6:\"mdhash\";s:32:\"e7d80f9f2d55225ecdcca2ab590d1601\";s:8:\"filesize\";s:5:\"52832\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:16:\"imce 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/238016\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/imce-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834565\";s:6:\"mdhash\";s:32:\"7e55f7af0171f599ba34536f1d657b2d\";s:8:\"filesize\";s:6:\"110105\";}}s:4:\"also\";a:1:{i:2;s:11:\"6.x-2.0-rc1\";}s:14:\"latest_version\";s:7:\"6.x-1.4\";s:11:\"recommended\";s:7:\"6.x-1.4\";s:6:\"status\";i:4;}s:12:\"imce_wysiwyg\";a:23:{s:4:\"name\";s:12:\"imce_wysiwyg\";s:4:\"info\";a:6:{s:4:\"name\";s:23:\"IMCE Wysiwyg API bridge\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"6.x-1.0\";s:7:\"project\";s:12:\"imce_wysiwyg\";s:9:\"datestamp\";s:10:\"1236182123\";s:16:\"_info_file_ctime\";i:1280943099;}s:9:\"datestamp\";s:10:\"1236182123\";s:8:\"includes\";a:1:{s:12:\"imce_wysiwyg\";s:23:\"IMCE Wysiwyg API bridge\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.0\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:19:\"IMCE Wysiwyg bridge\";s:10:\"short_name\";s:12:\"imce_wysiwyg\";s:10:\"dc:creator\";s:3:\"sun\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:38:\"http://drupal.org/project/imce_wysiwyg\";s:8:\"releases\";a:3:{s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:20:\"imce_wysiwyg 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/741170\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/imce_wysiwyg-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1268433606\";s:6:\"mdhash\";s:32:\"3fd03f7e05e058d0fbd22e3e6d5573d7\";s:8:\"filesize\";s:4:\"8756\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:20:\"imce_wysiwyg 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/390960\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/imce_wysiwyg-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1236182123\";s:6:\"mdhash\";s:32:\"1b1c172985c6de7dd1dd013b46d62fc4\";s:8:\"filesize\";s:4:\"7690\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:24:\"imce_wysiwyg 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/383902\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/imce_wysiwyg-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834569\";s:6:\"mdhash\";s:32:\"63e7ddc4ef0d31515b6adc52c47bdc07\";s:8:\"filesize\";s:4:\"8768\";}}s:14:\"latest_version\";s:7:\"6.x-1.1\";s:11:\"recommended\";s:7:\"6.x-1.1\";s:6:\"status\";i:4;}s:10:\"jquerymenu\";a:23:{s:4:\"name\";s:10:\"jquerymenu\";s:4:\"info\";a:6:{s:4:\"name\";s:11:\"Jquery Menu\";s:7:\"package\";s:24:\"Advanced Navigation Pack\";s:7:\"version\";s:7:\"6.x-3.3\";s:7:\"project\";s:10:\"jquerymenu\";s:9:\"datestamp\";s:10:\"1273902006\";s:16:\"_info_file_ctime\";i:1280943099;}s:9:\"datestamp\";s:10:\"1273902006\";s:8:\"includes\";a:1:{s:10:\"jquerymenu\";s:11:\"Jquery Menu\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-3.3\";s:14:\"existing_major\";s:1:\"3\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:11:\"JQuery menu\";s:10:\"short_name\";s:10:\"jquerymenu\";s:10:\"dc:creator\";s:13:\"Aaron Hawkins\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/jquerymenu\";s:8:\"releases\";a:17:{s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/799538\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1273902007\";s:6:\"mdhash\";s:32:\"e3a615f3c0104006324fb8369b83eddd\";s:8:\"filesize\";s:5:\"14157\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.2\";a:11:{s:4:\"name\";s:18:\"jquerymenu 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/790206\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1273046107\";s:6:\"mdhash\";s:32:\"895316145b0480bce1282ddec5e31d45\";s:8:\"filesize\";s:5:\"13287\";}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/633816\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1258361451\";s:6:\"mdhash\";s:32:\"5dcec1c8906fa7a806f9e0fe80dbe5ab\";s:8:\"filesize\";s:5:\"13280\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/375939\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1234907752\";s:6:\"mdhash\";s:32:\"7c008f95c6f95f22ccc0e6e30ab08fcb\";s:8:\"filesize\";s:5:\"11430\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/375176\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1234799154\";s:6:\"mdhash\";s:32:\"6b6a8ca9139ac2efeffdf28d800e392b\";s:8:\"filesize\";s:5:\"11408\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370608\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1234008044\";s:6:\"mdhash\";s:32:\"66c6aa9e3cf748edfc78e2a101e52c54\";s:8:\"filesize\";s:5:\"11372\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/369325\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1233784975\";s:6:\"mdhash\";s:32:\"2291fd5923b941d56c3f8012f937cfc7\";s:8:\"filesize\";s:5:\"10500\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.9\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.9\";s:7:\"version\";s:7:\"6.x-1.9\";s:3:\"tag\";s:13:\"DRUPAL-6--1-9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/354524\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1231161626\";s:6:\"mdhash\";s:32:\"3d08e06f70404a4d7872f4b75055554e\";s:8:\"filesize\";s:5:\"10520\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.8\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.8\";s:7:\"version\";s:7:\"6.x-1.8\";s:3:\"tag\";s:13:\"DRUPAL-6--1-8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/351854\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1230492629\";s:6:\"mdhash\";s:32:\"4e309dc67b84e3c827b829f48155c09c\";s:8:\"filesize\";s:5:\"10337\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.7\";a:11:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/349054\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1229683222\";s:6:\"mdhash\";s:32:\"76802b1c93b82a5a5f5075416f213b03\";s:8:\"filesize\";s:5:\"10219\";}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/348466\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1229561728\";s:6:\"mdhash\";s:32:\"405e894548c5d8e530040c8049e50d40\";s:8:\"filesize\";s:5:\"10244\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/343942\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1228659637\";s:6:\"mdhash\";s:32:\"55bb3176a7f2ad48440c887b248aef1d\";s:8:\"filesize\";s:5:\"10226\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:11:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/343931\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1228656325\";s:6:\"mdhash\";s:32:\"d23bb0bc1164f23a430b6aac465a76c2\";s:8:\"filesize\";s:5:\"10190\";}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/340795\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1228053916\";s:6:\"mdhash\";s:32:\"5bfb1ad68f657a7a173562cd31ad2ae8\";s:8:\"filesize\";s:5:\"10242\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/334431\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1226694016\";s:6:\"mdhash\";s:32:\"13600a256557fb04e1079772478451bb\";s:8:\"filesize\";s:5:\"10116\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/334295\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1226673317\";s:6:\"mdhash\";s:32:\"7cafd7ca8a5e21e60eb5336a07171645\";s:8:\"filesize\";s:4:\"9976\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:18:\"jquerymenu 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/333384\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/jquerymenu-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1226502027\";s:6:\"mdhash\";s:32:\"8371399bff4c647a94699b52edbe5aa6\";s:8:\"filesize\";s:4:\"9849\";}}s:14:\"latest_version\";s:7:\"6.x-3.3\";s:11:\"recommended\";s:7:\"6.x-3.3\";s:6:\"status\";i:5;}s:4:\"link\";a:23:{s:4:\"name\";s:4:\"link\";s:4:\"info\";a:6:{s:4:\"name\";s:4:\"Link\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-2.8\";s:7:\"project\";s:4:\"link\";s:9:\"datestamp\";s:10:\"1257394550\";s:16:\"_info_file_ctime\";i:1280943102;}s:9:\"datestamp\";s:10:\"1257394550\";s:8:\"includes\";a:1:{s:4:\"link\";s:4:\"Link\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-2.8\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:4:\"Link\";s:10:\"short_name\";s:4:\"link\";s:10:\"dc:creator\";s:7:\"jcfiala\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:30:\"http://drupal.org/project/link\";s:8:\"releases\";a:18:{s:7:\"6.x-2.9\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.9\";s:7:\"version\";s:7:\"6.x-2.9\";s:3:\"tag\";s:13:\"DRUPAL-6--2-9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/827200\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1276539609\";s:6:\"mdhash\";s:32:\"4ded032cae71f43174f70f70ecd57471\";s:8:\"filesize\";s:5:\"40597\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.8\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.8\";s:7:\"version\";s:7:\"6.x-2.8\";s:3:\"tag\";s:13:\"DRUPAL-6--2-8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/623932\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1257394550\";s:6:\"mdhash\";s:32:\"54bf94310938c8000eb80c22464ba2d8\";s:8:\"filesize\";s:5:\"24911\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/620668\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1257135943\";s:6:\"mdhash\";s:32:\"960d3e01365529c1fcae95039e9e7dc9\";s:8:\"filesize\";s:5:\"24902\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/512554\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1246976471\";s:6:\"mdhash\";s:32:\"e9dbc3209f93f78ec14dd8a48c5fb8d6\";s:8:\"filesize\";s:5:\"22630\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:13:\"6.x-2.6-beta3\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.6-beta3\";s:7:\"version\";s:13:\"6.x-2.6-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-6-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/510266\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.6-beta3.tar.gz\";s:4:\"date\";s:10:\"1246734941\";s:6:\"mdhash\";s:32:\"16ad8ed0d366777bbaf02195dee4f010\";s:8:\"filesize\";s:5:\"22631\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.6-beta2\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.6-beta2\";s:7:\"version\";s:13:\"6.x-2.6-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-6-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/507690\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.6-beta2.tar.gz\";s:4:\"date\";s:10:\"1246488355\";s:6:\"mdhash\";s:32:\"76db909e8b2621c9377bfd7060ba339a\";s:8:\"filesize\";s:5:\"23690\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.6-beta1\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.6-beta1\";s:7:\"version\";s:13:\"6.x-2.6-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-6-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/438778\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.6-beta1.tar.gz\";s:4:\"date\";s:10:\"1240201545\";s:6:\"mdhash\";s:32:\"5c7795e16074a0368a50a454eba9ec7c\";s:8:\"filesize\";s:5:\"22117\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/311640\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1222062031\";s:6:\"mdhash\";s:32:\"152beeb2451a532e2f7123ba10cb1866\";s:8:\"filesize\";s:5:\"26255\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/311636\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1222061435\";s:6:\"mdhash\";s:32:\"e038edae40617ed573c3cefb10caac3f\";s:8:\"filesize\";s:5:\"21682\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.x-2.3.1\";a:13:{s:4:\"name\";s:14:\"link 6.x-2.3.1\";s:7:\"version\";s:9:\"6.x-2.3.1\";s:3:\"tag\";s:15:\"DRUPAL-6--2-3-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/284503\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/link-6.x-2.3.1.tar.gz\";s:4:\"date\";s:10:\"1216417210\";s:6:\"mdhash\";s:32:\"51be611f4b6325f0e62ae8da61a22fbc\";s:8:\"filesize\";s:5:\"20500\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/276477\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1214777711\";s:6:\"mdhash\";s:32:\"3fb0a05406086be6a1b65f320d431f34\";s:8:\"filesize\";s:5:\"20495\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:12:\"link 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/267399\";s:13:\"download_link\";s:56:\"http://ftp.drupal.org/files/projects/link-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1212735317\";s:6:\"mdhash\";s:32:\"8856fc24bacd5198cffd46061541473b\";s:8:\"filesize\";s:5:\"18792\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.1-beta4\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.1-beta4\";s:7:\"version\";s:13:\"6.x-2.1-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-1-beta4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/249022\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.1-beta4.tar.gz\";s:4:\"date\";s:10:\"1208720713\";s:6:\"mdhash\";s:32:\"87ffef5ddba6eb90f4fdd2d135399358\";s:8:\"filesize\";s:5:\"16750\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.1-beta2\";a:12:{s:4:\"name\";s:18:\"link 6.x-2.1-beta2\";s:7:\"version\";s:13:\"6.x-2.1-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-1-beta2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/240739\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.1-beta2.tar.gz\";s:4:\"date\";s:10:\"1206952509\";s:6:\"mdhash\";s:32:\"f34f19c3e9d862705d61e4cc1905ffd6\";s:8:\"filesize\";s:5:\"16786\";}s:13:\"6.x-2.1-beta3\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.1-beta3\";s:7:\"version\";s:13:\"6.x-2.1-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-1-beta3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/240740\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.1-beta3.tar.gz\";s:4:\"date\";s:10:\"1206952509\";s:6:\"mdhash\";s:32:\"26cbeb74c30390dba9dd3c97cf83166a\";s:8:\"filesize\";s:5:\"16777\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.1-beta1\";a:13:{s:4:\"name\";s:18:\"link 6.x-2.1-beta1\";s:7:\"version\";s:13:\"6.x-2.1-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-1-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/240723\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/link-6.x-2.1-beta1.tar.gz\";s:4:\"date\";s:10:\"1206946811\";s:6:\"mdhash\";s:32:\"b2f0d3de0b8135053d8559d36dd41ff7\";s:8:\"filesize\";s:5:\"16773\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:16:\"link 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/580990\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/link-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834740\";s:6:\"mdhash\";s:32:\"360cbbf71f3142a51e6689512c153770\";s:8:\"filesize\";s:5:\"40614\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:16:\"link 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/240722\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/link-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834740\";s:6:\"mdhash\";s:32:\"928e74fb61f369ab6ec4a4a72c1302bb\";s:8:\"filesize\";s:5:\"23692\";}}s:14:\"latest_version\";s:7:\"6.x-2.9\";s:11:\"recommended\";s:7:\"6.x-2.9\";s:6:\"status\";i:4;}s:15:\"menu_attributes\";a:23:{s:4:\"name\";s:15:\"menu_attributes\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Menu Attributes\";s:7:\"package\";s:4:\"Menu\";s:7:\"version\";s:7:\"6.x-1.4\";s:7:\"project\";s:15:\"menu_attributes\";s:9:\"datestamp\";s:10:\"1240350367\";s:16:\"_info_file_ctime\";i:1280943103;}s:9:\"datestamp\";s:10:\"1240350367\";s:8:\"includes\";a:1:{s:15:\"menu_attributes\";s:15:\"Menu Attributes\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.4\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:15:\"Menu Attributes\";s:10:\"short_name\";s:15:\"menu_attributes\";s:10:\"dc:creator\";s:9:\"Schoonzie\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:41:\"http://drupal.org/project/menu_attributes\";s:8:\"releases\";a:7:{s:7:\"6.x-1.4\";a:11:{s:4:\"name\";s:23:\"menu_attributes 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/440928\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1240350367\";s:6:\"mdhash\";s:32:\"a713995aeb5a99f8cae40890fffdf093\";s:8:\"filesize\";s:4:\"8339\";}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:23:\"menu_attributes 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/440904\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1240349511\";s:6:\"mdhash\";s:32:\"fd0064507f27d04e8d86c4e5ede2c803\";s:8:\"filesize\";s:4:\"8324\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:23:\"menu_attributes 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/364152\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1232933723\";s:6:\"mdhash\";s:32:\"db3c41b196e33f9527050937ee566813\";s:8:\"filesize\";s:4:\"7191\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:23:\"menu_attributes 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/358964\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1231973730\";s:6:\"mdhash\";s:32:\"1fb163bc559ba27c0387be9d38e701d1\";s:8:\"filesize\";s:4:\"7094\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc1\";a:12:{s:4:\"name\";s:27:\"menu_attributes 6.x-1.0-rc1\";s:7:\"version\";s:11:\"6.x-1.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/353372\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1230870022\";s:6:\"mdhash\";s:32:\"1e9b4b7d17fad14ae89fffda0429f19e\";s:8:\"filesize\";s:4:\"6881\";}s:13:\"6.x-1.0-beta1\";a:12:{s:4:\"name\";s:29:\"menu_attributes 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/351982\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1230530724\";s:6:\"mdhash\";s:32:\"bf3e01357b899cf3ee37c1ee9c692324\";s:8:\"filesize\";s:4:\"6965\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:27:\"menu_attributes 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/863620\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/menu_attributes-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280016729\";s:6:\"mdhash\";s:32:\"93d3fa0a8d8a591e8202e26a8ff67d49\";s:8:\"filesize\";s:4:\"8614\";}}s:14:\"latest_version\";s:7:\"6.x-1.4\";s:11:\"recommended\";s:7:\"6.x-1.4\";s:6:\"status\";i:5;}s:10:\"menu_block\";a:24:{s:4:\"name\";s:10:\"menu_block\";s:4:\"info\";a:5:{s:4:\"name\";s:10:\"Menu Block\";s:7:\"version\";s:7:\"6.x-2.2\";s:7:\"project\";s:10:\"menu_block\";s:9:\"datestamp\";s:10:\"1229377222\";s:16:\"_info_file_ctime\";i:1280943104;}s:9:\"datestamp\";s:10:\"1229377222\";s:8:\"includes\";a:1:{s:10:\"menu_block\";s:10:\"Menu Block\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-2.2\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:16:\"security updates\";a:1:{i:0;a:12:{s:4:\"name\";s:18:\"menu_block 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/752248\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1269474612\";s:6:\"mdhash\";s:32:\"2b220e5dc87e0c85308ec92c7c93bd26\";s:8:\"filesize\";s:5:\"34639\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}}s:5:\"title\";s:10:\"Menu block\";s:10:\"short_name\";s:10:\"menu_block\";s:10:\"dc:creator\";s:9:\"JohnAlbin\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"http://drupal.org/project/menu_block\";s:8:\"releases\";a:5:{s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:18:\"menu_block 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/752248\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1269474612\";s:6:\"mdhash\";s:32:\"2b220e5dc87e0c85308ec92c7c93bd26\";s:8:\"filesize\";s:5:\"34639\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:18:\"menu_block 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/347427\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1229377222\";s:6:\"mdhash\";s:32:\"f00b51d3ac68f1c95260652f55c4e883\";s:8:\"filesize\";s:5:\"20104\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:18:\"menu_block 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/341098\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1228126522\";s:6:\"mdhash\";s:32:\"3bbfaf58017af2c8144cf5c10aec0e96\";s:8:\"filesize\";s:5:\"19904\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:18:\"menu_block 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/299622\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1219656627\";s:6:\"mdhash\";s:32:\"8285859ad904e0f5113008a6761401ba\";s:8:\"filesize\";s:5:\"13820\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:22:\"menu_block 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/299623\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/menu_block-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834864\";s:6:\"mdhash\";s:32:\"7e81149693574036b2476a27870c060c\";s:8:\"filesize\";s:5:\"34689\";}}s:14:\"latest_version\";s:7:\"6.x-2.3\";s:11:\"recommended\";s:7:\"6.x-2.3\";s:6:\"status\";i:1;}s:11:\"menu_editor\";a:24:{s:4:\"name\";s:11:\"menu_editor\";s:4:\"info\";a:6:{s:4:\"name\";s:11:\"Menu Editor\";s:7:\"package\";s:4:\"Menu\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:7:\"project\";s:11:\"menu_editor\";s:9:\"datestamp\";s:10:\"1272201609\";s:16:\"_info_file_ctime\";i:1280943104;}s:9:\"datestamp\";s:10:\"1272201609\";s:8:\"includes\";a:2:{s:11:\"menu_editor\";s:11:\"Menu Editor\";s:25:\"menu_editor_node_creation\";s:27:\"Menu Editor - Node creation\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:13:\"6.x-2.0-beta2\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:11:\"Menu Editor\";s:10:\"short_name\";s:11:\"menu_editor\";s:10:\"dc:creator\";s:10:\"donquixote\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:37:\"http://drupal.org/project/menu_editor\";s:8:\"releases\";a:18:{s:17:\"6.x-3.0-unstable3\";a:13:{s:4:\"name\";s:29:\"menu_editor 6.x-3.0-unstable3\";s:7:\"version\";s:17:\"6.x-3.0-unstable3\";s:3:\"tag\";s:23:\"DRUPAL-6--3-0-UNSTABLE3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:9:\"unstable3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/855168\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-3.0-unstable3.tar.gz\";s:4:\"date\";s:10:\"1279205110\";s:6:\"mdhash\";s:32:\"aea612722f5661c125fab8af453c2897\";s:8:\"filesize\";s:5:\"19145\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:17:\"6.x-3.0-unstable2\";a:13:{s:4:\"name\";s:29:\"menu_editor 6.x-3.0-unstable2\";s:7:\"version\";s:17:\"6.x-3.0-unstable2\";s:3:\"tag\";s:23:\"DRUPAL-6--3-0-UNSTABLE2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:9:\"unstable2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/821842\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-3.0-unstable2.tar.gz\";s:4:\"date\";s:10:\"1276014308\";s:6:\"mdhash\";s:32:\"64af081c0e61aa948199dd66dfa7e379\";s:8:\"filesize\";s:5:\"19115\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:17:\"6.x-3.0-unstable1\";a:13:{s:4:\"name\";s:29:\"menu_editor 6.x-3.0-unstable1\";s:7:\"version\";s:17:\"6.x-3.0-unstable1\";s:3:\"tag\";s:23:\"DRUPAL-6--3-0-UNSTABLE1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:9:\"unstable1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/821082\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-3.0-unstable1.tar.gz\";s:4:\"date\";s:10:\"1275960308\";s:6:\"mdhash\";s:32:\"1cd40ad3e34a5f538f15953a3d774c15\";s:8:\"filesize\";s:5:\"18576\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/821076\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279239044\";s:6:\"mdhash\";s:32:\"0beed3f32f316d83e9675f983e3a791d\";s:8:\"filesize\";s:5:\"19142\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:19:\"menu_editor 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/855016\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1279195215\";s:6:\"mdhash\";s:32:\"e6a1570c7f94211a4771873fa63918a0\";s:8:\"filesize\";s:5:\"16412\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:11:{s:4:\"name\";s:19:\"menu_editor 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/821074\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1275959408\";s:6:\"mdhash\";s:32:\"affd13aafd9367dab94ca0b7916de42e\";s:8:\"filesize\";s:5:\"16180\";}s:11:\"6.x-2.0-rc2\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-2.0-rc2\";s:7:\"version\";s:11:\"6.x-2.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/803064\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1274265607\";s:6:\"mdhash\";s:32:\"3dd9e5c9d5967a1bfbec9b2fd8918b09\";s:8:\"filesize\";s:5:\"16173\";}s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:23:\"menu_editor 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/802976\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1274259907\";s:6:\"mdhash\";s:32:\"4e976de9a55024fbcc5aed8d5919f95e\";s:8:\"filesize\";s:5:\"16181\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:25:\"menu_editor 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/781118\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1272201609\";s:6:\"mdhash\";s:32:\"0a97b870edf1a72cf87bf50776f0d652\";s:8:\"filesize\";s:5:\"16066\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:25:\"menu_editor 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/759000\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1270089010\";s:6:\"mdhash\";s:32:\"60f91f4abd9ebc007e6a0634626b753e\";s:8:\"filesize\";s:5:\"15822\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:14:\"6.x-2.0-alpha1\";a:13:{s:4:\"name\";s:26:\"menu_editor 6.x-2.0-alpha1\";s:7:\"version\";s:14:\"6.x-2.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/741990\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1268565906\";s:6:\"mdhash\";s:32:\"71c224f5e3dd73147561e83048650634\";s:8:\"filesize\";s:5:\"15197\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/741988\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279195819\";s:6:\"mdhash\";s:32:\"504045c135e1713c286f957e603ec439\";s:8:\"filesize\";s:5:\"16416\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.3-alpha1\";a:13:{s:4:\"name\";s:26:\"menu_editor 6.x-1.3-alpha1\";s:7:\"version\";s:14:\"6.x-1.3-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-3-ALPHA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/741978\";s:13:\"download_link\";s:70:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.3-alpha1.tar.gz\";s:4:\"date\";s:10:\"1268564707\";s:6:\"mdhash\";s:32:\"e8b11710a5afa069e6596ff325148426\";s:8:\"filesize\";s:5:\"15097\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:19:\"menu_editor 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/695478\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1264481106\";s:6:\"mdhash\";s:32:\"06bd1f420b16f85aae97560559e75ded\";s:8:\"filesize\";s:5:\"12622\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:11:{s:4:\"name\";s:19:\"menu_editor 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/695426\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1264476908\";s:6:\"mdhash\";s:32:\"43a2dc46f2827507a13560d2c32b7d7c\";s:8:\"filesize\";s:5:\"14347\";}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:19:\"menu_editor 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/670480\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1262148044\";s:6:\"mdhash\";s:32:\"b33bf71ca80eab5592d670b87641930d\";s:8:\"filesize\";s:5:\"12620\";}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/695406\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834866\";s:6:\"mdhash\";s:32:\"6ba4e6abfe0a87f797989f1aa8e75314\";s:8:\"filesize\";s:5:\"15097\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-0.x-dev\";a:12:{s:4:\"name\";s:23:\"menu_editor 6.x-0.x-dev\";s:7:\"version\";s:11:\"6.x-0.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/646364\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/menu_editor-6.x-0.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278834865\";s:6:\"mdhash\";s:32:\"e04539447713e06dd67ba2a5b94892bb\";s:8:\"filesize\";s:5:\"14842\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}}s:4:\"also\";a:1:{i:3;s:17:\"6.x-3.0-unstable3\";}s:14:\"latest_version\";s:7:\"6.x-2.1\";s:11:\"recommended\";s:7:\"6.x-2.1\";s:6:\"status\";i:4;}s:6:\"panels\";a:23:{s:4:\"name\";s:6:\"panels\";s:4:\"info\";a:6:{s:4:\"name\";s:6:\"Panels\";s:7:\"package\";s:6:\"Panels\";s:7:\"version\";s:7:\"6.x-3.5\";s:7:\"project\";s:6:\"panels\";s:9:\"datestamp\";s:10:\"1275094509\";s:16:\"_info_file_ctime\";i:1280943112;}s:9:\"datestamp\";s:10:\"1275094509\";s:8:\"includes\";a:3:{s:6:\"panels\";s:6:\"Panels\";s:11:\"panels_mini\";s:11:\"Mini panels\";s:11:\"panels_node\";s:11:\"Panel nodes\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-3.5\";s:14:\"existing_major\";s:1:\"3\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:6:\"Panels\";s:10:\"short_name\";s:6:\"panels\";s:10:\"dc:creator\";s:13:\"merlinofchaos\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:32:\"http://drupal.org/project/panels\";s:8:\"releases\";a:20:{s:7:\"6.x-3.7\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.7\";s:7:\"version\";s:7:\"6.x-3.7\";s:3:\"tag\";s:13:\"DRUPAL-6--3-7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/865584\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.7.tar.gz\";s:4:\"date\";s:10:\"1280189119\";s:6:\"mdhash\";s:32:\"e3a45d1e4085e4dc7736f20de9d209f7\";s:8:\"filesize\";s:6:\"382477\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.5\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.5\";s:7:\"version\";s:7:\"6.x-3.5\";s:3:\"tag\";s:13:\"DRUPAL-6--3-5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/812452\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.5.tar.gz\";s:4:\"date\";s:10:\"1275094509\";s:6:\"mdhash\";s:32:\"f713545b0a818271a43ffc10c9e192bd\";s:8:\"filesize\";s:6:\"348703\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.4\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.4\";s:7:\"version\";s:7:\"6.x-3.4\";s:3:\"tag\";s:13:\"DRUPAL-6--3-4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/803916\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.4.tar.gz\";s:4:\"date\";s:10:\"1274320813\";s:6:\"mdhash\";s:32:\"6fc2170843269a05f65bc22155aa0d97\";s:8:\"filesize\";s:6:\"372024\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-3.3\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.3\";s:7:\"version\";s:7:\"6.x-3.3\";s:3:\"tag\";s:13:\"DRUPAL-6--3-3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/701812\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1265065814\";s:6:\"mdhash\";s:32:\"46285850574246604750def846433e05\";s:8:\"filesize\";s:6:\"348175\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.2\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.2\";s:7:\"version\";s:7:\"6.x-3.2\";s:3:\"tag\";s:13:\"DRUPAL-6--3-2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/611096\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1256162761\";s:6:\"mdhash\";s:32:\"9b7a53d7892f202bfb4463a5b4b7e7b7\";s:8:\"filesize\";s:6:\"336144\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.1\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.1\";s:7:\"version\";s:7:\"6.x-3.1\";s:3:\"tag\";s:13:\"DRUPAL-6--3-1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/605840\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1255638659\";s:6:\"mdhash\";s:32:\"3533d26f01302b98487f087fafb07580\";s:8:\"filesize\";s:6:\"335965\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-3.0\";a:12:{s:4:\"name\";s:14:\"panels 6.x-3.0\";s:7:\"version\";s:7:\"6.x-3.0\";s:3:\"tag\";s:13:\"DRUPAL-6--3-0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/554226\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1250724669\";s:6:\"mdhash\";s:32:\"2bfa7f119253533dcbefa100bf354b61\";s:8:\"filesize\";s:6:\"322329\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.0-rc1\";a:13:{s:4:\"name\";s:18:\"panels 6.x-3.0-rc1\";s:7:\"version\";s:11:\"6.x-3.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--3-0-RC1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/528134\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1248309076\";s:6:\"mdhash\";s:32:\"e86ae024f95f29cf8e1ff9a52394982d\";s:8:\"filesize\";s:6:\"355424\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta4\";a:13:{s:4:\"name\";s:20:\"panels 6.x-3.0-beta4\";s:7:\"version\";s:13:\"6.x-3.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/517088\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1247424051\";s:6:\"mdhash\";s:32:\"705d1347895ad47daed06cefb7d22ce3\";s:8:\"filesize\";s:6:\"337007\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta2\";a:13:{s:4:\"name\";s:20:\"panels 6.x-3.0-beta2\";s:7:\"version\";s:13:\"6.x-3.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/468632\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1242862539\";s:6:\"mdhash\";s:32:\"2e26b928b8c3de8d651fea7fd8e6d63d\";s:8:\"filesize\";s:6:\"339504\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:20:\"panels 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/450240\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1241139940\";s:6:\"mdhash\";s:32:\"403e3907c9b38ccf76b5281b6643861a\";s:8:\"filesize\";s:6:\"337251\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha4\";a:13:{s:4:\"name\";s:21:\"panels 6.x-3.0-alpha4\";s:7:\"version\";s:14:\"6.x-3.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/421994\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1238697971\";s:6:\"mdhash\";s:32:\"f27d2b25d17ce8f065e5dd432f8a1a86\";s:8:\"filesize\";s:6:\"367906\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:21:\"panels 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/418640\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1238444751\";s:6:\"mdhash\";s:32:\"44693a0b993cfccb881c123d13a6f776\";s:8:\"filesize\";s:6:\"367243\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:21:\"panels 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/366425\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1233270339\";s:6:\"mdhash\";s:32:\"5641b7a35fa62580b116c97d5408249e\";s:8:\"filesize\";s:6:\"354040\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:21:\"panels 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/352589\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/panels-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1230663323\";s:6:\"mdhash\";s:32:\"284d81a8550d65e1a4958e5c84ebba10\";s:8:\"filesize\";s:6:\"400176\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:18:\"panels 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/366922\";s:13:\"download_link\";s:62:\"http://ftp.drupal.org/files/projects/panels-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280967484\";s:6:\"mdhash\";s:32:\"cb25005406e127140a3443589b9f4f5f\";s:8:\"filesize\";s:6:\"382708\";}s:14:\"6.x-2.0-alpha3\";a:11:{s:4:\"name\";s:21:\"panels 6.x-2.0-alpha3\";s:7:\"version\";s:14:\"6.x-2.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1230669628\";s:6:\"mdhash\";s:32:\"af08bf2c2b739341add3723b759a8d3c\";s:8:\"filesize\";s:6:\"418513\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha2\";a:11:{s:4:\"name\";s:21:\"panels 6.x-2.0-alpha2\";s:7:\"version\";s:14:\"6.x-2.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1223825423\";s:6:\"mdhash\";s:32:\"84813abb46ea70be8ab09711edcc007e\";s:8:\"filesize\";s:6:\"399737\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha1\";a:11:{s:4:\"name\";s:21:\"panels 6.x-2.0-alpha1\";s:7:\"version\";s:14:\"6.x-2.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1220497215\";s:6:\"mdhash\";s:32:\"f06c1a814d13dd7becff85a9c7078e3e\";s:8:\"filesize\";s:6:\"356885\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:9:{s:4:\"name\";s:18:\"panels 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1234656855\";s:6:\"mdhash\";s:32:\"c1ff3908e47d5f4f9cfba6077cd8fb4a\";s:8:\"filesize\";s:6:\"416317\";}}s:14:\"latest_version\";s:7:\"6.x-3.7\";s:11:\"recommended\";s:7:\"6.x-3.7\";s:6:\"status\";i:4;}s:8:\"pathauto\";a:24:{s:4:\"name\";s:8:\"pathauto\";s:4:\"info\";a:5:{s:4:\"name\";s:8:\"Pathauto\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:8:\"pathauto\";s:9:\"datestamp\";s:10:\"1214487317\";s:16:\"_info_file_ctime\";i:1280943116;}s:9:\"datestamp\";s:10:\"1214487317\";s:8:\"includes\";a:1:{s:8:\"pathauto\";s:8:\"Pathauto\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.1\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:8:\"Pathauto\";s:10:\"short_name\";s:8:\"pathauto\";s:10:\"dc:creator\";s:8:\"greggles\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:34:\"http://drupal.org/project/pathauto\";s:8:\"releases\";a:6:{s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:20:\"pathauto 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/710692\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/pathauto-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708032\";s:6:\"mdhash\";s:32:\"5fe0342a4d7a329f79d35dcb93880389\";s:8:\"filesize\";s:6:\"130703\";}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:16:\"pathauto 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/727806\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1267299906\";s:6:\"mdhash\";s:32:\"9d612b248ba1de5887ee52b69cbd1ad3\";s:8:\"filesize\";s:6:\"138251\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:16:\"pathauto 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/610622\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1256137878\";s:6:\"mdhash\";s:32:\"e27d8578aa485a68e9cc48d150d24dcc\";s:8:\"filesize\";s:6:\"127507\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:16:\"pathauto 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/275258\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1214487317\";s:6:\"mdhash\";s:32:\"1c6e0ef50e5cd3685bff7652c5cd4886\";s:8:\"filesize\";s:6:\"103474\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:16:\"pathauto 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/252930\";s:13:\"download_link\";s:60:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1209519916\";s:6:\"mdhash\";s:32:\"c9355aae82a7547c1f601c93d4598732\";s:8:\"filesize\";s:5:\"63114\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:20:\"pathauto 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/95354\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/pathauto-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708031\";s:6:\"mdhash\";s:32:\"60f99056d68e951cd3455403fb6c33c1\";s:8:\"filesize\";s:6:\"142048\";}}s:4:\"also\";a:1:{i:2;s:11:\"6.x-2.x-dev\";}s:14:\"latest_version\";s:7:\"6.x-1.3\";s:11:\"recommended\";s:7:\"6.x-1.3\";s:6:\"status\";i:4;}s:5:\"rules\";a:23:{s:4:\"name\";s:5:\"rules\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Rules\";s:7:\"package\";s:5:\"Rules\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:5:\"rules\";s:9:\"datestamp\";s:10:\"1251458463\";s:16:\"_info_file_ctime\";i:1280943133;}s:9:\"datestamp\";s:10:\"1251458463\";s:8:\"includes\";a:4:{s:5:\"rules\";s:5:\"Rules\";s:11:\"rules_admin\";s:23:\"Rules Administration UI\";s:11:\"rules_forms\";s:19:\"Rules Forms support\";s:15:\"rules_scheduler\";s:15:\"Rules Scheduler\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.1\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:5:\"Rules\";s:10:\"short_name\";s:5:\"rules\";s:10:\"dc:creator\";s:4:\"fago\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:31:\"http://drupal.org/project/rules\";s:8:\"releases\";a:19:{s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:13:\"rules 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/753980\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/rules-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1269612911\";s:6:\"mdhash\";s:32:\"34227cfdf9213d0ac1c0b1649cd980ab\";s:8:\"filesize\";s:6:\"208913\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:13:\"rules 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/562108\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/rules-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1251458464\";s:6:\"mdhash\";s:32:\"8f83c170841851694acb1af5de997d7b\";s:8:\"filesize\";s:6:\"166265\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:13:\"rules 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/465836\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1242650813\";s:6:\"mdhash\";s:32:\"943345c90a3c7eff49f46c7750e3d562\";s:8:\"filesize\";s:6:\"146811\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc2\";a:13:{s:4:\"name\";s:17:\"rules 6.x-1.0-rc2\";s:7:\"version\";s:11:\"6.x-1.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/449640\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1241101332\";s:6:\"mdhash\";s:32:\"31a63253c533f2ab2148998c953a09ba\";s:8:\"filesize\";s:6:\"143768\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.0-rc1\";a:13:{s:4:\"name\";s:17:\"rules 6.x-1.0-rc1\";s:7:\"version\";s:11:\"6.x-1.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--1-0-RC1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/439102\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1240230556\";s:6:\"mdhash\";s:32:\"e63772f0d98db9f839cd150126c0bfea\";s:8:\"filesize\";s:6:\"130322\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta5\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta5\";s:7:\"version\";s:13:\"6.x-1.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/383944\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1235598068\";s:6:\"mdhash\";s:32:\"a1eba007e3cb75195aa8589c37ec4739\";s:8:\"filesize\";s:6:\"124218\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta4\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta4\";s:7:\"version\";s:13:\"6.x-1.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370130\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1233920142\";s:6:\"mdhash\";s:32:\"7a691487316109c85633556cb358438a\";s:8:\"filesize\";s:6:\"123209\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta3\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta3\";s:7:\"version\";s:13:\"6.x-1.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/314905\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1222706456\";s:6:\"mdhash\";s:32:\"68ef6eb274cd27b2c113d527d3e8cedc\";s:8:\"filesize\";s:5:\"84390\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta2\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta2\";s:7:\"version\";s:13:\"6.x-1.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/303578\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1220461524\";s:6:\"mdhash\";s:32:\"31d6bc69b5815be4e7b9b8a930eb0cb5\";s:8:\"filesize\";s:5:\"84209\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta1\";a:13:{s:4:\"name\";s:19:\"rules 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/300060\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1219747215\";s:6:\"mdhash\";s:32:\"612419679c1b2b4225c025c372e1cae4\";s:8:\"filesize\";s:5:\"76064\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha8\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha8\";s:7:\"version\";s:14:\"6.x-1.0-alpha8\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/298161\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha8.tar.gz\";s:4:\"date\";s:10:\"1219329315\";s:6:\"mdhash\";s:32:\"1f0ba2f290f134bb7ce393a0e907ef72\";s:8:\"filesize\";s:5:\"76141\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha7\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha7\";s:7:\"version\";s:14:\"6.x-1.0-alpha7\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/297201\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha7.tar.gz\";s:4:\"date\";s:10:\"1219159830\";s:6:\"mdhash\";s:32:\"cc0ce1603e873640785a19b47d6cbd76\";s:8:\"filesize\";s:5:\"73242\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha6\";a:12:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha6\";s:7:\"version\";s:14:\"6.x-1.0-alpha6\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/295256\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha6.tar.gz\";s:4:\"date\";s:10:\"1218713720\";s:6:\"mdhash\";s:32:\"a0b47d1f3622417a2ba44e760b351ce8\";s:8:\"filesize\";s:5:\"70995\";}s:14:\"6.x-1.0-alpha5\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha5\";s:7:\"version\";s:14:\"6.x-1.0-alpha5\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/294355\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1218555034\";s:6:\"mdhash\";s:32:\"0f5aa61494d81cef84e583640060bda7\";s:8:\"filesize\";s:5:\"63255\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-1.0-alpha4\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha4\";s:7:\"version\";s:14:\"6.x-1.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/290916\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1217854827\";s:6:\"mdhash\";s:32:\"9253303e9ff2696a24c0d2c133240366\";s:8:\"filesize\";s:5:\"56611\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:14:\"6.x-1.0-alpha3\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha3\";s:7:\"version\";s:14:\"6.x-1.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/289966\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1217592379\";s:6:\"mdhash\";s:32:\"6c41cd855069d476917701b6ea929cda\";s:8:\"filesize\";s:5:\"55100\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:14:\"6.x-1.0-alpha2\";a:12:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha2\";s:7:\"version\";s:14:\"6.x-1.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/286338\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1216830913\";s:6:\"mdhash\";s:32:\"e5dc9cec039ee903394f56120138f9fc\";s:8:\"filesize\";s:5:\"51848\";}s:14:\"6.x-1.0-alpha1\";a:13:{s:4:\"name\";s:20:\"rules 6.x-1.0-alpha1\";s:7:\"version\";s:14:\"6.x-1.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--1-0-ALPHA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/282792\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/rules-6.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1216110312\";s:6:\"mdhash\";s:32:\"8b2f1616704124c5a0032a63992b7f88\";s:8:\"filesize\";s:5:\"39621\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:17:\"rules 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/271195\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/rules-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708155\";s:6:\"mdhash\";s:32:\"f0873ed1a925d663a3c904103d042230\";s:8:\"filesize\";s:6:\"212068\";}}s:14:\"latest_version\";s:7:\"6.x-1.2\";s:11:\"recommended\";s:7:\"6.x-1.2\";s:6:\"status\";i:4;}s:12:\"semantic_cck\";a:23:{s:4:\"name\";s:12:\"semantic_cck\";s:4:\"info\";a:6:{s:4:\"name\";s:12:\"Semantic CCK\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:12:\"semantic_cck\";s:9:\"datestamp\";s:10:\"1276563009\";s:16:\"_info_file_ctime\";i:1280943136;}s:9:\"datestamp\";s:10:\"1276563009\";s:8:\"includes\";a:1:{s:12:\"semantic_cck\";s:12:\"Semantic CCK\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.1\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:12:\"Semantic CCK\";s:10:\"short_name\";s:12:\"semantic_cck\";s:10:\"dc:creator\";s:6:\"rhache\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:38:\"http://drupal.org/project/semantic_cck\";s:8:\"releases\";a:3:{s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:20:\"semantic_cck 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/827500\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/semantic_cck-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1276563009\";s:6:\"mdhash\";s:32:\"a68096d44626a95aaffd6313e987427e\";s:8:\"filesize\";s:5:\"11244\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:20:\"semantic_cck 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/827010\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/semantic_cck-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1276527308\";s:6:\"mdhash\";s:32:\"973e2be59d79c75f1b638970da82198e\";s:8:\"filesize\";s:5:\"11248\";}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:24:\"semantic_cck 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/829408\";s:13:\"download_link\";s:68:\"http://ftp.drupal.org/files/projects/semantic_cck-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279541839\";s:6:\"mdhash\";s:32:\"7eec37bbe04150fd1af2584dd84731bb\";s:8:\"filesize\";s:5:\"11303\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}}s:14:\"latest_version\";s:7:\"6.x-1.1\";s:11:\"recommended\";s:7:\"6.x-1.1\";s:6:\"status\";i:5;}s:13:\"semanticviews\";a:23:{s:4:\"name\";s:13:\"semanticviews\";s:4:\"info\";a:6:{s:4:\"name\";s:14:\"Semantic Views\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:13:\"semanticviews\";s:9:\"datestamp\";s:10:\"1271635508\";s:16:\"_info_file_ctime\";i:1280943136;}s:9:\"datestamp\";s:10:\"1271635508\";s:8:\"includes\";a:1:{s:13:\"semanticviews\";s:14:\"Semantic Views\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.1\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:14:\"Semantic Views\";s:10:\"short_name\";s:13:\"semanticviews\";s:10:\"dc:creator\";s:9:\"bangpound\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"http://drupal.org/project/semanticviews\";s:8:\"releases\";a:4:{s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:21:\"semanticviews 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/774916\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/semanticviews-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1271635509\";s:6:\"mdhash\";s:32:\"926a4ed32135b9ae7b2e927a538daa1b\";s:8:\"filesize\";s:6:\"226207\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:21:\"semanticviews 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/720070\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/semanticviews-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1266646506\";s:6:\"mdhash\";s:32:\"22e390bb5a863e097a4639732f451dc7\";s:8:\"filesize\";s:6:\"225166\";}s:13:\"6.x-1.0-beta1\";a:12:{s:4:\"name\";s:27:\"semanticviews 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/618466\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/semanticviews-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1256853959\";s:6:\"mdhash\";s:32:\"84b3972fcc36bfd8d501c2f48b46d1ee\";s:8:\"filesize\";s:6:\"224094\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:25:\"semanticviews 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/572328\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/semanticviews-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278835613\";s:6:\"mdhash\";s:32:\"0bcd48fc3f214439b617a6381dbfb65f\";s:8:\"filesize\";s:6:\"226206\";}}s:14:\"latest_version\";s:7:\"6.x-1.1\";s:11:\"recommended\";s:7:\"6.x-1.1\";s:6:\"status\";i:5;}s:13:\"service_links\";a:24:{s:4:\"name\";s:13:\"service_links\";s:4:\"info\";a:5:{s:4:\"name\";s:13:\"Service links\";s:7:\"version\";s:7:\"6.x-1.0\";s:7:\"project\";s:13:\"service_links\";s:9:\"datestamp\";s:10:\"1207327211\";s:16:\"_info_file_ctime\";i:1280996073;}s:9:\"datestamp\";s:10:\"1207327211\";s:8:\"includes\";a:1:{s:13:\"service_links\";s:13:\"Service links\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.0\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:13:\"Service links\";s:10:\"short_name\";s:13:\"service_links\";s:10:\"dc:creator\";s:7:\"TheCrow\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"http://drupal.org/project/service_links\";s:8:\"releases\";a:3:{s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:25:\"service_links 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/423572\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/service_links-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278835625\";s:6:\"mdhash\";s:32:\"5a89a368f30774401672dccd41df7e0b\";s:8:\"filesize\";s:5:\"97165\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:21:\"service_links 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/242700\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/service_links-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1207327212\";s:6:\"mdhash\";s:32:\"5313414dbb7429c17fdf6fa299b5e4a7\";s:8:\"filesize\";s:5:\"22428\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:25:\"service_links 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/234270\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/service_links-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278807395\";s:6:\"mdhash\";s:32:\"fdf9b7d83b6b5ab0ea8ffb95f2b955b1\";s:8:\"filesize\";s:5:\"31188\";}}s:4:\"also\";a:1:{i:2;s:11:\"6.x-2.x-dev\";}s:14:\"latest_version\";s:7:\"6.x-1.0\";s:11:\"recommended\";s:7:\"6.x-1.0\";s:6:\"status\";i:5;}s:5:\"token\";a:23:{s:4:\"name\";s:5:\"token\";s:4:\"info\";a:5:{s:4:\"name\";s:5:\"Token\";s:7:\"version\";s:8:\"6.x-1.12\";s:7:\"project\";s:5:\"token\";s:9:\"datestamp\";s:10:\"1243895498\";s:16:\"_info_file_ctime\";i:1280943145;}s:9:\"datestamp\";s:10:\"1243895498\";s:8:\"includes\";a:1:{s:5:\"token\";s:5:\"Token\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:8:\"6.x-1.12\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:5:\"Token\";s:10:\"short_name\";s:5:\"token\";s:10:\"dc:creator\";s:5:\"eaton\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:31:\"http://drupal.org/project/token\";s:8:\"releases\";a:5:{s:8:\"6.x-1.13\";a:12:{s:4:\"name\";s:14:\"token 6.x-1.13\";s:7:\"version\";s:8:\"6.x-1.13\";s:3:\"tag\";s:14:\"DRUPAL-6--1-13\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/820600\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/token-6.x-1.13.tar.gz\";s:4:\"date\";s:10:\"1275922818\";s:6:\"mdhash\";s:32:\"c640dd34d3d25c0f7079d959bea2a650\";s:8:\"filesize\";s:5:\"61986\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.12\";a:12:{s:4:\"name\";s:14:\"token 6.x-1.12\";s:7:\"version\";s:8:\"6.x-1.12\";s:3:\"tag\";s:14:\"DRUPAL-6--1-12\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/479142\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/token-6.x-1.12.tar.gz\";s:4:\"date\";s:10:\"1243895498\";s:6:\"mdhash\";s:32:\"413e7d796066118f9ba78aaaa2974d80\";s:8:\"filesize\";s:5:\"47427\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.11\";a:12:{s:4:\"name\";s:14:\"token 6.x-1.11\";s:7:\"version\";s:8:\"6.x-1.11\";s:3:\"tag\";s:14:\"DRUPAL-6--1-11\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/290380\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/token-6.x-1.11.tar.gz\";s:4:\"date\";s:10:\"1217698238\";s:6:\"mdhash\";s:32:\"9abb50dec933520496b549d6ef95c1d9\";s:8:\"filesize\";s:5:\"33151\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-1.10\";a:11:{s:4:\"name\";s:14:\"token 6.x-1.10\";s:7:\"version\";s:8:\"6.x-1.10\";s:3:\"tag\";s:14:\"DRUPAL-6--1-10\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/225619\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/token-6.x-1.10.tar.gz\";s:4:\"date\";s:10:\"1203741911\";s:6:\"mdhash\";s:32:\"262848c39c75a7f832856ba6bc4713ea\";s:8:\"filesize\";s:5:\"17219\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:17:\"token 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/208375\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/token-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280103500\";s:6:\"mdhash\";s:32:\"ae0c57386c656f9ad10b0624766b5c99\";s:8:\"filesize\";s:5:\"68033\";}}s:14:\"latest_version\";s:8:\"6.x-1.13\";s:11:\"recommended\";s:8:\"6.x-1.13\";s:6:\"status\";i:4;}s:13:\"viewreference\";a:24:{s:4:\"name\";s:13:\"viewreference\";s:4:\"info\";a:6:{s:4:\"name\";s:14:\"View Reference\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:8:\"6.x-2.24\";s:7:\"project\";s:13:\"viewreference\";s:9:\"datestamp\";s:10:\"1263636305\";s:16:\"_info_file_ctime\";i:1280943148;}s:9:\"datestamp\";s:10:\"1263636305\";s:8:\"includes\";a:1:{s:13:\"viewreference\";s:14:\"View Reference\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:8:\"6.x-2.24\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:14:\"View Reference\";s:10:\"short_name\";s:13:\"viewreference\";s:10:\"dc:creator\";s:7:\"danielb\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"http://drupal.org/project/viewreference\";s:8:\"releases\";a:30:{s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:27:\"viewreference 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/793430\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/viewreference-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1273320912\";s:6:\"mdhash\";s:32:\"e07a6259efa2b28f96018cc6f3793437\";s:8:\"filesize\";s:5:\"12510\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:25:\"viewreference 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/793406\";s:13:\"download_link\";s:69:\"http://ftp.drupal.org/files/projects/viewreference-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836264\";s:6:\"mdhash\";s:32:\"b1d38316bf832fc508a50eaf4074ebe9\";s:8:\"filesize\";s:5:\"12520\";}s:8:\"6.x-2.24\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.24\";s:7:\"version\";s:8:\"6.x-2.24\";s:3:\"tag\";s:14:\"DRUPAL-6--2-24\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"24\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/686526\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.24.tar.gz\";s:4:\"date\";s:10:\"1263636305\";s:6:\"mdhash\";s:32:\"8433e82d6320cd9d140cade05fe719d3\";s:8:\"filesize\";s:5:\"12687\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.23\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.23\";s:7:\"version\";s:8:\"6.x-2.23\";s:3:\"tag\";s:14:\"DRUPAL-6--2-23\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"23\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/582604\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.23.tar.gz\";s:4:\"date\";s:10:\"1253441788\";s:6:\"mdhash\";s:32:\"988cac43cec98a5ad45ccc4a71b2cc16\";s:8:\"filesize\";s:5:\"12636\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:8:\"6.x-2.22\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.22\";s:7:\"version\";s:8:\"6.x-2.22\";s:3:\"tag\";s:14:\"DRUPAL-6--2-22\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"22\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/571272\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.22.tar.gz\";s:4:\"date\";s:10:\"1252400493\";s:6:\"mdhash\";s:32:\"74368d691ab5b1bcad7ba94863e4c952\";s:8:\"filesize\";s:5:\"12569\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.21\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.21\";s:7:\"version\";s:8:\"6.x-2.21\";s:3:\"tag\";s:14:\"DRUPAL-6--2-21\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"21\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/511060\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.21.tar.gz\";s:4:\"date\";s:10:\"1246847508\";s:6:\"mdhash\";s:32:\"f9c04100ec4d84485e15588832477bfe\";s:8:\"filesize\";s:5:\"12558\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.20\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.20\";s:7:\"version\";s:8:\"6.x-2.20\";s:3:\"tag\";s:14:\"DRUPAL-6--2-20\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"20\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/511050\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.20.tar.gz\";s:4:\"date\";s:10:\"1246846949\";s:6:\"mdhash\";s:32:\"fdd59708369b49cd6b0ad014ebc3fe62\";s:8:\"filesize\";s:5:\"12579\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.19\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.19\";s:7:\"version\";s:8:\"6.x-2.19\";s:3:\"tag\";s:14:\"DRUPAL-6--2-19\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"19\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/511018\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.19.tar.gz\";s:4:\"date\";s:10:\"1246841759\";s:6:\"mdhash\";s:32:\"03f225817bdbed49f771935e0867499d\";s:8:\"filesize\";s:5:\"12562\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.18\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.18\";s:7:\"version\";s:8:\"6.x-2.18\";s:3:\"tag\";s:14:\"DRUPAL-6--2-18\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/505828\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.18.tar.gz\";s:4:\"date\";s:10:\"1246325158\";s:6:\"mdhash\";s:32:\"9ef6ece555e580a90dcf9988b04925fe\";s:8:\"filesize\";s:5:\"12494\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.17\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.17\";s:7:\"version\";s:8:\"6.x-2.17\";s:3:\"tag\";s:14:\"DRUPAL-6--2-17\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/497676\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.17.tar.gz\";s:4:\"date\";s:10:\"1245565252\";s:6:\"mdhash\";s:32:\"e55862cc785541305fd239c00ca60810\";s:8:\"filesize\";s:5:\"12431\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.16\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.16\";s:7:\"version\";s:8:\"6.x-2.16\";s:3:\"tag\";s:14:\"DRUPAL-6--2-16\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/496870\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.16.tar.gz\";s:4:\"date\";s:10:\"1245453970\";s:6:\"mdhash\";s:32:\"c5cfbb405c535920e0459600b75cbc28\";s:8:\"filesize\";s:5:\"12428\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.15\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.15\";s:7:\"version\";s:8:\"6.x-2.15\";s:3:\"tag\";s:14:\"DRUPAL-6--2-15\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/494838\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.15.tar.gz\";s:4:\"date\";s:10:\"1245290486\";s:6:\"mdhash\";s:32:\"799b3a401186447b19bf240dc2c8f923\";s:8:\"filesize\";s:5:\"12483\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:8:\"6.x-2.14\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.14\";s:7:\"version\";s:8:\"6.x-2.14\";s:3:\"tag\";s:14:\"DRUPAL-6--2-14\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/457978\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.14.tar.gz\";s:4:\"date\";s:10:\"1241835358\";s:6:\"mdhash\";s:32:\"587a2759d0606be79a3d40ec420496fd\";s:8:\"filesize\";s:5:\"12243\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.13\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.13\";s:7:\"version\";s:8:\"6.x-2.13\";s:3:\"tag\";s:14:\"DRUPAL-6--2-13\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/386680\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.13.tar.gz\";s:4:\"date\";s:10:\"1235826657\";s:6:\"mdhash\";s:32:\"56d81a854f6b3df4f3f13079934dafed\";s:8:\"filesize\";s:5:\"12234\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.12\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.12\";s:7:\"version\";s:8:\"6.x-2.12\";s:3:\"tag\";s:14:\"DRUPAL-6--2-12\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/386676\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.12.tar.gz\";s:4:\"date\";s:10:\"1235826352\";s:6:\"mdhash\";s:32:\"22d6fe445e4d68b894e3e3a751334e6f\";s:8:\"filesize\";s:5:\"12222\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.11\";a:12:{s:4:\"name\";s:22:\"viewreference 6.x-2.11\";s:7:\"version\";s:8:\"6.x-2.11\";s:3:\"tag\";s:14:\"DRUPAL-6--2-11\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/339616\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.11.tar.gz\";s:4:\"date\";s:10:\"1227744354\";s:6:\"mdhash\";s:32:\"b5771241b07d87f7a53fa1b2c403be31\";s:8:\"filesize\";s:5:\"12120\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:8:\"6.x-2.10\";a:11:{s:4:\"name\";s:22:\"viewreference 6.x-2.10\";s:7:\"version\";s:8:\"6.x-2.10\";s:3:\"tag\";s:14:\"DRUPAL-6--2-10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/339282\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.10.tar.gz\";s:4:\"date\";s:10:\"1227682230\";s:6:\"mdhash\";s:32:\"2fccbdbac4162d6af99d9dbc0d2f4a17\";s:8:\"filesize\";s:5:\"12113\";}s:7:\"6.x-2.9\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.9\";s:7:\"version\";s:7:\"6.x-2.9\";s:3:\"tag\";s:13:\"DRUPAL-6--2-9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/339217\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1227664532\";s:6:\"mdhash\";s:32:\"2ae69c74294061b7923404465d3f806d\";s:8:\"filesize\";s:5:\"12161\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.8\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.8\";s:7:\"version\";s:7:\"6.x-2.8\";s:3:\"tag\";s:13:\"DRUPAL-6--2-8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/324481\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1224643222\";s:6:\"mdhash\";s:32:\"445ca2b9009f8a325bba01202f5c8c43\";s:8:\"filesize\";s:5:\"12152\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/323619\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1224500432\";s:6:\"mdhash\";s:32:\"a9d0a972c048d3d582be59513ccc99a7\";s:8:\"filesize\";s:5:\"12178\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/322977\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1224326420\";s:6:\"mdhash\";s:32:\"8c8c7bd8709ca583c16d85542bae7a53\";s:8:\"filesize\";s:5:\"12157\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/319854\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1223695236\";s:6:\"mdhash\";s:32:\"4e8c60a656590c1c7914e0e08417370a\";s:8:\"filesize\";s:5:\"12135\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/303257\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1220396434\";s:6:\"mdhash\";s:32:\"9843dd99523a78c6ce078af61876b27f\";s:8:\"filesize\";s:5:\"12121\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/302987\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1220349327\";s:6:\"mdhash\";s:32:\"b6c5e65cfe1b1b3c2004c2a6197dfb68\";s:8:\"filesize\";s:5:\"12124\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/302978\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1220347231\";s:6:\"mdhash\";s:32:\"0360b74cca544119e609343c2a14accd\";s:8:\"filesize\";s:5:\"12128\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/302969\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1220345725\";s:6:\"mdhash\";s:32:\"95a3676faa0eead6d8b87f336dbf6104\";s:8:\"filesize\";s:5:\"12143\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/301806\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1220072716\";s:6:\"mdhash\";s:32:\"cdf9a55977a6f0df345a499f54b55a6e\";s:8:\"filesize\";s:5:\"12133\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-1.2\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/298921\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1219465521\";s:6:\"mdhash\";s:32:\"294461e614244099546287c163f49fa9\";s:8:\"filesize\";s:5:\"11287\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:12:{s:4:\"name\";s:21:\"viewreference 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277922\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1215038744\";s:6:\"mdhash\";s:32:\"4ca4826f1ea042452a48eb77836d3162\";s:8:\"filesize\";s:5:\"11319\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:21:\"viewreference 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277491\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/viewreference-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1214958630\";s:6:\"mdhash\";s:32:\"c9fdc434d7afb168cc360ebad37b1b1c\";s:8:\"filesize\";s:5:\"11301\";}}s:4:\"also\";a:1:{i:3;s:13:\"6.x-3.0-beta1\";}s:14:\"latest_version\";s:8:\"6.x-2.24\";s:11:\"recommended\";s:8:\"6.x-2.24\";s:6:\"status\";i:5;}s:5:\"views\";a:25:{s:4:\"name\";s:5:\"views\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Views\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:8:\"6.x-2.10\";s:7:\"project\";s:5:\"views\";s:9:\"datestamp\";s:10:\"1270766108\";s:16:\"_info_file_ctime\";i:1280943167;}s:9:\"datestamp\";s:10:\"1270766108\";s:8:\"includes\";a:2:{s:5:\"views\";s:5:\"Views\";s:8:\"views_ui\";s:8:\"Views UI\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:8:\"6.x-2.10\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:16:\"security updates\";a:1:{i:0;a:12:{s:4:\"name\";s:14:\"views 6.x-2.11\";s:7:\"version\";s:8:\"6.x-2.11\";s:3:\"tag\";s:14:\"DRUPAL-6--2-11\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/829846\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/views-6.x-2.11.tar.gz\";s:4:\"date\";s:10:\"1276743616\";s:6:\"mdhash\";s:32:\"ea5ef15e0d03c03627f7c5ea2350d78d\";s:8:\"filesize\";s:7:\"1662750\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}}s:5:\"title\";s:5:\"Views\";s:10:\"short_name\";s:5:\"views\";s:10:\"dc:creator\";s:13:\"merlinofchaos\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:31:\"http://drupal.org/project/views\";s:8:\"releases\";a:31:{s:14:\"6.x-3.0-alpha3\";a:13:{s:4:\"name\";s:20:\"views 6.x-3.0-alpha3\";s:7:\"version\";s:14:\"6.x-3.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/765092\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1270684212\";s:6:\"mdhash\";s:32:\"fe7b96742eb7d8f62f011f9106896256\";s:8:\"filesize\";s:7:\"1639781\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:14:\"6.x-3.0-alpha2\";a:13:{s:4:\"name\";s:20:\"views 6.x-3.0-alpha2\";s:7:\"version\";s:14:\"6.x-3.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/695302\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1264463413\";s:6:\"mdhash\";s:32:\"6549c80d447a4fa7f8071dfe69fed6fd\";s:8:\"filesize\";s:7:\"1584488\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:14:\"6.x-3.0-alpha1\";a:13:{s:4:\"name\";s:20:\"views 6.x-3.0-alpha1\";s:7:\"version\";s:14:\"6.x-3.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--3-0-ALPHA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/629202\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1257895600\";s:6:\"mdhash\";s:32:\"0cb60791933141335a7f5032de687004\";s:8:\"filesize\";s:7:\"1552538\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:17:\"views 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/467670\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708445\";s:6:\"mdhash\";s:32:\"91eebe3d4a20e983fb64942062ccfd9d\";s:8:\"filesize\";s:7:\"1645005\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:8:\"6.x-2.11\";a:12:{s:4:\"name\";s:14:\"views 6.x-2.11\";s:7:\"version\";s:8:\"6.x-2.11\";s:3:\"tag\";s:14:\"DRUPAL-6--2-11\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/829846\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/views-6.x-2.11.tar.gz\";s:4:\"date\";s:10:\"1276743616\";s:6:\"mdhash\";s:32:\"ea5ef15e0d03c03627f7c5ea2350d78d\";s:8:\"filesize\";s:7:\"1662750\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:8:\"6.x-2.10\";a:12:{s:4:\"name\";s:14:\"views 6.x-2.10\";s:7:\"version\";s:8:\"6.x-2.10\";s:3:\"tag\";s:14:\"DRUPAL-6--2-10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/766164\";s:13:\"download_link\";s:58:\"http://ftp.drupal.org/files/projects/views-6.x-2.10.tar.gz\";s:4:\"date\";s:10:\"1270766109\";s:6:\"mdhash\";s:32:\"a5868e2316ed2b920d621602b0ee78b3\";s:8:\"filesize\";s:7:\"1655007\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.9\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.9\";s:7:\"version\";s:7:\"6.x-2.9\";s:3:\"tag\";s:13:\"DRUPAL-6--2-9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/765088\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1270683914\";s:6:\"mdhash\";s:32:\"81534c4df203820488063ddba3892886\";s:8:\"filesize\";s:7:\"1654130\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-2.8\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.8\";s:7:\"version\";s:7:\"6.x-2.8\";s:3:\"tag\";s:13:\"DRUPAL-6--2-8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/649642\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1259799378\";s:6:\"mdhash\";s:32:\"70c2e02d6f7288e3979108ab96966ef6\";s:8:\"filesize\";s:7:\"1553915\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/621428\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1257197511\";s:6:\"mdhash\";s:32:\"993a4ce82f5eb6f3f2166de7aa5edbce\";s:8:\"filesize\";s:7:\"1551476\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/488082\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1244671916\";s:6:\"mdhash\";s:32:\"a39827a5430373ab8508f2773b0bc6ea\";s:8:\"filesize\";s:7:\"1534198\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/431016\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1239478365\";s:6:\"mdhash\";s:32:\"2098b66ccb996c38463bc1f276e2c5e4\";s:8:\"filesize\";s:7:\"1421005\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/426916\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1239147355\";s:6:\"mdhash\";s:32:\"7da75bea2204e45cc1c31379ed8c10ac\";s:8:\"filesize\";s:7:\"1419570\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/370526\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1233981351\";s:6:\"mdhash\";s:32:\"582bde5b7a68357c026a2bee689fe3cb\";s:8:\"filesize\";s:7:\"1365883\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/347831\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1229455243\";s:6:\"mdhash\";s:32:\"71a5f10609c8cce32bae5a09a2913ba5\";s:8:\"filesize\";s:7:\"1315921\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/323897\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1224538829\";s:6:\"mdhash\";s:32:\"46b80d1acfdd785720de91330c770980\";s:8:\"filesize\";s:7:\"1304664\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:13:\"views 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/322829\";s:13:\"download_link\";s:57:\"http://ftp.drupal.org/files/projects/views-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1224280828\";s:6:\"mdhash\";s:32:\"879ac52df90bf18d1c9d3d454febf609\";s:8:\"filesize\";s:7:\"1304512\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc5\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc5\";s:7:\"version\";s:11:\"6.x-2.0-rc5\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/318786\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc5.tar.gz\";s:4:\"date\";s:10:\"1223507724\";s:6:\"mdhash\";s:32:\"f425efe6979c32e7de3cfdc5c6f01a28\";s:8:\"filesize\";s:7:\"1303138\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc4\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc4\";s:7:\"version\";s:11:\"6.x-2.0-rc4\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/315506\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1222819523\";s:6:\"mdhash\";s:32:\"11e1fae3b6ec5b05abdf7bd3f4148628\";s:8:\"filesize\";s:7:\"1301241\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc3\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc3\";s:7:\"version\";s:11:\"6.x-2.0-rc3\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/309397\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1221602125\";s:6:\"mdhash\";s:32:\"f80c1846f8b53961b940c75cb2e19cdc\";s:8:\"filesize\";s:7:\"1292652\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc2\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc2\";s:7:\"version\";s:11:\"6.x-2.0-rc2\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/307230\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1221173427\";s:6:\"mdhash\";s:32:\"e6abdee467e234d63fcb815c3156ee4c\";s:8:\"filesize\";s:7:\"1324961\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:11:\"6.x-2.0-rc1\";a:13:{s:4:\"name\";s:17:\"views 6.x-2.0-rc1\";s:7:\"version\";s:11:\"6.x-2.0-rc1\";s:3:\"tag\";s:17:\"DRUPAL-6--2-0-RC1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277862\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1215030345\";s:6:\"mdhash\";s:32:\"7968787a990c56061aa99ec08231f543\";s:8:\"filesize\";s:7:\"2796661\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:19:\"views 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/270323\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1213384535\";s:6:\"mdhash\";s:32:\"7c69feceffdef7e12ca42a479335f2bc\";s:8:\"filesize\";s:7:\"2762695\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:19:\"views 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/260452\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1211247918\";s:6:\"mdhash\";s:32:\"cb558adc81c9e823c10bd19f7f32680d\";s:8:\"filesize\";s:6:\"246695\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:19:\"views 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/251422\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1209167713\";s:6:\"mdhash\";s:32:\"f11cc711db983d6b8be55df473f3e440\";s:8:\"filesize\";s:6:\"226958\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:19:\"views 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/250924\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1209076839\";s:6:\"mdhash\";s:32:\"abf2a3fc0ec77ed4ca641bfbcd0a577a\";s:8:\"filesize\";s:6:\"216246\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha5\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha5\";s:7:\"version\";s:14:\"6.x-2.0-alpha5\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/245993\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1208050514\";s:6:\"mdhash\";s:32:\"4a0ab2a45188bb205a69d7319bfa0103\";s:8:\"filesize\";s:6:\"293424\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha4\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha4\";s:7:\"version\";s:14:\"6.x-2.0-alpha4\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/239997\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1206753612\";s:6:\"mdhash\";s:32:\"3b60a384ff4bf4559e15530e4b68728d\";s:8:\"filesize\";s:6:\"259834\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha3\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha3\";s:7:\"version\";s:14:\"6.x-2.0-alpha3\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/234752\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1205632511\";s:6:\"mdhash\";s:32:\"378cf25063ed356d973612ffb16c06ba\";s:8:\"filesize\";s:6:\"233853\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha2\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha2\";s:7:\"version\";s:14:\"6.x-2.0-alpha2\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/223163\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1203316508\";s:6:\"mdhash\";s:32:\"168b56a4ae8de81460ff5b9cc48a2233\";s:8:\"filesize\";s:6:\"196366\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha1\";a:13:{s:4:\"name\";s:20:\"views 6.x-2.0-alpha1\";s:7:\"version\";s:14:\"6.x-2.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/222747\";s:13:\"download_link\";s:64:\"http://ftp.drupal.org/files/projects/views-6.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1203222009\";s:6:\"mdhash\";s:32:\"f836b5c79c2ad78cac252135febffdab\";s:8:\"filesize\";s:6:\"195064\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:17:\"Views 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:28:\"http://drupal.org/node/95897\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/views-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708447\";s:6:\"mdhash\";s:32:\"3c97b73162b31fb54fcd1097d5c12e48\";s:8:\"filesize\";s:7:\"1664861\";}}s:4:\"also\";a:1:{i:3;s:14:\"6.x-3.0-alpha3\";}s:14:\"latest_version\";s:8:\"6.x-2.11\";s:11:\"recommended\";s:8:\"6.x-2.11\";s:6:\"status\";i:1;}s:21:\"views_bulk_operations\";a:24:{s:4:\"name\";s:21:\"views_bulk_operations\";s:4:\"info\";a:6:{s:4:\"name\";s:21:\"Views Bulk Operations\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"6.x-1.7\";s:7:\"project\";s:21:\"views_bulk_operations\";s:9:\"datestamp\";s:10:\"1242845770\";s:16:\"_info_file_ctime\";i:1280943167;}s:9:\"datestamp\";s:10:\"1242845770\";s:8:\"includes\";a:1:{s:21:\"views_bulk_operations\";s:21:\"Views Bulk Operations\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.7\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:27:\"Views Bulk Operations (VBO)\";s:10:\"short_name\";s:21:\"views_bulk_operations\";s:10:\"dc:creator\";s:10:\"infojunkie\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:3:\"1,3\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:47:\"http://drupal.org/project/views_bulk_operations\";s:8:\"releases\";a:12:{s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:33:\"views_bulk_operations 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/705744\";s:13:\"download_link\";s:77:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836278\";s:6:\"mdhash\";s:32:\"2d8ff50f8ae1f88ea596e72fbddea2a3\";s:8:\"filesize\";s:5:\"44567\";}s:7:\"6.x-1.9\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.9\";s:7:\"version\";s:7:\"6.x-1.9\";s:3:\"tag\";s:13:\"DRUPAL-6--1-9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/704134\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1265245814\";s:6:\"mdhash\";s:32:\"4f5e1a46648d22241a16eeeda5c1d8ae\";s:8:\"filesize\";s:5:\"41384\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.8\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.8\";s:7:\"version\";s:7:\"6.x-1.8\";s:3:\"tag\";s:13:\"DRUPAL-6--1-8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/573318\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1252556168\";s:6:\"mdhash\";s:32:\"f63816b17ea62832c9c36fa6176138d8\";s:8:\"filesize\";s:5:\"35423\";}s:7:\"6.x-1.7\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.7\";s:7:\"version\";s:7:\"6.x-1.7\";s:3:\"tag\";s:13:\"DRUPAL-6--1-7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/468366\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1242845770\";s:6:\"mdhash\";s:32:\"7f416fe95d84c693d0bd8bab4d1138f8\";s:8:\"filesize\";s:5:\"29357\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:7:\"6.x-1.6\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.6\";s:7:\"version\";s:7:\"6.x-1.6\";s:3:\"tag\";s:13:\"DRUPAL-6--1-6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/456994\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1241746598\";s:6:\"mdhash\";s:32:\"56676bfc273d20ffd6d9b93b5901a414\";s:8:\"filesize\";s:5:\"28317\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.5\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.5\";s:7:\"version\";s:7:\"6.x-1.5\";s:3:\"tag\";s:13:\"DRUPAL-6--1-5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/385040\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1235685696\";s:6:\"mdhash\";s:32:\"823836a57b015cbdaf308d212e3609b0\";s:8:\"filesize\";s:5:\"19583\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.4\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.4\";s:7:\"version\";s:7:\"6.x-1.4\";s:3:\"tag\";s:13:\"DRUPAL-6--1-4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/369243\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1233774350\";s:6:\"mdhash\";s:32:\"dcab763ae8e027e4297435fbcc1bb97f\";s:8:\"filesize\";s:5:\"17772\";}s:7:\"6.x-1.3\";a:12:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.3\";s:7:\"version\";s:7:\"6.x-1.3\";s:3:\"tag\";s:13:\"DRUPAL-6--1-3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/353139\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1230812434\";s:6:\"mdhash\";s:32:\"47a327267976a872ec61441d1c424a20\";s:8:\"filesize\";s:5:\"17416\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.2\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/319383\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1223611236\";s:6:\"mdhash\";s:32:\"c73b2af02669b02cd5b0e59b51cec9a6\";s:8:\"filesize\";s:5:\"14784\";}s:7:\"6.x-1.1\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/316955\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1223088323\";s:6:\"mdhash\";s:32:\"e58bc2c0a9cac134c0d1acefd08892bd\";s:8:\"filesize\";s:5:\"14659\";}s:7:\"6.x-1.0\";a:11:{s:4:\"name\";s:29:\"views_bulk_operations 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/305205\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1220814320\";s:6:\"mdhash\";s:32:\"e743364599f81ce7776964e1fe17e65b\";s:8:\"filesize\";s:5:\"13399\";}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:33:\"views_bulk_operations 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/286876\";s:13:\"download_link\";s:77:\"http://ftp.drupal.org/files/projects/views_bulk_operations-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279412331\";s:6:\"mdhash\";s:32:\"68099dbd611feeb0401dd56ab5ea75b4\";s:8:\"filesize\";s:5:\"51825\";}}s:4:\"also\";a:1:{i:3;s:11:\"6.x-3.x-dev\";}s:14:\"latest_version\";s:7:\"6.x-1.9\";s:11:\"recommended\";s:7:\"6.x-1.9\";s:6:\"status\";i:4;}s:22:\"views_exclude_previous\";a:23:{s:4:\"name\";s:22:\"views_exclude_previous\";s:4:\"info\";a:6:{s:4:\"name\";s:22:\"Views Exclude Previous\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"6.x-1.0\";s:7:\"project\";s:22:\"views_exclude_previous\";s:9:\"datestamp\";s:10:\"1233753530\";s:16:\"_info_file_ctime\";i:1280943168;}s:9:\"datestamp\";s:10:\"1233753530\";s:8:\"includes\";a:1:{s:22:\"views_exclude_previous\";s:22:\"Views Exclude Previous\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-1.0\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:22:\"Views exclude previous\";s:10:\"short_name\";s:22:\"views_exclude_previous\";s:10:\"dc:creator\";s:13:\"Anselm Heaton\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:48:\"http://drupal.org/project/views_exclude_previous\";s:8:\"releases\";a:2:{s:7:\"6.x-1.0\";a:12:{s:4:\"name\";s:30:\"views_exclude_previous 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/369047\";s:13:\"download_link\";s:74:\"http://ftp.drupal.org/files/projects/views_exclude_previous-6.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1233753530\";s:6:\"mdhash\";s:32:\"36ed2c09317e75224d79b5f261c60538\";s:8:\"filesize\";s:4:\"7639\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-1.x-dev\";a:11:{s:4:\"name\";s:34:\"views_exclude_previous 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/306874\";s:13:\"download_link\";s:78:\"http://ftp.drupal.org/files/projects/views_exclude_previous-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836284\";s:6:\"mdhash\";s:32:\"38864b4534fb13d5b1df7b52d56d3719\";s:8:\"filesize\";s:4:\"7642\";}}s:14:\"latest_version\";s:7:\"6.x-1.0\";s:11:\"recommended\";s:7:\"6.x-1.0\";s:6:\"status\";i:5;}s:15:\"views_php_array\";a:25:{s:4:\"name\";s:15:\"views_php_array\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Views PHP Array\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:13:\"6.x-1.0.x-dev\";s:7:\"project\";s:15:\"views_php_array\";s:9:\"datestamp\";s:10:\"1277814299\";s:16:\"_info_file_ctime\";i:1280943168;}s:9:\"datestamp\";s:10:\"1277814299\";s:8:\"includes\";a:1:{s:15:\"views_php_array\";s:15:\"Views PHP Array\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:13:\"6.x-1.0.x-dev\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:3:\"dev\";s:5:\"title\";s:15:\"Views PHP Array\";s:10:\"short_name\";s:15:\"views_php_array\";s:10:\"dc:creator\";s:8:\"adityakg\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:41:\"http://drupal.org/project/views_php_array\";s:8:\"releases\";a:1:{s:13:\"6.x-1.0.x-dev\";a:11:{s:4:\"name\";s:29:\"views_php_array 6.x-1.0.x-dev\";s:7:\"version\";s:13:\"6.x-1.0.x-dev\";s:3:\"tag\";s:4:\"HEAD\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/813138\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_php_array-6.x-1.0.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708461\";s:6:\"mdhash\";s:32:\"f9769548fbbbc1569bdc196e76d1f8fa\";s:8:\"filesize\";s:5:\"11039\";}}s:14:\"latest_version\";s:13:\"6.x-1.0.x-dev\";s:11:\"dev_version\";s:13:\"6.x-1.0.x-dev\";s:11:\"recommended\";s:13:\"6.x-1.0.x-dev\";s:10:\"latest_dev\";s:13:\"6.x-1.0.x-dev\";s:6:\"status\";i:4;}s:15:\"views_slideshow\";a:24:{s:4:\"name\";s:15:\"views_slideshow\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Views Slideshow\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"6.x-2.3\";s:7:\"project\";s:15:\"views_slideshow\";s:9:\"datestamp\";s:10:\"1279683019\";s:16:\"_info_file_ctime\";i:1280943171;}s:9:\"datestamp\";s:10:\"1279683019\";s:8:\"includes\";a:2:{s:15:\"views_slideshow\";s:15:\"Views Slideshow\";s:27:\"views_slideshow_singleframe\";s:28:\"Views Slideshow: SingleFrame\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-2.3\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:15:\"Views Slideshow\";s:10:\"short_name\";s:15:\"views_slideshow\";s:10:\"dc:creator\";s:5:\"aaron\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:41:\"http://drupal.org/project/views_slideshow\";s:8:\"releases\";a:14:{s:11:\"6.x-3.x-dev\";a:12:{s:4:\"name\";s:27:\"views_slideshow 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/776914\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708463\";s:6:\"mdhash\";s:32:\"0c676780f3a7c6ba83a196ab30ea51b2\";s:8:\"filesize\";s:6:\"284906\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:23:\"views_slideshow 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/860042\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1279683019\";s:6:\"mdhash\";s:32:\"e5def512a5dd0039a2e748559d0930b9\";s:8:\"filesize\";s:6:\"274658\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:23:\"views_slideshow 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/833078\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1277071511\";s:6:\"mdhash\";s:32:\"9eef38cdf7ee0ae18558de72641dbe7d\";s:8:\"filesize\";s:6:\"271304\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:23:\"views_slideshow 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/804646\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1274374814\";s:6:\"mdhash\";s:32:\"3b42e4dccb80d49b32f884f3afb1b3e2\";s:8:\"filesize\";s:6:\"270802\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:23:\"views_slideshow 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/776658\";s:13:\"download_link\";s:67:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1271785815\";s:6:\"mdhash\";s:32:\"95a50d0896d322d86738cd6a8a602a21\";s:8:\"filesize\";s:6:\"269245\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta5\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta5\";s:7:\"version\";s:13:\"6.x-2.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/773756\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1271479812\";s:6:\"mdhash\";s:32:\"111c49b5abaee79e7b22e6299269e239\";s:8:\"filesize\";s:6:\"269140\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/769738\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1271144712\";s:6:\"mdhash\";s:32:\"c48b0aec9d47c2c1826a9e9d8d72cd35\";s:8:\"filesize\";s:6:\"268126\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/769710\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1271141413\";s:6:\"mdhash\";s:32:\"397cb287c36bc01e901352f0f5d416e9\";s:8:\"filesize\";s:6:\"268113\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/591500\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1254260517\";s:6:\"mdhash\";s:32:\"4b9e9a6365929ab4ac5e09633a8ccaaf\";s:8:\"filesize\";s:5:\"27661\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-BETA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/559240\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1251224822\";s:6:\"mdhash\";s:32:\"a0bcfa4073bbd5e885d3305b84d83b9f\";s:8:\"filesize\";s:5:\"23741\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:12:{s:4:\"name\";s:27:\"views_slideshow 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/558296\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1279715144\";s:6:\"mdhash\";s:32:\"c4021ac9b1f9095c88ff7882998da98b\";s:8:\"filesize\";s:6:\"274659\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta2\";a:13:{s:4:\"name\";s:29:\"views_slideshow 6.x-1.0-beta2\";s:7:\"version\";s:13:\"6.x-1.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/434966\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1239848004\";s:6:\"mdhash\";s:32:\"bc36a1d6e5df5988772ac2b1ab4c528a\";s:8:\"filesize\";s:5:\"19875\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-1.0-beta1\";a:12:{s:4:\"name\";s:29:\"views_slideshow 6.x-1.0-beta1\";s:7:\"version\";s:13:\"6.x-1.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--1-0-BETA1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/315433\";s:13:\"download_link\";s:73:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1222806026\";s:6:\"mdhash\";s:32:\"38700e2527956edf44fe84a57688f455\";s:8:\"filesize\";s:5:\"12485\";}s:11:\"6.x-1.x-dev\";a:12:{s:4:\"name\";s:27:\"views_slideshow 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/315432\";s:13:\"download_link\";s:71:\"http://ftp.drupal.org/files/projects/views_slideshow-6.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836301\";s:6:\"mdhash\";s:32:\"be91bdac33c61d8df0f11f0530c61eb6\";s:8:\"filesize\";s:5:\"23643\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}}s:4:\"also\";a:1:{i:3;s:11:\"6.x-3.x-dev\";}s:14:\"latest_version\";s:7:\"6.x-2.3\";s:11:\"recommended\";s:7:\"6.x-2.3\";s:6:\"status\";i:5;}s:7:\"webform\";a:24:{s:4:\"name\";s:7:\"webform\";s:4:\"info\";a:5:{s:4:\"name\";s:7:\"Webform\";s:7:\"version\";s:7:\"6.x-2.9\";s:7:\"project\";s:7:\"webform\";s:9:\"datestamp\";s:10:\"1257475622\";s:16:\"_info_file_ctime\";i:1280943174;}s:9:\"datestamp\";s:10:\"1257475622\";s:8:\"includes\";a:1:{s:7:\"webform\";s:7:\"Webform\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-2.9\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:7:\"Webform\";s:10:\"short_name\";s:7:\"webform\";s:10:\"dc:creator\";s:11:\"quicksketch\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:33:\"http://drupal.org/project/webform\";s:8:\"releases\";a:26:{s:13:\"6.x-3.0-beta6\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta6\";s:7:\"version\";s:13:\"6.x-3.0-beta6\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/833242\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta6.tar.gz\";s:4:\"date\";s:10:\"1277096710\";s:6:\"mdhash\";s:32:\"d16966c8a72a6e7c6b72d630970e884e\";s:8:\"filesize\";s:6:\"341700\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta5\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta5\";s:7:\"version\";s:13:\"6.x-3.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/770254\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1271177415\";s:6:\"mdhash\";s:32:\"fe68f0a7d5f9f1f67417769da96b163b\";s:8:\"filesize\";s:6:\"340456\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta4\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta4\";s:7:\"version\";s:13:\"6.x-3.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/760868\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1270268111\";s:6:\"mdhash\";s:32:\"02672a67c0c2eb7bc12df6e424f005a4\";s:8:\"filesize\";s:6:\"338625\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta3\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta3\";s:7:\"version\";s:13:\"6.x-3.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/760848\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1270265709\";s:6:\"mdhash\";s:32:\"68fb2e724fe453f6cab3defe5f1d70d1\";s:8:\"filesize\";s:6:\"338566\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta2\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta2\";s:7:\"version\";s:13:\"6.x-3.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/729372\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1267464309\";s:6:\"mdhash\";s:32:\"15002887b5eeafae70cd726adb589acc\";s:8:\"filesize\";s:6:\"335562\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-3.0-beta1\";a:13:{s:4:\"name\";s:21:\"webform 6.x-3.0-beta1\";s:7:\"version\";s:13:\"6.x-3.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--3-0-BETA1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/713184\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1266026709\";s:6:\"mdhash\";s:32:\"d69c6eee7d7dad6a5995d6d192fd8470\";s:8:\"filesize\";s:6:\"335389\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-3.x-dev\";a:11:{s:4:\"name\";s:19:\"webform 6.x-3.x-dev\";s:7:\"version\";s:11:\"6.x-3.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/730872\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/webform-6.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708483\";s:6:\"mdhash\";s:32:\"660f7c865d6a4af768187ea97ed3d112\";s:8:\"filesize\";s:6:\"341816\";}s:7:\"6.x-2.9\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.9\";s:7:\"version\";s:7:\"6.x-2.9\";s:3:\"tag\";s:13:\"DRUPAL-6--2-9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/624964\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1257475622\";s:6:\"mdhash\";s:32:\"11fc58301b7f1cc38989cc39a77b4722\";s:8:\"filesize\";s:6:\"291979\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.8\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.8\";s:7:\"version\";s:7:\"6.x-2.8\";s:3:\"tag\";s:13:\"DRUPAL-6--2-8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/604920\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1255570893\";s:6:\"mdhash\";s:32:\"c908306a1ef0ee6d9294f7877775b175\";s:8:\"filesize\";s:6:\"265930\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}}s:7:\"6.x-2.7\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.7\";s:7:\"version\";s:7:\"6.x-2.7\";s:3:\"tag\";s:13:\"DRUPAL-6--2-7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/481258\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1244059025\";s:6:\"mdhash\";s:32:\"7bd1634ec1e4ac2393cbda7fa2fc6eec\";s:8:\"filesize\";s:6:\"254954\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:15:\"Security update\";}}}s:7:\"6.x-2.6\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.6\";s:7:\"version\";s:7:\"6.x-2.6\";s:3:\"tag\";s:13:\"DRUPAL-6--2-6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/374985\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1234762850\";s:6:\"mdhash\";s:32:\"996946e00335273a6c28438ef5b98b5a\";s:8:\"filesize\";s:6:\"248747\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.5\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.5\";s:7:\"version\";s:7:\"6.x-2.5\";s:3:\"tag\";s:13:\"DRUPAL-6--2-5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/374541\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1234651250\";s:6:\"mdhash\";s:32:\"cda473f662876293d11abba386294f99\";s:8:\"filesize\";s:6:\"248750\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.4\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.4\";s:7:\"version\";s:7:\"6.x-2.4\";s:3:\"tag\";s:13:\"DRUPAL-6--2-4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/357445\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1231716643\";s:6:\"mdhash\";s:32:\"a1f5c75a3d943544b60f8ddc10d019f2\";s:8:\"filesize\";s:6:\"231162\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.3\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.3\";s:7:\"version\";s:7:\"6.x-2.3\";s:3:\"tag\";s:13:\"DRUPAL-6--2-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/324841\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1224704730\";s:6:\"mdhash\";s:32:\"20a979dfdbbb57b4855d335374c318a5\";s:8:\"filesize\";s:6:\"194566\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.2\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.2\";s:7:\"version\";s:7:\"6.x-2.2\";s:3:\"tag\";s:13:\"DRUPAL-6--2-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/317490\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1223275521\";s:6:\"mdhash\";s:32:\"59c3a17257f183d3e59a5cb4ea041db7\";s:8:\"filesize\";s:6:\"183501\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:9:\"6.x-2.1.3\";a:13:{s:4:\"name\";s:17:\"webform 6.x-2.1.3\";s:7:\"version\";s:9:\"6.x-2.1.3\";s:3:\"tag\";s:15:\"DRUPAL-6--2-1-3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/292747\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/webform-6.x-2.1.3.tar.gz\";s:4:\"date\";s:10:\"1218174017\";s:6:\"mdhash\";s:32:\"8d0dcc14f6d5943da93e7511785915b8\";s:8:\"filesize\";s:6:\"176024\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.x-2.1.2\";a:13:{s:4:\"name\";s:17:\"webform 6.x-2.1.2\";s:7:\"version\";s:9:\"6.x-2.1.2\";s:3:\"tag\";s:15:\"DRUPAL-6--2-1-2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/285341\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/webform-6.x-2.1.2.tar.gz\";s:4:\"date\";s:10:\"1216653317\";s:6:\"mdhash\";s:32:\"26b457f340264e997b1ea93c4beb3ac0\";s:8:\"filesize\";s:6:\"175644\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:9:\"6.x-2.1.1\";a:13:{s:4:\"name\";s:17:\"webform 6.x-2.1-1\";s:7:\"version\";s:9:\"6.x-2.1.1\";s:3:\"tag\";s:15:\"DRUPAL-6--2-1-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/277305\";s:13:\"download_link\";s:61:\"http://ftp.drupal.org/files/projects/webform-6.x-2.1.1.tar.gz\";s:4:\"date\";s:10:\"1214931323\";s:6:\"mdhash\";s:32:\"19ee46cd2d4ea3771220419ac5078a39\";s:8:\"filesize\";s:6:\"180831\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:15:\"webform 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/276518\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/webform-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1214786414\";s:6:\"mdhash\";s:32:\"112942c62278acfdf61829e3e5118869\";s:8:\"filesize\";s:6:\"180782\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta6\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta6\";s:7:\"version\";s:13:\"6.x-2.0-beta6\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/256459\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta6.tar.gz\";s:4:\"date\";s:10:\"1210307418\";s:6:\"mdhash\";s:32:\"1889dd81d6310a25b6323b65143b9e6b\";s:8:\"filesize\";s:6:\"155293\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta5\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta5\";s:7:\"version\";s:13:\"6.x-2.0-beta5\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/246706\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1208222114\";s:6:\"mdhash\";s:32:\"4a8693658f31c528f6ba679001ec5f93\";s:8:\"filesize\";s:6:\"155204\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta4\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta4\";s:7:\"version\";s:13:\"6.x-2.0-beta4\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/246041\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1208075712\";s:6:\"mdhash\";s:32:\"3e4229c3edcc3f5b72ee3649645ea034\";s:8:\"filesize\";s:6:\"155186\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta3\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta3\";s:7:\"version\";s:13:\"6.x-2.0-beta3\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/242055\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1207195820\";s:6:\"mdhash\";s:32:\"127ad8d7e9e5352e9c344b7f3196e3d5\";s:8:\"filesize\";s:6:\"155178\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:15:\"Security update\";}}}s:13:\"6.x-2.0-beta2\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta2\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/237420\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1206165914\";s:6:\"mdhash\";s:32:\"4bce334b79fd4c32627bb0efe6936072\";s:8:\"filesize\";s:6:\"144543\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:13:\"6.x-2.0-beta1\";a:13:{s:4:\"name\";s:21:\"webform 6.x-2.0-beta1\";s:7:\"version\";s:13:\"6.x-2.0-beta1\";s:3:\"tag\";s:19:\"DRUPAL-6--2-0-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/235014\";s:13:\"download_link\";s:65:\"http://ftp.drupal.org/files/projects/webform-6.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1205696119\";s:6:\"mdhash\";s:32:\"9dead3fa91ce0bfc4fd92f21229d3ec8\";s:8:\"filesize\";s:6:\"143962\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:19:\"webform 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/235004\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/webform-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1280708483\";s:6:\"mdhash\";s:32:\"eaca075829ce568a489249c7c21a7ec4\";s:8:\"filesize\";s:6:\"307502\";}}s:4:\"also\";a:1:{i:3;s:13:\"6.x-3.0-beta6\";}s:14:\"latest_version\";s:7:\"6.x-2.9\";s:11:\"recommended\";s:7:\"6.x-2.9\";s:6:\"status\";i:5;}s:7:\"wysiwyg\";a:23:{s:4:\"name\";s:7:\"wysiwyg\";s:4:\"info\";a:6:{s:4:\"name\";s:7:\"Wysiwyg\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"6.x-2.1\";s:7:\"project\";s:7:\"wysiwyg\";s:9:\"datestamp\";s:10:\"1268063714\";s:16:\"_info_file_ctime\";i:1280943177;}s:9:\"datestamp\";s:10:\"1268063714\";s:8:\"includes\";a:1:{s:7:\"wysiwyg\";s:7:\"Wysiwyg\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"6.x-2.1\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:7:\"Wysiwyg\";s:10:\"short_name\";s:7:\"wysiwyg\";s:10:\"dc:creator\";s:3:\"sun\";s:11:\"api_version\";s:3:\"6.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:33:\"http://drupal.org/project/wysiwyg\";s:8:\"releases\";a:11:{s:7:\"6.x-2.1\";a:12:{s:4:\"name\";s:15:\"wysiwyg 6.x-2.1\";s:7:\"version\";s:7:\"6.x-2.1\";s:3:\"tag\";s:13:\"DRUPAL-6--2-1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/736112\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/wysiwyg-6.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1268063714\";s:6:\"mdhash\";s:32:\"8a3ee47e20e9008c40ae96a6e4747a4f\";s:8:\"filesize\";s:6:\"108490\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-2.0\";a:12:{s:4:\"name\";s:15:\"wysiwyg 6.x-2.0\";s:7:\"version\";s:7:\"6.x-2.0\";s:3:\"tag\";s:13:\"DRUPAL-6--2-0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/487044\";s:13:\"download_link\";s:59:\"http://ftp.drupal.org/files/projects/wysiwyg-6.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1244598972\";s:6:\"mdhash\";s:32:\"0dcc5b435b6698e61a336d32f280ed95\";s:8:\"filesize\";s:5:\"89627\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:14:\"6.x-2.0-alpha1\";a:13:{s:4:\"name\";s:22:\"wysiwyg 6.x-2.0-alpha1\";s:7:\"version\";s:14:\"6.x-2.0-alpha1\";s:3:\"tag\";s:20:\"DRUPAL-6--2-0-ALPHA1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/464872\";s:13:\"download_link\";s:66:\"http://ftp.drupal.org/files/projects/wysiwyg-6.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1242523576\";s:6:\"mdhash\";s:32:\"a745141da5436606e8bdf848cfd6da20\";s:8:\"filesize\";s:5:\"80232\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}}s:11:\"6.x-2.x-dev\";a:11:{s:4:\"name\";s:19:\"wysiwyg 6.x-2.x-dev\";s:7:\"version\";s:11:\"6.x-2.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:29:\"http://drupal.org/node/365590\";s:13:\"download_link\";s:63:\"http://ftp.drupal.org/files/projects/wysiwyg-6.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1278836393\";s:6:\"mdhash\";s:32:\"629a59a77571b5c17beeaef323e34e2d\";s:8:\"filesize\";s:6:\"113097\";}s:7:\"6.x-1.2\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-1.2\";s:7:\"version\";s:7:\"6.x-1.2\";s:3:\"tag\";s:13:\"DRUPAL-6--1-2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1242522960\";s:6:\"mdhash\";s:32:\"4d4e038fb609ad57b7430a563f03fd09\";s:8:\"filesize\";s:5:\"65875\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.1\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-1.1\";s:7:\"version\";s:7:\"6.x-1.1\";s:3:\"tag\";s:13:\"DRUPAL-6--1-1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1236562853\";s:6:\"mdhash\";s:32:\"e0d84b73c7f903d9f50e96ff39e15c4a\";s:8:\"filesize\";s:5:\"65534\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}s:7:\"6.x-1.0\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-1.0\";s:7:\"version\";s:7:\"6.x-1.0\";s:3:\"tag\";s:13:\"DRUPAL-6--1-0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1234552285\";s:6:\"mdhash\";s:32:\"47f4db6f8b9f711835203a1a04c4c287\";s:8:\"filesize\";s:5:\"59227\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:11:\"6.x-1.x-dev\";a:9:{s:4:\"name\";s:19:\"wysiwyg 6.x-1.x-dev\";s:7:\"version\";s:11:\"6.x-1.x-dev\";s:3:\"tag\";s:11:\"DRUPAL-6--1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1244161854\";s:6:\"mdhash\";s:32:\"88d40ccdebd0bb3dd21f6890adf60bfd\";s:8:\"filesize\";s:5:\"71871\";}s:7:\"6.x-0.5\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-0.5\";s:7:\"version\";s:7:\"6.x-0.5\";s:3:\"tag\";s:13:\"DRUPAL-6--0-5\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1228142425\";s:6:\"mdhash\";s:32:\"dfc9b006642cda543fd17c841462cee2\";s:8:\"filesize\";s:5:\"54206\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-0.4\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-0.4\";s:7:\"version\";s:7:\"6.x-0.4\";s:3:\"tag\";s:13:\"DRUPAL-6--0-4\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1224021920\";s:6:\"mdhash\";s:32:\"db01863f705e57477d6508bd083c75f2\";s:8:\"filesize\";s:5:\"50865\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}}s:7:\"6.x-0.3\";a:10:{s:4:\"name\";s:15:\"wysiwyg 6.x-0.3\";s:7:\"version\";s:7:\"6.x-0.3\";s:3:\"tag\";s:13:\"DRUPAL-6--0-3\";s:13:\"version_major\";s:1:\"0\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:11:\"unpublished\";s:4:\"date\";s:10:\"1221251441\";s:6:\"mdhash\";s:32:\"3fd04f042435a957e4abed89ab71e4ea\";s:8:\"filesize\";s:5:\"45967\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}}}s:14:\"latest_version\";s:7:\"6.x-2.1\";s:11:\"recommended\";s:7:\"6.x-2.1\";s:6:\"status\";i:5;}}','1281087032','1281083432',null,'1');
INSERT INTO `cache_update` VALUES ('update_project_projects','a:38:{s:8:\"addtoany\";a:7:{s:4:\"name\";s:8:\"addtoany\";s:4:\"info\";a:5:{s:4:\"name\";s:8:\"AddToAny\";s:7:\"version\";s:7:\"6.x-3.3\";s:7:\"project\";s:8:\"addtoany\";s:9:\"datestamp\";s:10:\"1278719704\";s:16:\"_info_file_ctime\";i:1280942999;}s:9:\"datestamp\";s:10:\"1278719704\";s:8:\"includes\";a:1:{s:8:\"addtoany\";s:8:\"AddToAny\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:10:\"admin_menu\";a:7:{s:4:\"name\";s:10:\"admin_menu\";s:4:\"info\";a:6:{s:4:\"name\";s:19:\"Administration menu\";s:7:\"package\";s:14:\"Administration\";s:7:\"version\";s:7:\"6.x-1.5\";s:7:\"project\";s:10:\"admin_menu\";s:9:\"datestamp\";s:10:\"1246537502\";s:16:\"_info_file_ctime\";i:1280942999;}s:9:\"datestamp\";s:10:\"1246537502\";s:8:\"includes\";a:1:{s:10:\"admin_menu\";s:19:\"Administration menu\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:14:\"backup_migrate\";a:7:{s:4:\"name\";s:14:\"backup_migrate\";s:4:\"info\";a:5:{s:4:\"name\";s:18:\"Backup and Migrate\";s:7:\"version\";s:7:\"6.x-1.2\";s:7:\"project\";s:14:\"backup_migrate\";s:9:\"datestamp\";s:10:\"1232247609\";s:16:\"_info_file_ctime\";i:1280943010;}s:9:\"datestamp\";s:10:\"1232247609\";s:8:\"includes\";a:1:{s:14:\"backup_migrate\";s:18:\"Backup and Migrate\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:6:\"drupal\";a:7:{s:4:\"name\";s:6:\"drupal\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Block\";s:7:\"package\";s:15:\"Core - required\";s:7:\"version\";s:4:\"6.17\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1275505216\";s:16:\"_info_file_ctime\";i:1280943179;}s:9:\"datestamp\";s:10:\"1275505216\";s:8:\"includes\";a:16:{s:5:\"block\";s:5:\"Block\";s:5:\"color\";s:5:\"Color\";s:7:\"comment\";s:7:\"Comment\";s:5:\"dblog\";s:16:\"Database logging\";s:6:\"filter\";s:6:\"Filter\";s:4:\"help\";s:4:\"Help\";s:6:\"locale\";s:6:\"Locale\";s:4:\"menu\";s:4:\"Menu\";s:4:\"node\";s:4:\"Node\";s:4:\"path\";s:4:\"Path\";s:3:\"php\";s:10:\"PHP filter\";s:6:\"system\";s:6:\"System\";s:8:\"taxonomy\";s:8:\"Taxonomy\";s:6:\"update\";s:13:\"Update status\";s:4:\"user\";s:4:\"User\";s:6:\"harold\";s:6:\"harold\";}s:12:\"project_type\";s:4:\"core\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:7:\"captcha\";a:7:{s:4:\"name\";s:7:\"captcha\";s:4:\"info\";a:6:{s:4:\"name\";s:7:\"CAPTCHA\";s:7:\"package\";s:12:\"Spam control\";s:7:\"version\";s:7:\"6.x-2.2\";s:7:\"project\";s:7:\"captcha\";s:9:\"datestamp\";s:10:\"1274250303\";s:16:\"_info_file_ctime\";i:1280956197;}s:9:\"datestamp\";s:10:\"1274250303\";s:8:\"includes\";a:2:{s:7:\"captcha\";s:7:\"CAPTCHA\";s:13:\"image_captcha\";s:13:\"Image CAPTCHA\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:3:\"cck\";a:7:{s:4:\"name\";s:3:\"cck\";s:4:\"info\";a:6:{s:4:\"name\";s:7:\"Content\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-2.5\";s:7:\"project\";s:3:\"cck\";s:9:\"datestamp\";s:10:\"1249334428\";s:16:\"_info_file_ctime\";i:1280943020;}s:9:\"datestamp\";s:10:\"1249334428\";s:8:\"includes\";a:8:{s:7:\"content\";s:7:\"Content\";s:12:\"content_copy\";s:12:\"Content Copy\";s:10:\"fieldgroup\";s:10:\"Fieldgroup\";s:13:\"nodereference\";s:14:\"Node Reference\";s:6:\"number\";s:6:\"Number\";s:13:\"optionwidgets\";s:14:\"Option Widgets\";s:4:\"text\";s:4:\"Text\";s:13:\"userreference\";s:14:\"User Reference\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:3:\"ctm\";a:7:{s:4:\"name\";s:3:\"ctm\";s:4:\"info\";a:6:{s:4:\"name\";s:30:\"Menu Settings per Content Type\";s:7:\"package\";s:14:\"Administration\";s:7:\"project\";s:3:\"ctm\";s:7:\"version\";s:7:\"6.x-1.0\";s:9:\"datestamp\";s:10:\"1227532508\";s:16:\"_info_file_ctime\";i:1280943054;}s:9:\"datestamp\";s:10:\"1227532508\";s:8:\"includes\";a:1:{s:3:\"ctm\";s:30:\"Menu Settings per Content Type\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:6:\"ctools\";a:7:{s:4:\"name\";s:6:\"ctools\";s:4:\"info\";a:6:{s:4:\"name\";s:11:\"Chaos tools\";s:7:\"package\";s:16:\"Chaos tool suite\";s:7:\"version\";s:7:\"6.x-1.4\";s:7:\"project\";s:6:\"ctools\";s:9:\"datestamp\";s:10:\"1274320504\";s:16:\"_info_file_ctime\";i:1280943068;}s:9:\"datestamp\";s:10:\"1274320504\";s:8:\"includes\";a:3:{s:6:\"ctools\";s:11:\"Chaos tools\";s:12:\"page_manager\";s:12:\"Page manager\";s:13:\"views_content\";s:19:\"Views content panes\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:5:\"devel\";a:7:{s:4:\"name\";s:5:\"devel\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Devel\";s:7:\"package\";s:11:\"Development\";s:7:\"version\";s:8:\"6.x-1.16\";s:7:\"project\";s:5:\"devel\";s:9:\"datestamp\";s:10:\"1239375932\";s:16:\"_info_file_ctime\";i:1280943077;}s:9:\"datestamp\";s:10:\"1239375932\";s:8:\"includes\";a:2:{s:5:\"devel\";s:5:\"Devel\";s:17:\"devel_node_access\";s:17:\"Devel node access\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:9:\"filefield\";a:7:{s:4:\"name\";s:9:\"filefield\";s:4:\"info\";a:6:{s:4:\"name\";s:9:\"FileField\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-3.2\";s:7:\"project\";s:9:\"filefield\";s:9:\"datestamp\";s:10:\"1256070656\";s:16:\"_info_file_ctime\";i:1280943082;}s:9:\"datestamp\";s:10:\"1256070656\";s:8:\"includes\";a:1:{s:9:\"filefield\";s:9:\"FileField\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:19:\"hierarchical_select\";a:7:{s:4:\"name\";s:19:\"hierarchical_select\";s:4:\"info\";a:6:{s:4:\"name\";s:19:\"Hierarchical Select\";s:7:\"package\";s:13:\"Form Elements\";s:7:\"version\";s:7:\"6.x-3.3\";s:7:\"project\";s:19:\"hierarchical_select\";s:9:\"datestamp\";s:10:\"1278589208\";s:16:\"_info_file_ctime\";i:1280943086;}s:9:\"datestamp\";s:10:\"1278589208\";s:8:\"includes\";a:2:{s:19:\"hierarchical_select\";s:19:\"Hierarchical Select\";s:17:\"hs_smallhierarchy\";s:35:\"Hierarchical Select Small Hierarchy\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:8:\"imageapi\";a:7:{s:4:\"name\";s:8:\"imageapi\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"ImageAPI\";s:7:\"package\";s:10:\"ImageCache\";s:7:\"version\";s:7:\"6.x-1.6\";s:7:\"project\";s:8:\"imageapi\";s:9:\"datestamp\";s:10:\"1239992203\";s:16:\"_info_file_ctime\";i:1280943092;}s:9:\"datestamp\";s:10:\"1239992203\";s:8:\"includes\";a:3:{s:8:\"imageapi\";s:8:\"ImageAPI\";s:11:\"imageapi_gd\";s:12:\"ImageAPI GD2\";s:20:\"imageapi_imagemagick\";s:20:\"ImageAPI ImageMagick\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:10:\"imagecache\";a:7:{s:4:\"name\";s:10:\"imagecache\";s:4:\"info\";a:6:{s:4:\"name\";s:10:\"ImageCache\";s:7:\"package\";s:10:\"ImageCache\";s:7:\"version\";s:14:\"6.x-2.0-beta10\";s:7:\"project\";s:10:\"imagecache\";s:9:\"datestamp\";s:10:\"1250716281\";s:16:\"_info_file_ctime\";i:1280943093;}s:9:\"datestamp\";s:10:\"1250716281\";s:8:\"includes\";a:2:{s:10:\"imagecache\";s:10:\"ImageCache\";s:13:\"imagecache_ui\";s:13:\"ImageCache UI\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:18:\"imagecache_actions\";a:7:{s:4:\"name\";s:18:\"imagecache_actions\";s:4:\"info\";a:6:{s:4:\"name\";s:25:\"Imagecache Canvas Actions\";s:7:\"package\";s:10:\"ImageCache\";s:7:\"version\";s:7:\"6.x-1.6\";s:7:\"project\";s:18:\"imagecache_actions\";s:9:\"datestamp\";s:10:\"1244598933\";s:16:\"_info_file_ctime\";i:1280943095;}s:9:\"datestamp\";s:10:\"1244598933\";s:8:\"includes\";a:4:{s:24:\"imagecache_canvasactions\";s:25:\"Imagecache Canvas Actions\";s:23:\"imagecache_coloractions\";s:24:\"Imagecache Color Actions\";s:24:\"imagecache_customactions\";s:25:\"Imagecache Custom Actions\";s:22:\"imagecache_textactions\";s:23:\"Imagecache Text Actions\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:18:\"imagecache_effects\";a:7:{s:4:\"name\";s:18:\"imagecache_effects\";s:4:\"info\";a:6:{s:4:\"name\";s:18:\"ImageCache Effects\";s:7:\"package\";s:10:\"ImageCache\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:18:\"imagecache_effects\";s:9:\"datestamp\";s:10:\"1231131919\";s:16:\"_info_file_ctime\";i:1280943096;}s:9:\"datestamp\";s:10:\"1231131919\";s:8:\"includes\";a:1:{s:18:\"imagecache_effects\";s:18:\"ImageCache Effects\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:10:\"imagefield\";a:7:{s:4:\"name\";s:10:\"imagefield\";s:4:\"info\";a:6:{s:4:\"name\";s:10:\"ImageField\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-3.2\";s:7:\"project\";s:10:\"imagefield\";s:9:\"datestamp\";s:10:\"1256070937\";s:16:\"_info_file_ctime\";i:1280943096;}s:9:\"datestamp\";s:10:\"1256070937\";s:8:\"includes\";a:1:{s:10:\"imagefield\";s:10:\"ImageField\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:4:\"imce\";a:7:{s:4:\"name\";s:4:\"imce\";s:4:\"info\";a:5:{s:4:\"name\";s:4:\"IMCE\";s:7:\"version\";s:7:\"6.x-1.2\";s:7:\"project\";s:4:\"imce\";s:9:\"datestamp\";s:10:\"1235227525\";s:16:\"_info_file_ctime\";i:1280943097;}s:9:\"datestamp\";s:10:\"1235227525\";s:8:\"includes\";a:1:{s:4:\"imce\";s:4:\"IMCE\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:12:\"imce_wysiwyg\";a:7:{s:4:\"name\";s:12:\"imce_wysiwyg\";s:4:\"info\";a:6:{s:4:\"name\";s:23:\"IMCE Wysiwyg API bridge\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"6.x-1.0\";s:7:\"project\";s:12:\"imce_wysiwyg\";s:9:\"datestamp\";s:10:\"1236182123\";s:16:\"_info_file_ctime\";i:1280943099;}s:9:\"datestamp\";s:10:\"1236182123\";s:8:\"includes\";a:1:{s:12:\"imce_wysiwyg\";s:23:\"IMCE Wysiwyg API bridge\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:10:\"jquerymenu\";a:7:{s:4:\"name\";s:10:\"jquerymenu\";s:4:\"info\";a:6:{s:4:\"name\";s:11:\"Jquery Menu\";s:7:\"package\";s:24:\"Advanced Navigation Pack\";s:7:\"version\";s:7:\"6.x-3.3\";s:7:\"project\";s:10:\"jquerymenu\";s:9:\"datestamp\";s:10:\"1273902006\";s:16:\"_info_file_ctime\";i:1280943099;}s:9:\"datestamp\";s:10:\"1273902006\";s:8:\"includes\";a:1:{s:10:\"jquerymenu\";s:11:\"Jquery Menu\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:4:\"link\";a:7:{s:4:\"name\";s:4:\"link\";s:4:\"info\";a:6:{s:4:\"name\";s:4:\"Link\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-2.8\";s:7:\"project\";s:4:\"link\";s:9:\"datestamp\";s:10:\"1257394550\";s:16:\"_info_file_ctime\";i:1280943102;}s:9:\"datestamp\";s:10:\"1257394550\";s:8:\"includes\";a:1:{s:4:\"link\";s:4:\"Link\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:15:\"menu_attributes\";a:7:{s:4:\"name\";s:15:\"menu_attributes\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Menu Attributes\";s:7:\"package\";s:4:\"Menu\";s:7:\"version\";s:7:\"6.x-1.4\";s:7:\"project\";s:15:\"menu_attributes\";s:9:\"datestamp\";s:10:\"1240350367\";s:16:\"_info_file_ctime\";i:1280943103;}s:9:\"datestamp\";s:10:\"1240350367\";s:8:\"includes\";a:1:{s:15:\"menu_attributes\";s:15:\"Menu Attributes\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:10:\"menu_block\";a:7:{s:4:\"name\";s:10:\"menu_block\";s:4:\"info\";a:5:{s:4:\"name\";s:10:\"Menu Block\";s:7:\"version\";s:7:\"6.x-2.2\";s:7:\"project\";s:10:\"menu_block\";s:9:\"datestamp\";s:10:\"1229377222\";s:16:\"_info_file_ctime\";i:1280943104;}s:9:\"datestamp\";s:10:\"1229377222\";s:8:\"includes\";a:1:{s:10:\"menu_block\";s:10:\"Menu Block\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:11:\"menu_editor\";a:7:{s:4:\"name\";s:11:\"menu_editor\";s:4:\"info\";a:6:{s:4:\"name\";s:11:\"Menu Editor\";s:7:\"package\";s:4:\"Menu\";s:7:\"version\";s:13:\"6.x-2.0-beta2\";s:7:\"project\";s:11:\"menu_editor\";s:9:\"datestamp\";s:10:\"1272201609\";s:16:\"_info_file_ctime\";i:1280943104;}s:9:\"datestamp\";s:10:\"1272201609\";s:8:\"includes\";a:2:{s:11:\"menu_editor\";s:11:\"Menu Editor\";s:25:\"menu_editor_node_creation\";s:27:\"Menu Editor - Node creation\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:6:\"panels\";a:7:{s:4:\"name\";s:6:\"panels\";s:4:\"info\";a:6:{s:4:\"name\";s:6:\"Panels\";s:7:\"package\";s:6:\"Panels\";s:7:\"version\";s:7:\"6.x-3.5\";s:7:\"project\";s:6:\"panels\";s:9:\"datestamp\";s:10:\"1275094509\";s:16:\"_info_file_ctime\";i:1280943112;}s:9:\"datestamp\";s:10:\"1275094509\";s:8:\"includes\";a:3:{s:6:\"panels\";s:6:\"Panels\";s:11:\"panels_mini\";s:11:\"Mini panels\";s:11:\"panels_node\";s:11:\"Panel nodes\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:8:\"pathauto\";a:7:{s:4:\"name\";s:8:\"pathauto\";s:4:\"info\";a:5:{s:4:\"name\";s:8:\"Pathauto\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:8:\"pathauto\";s:9:\"datestamp\";s:10:\"1214487317\";s:16:\"_info_file_ctime\";i:1280943116;}s:9:\"datestamp\";s:10:\"1214487317\";s:8:\"includes\";a:1:{s:8:\"pathauto\";s:8:\"Pathauto\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:5:\"rules\";a:7:{s:4:\"name\";s:5:\"rules\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Rules\";s:7:\"package\";s:5:\"Rules\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:5:\"rules\";s:9:\"datestamp\";s:10:\"1251458463\";s:16:\"_info_file_ctime\";i:1280943133;}s:9:\"datestamp\";s:10:\"1251458463\";s:8:\"includes\";a:4:{s:5:\"rules\";s:5:\"Rules\";s:11:\"rules_admin\";s:23:\"Rules Administration UI\";s:11:\"rules_forms\";s:19:\"Rules Forms support\";s:15:\"rules_scheduler\";s:15:\"Rules Scheduler\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:12:\"semantic_cck\";a:7:{s:4:\"name\";s:12:\"semantic_cck\";s:4:\"info\";a:6:{s:4:\"name\";s:12:\"Semantic CCK\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:12:\"semantic_cck\";s:9:\"datestamp\";s:10:\"1276563009\";s:16:\"_info_file_ctime\";i:1280943136;}s:9:\"datestamp\";s:10:\"1276563009\";s:8:\"includes\";a:1:{s:12:\"semantic_cck\";s:12:\"Semantic CCK\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:13:\"semanticviews\";a:7:{s:4:\"name\";s:13:\"semanticviews\";s:4:\"info\";a:6:{s:4:\"name\";s:14:\"Semantic Views\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"6.x-1.1\";s:7:\"project\";s:13:\"semanticviews\";s:9:\"datestamp\";s:10:\"1271635508\";s:16:\"_info_file_ctime\";i:1280943136;}s:9:\"datestamp\";s:10:\"1271635508\";s:8:\"includes\";a:1:{s:13:\"semanticviews\";s:14:\"Semantic Views\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:13:\"service_links\";a:7:{s:4:\"name\";s:13:\"service_links\";s:4:\"info\";a:5:{s:4:\"name\";s:13:\"Service links\";s:7:\"version\";s:7:\"6.x-1.0\";s:7:\"project\";s:13:\"service_links\";s:9:\"datestamp\";s:10:\"1207327211\";s:16:\"_info_file_ctime\";i:1280996073;}s:9:\"datestamp\";s:10:\"1207327211\";s:8:\"includes\";a:1:{s:13:\"service_links\";s:13:\"Service links\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:5:\"token\";a:7:{s:4:\"name\";s:5:\"token\";s:4:\"info\";a:5:{s:4:\"name\";s:5:\"Token\";s:7:\"version\";s:8:\"6.x-1.12\";s:7:\"project\";s:5:\"token\";s:9:\"datestamp\";s:10:\"1243895498\";s:16:\"_info_file_ctime\";i:1280943145;}s:9:\"datestamp\";s:10:\"1243895498\";s:8:\"includes\";a:1:{s:5:\"token\";s:5:\"Token\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:13:\"viewreference\";a:7:{s:4:\"name\";s:13:\"viewreference\";s:4:\"info\";a:6:{s:4:\"name\";s:14:\"View Reference\";s:7:\"package\";s:3:\"CCK\";s:7:\"version\";s:8:\"6.x-2.24\";s:7:\"project\";s:13:\"viewreference\";s:9:\"datestamp\";s:10:\"1263636305\";s:16:\"_info_file_ctime\";i:1280943148;}s:9:\"datestamp\";s:10:\"1263636305\";s:8:\"includes\";a:1:{s:13:\"viewreference\";s:14:\"View Reference\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:5:\"views\";a:7:{s:4:\"name\";s:5:\"views\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Views\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:8:\"6.x-2.10\";s:7:\"project\";s:5:\"views\";s:9:\"datestamp\";s:10:\"1270766108\";s:16:\"_info_file_ctime\";i:1280943167;}s:9:\"datestamp\";s:10:\"1270766108\";s:8:\"includes\";a:2:{s:5:\"views\";s:5:\"Views\";s:8:\"views_ui\";s:8:\"Views UI\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:21:\"views_bulk_operations\";a:7:{s:4:\"name\";s:21:\"views_bulk_operations\";s:4:\"info\";a:6:{s:4:\"name\";s:21:\"Views Bulk Operations\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"6.x-1.7\";s:7:\"project\";s:21:\"views_bulk_operations\";s:9:\"datestamp\";s:10:\"1242845770\";s:16:\"_info_file_ctime\";i:1280943167;}s:9:\"datestamp\";s:10:\"1242845770\";s:8:\"includes\";a:1:{s:21:\"views_bulk_operations\";s:21:\"Views Bulk Operations\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:22:\"views_exclude_previous\";a:7:{s:4:\"name\";s:22:\"views_exclude_previous\";s:4:\"info\";a:6:{s:4:\"name\";s:22:\"Views Exclude Previous\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"6.x-1.0\";s:7:\"project\";s:22:\"views_exclude_previous\";s:9:\"datestamp\";s:10:\"1233753530\";s:16:\"_info_file_ctime\";i:1280943168;}s:9:\"datestamp\";s:10:\"1233753530\";s:8:\"includes\";a:1:{s:22:\"views_exclude_previous\";s:22:\"Views Exclude Previous\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:15:\"views_php_array\";a:7:{s:4:\"name\";s:15:\"views_php_array\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Views PHP Array\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:13:\"6.x-1.0.x-dev\";s:7:\"project\";s:15:\"views_php_array\";s:9:\"datestamp\";s:10:\"1277814299\";s:16:\"_info_file_ctime\";i:1280943168;}s:9:\"datestamp\";s:10:\"1277814299\";s:8:\"includes\";a:1:{s:15:\"views_php_array\";s:15:\"Views PHP Array\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:15:\"views_slideshow\";a:7:{s:4:\"name\";s:15:\"views_slideshow\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Views Slideshow\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"6.x-2.3\";s:7:\"project\";s:15:\"views_slideshow\";s:9:\"datestamp\";s:10:\"1279683019\";s:16:\"_info_file_ctime\";i:1280943171;}s:9:\"datestamp\";s:10:\"1279683019\";s:8:\"includes\";a:2:{s:15:\"views_slideshow\";s:15:\"Views Slideshow\";s:27:\"views_slideshow_singleframe\";s:28:\"Views Slideshow: SingleFrame\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:7:\"webform\";a:7:{s:4:\"name\";s:7:\"webform\";s:4:\"info\";a:5:{s:4:\"name\";s:7:\"Webform\";s:7:\"version\";s:7:\"6.x-2.9\";s:7:\"project\";s:7:\"webform\";s:9:\"datestamp\";s:10:\"1257475622\";s:16:\"_info_file_ctime\";i:1280943174;}s:9:\"datestamp\";s:10:\"1257475622\";s:8:\"includes\";a:1:{s:7:\"webform\";s:7:\"Webform\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:7:\"wysiwyg\";a:7:{s:4:\"name\";s:7:\"wysiwyg\";s:4:\"info\";a:6:{s:4:\"name\";s:7:\"Wysiwyg\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"6.x-2.1\";s:7:\"project\";s:7:\"wysiwyg\";s:9:\"datestamp\";s:10:\"1268063714\";s:16:\"_info_file_ctime\";i:1280943177;}s:9:\"datestamp\";s:10:\"1268063714\";s:8:\"includes\";a:1:{s:7:\"wysiwyg\";s:7:\"Wysiwyg\";}s:12:\"project_type\";s:6:\"module\";s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}}','1281087032','1281083432',null,'1');
DROP TABLE IF EXISTS `cache_views`;
CREATE TABLE `cache_views` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '0',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `cache_views_data`;
CREATE TABLE `cache_views_data` (   `cid` varchar(255) NOT NULL default '',   `data` longblob,   `expire` int(11) NOT NULL default '0',   `created` int(11) NOT NULL default '0',   `headers` text,   `serialized` smallint(6) NOT NULL default '1',   PRIMARY KEY  (`cid`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `captcha_points`;
CREATE TABLE `captcha_points` (   `form_id` varchar(128) NOT NULL,   `module` varchar(64) default NULL,   `type` varchar(64) default NULL,   PRIMARY KEY  (`form_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `captcha_points` VALUES ('comment_form',null,null);
INSERT INTO `captcha_points` VALUES ('contact_mail_user',null,null);
INSERT INTO `captcha_points` VALUES ('contact_mail_page',null,null);
INSERT INTO `captcha_points` VALUES ('user_register',null,null);
INSERT INTO `captcha_points` VALUES ('user_pass',null,null);
INSERT INTO `captcha_points` VALUES ('user_login',null,null);
INSERT INTO `captcha_points` VALUES ('user_login_block',null,null);
INSERT INTO `captcha_points` VALUES ('forum_node_form',null,null);
INSERT INTO `captcha_points` VALUES ('webform_client_form_16','image_captcha','Image');
DROP TABLE IF EXISTS `captcha_sessions`;
CREATE TABLE `captcha_sessions` (   `csid` int(11) NOT NULL auto_increment,   `uid` int(11) NOT NULL default '0',   `sid` varchar(64) NOT NULL default '',   `ip_address` varchar(128) default NULL,   `timestamp` int(11) NOT NULL default '0',   `form_id` varchar(128) NOT NULL,   `solution` varchar(128) NOT NULL default '',   `status` int(11) NOT NULL default '0',   `attempts` int(11) NOT NULL default '0',   PRIMARY KEY  (`csid`),   KEY `csid_ip` (`csid`,`ip_address`) ) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8 AUTO_INCREMENT=77;
INSERT INTO `captcha_sessions` VALUES ('64','0','c66ba911c412c11e223f70e395887784','192.168.0.21','1280997724','webform_client_form_16','7HFa5','0','0');
INSERT INTO `captcha_sessions` VALUES ('65','0','c66ba911c412c11e223f70e395887784','192.168.0.21','1280997807','webform_client_form_16','6tSGB','0','0');
INSERT INTO `captcha_sessions` VALUES ('66','0','c66ba911c412c11e223f70e395887784','192.168.0.21','1280997829','webform_client_form_16','LmNFF','0','0');
INSERT INTO `captcha_sessions` VALUES ('67','1','dec046793914ee53a519c1b3f5460bc7','192.168.0.24','1280999146','webform_client_form_16','L96Nh','0','0');
INSERT INTO `captcha_sessions` VALUES ('68','1','0a8737845656055e68e8f8d2c27e3d7b','192.168.0.21','1281001621','webform_client_form_16','T7jf8','0','0');
INSERT INTO `captcha_sessions` VALUES ('69','1','32704903999a2d86b1e71a9bd8d6f4a3','192.168.0.22','1281001698','webform_client_form_16','Qa44B','0','0');
INSERT INTO `captcha_sessions` VALUES ('70','1','32704903999a2d86b1e71a9bd8d6f4a3','192.168.0.22','1281001887','webform_client_form_16','d6GF3','0','0');
INSERT INTO `captcha_sessions` VALUES ('71','1','0a8737845656055e68e8f8d2c27e3d7b','192.168.0.21','1281008311','webform_client_form_16','Y4X75','0','0');
INSERT INTO `captcha_sessions` VALUES ('72','2','e3c0b544e2a1f0160fbaf0e4d0b8f9d0','93.219.191.145','1281008394','webform_client_form_16','FSN5G','0','0');
INSERT INTO `captcha_sessions` VALUES ('73','2','e3c0b544e2a1f0160fbaf0e4d0b8f9d0','93.219.191.145','1281008920','webform_client_form_16','tT4Y6','0','0');
INSERT INTO `captcha_sessions` VALUES ('74','2','e3c0b544e2a1f0160fbaf0e4d0b8f9d0','93.219.191.145','1281010938','webform_client_form_16','bfY6S','0','0');
INSERT INTO `captcha_sessions` VALUES ('75','0','00f01d6832868e316f09322613ed841d','192.168.0.24','1281011663','webform_client_form_16','EQNS4','0','0');
INSERT INTO `captcha_sessions` VALUES ('76','0','32704903999a2d86b1e71a9bd8d6f4a3','192.168.0.22','1281019319','webform_client_form_16','Shj2r','0','0');
DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (   `cid` int(11) NOT NULL auto_increment,   `pid` int(11) NOT NULL default '0',   `nid` int(11) NOT NULL default '0',   `uid` int(11) NOT NULL default '0',   `subject` varchar(64) NOT NULL default '',   `comment` longtext NOT NULL,   `hostname` varchar(128) NOT NULL default '',   `timestamp` int(11) NOT NULL default '0',   `status` tinyint(3) unsigned NOT NULL default '0',   `format` smallint(6) NOT NULL default '0',   `thread` varchar(255) NOT NULL,   `name` varchar(60) default NULL,   `mail` varchar(64) default NULL,   `homepage` varchar(255) default NULL,   PRIMARY KEY  (`cid`),   KEY `pid` (`pid`),   KEY `nid` (`nid`),   KEY `status` (`status`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `content_field_slide`;
CREATE TABLE `content_field_slide` (   `vid` int(10) unsigned NOT NULL default '0',   `nid` int(10) unsigned NOT NULL default '0',   `delta` int(10) unsigned NOT NULL default '0',   `field_slide_fid` int(11) default NULL,   `field_slide_list` tinyint(4) default NULL,   `field_slide_data` text,   PRIMARY KEY  (`vid`,`delta`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_field_slide` VALUES ('11','11','0','18','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
INSERT INTO `content_field_slide` VALUES ('11','11','1','21','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
INSERT INTO `content_field_slide` VALUES ('11','11','2','25','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
INSERT INTO `content_field_slide` VALUES ('11','11','3','22','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
DROP TABLE IF EXISTS `content_field_slide_2`;
CREATE TABLE `content_field_slide_2` (   `vid` int(10) unsigned NOT NULL default '0',   `nid` int(10) unsigned NOT NULL default '0',   `delta` int(10) unsigned NOT NULL default '0',   `field_slide_2_fid` int(11) default NULL,   `field_slide_2_list` tinyint(4) default NULL,   `field_slide_2_data` text,   PRIMARY KEY  (`vid`,`delta`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_field_slide_2` VALUES ('11','11','0','23','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
INSERT INTO `content_field_slide_2` VALUES ('11','11','1','24','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
DROP TABLE IF EXISTS `content_field_slide_3`;
CREATE TABLE `content_field_slide_3` (   `vid` int(10) unsigned NOT NULL default '0',   `nid` int(10) unsigned NOT NULL default '0',   `delta` int(10) unsigned NOT NULL default '0',   `field_slide_3_fid` int(11) default NULL,   `field_slide_3_list` tinyint(4) default NULL,   `field_slide_3_data` text,   PRIMARY KEY  (`vid`,`delta`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_field_slide_3` VALUES ('11','11','0',null,null,null);
DROP TABLE IF EXISTS `content_field_slide_4`;
CREATE TABLE `content_field_slide_4` (   `vid` int(10) unsigned NOT NULL default '0',   `nid` int(10) unsigned NOT NULL default '0',   `delta` int(10) unsigned NOT NULL default '0',   `field_slide_4_fid` int(11) default NULL,   `field_slide_4_list` tinyint(4) default NULL,   `field_slide_4_data` text,   PRIMARY KEY  (`vid`,`delta`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_field_slide_4` VALUES ('11','11','0',null,null,null);
DROP TABLE IF EXISTS `content_field_slide_5`;
CREATE TABLE `content_field_slide_5` (   `vid` int(10) unsigned NOT NULL default '0',   `nid` int(10) unsigned NOT NULL default '0',   `delta` int(10) unsigned NOT NULL default '0',   `field_slide_5_fid` int(11) default NULL,   `field_slide_5_list` tinyint(4) default NULL,   `field_slide_5_data` text,   PRIMARY KEY  (`vid`,`delta`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_field_slide_5` VALUES ('11','11','0',null,null,null);
DROP TABLE IF EXISTS `content_group`;
CREATE TABLE `content_group` (   `group_type` varchar(32) NOT NULL default 'standard',   `type_name` varchar(32) NOT NULL default '',   `group_name` varchar(32) NOT NULL default '',   `label` varchar(255) NOT NULL default '',   `settings` mediumtext NOT NULL,   `weight` int(11) NOT NULL default '0',   PRIMARY KEY  (`type_name`,`group_name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `content_group_fields`;
CREATE TABLE `content_group_fields` (   `type_name` varchar(32) NOT NULL default '',   `group_name` varchar(32) NOT NULL default '',   `field_name` varchar(32) NOT NULL default '',   PRIMARY KEY  (`type_name`,`group_name`,`field_name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `content_node_field`;
CREATE TABLE `content_node_field` (   `field_name` varchar(32) NOT NULL default '',   `type` varchar(127) NOT NULL default '',   `global_settings` mediumtext NOT NULL,   `required` tinyint(4) NOT NULL default '0',   `multiple` tinyint(4) NOT NULL default '0',   `db_storage` tinyint(4) NOT NULL default '1',   `module` varchar(127) NOT NULL default '',   `db_columns` mediumtext NOT NULL,   `active` tinyint(4) NOT NULL default '0',   `locked` tinyint(4) NOT NULL default '0',   PRIMARY KEY  (`field_name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_node_field` VALUES ('field_image','filefield','a:21:{s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";}','0','0','1','filefield','a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}','1','0');
INSERT INTO `content_node_field` VALUES ('field_slide','filefield','a:21:{s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";}','0','1','0','filefield','a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}','1','0');
INSERT INTO `content_node_field` VALUES ('field_slide_2','filefield','a:21:{s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:3:\"div\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:2:\"h3\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:1:\":\";s:33:\"semantic_cck_label_element_inline\";s:4:\"span\";s:35:\"semantic_cck_multiple_items_element\";s:3:\"div\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:3:\"div\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:3:\"div\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:5:\"first\";s:23:\"semantic_cck_last_class\";s:4:\"last\";s:29:\"semantic_cck_striping_classes\";s:8:\"odd even\";}','0','1','0','filefield','a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}','1','0');
INSERT INTO `content_node_field` VALUES ('field_slide_3','filefield','a:21:{s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";}','0','1','0','filefield','a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}','1','0');
INSERT INTO `content_node_field` VALUES ('field_slide_4','filefield','a:21:{s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";}','0','1','0','filefield','a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}','1','0');
INSERT INTO `content_node_field` VALUES ('field_slide_5','filefield','a:21:{s:10:\"list_field\";s:1:\"0\";s:12:\"list_default\";i:1;s:17:\"description_field\";s:1:\"0\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:0:\"\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:0:\"\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:0:\"\";s:33:\"semantic_cck_label_element_inline\";s:0:\"\";s:35:\"semantic_cck_multiple_items_element\";s:0:\"\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:0:\"\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:0:\"\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:0:\"\";s:23:\"semantic_cck_last_class\";s:0:\"\";s:29:\"semantic_cck_striping_classes\";s:0:\"\";}','0','1','0','filefield','a:3:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"list\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:0;s:5:\"views\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:9:\"serialize\";b:1;s:5:\"views\";b:1;}}','1','0');
INSERT INTO `content_node_field` VALUES ('field_slid_select','text','a:22:{s:15:\"text_processing\";s:1:\"0\";s:10:\"max_length\";s:0:\"\";s:14:\"allowed_values\";s:63:\"1 | slide 1\r\n2 | slide 2\r\n3 | slide 3\r\n4 | slide 4\r\n5 | slide 5\";s:18:\"allowed_values_php\";s:0:\"\";s:32:\"semantic_cck_use_semantic_output\";i:0;s:26:\"semantic_cck_field_element\";s:3:\"div\";s:24:\"semantic_cck_field_class\";s:0:\"\";s:32:\"semantic_cck_label_element_above\";s:2:\"h3\";s:31:\"semantic_cck_label_suffix_above\";s:0:\"\";s:32:\"semantic_cck_label_suffix_inline\";s:1:\":\";s:33:\"semantic_cck_label_element_inline\";s:4:\"span\";s:35:\"semantic_cck_multiple_items_element\";s:3:\"div\";s:33:\"semantic_cck_multiple_items_class\";s:0:\"\";s:34:\"semantic_cck_multiple_item_element\";s:3:\"div\";s:32:\"semantic_cck_multiple_item_class\";s:0:\"\";s:37:\"semantic_cck_use_singlevalue_settings\";i:0;s:32:\"semantic_cck_single_item_element\";s:3:\"div\";s:30:\"semantic_cck_single_item_class\";s:0:\"\";s:27:\"semantic_cck_last_every_nth\";s:1:\"0\";s:24:\"semantic_cck_first_class\";s:5:\"first\";s:23:\"semantic_cck_last_class\";s:4:\"last\";s:29:\"semantic_cck_striping_classes\";s:8:\"odd even\";}','0','0','1','text','a:1:{s:5:\"value\";a:5:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;s:8:\"sortable\";b:1;s:5:\"views\";b:1;}}','1','0');
DROP TABLE IF EXISTS `content_node_field_instance`;
CREATE TABLE `content_node_field_instance` (   `field_name` varchar(32) NOT NULL default '',   `type_name` varchar(32) NOT NULL default '',   `weight` int(11) NOT NULL default '0',   `label` varchar(255) NOT NULL default '',   `widget_type` varchar(32) NOT NULL default '',   `widget_settings` mediumtext NOT NULL,   `display_settings` mediumtext NOT NULL,   `description` mediumtext NOT NULL,   `widget_module` varchar(127) NOT NULL default '',   `widget_active` tinyint(4) NOT NULL default '0',   PRIMARY KEY  (`field_name`,`type_name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_node_field_instance` VALUES ('field_image','ref','31','image','imagefield_widget','a:15:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;}','a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}','','imagefield','1');
INSERT INTO `content_node_field_instance` VALUES ('field_slide','slide','31','slideshow','imagefield_widget','a:15:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;}','a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}','','imagefield','1');
INSERT INTO `content_node_field_instance` VALUES ('field_slide_2','slide','32','slideshow_2','imagefield_widget','a:14:{s:15:\"file_extensions\";s:12:\"gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:34:\"semantic_cck_use_semantic_instance\";i:0;s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:17:\"use_default_image\";i:0;}','a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}}','','imagefield','1');
INSERT INTO `content_node_field_instance` VALUES ('field_slide_3','slide','33','slideshow_3','imagefield_widget','a:15:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;}','a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}','','imagefield','1');
INSERT INTO `content_node_field_instance` VALUES ('field_slide_4','slide','34','slideshow_4','imagefield_widget','a:15:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;}','a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}','','imagefield','1');
INSERT INTO `content_node_field_instance` VALUES ('field_slide_5','slide','35','slideshow_5','imagefield_widget','a:15:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:9:\"file_path\";s:0:\"\";s:18:\"progress_indicator\";s:3:\"bar\";s:21:\"max_filesize_per_file\";s:0:\"\";s:21:\"max_filesize_per_node\";s:0:\"\";s:14:\"max_resolution\";s:1:\"0\";s:14:\"min_resolution\";s:1:\"0\";s:3:\"alt\";s:0:\"\";s:10:\"custom_alt\";i:0;s:5:\"title\";s:0:\"\";s:12:\"custom_title\";i:0;s:10:\"title_type\";s:9:\"textfield\";s:13:\"default_image\";N;s:17:\"use_default_image\";i:0;s:34:\"semantic_cck_use_semantic_instance\";i:0;}','a:4:{s:5:\"label\";a:2:{s:6:\"format\";s:5:\"above\";s:7:\"exclude\";i:0;}s:6:\"teaser\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:11:\"image_plain\";s:7:\"exclude\";i:0;}}','','imagefield','1');
INSERT INTO `content_node_field_instance` VALUES ('field_slid_select','page','31','Slideshow Auswahl','optionwidgets_buttons','a:3:{s:34:\"semantic_cck_use_semantic_instance\";i:0;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"1 \";}}s:17:\"default_value_php\";N;}','a:6:{s:6:\"weight\";s:2:\"31\";s:6:\"parent\";s:0:\"\";s:5:\"label\";a:1:{s:6:\"format\";s:6:\"hidden\";}s:6:\"teaser\";a:2:{s:6:\"format\";s:6:\"hidden\";s:7:\"exclude\";i:0;}s:4:\"full\";a:2:{s:6:\"format\";s:6:\"hidden\";s:7:\"exclude\";i:0;}i:4;a:2:{s:6:\"format\";s:7:\"default\";s:7:\"exclude\";i:0;}}','','optionwidgets','1');
DROP TABLE IF EXISTS `content_type_page`;
CREATE TABLE `content_type_page` (   `vid` int(10) unsigned NOT NULL default '0',   `nid` int(10) unsigned NOT NULL default '0',   `field_slid_select_value` longtext,   PRIMARY KEY  (`vid`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_type_page` VALUES ('1','1','1 ');
INSERT INTO `content_type_page` VALUES ('2','2','2 ');
INSERT INTO `content_type_page` VALUES ('3','3',null);
INSERT INTO `content_type_page` VALUES ('5','5',null);
INSERT INTO `content_type_page` VALUES ('6','6',null);
INSERT INTO `content_type_page` VALUES ('10','10',null);
INSERT INTO `content_type_page` VALUES ('15','15',null);
INSERT INTO `content_type_page` VALUES ('18','18','1 ');
INSERT INTO `content_type_page` VALUES ('19','19','1 ');
INSERT INTO `content_type_page` VALUES ('20','20','1 ');
INSERT INTO `content_type_page` VALUES ('21','21','1 ');
INSERT INTO `content_type_page` VALUES ('22','22','1 ');
INSERT INTO `content_type_page` VALUES ('23','23','1 ');
INSERT INTO `content_type_page` VALUES ('24','24','1 ');
INSERT INTO `content_type_page` VALUES ('25','25','1 ');
DROP TABLE IF EXISTS `content_type_ref`;
CREATE TABLE `content_type_ref` (   `vid` int(10) unsigned NOT NULL default '0',   `nid` int(10) unsigned NOT NULL default '0',   `field_image_fid` int(11) default NULL,   `field_image_list` tinyint(4) default NULL,   `field_image_data` text,   PRIMARY KEY  (`vid`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_type_ref` VALUES ('12','12','26','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
INSERT INTO `content_type_ref` VALUES ('13','13','27','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
INSERT INTO `content_type_ref` VALUES ('14','14','28','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
INSERT INTO `content_type_ref` VALUES ('17','17','29','1','a:3:{s:11:\"description\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";}');
DROP TABLE IF EXISTS `content_type_slide`;
CREATE TABLE `content_type_slide` (   `vid` int(10) unsigned NOT NULL default '0',   `nid` int(10) unsigned NOT NULL default '0',   PRIMARY KEY  (`vid`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `content_type_slide` VALUES ('11','11');
DROP TABLE IF EXISTS `ctools_css_cache`;
CREATE TABLE `ctools_css_cache` (   `cid` varchar(128) NOT NULL,   `filename` varchar(255) default NULL,   `css` longtext,   `filter` tinyint(4) default NULL,   PRIMARY KEY  (`cid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `ctools_object_cache`;
CREATE TABLE `ctools_object_cache` (   `sid` varchar(64) NOT NULL,   `name` varchar(128) NOT NULL,   `obj` varchar(32) NOT NULL,   `updated` int(10) unsigned NOT NULL default '0',   `data` longtext,   PRIMARY KEY  (`sid`,`obj`,`name`),   KEY `updated` (`updated`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `devel_queries`;
CREATE TABLE `devel_queries` (   `qid` int(11) NOT NULL auto_increment,   `function` varchar(255) NOT NULL default '',   `query` text NOT NULL,   `hash` varchar(255) NOT NULL default '',   PRIMARY KEY  (`hash`),   KEY `qid` (`qid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `devel_times`;
CREATE TABLE `devel_times` (   `tid` int(11) NOT NULL auto_increment,   `qid` int(11) NOT NULL default '0',   `time` float default NULL,   PRIMARY KEY  (`tid`),   KEY `qid` (`qid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `files`;
CREATE TABLE `files` (   `fid` int(10) unsigned NOT NULL auto_increment,   `uid` int(10) unsigned NOT NULL default '0',   `filename` varchar(255) NOT NULL default '',   `filepath` varchar(255) NOT NULL default '',   `filemime` varchar(255) NOT NULL default '',   `filesize` int(10) unsigned NOT NULL default '0',   `status` int(11) NOT NULL default '0',   `timestamp` int(10) unsigned NOT NULL default '0',   PRIMARY KEY  (`fid`),   KEY `uid` (`uid`),   KEY `status` (`status`),   KEY `timestamp` (`timestamp`) ) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 AUTO_INCREMENT=30;
INSERT INTO `files` VALUES ('18','1','DSC05472_710.JPG','sites/default/files/DSC05472_710.JPG','image/jpeg','86606','1','1280932101');
INSERT INTO `files` VALUES ('21','1','Stoffbutton_710.jpg','sites/default/files/Stoffbutton_710.jpg','image/jpeg','83369','1','1280932127');
INSERT INTO `files` VALUES ('22','1','Buttons 03_710_2.jpg','sites/default/files/Buttons 03_710_2.jpg','image/jpeg','69104','1','1280932135');
INSERT INTO `files` VALUES ('23','1','Druckbutton 04.jpg','sites/default/files/Druckbutton 04.jpg','image/jpeg','1758502','1','1280932169');
INSERT INTO `files` VALUES ('24','1','DSC05472.JPG','sites/default/files/DSC05472.JPG','image/jpeg','2425462','1','1280932222');
INSERT INTO `files` VALUES ('25','1','DSC01354_710_2.JPG','sites/default/files/DSC01354_710_2.JPG','image/jpeg','74314','1','1280933045');
INSERT INTO `files` VALUES ('26','1','Druckbutton 05_70.jpg','sites/default/files/Druckbutton 05_70.jpg','image/jpeg','10911','1','1280999736');
INSERT INTO `files` VALUES ('27','1','Druckbutton 01_70.jpg','sites/default/files/Druckbutton 01_70.jpg','image/jpeg','10195','1','1280999755');
INSERT INTO `files` VALUES ('28','1','Druckbutton 04_70.jpg','sites/default/files/Druckbutton 04_70.jpg','image/jpeg','11927','1','1280999774');
INSERT INTO `files` VALUES ('29','2','Druckbutton 02_70.jpg','sites/default/files/Druckbutton 02_70.jpg','image/jpeg','9011','1','1280999832');
DROP TABLE IF EXISTS `filter_formats`;
CREATE TABLE `filter_formats` (   `format` int(11) NOT NULL auto_increment,   `name` varchar(255) NOT NULL default '',   `roles` varchar(255) NOT NULL default '',   `cache` tinyint(4) NOT NULL default '0',   PRIMARY KEY  (`format`),   UNIQUE KEY `name` (`name`) ) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 AUTO_INCREMENT=4;
INSERT INTO `filter_formats` VALUES ('1','Filtered HTML',',1,2,','1');
INSERT INTO `filter_formats` VALUES ('2','Full HTML',',1,2,','1');
INSERT INTO `filter_formats` VALUES ('3','PHP code','','0');
DROP TABLE IF EXISTS `filters`;
CREATE TABLE `filters` (   `fid` int(11) NOT NULL auto_increment,   `format` int(11) NOT NULL default '0',   `module` varchar(64) NOT NULL default '',   `delta` tinyint(4) NOT NULL default '0',   `weight` tinyint(4) NOT NULL default '0',   PRIMARY KEY  (`fid`),   UNIQUE KEY `fmd` (`format`,`module`,`delta`),   KEY `list` (`format`,`weight`,`module`,`delta`) ) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 AUTO_INCREMENT=12;
INSERT INTO `filters` VALUES ('1','1','filter','2','0');
INSERT INTO `filters` VALUES ('2','1','filter','0','1');
INSERT INTO `filters` VALUES ('3','1','filter','1','2');
INSERT INTO `filters` VALUES ('4','1','filter','3','10');
INSERT INTO `filters` VALUES ('9','2','filter','2','0');
INSERT INTO `filters` VALUES ('10','2','filter','1','1');
INSERT INTO `filters` VALUES ('8','2','filter','3','10');
INSERT INTO `filters` VALUES ('11','3','php','0','0');
DROP TABLE IF EXISTS `flood`;
CREATE TABLE `flood` (   `fid` int(11) NOT NULL auto_increment,   `event` varchar(64) NOT NULL default '',   `hostname` varchar(128) NOT NULL default '',   `timestamp` int(11) NOT NULL default '0',   PRIMARY KEY  (`fid`),   KEY `allow` (`event`,`hostname`,`timestamp`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `history`;
CREATE TABLE `history` (   `uid` int(11) NOT NULL default '0',   `nid` int(11) NOT NULL default '0',   `timestamp` int(11) NOT NULL default '0',   PRIMARY KEY  (`uid`,`nid`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `history` VALUES ('1','1','1281004374');
INSERT INTO `history` VALUES ('1','2','1281011842');
INSERT INTO `history` VALUES ('1','3','1280925065');
INSERT INTO `history` VALUES ('1','4','1280952647');
INSERT INTO `history` VALUES ('1','5','1281001878');
INSERT INTO `history` VALUES ('1','6','1281004734');
INSERT INTO `history` VALUES ('1','7','1280490436');
INSERT INTO `history` VALUES ('1','8','1280490380');
INSERT INTO `history` VALUES ('1','9','1280490249');
INSERT INTO `history` VALUES ('1','10','1281001863');
INSERT INTO `history` VALUES ('1','11','1280491584');
INSERT INTO `history` VALUES ('1','12','1280498288');
INSERT INTO `history` VALUES ('1','13','1280498236');
INSERT INTO `history` VALUES ('1','14','1280498174');
INSERT INTO `history` VALUES ('1','15','1281080885');
INSERT INTO `history` VALUES ('1','16','1281008311');
INSERT INTO `history` VALUES ('1','18','1281004737');
INSERT INTO `history` VALUES ('1','19','1281004252');
INSERT INTO `history` VALUES ('1','20','1281001873');
INSERT INTO `history` VALUES ('1','21','1281001876');
INSERT INTO `history` VALUES ('1','22','1281001844');
INSERT INTO `history` VALUES ('1','23','1281004255');
INSERT INTO `history` VALUES ('2','1','1281012449');
INSERT INTO `history` VALUES ('2','2','1281008387');
INSERT INTO `history` VALUES ('2','5','1281008374');
INSERT INTO `history` VALUES ('2','6','1281012942');
INSERT INTO `history` VALUES ('2','10','1281012947');
INSERT INTO `history` VALUES ('2','15','1281013034');
INSERT INTO `history` VALUES ('2','16','1281010938');
INSERT INTO `history` VALUES ('2','17','1280999835');
INSERT INTO `history` VALUES ('2','18','1281012953');
INSERT INTO `history` VALUES ('2','19','1281012955');
INSERT INTO `history` VALUES ('2','23','1281008009');
INSERT INTO `history` VALUES ('2','24','1281008159');
INSERT INTO `history` VALUES ('2','25','1281011959');
DROP TABLE IF EXISTS `imagecache_action`;
CREATE TABLE `imagecache_action` (   `actionid` int(10) unsigned NOT NULL auto_increment,   `presetid` int(10) unsigned NOT NULL default '0',   `weight` int(11) NOT NULL default '0',   `module` varchar(255) NOT NULL,   `action` varchar(255) NOT NULL,   `data` longtext NOT NULL,   PRIMARY KEY  (`actionid`),   KEY `presetid` (`presetid`) ) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 AUTO_INCREMENT=4;
INSERT INTO `imagecache_action` VALUES ('1','1','0','imagecache','imagecache_crop','a:4:{s:5:\"width\";s:2:\"70\";s:6:\"height\";s:2:\"70\";s:7:\"xoffset\";s:0:\"\";s:7:\"yoffset\";s:0:\"\";}');
INSERT INTO `imagecache_action` VALUES ('2','2','0','imagecache','imagecache_crop','a:4:{s:5:\"width\";s:3:\"710\";s:6:\"height\";s:3:\"115\";s:7:\"xoffset\";s:0:\"\";s:7:\"yoffset\";s:0:\"\";}');
INSERT INTO `imagecache_action` VALUES ('3','2','0','imagecache','imagecache_scale','a:3:{s:5:\"width\";s:3:\"710\";s:6:\"height\";s:0:\"\";s:7:\"upscale\";i:1;}');
DROP TABLE IF EXISTS `imagecache_preset`;
CREATE TABLE `imagecache_preset` (   `presetid` int(10) unsigned NOT NULL auto_increment,   `presetname` varchar(255) NOT NULL,   PRIMARY KEY  (`presetid`) ) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 AUTO_INCREMENT=3;
INSERT INTO `imagecache_preset` VALUES ('1','logo');
INSERT INTO `imagecache_preset` VALUES ('2','slide');
DROP TABLE IF EXISTS `jquerymenus`;
CREATE TABLE `jquerymenus` (   `mid` int(10) unsigned NOT NULL auto_increment,   `menu_name` varchar(255) NOT NULL,   PRIMARY KEY  (`mid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `languages`;
CREATE TABLE `languages` (   `language` varchar(12) NOT NULL default '',   `name` varchar(64) NOT NULL default '',   `native` varchar(64) NOT NULL default '',   `direction` int(11) NOT NULL default '0',   `enabled` int(11) NOT NULL default '0',   `plurals` int(11) NOT NULL default '0',   `formula` varchar(128) NOT NULL default '',   `domain` varchar(128) NOT NULL default '',   `prefix` varchar(128) NOT NULL default '',   `weight` int(11) NOT NULL default '0',   `javascript` varchar(32) NOT NULL default '',   PRIMARY KEY  (`language`),   KEY `list` (`weight`,`name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `languages` VALUES ('de','German','Deutsch','0','1','2','($n!=1)','','de','0','fc6d30899b6948e675c4a3a2c1ff0bc2');
INSERT INTO `languages` VALUES ('en','English','English','0','1','0','','','','0','');
DROP TABLE IF EXISTS `locales_source`;
CREATE TABLE `locales_source` (   `lid` int(11) NOT NULL auto_increment,   `location` varchar(255) NOT NULL default '',   `textgroup` varchar(255) NOT NULL default 'default',   `source` blob NOT NULL,   `version` varchar(20) NOT NULL default 'none',   PRIMARY KEY  (`lid`),   KEY `source` (`source`(30)) ) ENGINE=InnoDB AUTO_INCREMENT=5817 DEFAULT CHARSET=utf8 AUTO_INCREMENT=5817;
INSERT INTO `locales_source` VALUES ('1',' misc/drupal.js:0; misc/drupal.js','default','Unspecified error','none');
INSERT INTO `locales_source` VALUES ('2','misc/drupal.js','default','An error occurred. \\n@uri\\n@text','none');
INSERT INTO `locales_source` VALUES ('3','misc/drupal.js','default','An error occurred. \\n@uri\\n(no information available).','none');
INSERT INTO `locales_source` VALUES ('4','misc/drupal.js','default','An HTTP error @status occurred. \\n@uri','none');
INSERT INTO `locales_source` VALUES ('5',' modules/block/block.admin.inc:237','default','Show on every page except the listed pages.','6.17');
INSERT INTO `locales_source` VALUES ('6',' modules/block/block.admin.inc:237','default','Show on only the listed pages.','6.17');
INSERT INTO `locales_source` VALUES ('7',' modules/block/block.admin.inc:252','default','Pages','6.17');
INSERT INTO `locales_source` VALUES ('8',' modules/block/block.admin.inc:161','default','Block title','6.17');
INSERT INTO `locales_source` VALUES ('9',' modules/block/block.admin.inc:163','default','The title of the block as shown to the user.','6.17');
INSERT INTO `locales_source` VALUES ('10',' plugins/layouts/flexible/flexible.inc:511','default','Region','6.17');
INSERT INTO `locales_source` VALUES ('11',' modules/block/block.module:156','default','Add block','6.17');
INSERT INTO `locales_source` VALUES ('12',' modules/block/block.admin.inc:241','default','Show if the following PHP code returns <code>TRUE</code> (PHP-mode, experts only).','6.17');
INSERT INTO `locales_source` VALUES ('13',' modules/block/block.admin.inc:238','default','Enter one page per line as Drupal paths. The \'*\' character is a wildcard. Example paths are %blog for the blog page and %blog-wildcard for every personal blog. %front is the front page.','6.17');
INSERT INTO `locales_source` VALUES ('14',' plugins/content_types/block/block.inc:91','default','Configure block','6.17');
INSERT INTO `locales_source` VALUES ('15',' modules/block/block.admin.inc:334','default','Are you sure you want to delete the block %name?','none');
INSERT INTO `locales_source` VALUES ('16',' modules/block/block.admin.inc:343','default','The block %name has been removed.','none');
INSERT INTO `locales_source` VALUES ('17',' modules/block/block.admin.inc:213','default','Role specific visibility settings','6.17');
INSERT INTO `locales_source` VALUES ('18',' modules/block/block.module:328','default','Block description','6.17');
INSERT INTO `locales_source` VALUES ('19',' modules/block/block.module:121','default','Blocks','6.17');
INSERT INTO `locales_source` VALUES ('20',' modules/block/block.module:122','default','Configure what block content appears in your site\'s sidebars and other regions.','6.17');
INSERT INTO `locales_source` VALUES ('21',' modules/block/block.module:148','default','Delete block','6.17');
INSERT INTO `locales_source` VALUES ('22',' modules/block/block.admin.inc:91','default','Save blocks','6.17');
INSERT INTO `locales_source` VALUES ('23',' modules/block/block.admin.inc:106','default','The block settings have been updated.','6.17');
INSERT INTO `locales_source` VALUES ('24',' modules/block/block.admin.inc:156','default','Block specific settings','6.17');
INSERT INTO `locales_source` VALUES ('25',' modules/block/block.admin.inc:163','default','Override the default title for the block. Use <em>&lt;none&gt;</em> to display no title, or leave blank to use the default block title.','6.17');
INSERT INTO `locales_source` VALUES ('26',' modules/block/block.admin.inc:179','default','\'%name\' block','6.17');
INSERT INTO `locales_source` VALUES ('27',' modules/block/block.admin.inc:185','default','User specific visibility settings','6.17');
INSERT INTO `locales_source` VALUES ('28',' modules/block/block.admin.inc:190','default','Custom visibility settings','6.17');
INSERT INTO `locales_source` VALUES ('29',' modules/block/block.admin.inc:192','default','Users cannot control whether or not they see this block.','6.17');
INSERT INTO `locales_source` VALUES ('30',' modules/block/block.admin.inc:193','default','Show this block by default, but let individual users hide it.','6.17');
INSERT INTO `locales_source` VALUES ('31',' modules/block/block.admin.inc:194','default','Hide this block by default but let individual users show it.','6.17');
INSERT INTO `locales_source` VALUES ('32',' modules/block/block.admin.inc:196','default','Allow individual users to customize the visibility of this block in their account settings.','6.17');
INSERT INTO `locales_source` VALUES ('33',' modules/block/block.admin.inc:218','default','Show block for specific roles','6.17');
INSERT INTO `locales_source` VALUES ('34',' modules/block/block.admin.inc:221','default','Show this block only for the selected role(s). If you select no roles, the block will be visible to all users.','6.17');
INSERT INTO `locales_source` VALUES ('35',' modules/block/block.admin.inc:226','default','Page specific visibility settings','6.17');
INSERT INTO `locales_source` VALUES ('36',' modules/block/block.admin.inc:242','default','If the PHP-mode is chosen, enter PHP code between %php. Note that executing incorrect PHP-code can break your Drupal site.','6.17');
INSERT INTO `locales_source` VALUES ('37',' modules/block/block.admin.inc:246','default','Show block on specific pages','6.17');
INSERT INTO `locales_source` VALUES ('38',' modules/block/block.admin.inc:260','default','Save block','6.17');
INSERT INTO `locales_source` VALUES ('39',' modules/block/block.admin.inc:269,298','default','Please ensure that each block description is unique.','6.17');
INSERT INTO `locales_source` VALUES ('40',' modules/block/block.admin.inc:282','default','The block configuration has been saved.','6.17');
INSERT INTO `locales_source` VALUES ('41',' modules/block/block.admin.inc:319','default','The block has been created.','6.17');
INSERT INTO `locales_source` VALUES ('42',' modules/block/block.module:331','default','A brief description of your block. Used on the <a href=\"@overview\">block overview page</a>.','6.17');
INSERT INTO `locales_source` VALUES ('43',' modules/block/block.module:338','default','Block body','6.17');
INSERT INTO `locales_source` VALUES ('44',' modules/block/block.module:341','default','The content of the block as shown to the user.','6.17');
INSERT INTO `locales_source` VALUES ('45',' modules/block/block.module:387','default','Block configuration','6.17');
INSERT INTO `locales_source` VALUES ('46',' modules/block/block.module:113','default','administer blocks','6.17');
INSERT INTO `locales_source` VALUES ('47',' modules/block/block.module:113','default','use PHP for block visibility','6.17');
INSERT INTO `locales_source` VALUES ('48',' modules/block/block-admin-display-form.tpl.php:57','default','No blocks in this region','6.17');
INSERT INTO `locales_source` VALUES ('49',' modules/block/block.module:70','default','Blocks are boxes of content rendered into an area, or region, of a web page. The default theme Garland, for example, implements the regions \"left sidebar\", \"right sidebar\", \"content\", \"header\", and \"footer\", and a block may appear in any one of these areas. The <a href=\"@blocks\">blocks administration page</a> provides a drag-and-drop interface for assigning a block to a region, and for controlling the order of blocks within regions.','6.17');
INSERT INTO `locales_source` VALUES ('50',' modules/block/block.module:71','default','Although blocks are usually generated automatically by modules (like the <em>User login</em> block, for example), administrators can also define custom blocks. Custom blocks have a title, description, and body. The body of the block can be as long as necessary, and can contain content supported by any available <a href=\"@input-format\">input format</a>.','6.17');
INSERT INTO `locales_source` VALUES ('51',' modules/block/block.module:72','default','When working with blocks, remember that:','6.17');
INSERT INTO `locales_source` VALUES ('52',' modules/block/block.module:73','default','since not all themes implement the same regions, or display regions in the same way, blocks are positioned on a per-theme basis.','6.17');
INSERT INTO `locales_source` VALUES ('53',' modules/block/block.module:74','default','disabled blocks, or blocks not in a region, are never shown.','6.17');
INSERT INTO `locales_source` VALUES ('54',' modules/block/block.module:75','default','when throttle module is enabled, throttled blocks (blocks with the <em>Throttle</em> checkbox selected) are hidden during high server loads.','6.17');
INSERT INTO `locales_source` VALUES ('55',' modules/block/block.module:76','default','blocks can be configured to be visible only on certain pages.','6.17');
INSERT INTO `locales_source` VALUES ('56',' modules/block/block.module:77','default','blocks can be configured to be visible only when specific conditions are true.','6.17');
INSERT INTO `locales_source` VALUES ('57',' modules/block/block.module:78','default','blocks can be configured to be visible only for certain user roles.','6.17');
INSERT INTO `locales_source` VALUES ('58',' modules/block/block.module:79','default','when allowed by an administrator, specific blocks may be enabled or disabled on a per-user basis using the <em>My account</em> page.','6.17');
INSERT INTO `locales_source` VALUES ('59',' modules/block/block.module:80','default','some dynamic blocks, such as those generated by modules, will be displayed only on certain pages.','6.17');
INSERT INTO `locales_source` VALUES ('60',' modules/block/block.module:81','default','For more information, see the online handbook entry for <a href=\"@block\">Block module</a>.','6.17');
INSERT INTO `locales_source` VALUES ('61',' modules/block/block.module:85','default','This page provides a drag-and-drop interface for assigning a block to a region, and for controlling the order of blocks within regions. To change the region or order of a block, grab a drag-and-drop handle under the <em>Block</em> column and drag the block to a new location in the list. (Grab a handle by clicking and holding the mouse while hovering over a handle icon.) Since not all themes implement the same regions, or display regions in the same way, blocks are positioned on a per-theme basis. Remember that your changes will not be saved until you click the <em>Save blocks</em> button at the bottom of the page.','6.17');
INSERT INTO `locales_source` VALUES ('62',' modules/block/block.module:87','default','To reduce CPU usage, database traffic or bandwidth, blocks may be automatically disabled during high server loads by selecting their <em>Throttle</em> checkbox. Adjust throttle thresholds on the <a href=\"@throttleconfig\">throttle configuration page</a>.','none');
INSERT INTO `locales_source` VALUES ('63',' modules/block/block.module:89','default','Click the <em>configure</em> link next to each block to configure its specific title and visibility settings. Use the <a href=\"@add-block\">add block page</a> to create a custom block.','6.17');
INSERT INTO `locales_source` VALUES ('64',' modules/block/block.module:92','default','Use this page to create a new custom block. New blocks are disabled by default, and must be moved to a region on the <a href=\"@blocks\">blocks administration page</a> to be visible.','6.17');
INSERT INTO `locales_source` VALUES ('65',' modules/block/block.module:276','default','The block %info was assigned to the invalid region %region and has been disabled.','none');
INSERT INTO `locales_source` VALUES ('66',' modules/block/block.module:133','default','JavaScript List Form','6.17');
INSERT INTO `locales_source` VALUES ('67',' modules/block/block.js:0; modules/block/block.js','default','The changes to these blocks will not be saved until the <em>Save blocks</em> button is clicked.','none');
INSERT INTO `locales_source` VALUES ('68',' rules_admin.inc:351','default','Custom','6.17');
INSERT INTO `locales_source` VALUES ('69',' image_captcha/image_captcha.admin.inc:118','default','Text color','6.17');
INSERT INTO `locales_source` VALUES ('70',' modules/color/color.install:26','default','Not installed','none');
INSERT INTO `locales_source` VALUES ('71',' modules/color/color.module:183','default','Link color','none');
INSERT INTO `locales_source` VALUES ('72',' modules/color/color.module:43','default','Color scheme','none');
INSERT INTO `locales_source` VALUES ('73',' modules/color/color.install:28','default','The GD library for PHP is missing or outdated. Please check the <a href=\"@url\">PHP image documentation</a> for information on how to correct this.','none');
INSERT INTO `locales_source` VALUES ('74',' modules/color/color.install:31','default','GD library','6.17');
INSERT INTO `locales_source` VALUES ('75',' modules/color/color.module:174','default','Color set','none');
INSERT INTO `locales_source` VALUES ('76',' modules/color/color.module:10','default','The color module allows a site administrator to quickly and easily change the color scheme of certain themes. Although not all themes support color module, both Garland (the default theme) and Minnelli were designed to take advantage of its features. By using color module with a compatible theme, you can easily change the color of links, backgrounds, text, and other theme elements. Color module requires that your <a href=\"@url\">file download method</a> be set to public.','none');
INSERT INTO `locales_source` VALUES ('77',' modules/color/color.module:11','default','It is important to remember that color module saves a modified copy of the theme\'s specified stylesheets in the files directory. This means that if you make any manual changes to your theme\'s stylesheet, you must save your color settings again, even if they haven\'t changed. This causes the color module generated version of the stylesheets in the files directory to be recreated using the new version of the original file.','none');
INSERT INTO `locales_source` VALUES ('78',' modules/color/color.module:12','default','To change the color settings for a compatible theme, select the \"configure\" link for the theme on the <a href=\"@themes\">themes administration page</a>.','none');
INSERT INTO `locales_source` VALUES ('79',' modules/color/color.module:13','default','For more information, see the online handbook entry for <a href=\"@color\">Color module</a>.','none');
INSERT INTO `locales_source` VALUES ('80',' modules/color/color.module:38','default','The color picker only works if the <a href=\"@url\">download method</a> is set to public.','none');
INSERT INTO `locales_source` VALUES ('81',' modules/color/color.module:182','default','Base color','none');
INSERT INTO `locales_source` VALUES ('82',' modules/color/color.module:184','default','Header top','none');
INSERT INTO `locales_source` VALUES ('83',' modules/color/color.module:185','default','Header bottom','none');
INSERT INTO `locales_source` VALUES ('84',' modules/color/color.module:271','default','There is not enough memory available to PHP to change this theme\'s color scheme. You need at least %size more. Check the <a href=\"@url\">PHP documentation</a> for more information.','none');
INSERT INTO `locales_source` VALUES ('85',' modules/color/color.install:21','default','The GD library for PHP is enabled, but was compiled without PNG support. Please check the <a href=\"@url\">PHP image documentation</a> for information on how to correct this.','none');
INSERT INTO `locales_source` VALUES ('86',' modules/comment/comment.module:1283','default','Administration','6.17');
INSERT INTO `locales_source` VALUES ('87',' modules/comment/comment.module:1326,1351,1358','default','Homepage','none');
INSERT INTO `locales_source` VALUES ('88',' modules/comment/comment.module:558,1430','default','Preview comment','6.17');
INSERT INTO `locales_source` VALUES ('89',' modules/comment/comment.module:421','default','Jump to the first comment of this posting.','none');
INSERT INTO `locales_source` VALUES ('90',' modules/comment/comment.module:432','default','Jump to the first new comment of this posting.','none');
INSERT INTO `locales_source` VALUES ('91',' modules/comment/comment.module:441,462','default','Add new comment','6.17');
INSERT INTO `locales_source` VALUES ('92',' modules/comment/comment.module:443','default','Add a new comment to this page.','none');
INSERT INTO `locales_source` VALUES ('93',' modules/comment/comment.module:464','default','Share your thoughts and opinions related to this posting.','6.17');
INSERT INTO `locales_source` VALUES ('94',' modules/comment/comment.module:285,289','default','Recent comments','6.17');
INSERT INTO `locales_source` VALUES ('95',' modules/comment/comment.admin.inc:227','default','The comment no longer exists.','none');
INSERT INTO `locales_source` VALUES ('96',' modules/comment/comment.admin.inc:256','default','The comment and all its replies have been deleted.','none');
INSERT INTO `locales_source` VALUES ('97',' modules/comment/comment.module:533','default','Do not display','6.17');
INSERT INTO `locales_source` VALUES ('98',' modules/comment/comment.module:834,846','default','reply','none');
INSERT INTO `locales_source` VALUES ('99',' modules/comment/comment.module:275','default','administer comments','6.17');
INSERT INTO `locales_source` VALUES ('100',' modules/comment/comment.admin.inc:189','default','Delete comments','none');
INSERT INTO `locales_source` VALUES ('101',' modules/comment/comment-folded.tpl.php:20','default','by','none');
INSERT INTO `locales_source` VALUES ('102',' modules/comment/comment.admin.inc:206','default','The comments have been deleted.','none');
INSERT INTO `locales_source` VALUES ('103',' modules/comment/comment.module:207','default','Published comments','6.17');
INSERT INTO `locales_source` VALUES ('104',' modules/comment/comment.module:781','default','Your comment has been queued for moderation by site administrators and will be published after approval.','none');
INSERT INTO `locales_source` VALUES ('105',' modules/comment/comment.module:493,576','default','Comment settings','6.17');
INSERT INTO `locales_source` VALUES ('106',' modules/comment/comment.module:501,585','default','Read only','6.17');
INSERT INTO `locales_source` VALUES ('107',' modules/comment/comment.module:212','default','Approval queue','6.17');
INSERT INTO `locales_source` VALUES ('108',' captcha.module:33','default','Display on separate page','6.17');
INSERT INTO `locales_source` VALUES ('109',' captcha.module:32','default','Location of comment submission form','6.17');
INSERT INTO `locales_source` VALUES ('110',' modules/comment/comment.module:538','default','Anonymous commenting','6.17');
INSERT INTO `locales_source` VALUES ('111',' modules/comment/comment.module:541','default','Anonymous posters may not enter their contact information','6.17');
INSERT INTO `locales_source` VALUES ('112',' modules/comment/comment.module:542','default','Anonymous posters may leave their contact information','6.17');
INSERT INTO `locales_source` VALUES ('113',' modules/comment/comment.module:543','default','Anonymous posters must leave their contact information','6.17');
INSERT INTO `locales_source` VALUES ('114',' modules/comment/comment.module:544','default','This option is enabled when anonymous users have permission to post comments on the <a href=\"@url\">permissions page</a>.','6.17');
INSERT INTO `locales_source` VALUES ('115',' modules/comment/comment.module:567','default','Display below post or comments','6.17');
INSERT INTO `locales_source` VALUES ('116',' modules/comment/comment.module:499','default','Default comment setting','6.17');
INSERT INTO `locales_source` VALUES ('117',' modules/comment/comment.module:501,585','default','Read/Write','6.17');
INSERT INTO `locales_source` VALUES ('118',' modules/comment/comment.module:502','default','Users with the <em>administer comments</em> permission will be able to override this setting.','6.17');
INSERT INTO `locales_source` VALUES ('119',' modules/comment/comment.module:817','default','parent','none');
INSERT INTO `locales_source` VALUES ('120',' modules/comment/comment.module:1856','default','Flat list - collapsed','6.17');
INSERT INTO `locales_source` VALUES ('121',' modules/comment/comment.module:1857','default','Flat list - expanded','6.17');
INSERT INTO `locales_source` VALUES ('122',' modules/comment/comment.module:1858','default','Threaded list - collapsed','6.17');
INSERT INTO `locales_source` VALUES ('123',' modules/comment/comment.module:1859','default','Threaded list - expanded','6.17');
INSERT INTO `locales_source` VALUES ('124',' modules/comment/comment.module:429','default','1 new comment','none');
INSERT INTO `locales_source` VALUES ('125',' modules/comment/comment.module:429','default','@count new comments','none');
INSERT INTO `locales_source` VALUES ('126',' modules/comment/comment.module:275','default','access comments','6.17');
INSERT INTO `locales_source` VALUES ('127',' modules/comment/comment.module:275','default','post comments','6.17');
INSERT INTO `locales_source` VALUES ('128',' modules/comment/comment.module:275','default','post comments without approval','6.17');
INSERT INTO `locales_source` VALUES ('129',' modules/comment/comment.module:1813','default','<a href=\"@login\">Login</a> to post comments','none');
INSERT INTO `locales_source` VALUES ('130',' modules/comment/comment.pages.inc:102','default','Reply','none');
INSERT INTO `locales_source` VALUES ('131',' modules/comment/comment.admin.inc:141','default','No comments available.','none');
INSERT INTO `locales_source` VALUES ('132',' plugins/content_types/node_context/node_comments.inc:62','default','!a comments per page','none');
INSERT INTO `locales_source` VALUES ('133',' modules/comment/comment.module:228','default','Edit comment','6.17');
INSERT INTO `locales_source` VALUES ('134',' modules/comment/comment.admin.inc:86','default','Please select one or more comments to perform the update on.','none');
INSERT INTO `locales_source` VALUES ('135',' modules/comment/comment.module:2045','default','Unpublish comment','6.17');
INSERT INTO `locales_source` VALUES ('136',' modules/comment/comment.module:2053','default','Unpublish comment containing keyword(s)','6.17');
INSERT INTO `locales_source` VALUES ('137',' modules/comment.rules.inc:18','default','After saving a new comment','6.17');
INSERT INTO `locales_source` VALUES ('138',' modules/comment.rules.inc:23','default','After saving an updated comment','6.17');
INSERT INTO `locales_source` VALUES ('139',' modules/comment.rules.inc:28','default','After deleting a comment','6.17');
INSERT INTO `locales_source` VALUES ('140',' modules/comment/comment.module:2024','default','When a comment is being viewed by an authenticated user','none');
INSERT INTO `locales_source` VALUES ('141',' modules/comment/comment.module:2106,2127','default','Unpublished comment %subject.','none');
INSERT INTO `locales_source` VALUES ('142',' modules/comment/comment.module:2144','default','The comment will be unpublished if it contains any of the character sequences above. Use a comma-separated list of character sequences. Example: funny, bungee jumping, \"Company, Inc.\". Character sequences are case-sensitive.','none');
INSERT INTO `locales_source` VALUES ('143',' modules/comment/comment.module:1051','default','Post new comment','none');
INSERT INTO `locales_source` VALUES ('144',' modules/comment/comment.module:513','default','Default display order','6.17');
INSERT INTO `locales_source` VALUES ('145',' modules/comment/comment.module:516','default','The default sorting for new users and anonymous users while viewing comments. These users may change their view using the comment control panel. For registered users, this change is remembered as a persistent user preference.','6.17');
INSERT INTO `locales_source` VALUES ('146',' modules/comment/comment.module:136','default','Below is a list of the comments posted to your site that need approval. To approve a comment, click on \'edit\' and then change its \'moderation status\' to Approved. Click on a subject to see the comment, the author\'s name to edit the author\'s user information, \'edit\' to modify the text, and \'delete\' to remove their submission.','none');
INSERT INTO `locales_source` VALUES ('147',' modules/comment/comment.module:199','default','List and edit site comments and the comment moderation queue.','6.17');
INSERT INTO `locales_source` VALUES ('148',' modules/comment/comment.module:220','default','Delete comment','6.17');
INSERT INTO `locales_source` VALUES ('149',' modules/comment/comment.module:235','default','Reply to comment','none');
INSERT INTO `locales_source` VALUES ('150',' modules/comment/comment.module:506','default','Default display mode','6.17');
INSERT INTO `locales_source` VALUES ('151',' modules/comment/comment.module:509','default','The default view for comments. Expanded views display the body of the comment. Threaded views keep replies together.','6.17');
INSERT INTO `locales_source` VALUES ('152',' modules/comment/comment.module:520','default','Default comments per page','6.17');
INSERT INTO `locales_source` VALUES ('153',' modules/comment/comment.module:523','default','Default number of comments for each page: more comments are distributed in several pages.','6.17');
INSERT INTO `locales_source` VALUES ('154',' modules/comment/comment.module:527','default','Comment controls','6.17');
INSERT INTO `locales_source` VALUES ('155',' modules/comment/comment.module:530','default','Display above the comments','6.17');
INSERT INTO `locales_source` VALUES ('156',' modules/comment/comment.module:531','default','Display below the comments','6.17');
INSERT INTO `locales_source` VALUES ('157',' modules/comment/comment.module:532','default','Display above and below the comments','6.17');
INSERT INTO `locales_source` VALUES ('158',' modules/comment/comment.module:534','default','Position of the comment controls box. The comment controls let the user change the default display mode and display order of comments.','6.17');
INSERT INTO `locales_source` VALUES ('159',' modules/comment/comment.module:551','default','Comment subject field','6.17');
INSERT INTO `locales_source` VALUES ('160',' modules/comment/comment.module:554','default','Can users provide a unique subject for their comments?','6.17');
INSERT INTO `locales_source` VALUES ('161',' modules/comment/comment.pages.inc:65,105','default','You are not authorized to post comments.','none');
INSERT INTO `locales_source` VALUES ('162',' modules/comment/comment.pages.inc:78,87','default','The comment you are replying to does not exist.','none');
INSERT INTO `locales_source` VALUES ('163',' modules/comment/comment.pages.inc:98','default','This discussion is closed: you can\'t post new comments.','none');
INSERT INTO `locales_source` VALUES ('164',' modules/comment/comment.pages.inc:111','default','You are not authorized to view comments.','none');
INSERT INTO `locales_source` VALUES ('165',' modules/comment/comment.module:771','default','Comment: added %subject.','none');
INSERT INTO `locales_source` VALUES ('166',' modules/comment/comment.admin.inc:244','default','Are you sure you want to delete the comment %title?','none');
INSERT INTO `locales_source` VALUES ('167',' modules/comment/comment.admin.inc:246','default','Any replies to this comment will be lost. This action cannot be undone.','none');
INSERT INTO `locales_source` VALUES ('168',' modules/comment/comment.module:1074,1086','default','Publish the selected comments','none');
INSERT INTO `locales_source` VALUES ('169',' modules/comment/comment.module:1080,1087','default','Unpublish the selected comments','none');
INSERT INTO `locales_source` VALUES ('170',' modules/comment/comment.admin.inc:182','default','There do not appear to be any comments to delete or your selected comment was deleted by another administrator.','none');
INSERT INTO `locales_source` VALUES ('171',' modules/comment/comment.admin.inc:187','default','Are you sure you want to delete these comments and all their children?','none');
INSERT INTO `locales_source` VALUES ('172',' modules/comment/comment.module:1197','default','You have to specify a valid author.','none');
INSERT INTO `locales_source` VALUES ('173',' modules/comment/comment.module:1208','default','The name you used belongs to a registered user.','none');
INSERT INTO `locales_source` VALUES ('174',' modules/comment/comment.module:1213','default','You have to leave your name.','none');
INSERT INTO `locales_source` VALUES ('175',' modules/comment/comment.module:1218','default','The e-mail address you specified is not valid.','none');
INSERT INTO `locales_source` VALUES ('176',' modules/comment/comment.module:1222','default','You have to leave an e-mail address.','none');
INSERT INTO `locales_source` VALUES ('177',' modules/comment/comment.module:1227','default','The URL of your homepage is not valid. Remember that it must be fully qualified, i.e. of the form <code>http://example.com/directory</code>.','none');
INSERT INTO `locales_source` VALUES ('178',' modules/comment/comment.module:1532','default','(No subject)','none');
INSERT INTO `locales_source` VALUES ('179',' modules/comment/comment.module:1651','default','Select your preferred way to display the comments and click \"Save settings\" to activate your changes.','none');
INSERT INTO `locales_source` VALUES ('180',' modules/comment/comment.module:1652','default','Comment viewing options','none');
INSERT INTO `locales_source` VALUES ('181',' modules/comment/comment.module:1809','default','<a href=\"@login\">Login</a> or <a href=\"@register\">register</a> to post comments','none');
INSERT INTO `locales_source` VALUES ('182',' modules/comment/comment.admin.inc:285','default','Comment: deleted %subject.','none');
INSERT INTO `locales_source` VALUES ('183',' modules/comment/comment.admin.inc:56','default','Posted in','none');
INSERT INTO `locales_source` VALUES ('184',' modules/comment/comment.admin.inc:279','default','Cannot delete non-existent comment.','none');
INSERT INTO `locales_source` VALUES ('185',' modules/comment/comment.module:130','default','Comment permissions are assigned to user roles, and are used to determine whether anonymous users (or other roles) are allowed to comment on posts. If anonymous users are allowed to comment, their individual contact information may be retained in cookies stored on their local computer for use in later comment submissions. When a comment has no replies, it may be (optionally) edited by its author. The comment module uses the same input formats and HTML tags available when creating other forms of content.','none');
INSERT INTO `locales_source` VALUES ('186',' modules/comment/comment.module:131','default','For more information, see the online handbook entry for <a href=\"@comment\">Comment module</a>.','none');
INSERT INTO `locales_source` VALUES ('187',' modules/comment/comment.module:134','default','Below is a list of the latest comments posted to your site. Click on a subject to see the comment, the author\'s name to edit the author\'s user information, \'edit\' to modify the text, and \'delete\' to remove their submission.','none');
INSERT INTO `locales_source` VALUES ('188',' modules/comment/comment.module:561','default','Forces a user to look at their comment by clicking on a \'Preview\' button before they can actually add the comment','6.17');
INSERT INTO `locales_source` VALUES ('189',' modules/comment/comment.module:794,793','default','Comment: unauthorized comment submitted or comment submitted to a closed post %subject.','none');
INSERT INTO `locales_source` VALUES ('190',' modules/comment/comment.module:1841','default','Submitted by !username on @datetime.','none');
INSERT INTO `locales_source` VALUES ('191',' modules/comment/comment.module:2037','default','Publish comment','6.17');
INSERT INTO `locales_source` VALUES ('192',' modules/comment/comment.module:129','default','The comment module allows visitors to comment on your posts, creating ad hoc discussion boards. Any <a href=\"@content-type\">content type</a> may have its <em>Default comment setting</em> set to <em>Read/Write</em> to allow comments, or <em>Disabled</em>, to prevent comments. Comment display settings and other controls may also be customized for each content type (some display settings are customizable by individual users).','none');
INSERT INTO `locales_source` VALUES ('193',' modules/comment/comment.module:1075,1081,1088','default','Delete the selected comments','none');
INSERT INTO `locales_source` VALUES ('194',' modules/comment/comment.module:2083','default','Published comment %subject.','none');
INSERT INTO `locales_source` VALUES ('195',' modules/dblog/dblog.admin.inc:91,119','default','No log messages available.','none');
INSERT INTO `locales_source` VALUES ('196',' modules/dblog/dblog.admin.inc:150','default','Location','6.17');
INSERT INTO `locales_source` VALUES ('197',' modules/system.rules_forms.inc:169','default','Severity','none');
INSERT INTO `locales_source` VALUES ('198',' modules/dblog/dblog.admin.inc:107','default','Count','none');
INSERT INTO `locales_source` VALUES ('199',' modules/dblog/dblog.admin.inc:270','default','Filter log messages','none');
INSERT INTO `locales_source` VALUES ('200',' modules/dblog/dblog.admin.inc:307','default','You must select something to filter by.','none');
INSERT INTO `locales_source` VALUES ('201',' modules/dblog/dblog.admin.inc:18','default','Discard log entries above the following row limit','none');
INSERT INTO `locales_source` VALUES ('202',' modules/dblog/dblog.admin.inc:21','default','The maximum number of rows to keep in the database log. Older entries will be automatically discarded. (Requires a correctly configured <a href=\"@cron\">cron maintenance task</a>.)','none');
INSERT INTO `locales_source` VALUES ('203',' modules/dblog/dblog.module:21','default','The dblog module monitors your system, capturing system events in a log to be reviewed by an authorized individual at a later time. This is useful for site administrators who want a quick overview of activities on their site. The logs also record the sequence of events, so it can be useful for debugging site errors.','none');
INSERT INTO `locales_source` VALUES ('204',' modules/dblog/dblog.module:22','default','The dblog log is simply a list of recorded events containing usage data, performance data, errors, warnings and operational information. Administrators should check the dblog report on a regular basis to ensure their site is working properly.','none');
INSERT INTO `locales_source` VALUES ('205',' modules/dblog/dblog.module:23','default','For more information, see the online handbook entry for <a href=\"@dblog\">Dblog module</a>.','none');
INSERT INTO `locales_source` VALUES ('206',' modules/dblog/dblog.module:26','default','The dblog module monitors your website, capturing system events in a log to be reviewed by an authorized individual at a later time. The dblog log is simply a list of recorded events containing usage data, performance data, errors, warnings and operational information. It is vital to check the dblog report on a regular basis as it is often the only way to tell what is going on.','none');
INSERT INTO `locales_source` VALUES ('207',' modules/dblog/dblog.module:47','default','Settings for logging to the Drupal database logs. This is the most common method for small to medium sites on shared hosting. The logs are viewable from the admin pages.','6.17');
INSERT INTO `locales_source` VALUES ('208',' modules/dblog/dblog.module:55','default','Recent log entries','6.17');
INSERT INTO `locales_source` VALUES ('209',' modules/dblog/dblog.module:56','default','View events that have recently been logged.','6.17');
INSERT INTO `locales_source` VALUES ('210',' modules/dblog/dblog.module:63','default','Top \'page not found\' errors','6.17');
INSERT INTO `locales_source` VALUES ('211',' modules/dblog/dblog.module:64','default','View \'page not found\' errors (404s).','6.17');
INSERT INTO `locales_source` VALUES ('212',' modules/dblog/dblog.module:71','default','Top \'access denied\' errors','6.17');
INSERT INTO `locales_source` VALUES ('213',' modules/dblog/dblog.module:72','default','View \'access denied\' errors (403s).','6.17');
INSERT INTO `locales_source` VALUES ('214',' modules/filter/filter.module:680','default','Filter HTML tags','none');
INSERT INTO `locales_source` VALUES ('215',' plugins/content_types/node_form/node_form_input_format.inc:22','default','Input format','6.17');
INSERT INTO `locales_source` VALUES ('216',' modules/filter/filter.module:209','default','Table','6.17');
INSERT INTO `locales_source` VALUES ('217',' modules/filter/filter.admin.inc:130','default','Filters','6.17');
INSERT INTO `locales_source` VALUES ('218',' modules/filter/filter.module:203','default','Preformatted','6.17');
INSERT INTO `locales_source` VALUES ('219',' modules/filter/filter.module:211','default','Deleted','6.17');
INSERT INTO `locales_source` VALUES ('220',' modules/rules.rules_forms.inc:35','default','Greater than','none');
INSERT INTO `locales_source` VALUES ('221',' modules/rules.rules_forms.inc:35','default','Less than','none');
INSERT INTO `locales_source` VALUES ('222',' modules/filter/filter.module:701','default','Spam link deterrent','none');
INSERT INTO `locales_source` VALUES ('223',' modules/filter/filter.module:157','default','administer filters','6.17');
INSERT INTO `locales_source` VALUES ('224',' modules/filter/filter.module:624','default','Line break converter','6.17');
INSERT INTO `locales_source` VALUES ('225',' modules/filter/filter.module:199','default','Underlined','none');
INSERT INTO `locales_source` VALUES ('226',' modules/filter/filter.module:71','default','Input formats','6.17');
INSERT INTO `locales_source` VALUES ('227',' modules/filter/filter.module:221','default','Subtitle','none');
INSERT INTO `locales_source` VALUES ('228',' modules/filter/filter.module:682','default','Escape all tags','none');
INSERT INTO `locales_source` VALUES ('229',' modules/filter/filter.module:682','default','Strip disallowed tags','none');
INSERT INTO `locales_source` VALUES ('230',' modules/filter/filter.pages.inc:35','default','input formats','none');
INSERT INTO `locales_source` VALUES ('231',' modules/filter/filter.module:131','default','Rearrange','6.17');
INSERT INTO `locales_source` VALUES ('232',' modules/filter/filter.module:703','default','If enabled, Drupal will add rel=\"nofollow\" to all links, as a measure to reduce the effectiveness of spam links. Note: this will also prevent valid links from being followed by search engines, therefore it is likely most effective when enabled for anonymous users.','none');
INSERT INTO `locales_source` VALUES ('233',' modules/filter/filter.module:740','default','Maximum link text length','6.17');
INSERT INTO `locales_source` VALUES ('234',' modules/filter/filter.module:743','default','URLs longer than this number of characters will be truncated to prevent long strings that break formatting. The link itself will be retained; just the text portion of the link will be truncated.','6.17');
INSERT INTO `locales_source` VALUES ('235',' modules/filter/filter.module:624,735','default','URL filter','6.17');
INSERT INTO `locales_source` VALUES ('236',' modules/filter/filter.module:205','default','Acronym','6.17');
INSERT INTO `locales_source` VALUES ('237',' modules/filter/filter.module:204','default','Abbreviation','6.17');
INSERT INTO `locales_source` VALUES ('238',' modules/filter/filter.module:212','default','Inserted','6.17');
INSERT INTO `locales_source` VALUES ('239',' modules/filter/filter.admin.inc:33','default','All roles may use default format','6.17');
INSERT INTO `locales_source` VALUES ('240',' modules/filter/filter.admin.inc:33','default','No roles may use this format','6.17');
INSERT INTO `locales_source` VALUES ('241',' modules/filter/filter.admin.inc:38','default','Set default format','6.17');
INSERT INTO `locales_source` VALUES ('242',' modules/filter/filter.admin.inc:45','default','Default format updated.','6.17');
INSERT INTO `locales_source` VALUES ('243',' modules/filter/filter.admin.inc:97','default','All roles for the default format must be enabled and cannot be changed.','6.17');
INSERT INTO `locales_source` VALUES ('244',' modules/filter/filter.admin.inc:104','default','Specify a unique name for this filter format.','6.17');
INSERT INTO `locales_source` VALUES ('245',' modules/filter/filter.admin.inc:111','default','Choose which roles may use this filter format. Note that roles with the \"administer filters\" permission can always use all the filter formats.','6.17');
INSERT INTO `locales_source` VALUES ('246',' modules/filter/filter.admin.inc:131','default','Choose the filters that will be used in this filter format.','6.17');
INSERT INTO `locales_source` VALUES ('247',' modules/filter/filter.admin.inc:149','default','No guidelines available.','none');
INSERT INTO `locales_source` VALUES ('248',' modules/filter/filter.admin.inc:151','default','These are the guidelines that users will see for posting in this input format. They are automatically generated from the filter settings.','6.17');
INSERT INTO `locales_source` VALUES ('249',' modules/filter/filter.admin.inc:168','default','Filter format names need to be unique. A format named %name already exists.','none');
INSERT INTO `locales_source` VALUES ('250',' modules/filter/filter.admin.inc:187','default','Added input format %format.','none');
INSERT INTO `locales_source` VALUES ('251',' modules/filter/filter.admin.inc:190','default','The input format settings have been updated.','6.17');
INSERT INTO `locales_source` VALUES ('252',' modules/filter/filter.admin.inc:252','default','Are you sure you want to delete the input format %format?','none');
INSERT INTO `locales_source` VALUES ('253',' modules/filter/filter.admin.inc:252','default','If you have any content left in this input format, it will be switched to the default input format. This action cannot be undone.','none');
INSERT INTO `locales_source` VALUES ('254',' modules/filter/filter.admin.inc:255','default','The default format cannot be deleted.','none');
INSERT INTO `locales_source` VALUES ('255',' modules/filter/filter.admin.inc:278','default','Deleted input format %format.','none');
INSERT INTO `locales_source` VALUES ('256',' modules/filter/filter.admin.inc:289','default','Configure %format','6.17');
INSERT INTO `locales_source` VALUES ('257',' modules/filter/filter.admin.inc:312','default','No settings are available.','none');
INSERT INTO `locales_source` VALUES ('258',' modules/filter/filter.admin.inc:330','default','Rearrange %format','6.17');
INSERT INTO `locales_source` VALUES ('259',' modules/filter/filter.admin.inc:391','default','The filter ordering has been saved.','none');
INSERT INTO `locales_source` VALUES ('260',' modules/filter/filter.module:23','default','The filter module allows administrators to configure text input formats for use on your site. An input format defines the HTML tags, codes, and other input allowed in both content and comments, and is a key feature in guarding against potentially damaging input from malicious users. Two input formats included by default are <em>Filtered HTML</em> (which allows only an administrator-approved subset of HTML tags) and <em>Full HTML</em> (which allows the full set of HTML tags). Additional input formats may be created by an administrator.','none');
INSERT INTO `locales_source` VALUES ('261',' modules/filter/filter.module:24','default','Each input format uses filters to manipulate text, and most input formats apply several different filters to text in a specific order. Each filter is designed for a specific purpose, and generally either adds, removes or transforms elements within user-entered text before it is displayed. A filter does not change the actual content of a post, but instead, modifies it temporarily before it is displayed. A filter may remove unapproved HTML tags, for instance, while another automatically adds HTML to make links referenced in text clickable.','none');
INSERT INTO `locales_source` VALUES ('262',' modules/filter/filter.module:25','default','Users can choose between the available input formats when creating or editing content. Administrators can configure which input formats are available to which user roles, as well as choose a default input format.','none');
INSERT INTO `locales_source` VALUES ('263',' modules/filter/filter.module:26','default','For more information, see the online handbook entry for <a href=\"@filter\">Filter module</a>.','none');
INSERT INTO `locales_source` VALUES ('264',' modules/filter/filter.module:29','default','<em>Input formats</em> define a way of processing user-supplied text in Drupal. Each input format uses filters to manipulate text, and most input formats apply several different filters to text, in a specific order. Each filter is designed to accomplish a specific purpose, and generally either removes elements from or adds elements to text before it is displayed. Users can choose between the available input formats when submitting content.','6.17');
INSERT INTO `locales_source` VALUES ('265',' modules/filter/filter.module:30','default','Use the list below to configure which input formats are available to which roles, as well as choose a default input format (used for imported content, for example). The default format is always available to users. All input formats are available to users in a role with the \"administer filters\" permission.','6.17');
INSERT INTO `locales_source` VALUES ('266',' modules/filter/filter.module:33','default','Every <em>filter</em> performs one particular change on the user input, for example stripping out malicious HTML or making URLs clickable. Choose which filters you want to apply to text in this input format. If you notice some filters are causing conflicts in the output, you can <a href=\"@rearrange\">rearrange them</a>.','6.17');
INSERT INTO `locales_source` VALUES ('267',' modules/filter/filter.module:35','default','If you cannot find the settings for a certain filter, make sure you have enabled it on the <a href=\"@url\">view tab</a> first.','6.17');
INSERT INTO `locales_source` VALUES ('268',' modules/filter/filter.module:37','default','Because of the flexible filtering system, you might encounter a situation where one filter prevents another from doing its job. For example: a word in an URL gets converted into a glossary term, before the URL can be converted to a clickable link. When this happens, rearrange the order of the filters.','6.17');
INSERT INTO `locales_source` VALUES ('269',' modules/filter/filter.module:38','default','Filters are executed from top-to-bottom. To change the order of the filters, modify the values in the <em>Weight</em> column or grab a drag-and-drop handle under the <em>Name</em> column and drag filters to new locations in the list. (Grab a handle by clicking and holding the mouse while hovering over a handle icon.) Remember that your changes will not be saved until you click the <em>Save configuration</em> button at the bottom of the page.','6.17');
INSERT INTO `locales_source` VALUES ('270',' modules/filter/filter.module:180,182','default','Allowed HTML tags: @tags','6.17');
INSERT INTO `locales_source` VALUES ('271',' modules/filter/filter.module:187','default','\n<p>This site allows HTML content. While learning all of HTML may feel intimidating, learning how to use a very small number of the most basic HTML \"tags\" is very easy. This table provides examples for each tag that is enabled on this site.</p>\n<p>For more information see W3C\'s <a href=\"http://www.w3.org/TR/html/\">HTML Specifications</a> or use your favorite search engine to find other sites that explain HTML.</p>','none');
INSERT INTO `locales_source` VALUES ('272',' modules/filter/filter.module:191','default','Anchors are used to make links to other pages.','none');
INSERT INTO `locales_source` VALUES ('273',' modules/filter/filter.module:192','default','By default line break tags are automatically added, so use this tag to add additional ones. Use of this tag is different because it is not used with an open/close pair like all the others. Use the extra \" /\" inside the tag to maintain XHTML 1.0 compatibility','none');
INSERT INTO `locales_source` VALUES ('274',' modules/filter/filter.module:192','default','Text with <br />line break','none');
INSERT INTO `locales_source` VALUES ('275',' modules/filter/filter.module:193','default','By default paragraph tags are automatically added, so use this tag to add additional ones.','none');
INSERT INTO `locales_source` VALUES ('276',' modules/filter/filter.module:193','default','Paragraph one.','none');
INSERT INTO `locales_source` VALUES ('277',' modules/filter/filter.module:193','default','Paragraph two.','none');
INSERT INTO `locales_source` VALUES ('278',' modules/filter/filter.module:194','default','Strong','none');
INSERT INTO `locales_source` VALUES ('279',' modules/filter/filter.module:195','default','Emphasized','none');
INSERT INTO `locales_source` VALUES ('280',' modules/filter/filter.module:196','default','Cited','none');
INSERT INTO `locales_source` VALUES ('281',' modules/filter/filter.module:197','default','Coded text used to show programming source code','none');
INSERT INTO `locales_source` VALUES ('282',' modules/filter/filter.module:197','default','Coded','none');
INSERT INTO `locales_source` VALUES ('283',' modules/filter/filter.module:198','default','Bolded','none');
INSERT INTO `locales_source` VALUES ('284',' modules/filter/filter.module:200','default','Italicized','none');
INSERT INTO `locales_source` VALUES ('285',' modules/filter/filter.module:201','default','Superscripted','none');
INSERT INTO `locales_source` VALUES ('286',' modules/filter/filter.module:201','default','<sup>Super</sup>scripted','none');
INSERT INTO `locales_source` VALUES ('287',' modules/filter/filter.module:202','default','Subscripted','none');
INSERT INTO `locales_source` VALUES ('288',' modules/filter/filter.module:202','default','<sub>Sub</sub>scripted','none');
INSERT INTO `locales_source` VALUES ('289',' modules/filter/filter.module:204','default','<abbr title=\"Abbreviation\">Abbrev.</abbr>','none');
INSERT INTO `locales_source` VALUES ('290',' modules/filter/filter.module:205','default','<acronym title=\"Three-Letter Acronym\">TLA</acronym>','none');
INSERT INTO `locales_source` VALUES ('291',' modules/filter/filter.module:206','default','Block quoted','none');
INSERT INTO `locales_source` VALUES ('292',' modules/filter/filter.module:207','default','Quoted inline','none');
INSERT INTO `locales_source` VALUES ('293',' modules/filter/filter.module:209','default','Table header','none');
INSERT INTO `locales_source` VALUES ('294',' modules/filter/filter.module:209','default','Table cell','none');
INSERT INTO `locales_source` VALUES ('295',' modules/filter/filter.module:214','default','Ordered list - use the &lt;li&gt; to begin each list item','none');
INSERT INTO `locales_source` VALUES ('296',' modules/filter/filter.module:214,215','default','First item','none');
INSERT INTO `locales_source` VALUES ('297',' modules/filter/filter.module:214,215','default','Second item','none');
INSERT INTO `locales_source` VALUES ('298',' modules/filter/filter.module:215','default','Unordered list - use the &lt;li&gt; to begin each list item','none');
INSERT INTO `locales_source` VALUES ('299',' modules/filter/filter.module:218','default','Definition lists are similar to other HTML lists. &lt;dl&gt; begins the definition list, &lt;dt&gt; begins the definition term and &lt;dd&gt; begins the definition description.','none');
INSERT INTO `locales_source` VALUES ('300',' modules/filter/filter.module:218','default','First term','none');
INSERT INTO `locales_source` VALUES ('301',' modules/filter/filter.module:218','default','First definition','none');
INSERT INTO `locales_source` VALUES ('302',' modules/filter/filter.module:218','default','Second term','none');
INSERT INTO `locales_source` VALUES ('303',' modules/filter/filter.module:218','default','Second definition','none');
INSERT INTO `locales_source` VALUES ('304',' modules/filter/filter.module:222','default','Subtitle three','none');
INSERT INTO `locales_source` VALUES ('305',' modules/filter/filter.module:223','default','Subtitle four','none');
INSERT INTO `locales_source` VALUES ('306',' modules/filter/filter.module:224','default','Subtitle five','none');
INSERT INTO `locales_source` VALUES ('307',' modules/filter/filter.module:225','default','Subtitle six','none');
INSERT INTO `locales_source` VALUES ('308',' modules/filter/filter.module:227','default','Tag Description','none');
INSERT INTO `locales_source` VALUES ('309',' modules/filter/filter.module:227,256','default','You Type','none');
INSERT INTO `locales_source` VALUES ('310',' modules/filter/filter.module:227,256','default','You Get','none');
INSERT INTO `locales_source` VALUES ('311',' modules/filter/filter.module:241','default','No help provided for tag %tag.','none');
INSERT INTO `locales_source` VALUES ('312',' modules/filter/filter.module:247','default','\n<p>Most unusual characters can be directly entered without any problems.</p>\n<p>If you do encounter problems, try using HTML character entities. A common example looks like &amp;amp; for an ampersand &amp; character. For a full list of entities see HTML\'s <a href=\"http://www.w3.org/TR/html4/sgml/entities.html\">entities</a> page. Some of the available characters include:</p>','none');
INSERT INTO `locales_source` VALUES ('313',' modules/filter/filter.module:251','default','Ampersand','none');
INSERT INTO `locales_source` VALUES ('314',' modules/filter/filter.module:254','default','Quotation mark','none');
INSERT INTO `locales_source` VALUES ('315',' modules/filter/filter.module:256','default','Character Description','none');
INSERT INTO `locales_source` VALUES ('316',' modules/filter/filter.module:270','default','No HTML tags allowed','none');
INSERT INTO `locales_source` VALUES ('317',' modules/filter/filter.module:278','default','Lines and paragraphs break automatically.','6.17');
INSERT INTO `locales_source` VALUES ('318',' modules/filter/filter.module:280','default','Lines and paragraphs are automatically recognized. The &lt;br /&gt; line break, &lt;p&gt; paragraph and &lt;/p&gt; close paragraph tags are inserted automatically. If paragraphs are not recognized simply add a couple blank lines.','none');
INSERT INTO `locales_source` VALUES ('319',' modules/filter/filter.module:284','default','Web page addresses and e-mail addresses turn into links automatically.','6.17');
INSERT INTO `locales_source` VALUES ('320',' modules/filter/filter.module:624,675','default','HTML filter','6.17');
INSERT INTO `locales_source` VALUES ('321',' modules/filter/filter.module:624','default','HTML corrector','6.17');
INSERT INTO `locales_source` VALUES ('322',' modules/filter/filter.module:629','default','Allows you to restrict whether users can post HTML and which tags to filter out. It will also remove harmful content such as JavaScript events, JavaScript URLs and CSS styles from those tags that are not removed.','6.17');
INSERT INTO `locales_source` VALUES ('323',' modules/filter/filter.module:631','default','Converts line breaks into HTML (i.e. &lt;br&gt; and &lt;p&gt; tags).','6.17');
INSERT INTO `locales_source` VALUES ('324',' modules/filter/filter.module:633','default','Turns web and e-mail addresses into clickable links.','6.17');
INSERT INTO `locales_source` VALUES ('325',' modules/filter/filter.module:635','default','Corrects faulty and chopped off HTML in postings.','6.17');
INSERT INTO `locales_source` VALUES ('326',' modules/filter/filter.module:683','default','How to deal with HTML tags in user-contributed content. If set to \"Strip disallowed tags\", dangerous tags are removed (see below). If set to \"Escape tags\", all HTML is escaped and presented as it was typed.','none');
INSERT INTO `locales_source` VALUES ('327',' modules/filter/filter.module:691','default','If \"Strip disallowed tags\" is selected, optionally specify tags which should not be stripped. JavaScript event attributes are always stripped.','none');
INSERT INTO `locales_source` VALUES ('328',' modules/filter/filter.module:695','default','Display HTML help','none');
INSERT INTO `locales_source` VALUES ('329',' modules/filter/filter.module:697','default','If enabled, Drupal will display some basic HTML help in the long filter tips.','none');
INSERT INTO `locales_source` VALUES ('330',' modules/filter/filter.module:72','default','Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.','6.17');
INSERT INTO `locales_source` VALUES ('331',' modules/filter/filter.module:91','default','Delete input format','6.17');
INSERT INTO `locales_source` VALUES ('332',' modules/filter/filter.module:99','default','Compose tips','6.17');
INSERT INTO `locales_source` VALUES ('333',' modules/help/help.module:41','default','This guide provides context sensitive help on the use and configuration of <a href=\"@drupal\">Drupal</a> and its modules, and is a supplement to the more extensive online <a href=\"@handbook\">Drupal handbook</a>. The online handbook may contain more up-to-date information, is annotated with helpful user-contributed comments, and serves as the definitive reference point for all Drupal documentation.','none');
INSERT INTO `locales_source` VALUES ('334',' modules/help/help.module:44','default','The help module provides context sensitive help on the use and configuration of <a href=\"@drupal\">Drupal</a> and its modules, and is a supplement to the more extensive online <a href=\"@handbook\">Drupal handbook</a>. The online handbook may contain more up-to-date information, is annotated with helpful user-contributed comments, and serves as the definitive reference point for all Drupal documentation.','none');
INSERT INTO `locales_source` VALUES ('335',' modules/help/help.module:45','default','For more information, see the online handbook entry for <a href=\"@help\">Help module</a>.','none');
INSERT INTO `locales_source` VALUES ('336',' modules/help/help.admin.inc:15','default','Help topics','none');
INSERT INTO `locales_source` VALUES ('337',' modules/help/help.admin.inc:15','default','Help is available on the following items:','none');
INSERT INTO `locales_source` VALUES ('338',' modules/help/help.admin.inc:30','default','No help is available for module %module.','none');
INSERT INTO `locales_source` VALUES ('339',' modules/help/help.admin.inc:41','default','@module administration pages','none');
INSERT INTO `locales_source` VALUES ('340',' rules_admin.module:62;182;213','default','Overview','6.17');
INSERT INTO `locales_source` VALUES ('341',' modules/locale/locale.module:445','default','All','none');
INSERT INTO `locales_source` VALUES ('342',' modules/locale/locale.module:0','default','Mon','6.17');
INSERT INTO `locales_source` VALUES ('343',' modules/locale/locale.module:0','default','Tue','none');
INSERT INTO `locales_source` VALUES ('344',' modules/locale/locale.module:0','default','Wed','6.17');
INSERT INTO `locales_source` VALUES ('345',' modules/locale/locale.module:0','default','Thu','6.17');
INSERT INTO `locales_source` VALUES ('346',' modules/locale/locale.module:0','default','Fri','6.17');
INSERT INTO `locales_source` VALUES ('347',' modules/locale/locale.module:0','default','Sat','none');
INSERT INTO `locales_source` VALUES ('348',' modules/locale/locale.module:0','default','Sun','none');
INSERT INTO `locales_source` VALUES ('349',' modules/locale/locale.module:0','default','May','6.17');
INSERT INTO `locales_source` VALUES ('350',' modules/locale/locale.module:0','default','am','none');
INSERT INTO `locales_source` VALUES ('351',' modules/locale/locale.module:0','default','pm','none');
INSERT INTO `locales_source` VALUES ('352',' modules/locale/locale.module:0','default','Jan','none');
INSERT INTO `locales_source` VALUES ('353',' modules/locale/locale.module:0','default','Feb','6.17');
INSERT INTO `locales_source` VALUES ('354',' modules/locale/locale.module:0','default','Mar','6.17');
INSERT INTO `locales_source` VALUES ('355',' modules/locale/locale.module:0','default','Apr','6.17');
INSERT INTO `locales_source` VALUES ('356',' modules/locale/locale.module:0','default','Jun','6.17');
INSERT INTO `locales_source` VALUES ('357',' modules/locale/locale.module:0','default','Jul','6.17');
INSERT INTO `locales_source` VALUES ('358',' modules/locale/locale.module:0','default','Aug','6.17');
INSERT INTO `locales_source` VALUES ('359',' modules/locale/locale.module:0','default','Sep','6.17');
INSERT INTO `locales_source` VALUES ('360',' modules/locale/locale.module:0','default','Oct','none');
INSERT INTO `locales_source` VALUES ('361',' modules/locale/locale.module:0','default','Nov','none');
INSERT INTO `locales_source` VALUES ('362',' modules/locale/locale.module:0','default','Dec','6.17');
INSERT INTO `locales_source` VALUES ('363',' modules/locale/locale.module:565','default','Language switcher','6.17');
INSERT INTO `locales_source` VALUES ('364',' modules/locale/locale.module:120','default','Translate interface','6.17');
INSERT INTO `locales_source` VALUES ('365',' modules/locale/locale.module:156','default','Edit string','none');
INSERT INTO `locales_source` VALUES ('366',' modules/locale/locale.module:163','default','Delete string','none');
INSERT INTO `locales_source` VALUES ('367',' modules/locale/locale.module:0','default','AM','none');
INSERT INTO `locales_source` VALUES ('368',' modules/locale/locale.module:0','default','PM','none');
INSERT INTO `locales_source` VALUES ('369',' modules/locale/locale.module:262','default','Multilingual support','6.17');
INSERT INTO `locales_source` VALUES ('370',' modules/locale/locale.module:222','default','Language settings','6.17');
INSERT INTO `locales_source` VALUES ('371',' modules/locale/locale.module:104','default','Edit language','none');
INSERT INTO `locales_source` VALUES ('372',' modules/locale/locale.module:24','default','The locale module allows your Drupal site to be presented in languages other than the default English, a defining feature of multi-lingual websites. The locale module works by examining text as it is about to be displayed: when a translation of the text is available in the language to be displayed, the translation is displayed rather than the original text. When a translation is unavailable, the original text is displayed, and then stored for later review by a translator.','none');
INSERT INTO `locales_source` VALUES ('373',' modules/locale/locale.module:25','default','Beyond translation of the Drupal interface, the locale module provides a feature set tailored to the needs of a multi-lingual site. Language negotiation allows your site to automatically change language based on the domain or path used for each request. Users may (optionally) select their preferred language on their <em>My account</em> page, and your site can be configured to honor a web browser\'s preferred language settings. Your site content can be created in (and translated to) any enabled language, and each post may have a language-appropriate alias for each of its translations. The locale module works in concert with the <a href=\"@content-help\">content translation module</a> to manage translated content.','none');
INSERT INTO `locales_source` VALUES ('374',' modules/locale/locale.module:26','default','Translations may be provided by:','none');
INSERT INTO `locales_source` VALUES ('375',' modules/locale/locale.module:27','default','translating the original text via the locale module\'s integrated web interface, or','none');
INSERT INTO `locales_source` VALUES ('376',' modules/locale/locale.module:28','default','importing files from a set of existing translations, known as a translation package. A translation package enables the display of a specific version of Drupal in a specific language, and contain files in the Gettext Portable Object (<em>.po</em>) format. Although not all languages are available for every version of Drupal, translation packages for many languages are available for download from the <a href=\"@translations\">Drupal translation page</a>.','none');
INSERT INTO `locales_source` VALUES ('377',' modules/locale/locale.module:29','default','If an existing translation package does not meet your needs, the Gettext Portable Object (<em>.po</em>) files within a package may be modified, or new <em>.po</em> files may be created, using a desktop Gettext editor. The locale module\'s <a href=\"@import\">import</a> feature allows the translated strings from a new or modified <em>.po</em> file to be added to your site. The locale module\'s <a href=\"@export\">export</a> feature generates files from your site\'s translated strings, that can either be shared with others or edited offline by a Gettext translation editor.','none');
INSERT INTO `locales_source` VALUES ('378',' modules/locale/locale.module:30','default','For more information, see the online handbook entry for <a href=\"@locale\">Locale module</a>.','none');
INSERT INTO `locales_source` VALUES ('379',' modules/locale/locale.module:33','default','This page provides an overview of your site\'s enabled languages. If multiple languages are available and enabled, the text on your site interface may be translated, registered users may select their preferred language on the <em>My account</em> page, and site authors may indicate a specific language when creating posts. The site\'s default language is used for anonymous visitors and for users who have not selected a preferred language.','6.17');
INSERT INTO `locales_source` VALUES ('380',' modules/locale/locale.module:34','default','For each language available on the site, use the <em>edit</em> link to configure language details, including name, an optional language-specific path or domain, and whether the language is natively presented either left-to-right or right-to-left. These languages also appear in the <em>Language</em> selection when creating a post of a content type with multilingual support.','6.17');
INSERT INTO `locales_source` VALUES ('381',' modules/locale/locale.module:35','default','Use the <a href=\"@add-language\">add language page</a> to enable additional languages (and automatically import files from a translation package, if available), the <a href=\"@search\">translate interface page</a> to locate strings for manual translation, or the <a href=\"@import\">import page</a> to add translations from individual <em>.po</em> files. A number of contributed translation packages containing <em>.po</em> files are available on the <a href=\"@translations\">Drupal.org translations page</a>.','6.17');
INSERT INTO `locales_source` VALUES ('382',' modules/locale/locale.module:38','default','Add all languages to be supported by your site. If your desired language is not available in the <em>Language name</em> drop-down, click <em>Custom language</em> and provide a language code and other details manually. When providing a language code manually, be sure to enter a standardized language code, since this code may be used by browsers to determine an appropriate display language.','none');
INSERT INTO `locales_source` VALUES ('383',' modules/locale/locale.module:40','default','Language negotiation settings determine the site\'s presentation language. Available options include:','none');
INSERT INTO `locales_source` VALUES ('384',' modules/locale/locale.module:41','default','<strong>None.</strong> The default language is used for site presentation, though users may (optionally) select a preferred language on the <em>My Account</em> page. (User language preferences will be used for site e-mails, if available.)','none');
INSERT INTO `locales_source` VALUES ('385',' modules/locale/locale.module:42','default','<strong>Path prefix only.</strong> The presentation language is determined by examining the path for a language code or other custom string that matches the path prefix (if any) specified for each language. If a suitable prefix is not identified, the default language is used. <em>Example: \"example.com/de/contact\" sets presentation language to German based on the use of \"de\" within the path.</em>','none');
INSERT INTO `locales_source` VALUES ('386',' modules/locale/locale.module:43','default','<strong>Path prefix with language fallback.</strong> The presentation language is determined by examining the path for a language code or other custom string that matches the path prefix (if any) specified for each language. If a suitable prefix is not identified, the display language is determined by the user\'s language preferences from the <em>My Account</em> page, or by the browser\'s language settings. If a presentation language cannot be determined, the default language is used.','none');
INSERT INTO `locales_source` VALUES ('387',' modules/locale/locale.module:44','default','<strong>Domain name only.</strong> The presentation language is determined by examining the domain used to access the site, and comparing it to the language domain (if any) specified for each language. If a match is not identified, the default language is used. <em>Example: \"http://de.example.com/contact\" sets presentation language to German based on the use of \"http://de.example.com\" in the domain.</em>','none');
INSERT INTO `locales_source` VALUES ('388',' modules/locale/locale.module:45','default','The path prefix or domain name for a language may be set by editing the <a href=\"@languages\">available languages</a>. In the absence of an appropriate match, the site is displayed in the <a href=\"@languages\">default language</a>.','none');
INSERT INTO `locales_source` VALUES ('389',' modules/locale/locale.module:48','default','This page provides an overview of available translatable strings. Drupal displays translatable strings in text groups; modules may define additional text groups containing other translatable strings. Because text groups provide a method of grouping related strings, they are often used to focus translation efforts on specific areas of the Drupal interface.','6.17');
INSERT INTO `locales_source` VALUES ('390',' modules/locale/locale.module:49','default','Review the <a href=\"@languages\">languages page</a> for more information on adding support for additional languages.','6.17');
INSERT INTO `locales_source` VALUES ('391',' modules/locale/locale.module:52','default','This page imports the translated strings contained in an individual Gettext Portable Object (<em>.po</em>) file. Normally distributed as part of a translation package (each translation package may contain several <em>.po</em> files), a <em>.po</em> file may need to be imported after off-line editing in a Gettext translation editor. Importing an individual <em>.po</em> file may be a lengthy process.','6.17');
INSERT INTO `locales_source` VALUES ('392',' modules/locale/locale.module:53','default','Note that the <em>.po</em> files within a translation package are imported automatically (if available) when new modules or themes are enabled, or as new languages are added. Since this page only allows the import of one <em>.po</em> file at a time, it may be simpler to download and extract a translation package into your Drupal installation directory and <a href=\"@language-add\">add the language</a> (which automatically imports all <em>.po</em> files within the package). Translation packages are available for download on the <a href=\"@translations\">Drupal translation page</a>.','6.17');
INSERT INTO `locales_source` VALUES ('393',' modules/locale/locale.module:56','default','This page exports the translated strings used by your site. An export file may be in Gettext Portable Object (<em>.po</em>) form, which includes both the original string and the translation (used to share translations with others), or in Gettext Portable Object Template (<em>.pot</em>) form, which includes the original strings only (used to create new translations with a Gettext translation editor).','none');
INSERT INTO `locales_source` VALUES ('394',' modules/locale/locale.module:58','default','This page allows a translator to search for specific translated and untranslated strings, and is used when creating or editing translations. (Note: For translation tasks involving many strings, it may be more convenient to <a href=\"@export\">export</a> strings for off-line editing in a desktop Gettext translation editor.) Searches may be limited to strings found within a specific text group or in a specific language.','none');
INSERT INTO `locales_source` VALUES ('395',' modules/locale/locale.module:61','default','This block is only shown if <a href=\"@languages\">at least two languages are enabled</a> and <a href=\"@configuration\">language negotiation</a> is set to something other than <em>None</em>.','none');
INSERT INTO `locales_source` VALUES ('396',' modules/locale/locale.module:196','default','Built-in interface','6.17');
INSERT INTO `locales_source` VALUES ('397',' modules/locale/locale.module:233','default','This account\'s default language for e-mails, and preferred language for site presentation.','none');
INSERT INTO `locales_source` VALUES ('398',' modules/locale/locale.module:233','default','This account\'s default language for e-mails.','6.17');
INSERT INTO `locales_source` VALUES ('399',' modules/locale/locale.module:253','default','A path alias set for a specific language will always be used when displaying this page in that language, and takes precedence over path aliases set for <em>All languages</em>.','none');
INSERT INTO `locales_source` VALUES ('400',' modules/locale/locale.module:265','default','Enable multilingual support for this content type. If enabled, a language selection field will be added to the editing form, allowing you to select from one of the <a href=\"!languages\">enabled languages</a>. If disabled, new posts are saved with the default language. Existing content will not be affected by changing this option.','6.17');
INSERT INTO `locales_source` VALUES ('401',' modules/locale/locale.module:187','default','administer languages','6.17');
INSERT INTO `locales_source` VALUES ('402',' modules/locale/locale.module:187','default','translate interface','6.17');
INSERT INTO `locales_source` VALUES ('403',' modules/locale/locale.module:77','default','Configure languages for content and the user interface.','6.17');
INSERT INTO `locales_source` VALUES ('404',' modules/locale/locale.module:121','default','Translate the built in interface and optionally other text.','6.17');
INSERT INTO `locales_source` VALUES ('405',' modules/locale/locale.module:0','default','!long-month-name January','none');
INSERT INTO `locales_source` VALUES ('406',' modules/locale/locale.module:0','default','!long-month-name February','none');
INSERT INTO `locales_source` VALUES ('407',' modules/locale/locale.module:0','default','!long-month-name March','none');
INSERT INTO `locales_source` VALUES ('408',' modules/locale/locale.module:0','default','!long-month-name April','none');
INSERT INTO `locales_source` VALUES ('409',' modules/locale/locale.module:0','default','!long-month-name May','none');
INSERT INTO `locales_source` VALUES ('410',' modules/locale/locale.module:0','default','!long-month-name June','none');
INSERT INTO `locales_source` VALUES ('411',' modules/locale/locale.module:0','default','!long-month-name July','6.17');
INSERT INTO `locales_source` VALUES ('412',' modules/locale/locale.module:0','default','!long-month-name August','6.17');
INSERT INTO `locales_source` VALUES ('413',' modules/locale/locale.module:0','default','!long-month-name September','none');
INSERT INTO `locales_source` VALUES ('414',' modules/locale/locale.module:0','default','!long-month-name October','none');
INSERT INTO `locales_source` VALUES ('415',' modules/locale/locale.module:0','default','!long-month-name November','none');
INSERT INTO `locales_source` VALUES ('416',' modules/locale/locale.module:0','default','!long-month-name December','none');
INSERT INTO `locales_source` VALUES ('417',' modules/menu/menu.module:96','default','Add item','6.17');
INSERT INTO `locales_source` VALUES ('418',' modules/menu/menu.admin.inc:176','default','Menu item','6.17');
INSERT INTO `locales_source` VALUES ('419',' modules/menu/menu.admin.inc:178,300','default','Expanded','6.17');
INSERT INTO `locales_source` VALUES ('420',' modules/menu/menu.admin.inc:261','default','The path this menu item links to. This can be an internal Drupal path such as %add-node or an external URL such as %drupal. Enter %front to link to the front page.','6.17');
INSERT INTO `locales_source` VALUES ('421',' modules/menu/menu.admin.inc:302','default','If selected and this menu item has children, the menu will always appear expanded.','6.17');
INSERT INTO `locales_source` VALUES ('422',' modules/menu/menu.admin.inc:105','default','reset','6.17');
INSERT INTO `locales_source` VALUES ('423',' modules/menu/menu.module:63','default','Add menu','6.17');
INSERT INTO `locales_source` VALUES ('424',' modules/menu/menu.admin.inc:573','default','Are you sure you want to delete the custom menu item %item?','6.17');
INSERT INTO `locales_source` VALUES ('425',' modules/menu/menu.admin.inc:583','default','The menu item %title has been deleted.','6.17');
INSERT INTO `locales_source` VALUES ('426',' modules/menu/menu.admin.inc:584','default','Deleted menu item %title.','none');
INSERT INTO `locales_source` VALUES ('427',' modules/menu/menu.module:104','default','Edit menu','6.17');
INSERT INTO `locales_source` VALUES ('428',' modules/menu/menu.module:112','default','Delete menu','none');
INSERT INTO `locales_source` VALUES ('429',' modules/menu/menu.module:120','default','Edit menu item','6.17');
INSERT INTO `locales_source` VALUES ('430',' modules/menu/menu.module:128','default','Reset menu item','6.17');
INSERT INTO `locales_source` VALUES ('431',' modules/menu/menu.module:136','default','Delete menu item','6.17');
INSERT INTO `locales_source` VALUES ('432',' modules/menu/menu.admin.inc:290','default','The description displayed when hovering over a menu item.','6.17');
INSERT INTO `locales_source` VALUES ('433',' modules/menu/menu.admin.inc:625','default','No primary links','6.17');
INSERT INTO `locales_source` VALUES ('434',' modules/menu/menu.admin.inc:628','default','Source for the primary links','6.17');
INSERT INTO `locales_source` VALUES ('435',' modules/menu/menu.admin.inc:632','default','Select what should be displayed as the primary links.','6.17');
INSERT INTO `locales_source` VALUES ('436',' modules/menu/menu.admin.inc:635','default','No secondary links','6.17');
INSERT INTO `locales_source` VALUES ('437',' modules/menu/menu.admin.inc:638','default','Source for the secondary links','6.17');
INSERT INTO `locales_source` VALUES ('438',' modules/menu/menu.admin.inc:296','default','Menu items that are not enabled will not be listed in any menu.','6.17');
INSERT INTO `locales_source` VALUES ('439',' modules/menu/menu.module:30','default','To rearrange menu items, grab a drag-and-drop handle under the <em>Menu item</em> column and drag the items (or group of items) to a new location in the list. (Grab a handle by clicking and holding the mouse while hovering over a handle icon.) Remember that your changes will not be saved until you click the <em>Save configuration</em> button at the bottom of the page.','6.17');
INSERT INTO `locales_source` VALUES ('440',' modules/menu/menu.module:57','default','List menus','6.17');
INSERT INTO `locales_source` VALUES ('441',' modules/menu/menu.module:80','default','Customize menu','none');
INSERT INTO `locales_source` VALUES ('442',' modules/menu/menu.module:90','default','List items','6.17');
INSERT INTO `locales_source` VALUES ('443',' plugins/content_types/block/block.inc:279;359','default','Menus','6.17');
INSERT INTO `locales_source` VALUES ('444',' modules/menu/menu.module:49','default','Control your site\'s navigation menu, primary links and secondary links. as well as rename and reorganize menu items.','6.17');
INSERT INTO `locales_source` VALUES ('445',' modules/menu/menu.admin.inc:593','default','Are you sure you want to reset the item %item to its default values?','6.17');
INSERT INTO `locales_source` VALUES ('446',' modules/menu/menu.admin.inc:593','default','Any customizations will be lost. This action cannot be undone.','6.17');
INSERT INTO `locales_source` VALUES ('447',' modules/menu/menu.admin.inc:602','default','The menu item was reset to its default settings.','6.17');
INSERT INTO `locales_source` VALUES ('448',' modules/menu/menu.module:40','default','administer menu','6.17');
INSERT INTO `locales_source` VALUES ('449',' modules/menu/menu.admin.inc:55','default','There are no menu items yet.','6.17');
INSERT INTO `locales_source` VALUES ('450',' modules/menu/menu.admin.inc:282','default','The link text corresponding to this item that should appear in the menu.','6.17');
INSERT INTO `locales_source` VALUES ('451',' modules/menu/menu.admin.inc:412','default','Menu name','6.17');
INSERT INTO `locales_source` VALUES ('452',' modules/menu/menu.admin.inc:414','default','The machine-readable name of this menu. This text will be used for constructing the URL of the <em>menu overview</em> page for this menu. This name must contain only lowercase letters, numbers, and hyphens, and must be unique.','6.17');
INSERT INTO `locales_source` VALUES ('453',' modules/menu/menu.admin.inc:469','default','Are you sure you want to delete the custom menu %title?','none');
INSERT INTO `locales_source` VALUES ('454',' modules/menu/menu.admin.inc:511','default','The menu name may only consist of lowercase letters, numbers, and hyphens.','6.17');
INSERT INTO `locales_source` VALUES ('455',' modules/menu/menu.admin.inc:521','default','The menu already exists.','none');
INSERT INTO `locales_source` VALUES ('456',' modules/menu/menu.admin.inc:466','default','<strong>Warning:</strong> There is currently 1 menu item in %title. It will be deleted (system-defined items will be reset).','none');
INSERT INTO `locales_source` VALUES ('457',' modules/menu/menu.admin.inc:466','default','<strong>Warning:</strong> There are currently @count menu items in %title. They will be deleted (system-defined items will be reset).','none');
INSERT INTO `locales_source` VALUES ('458',' modules/menu/menu.admin.inc:514','default','The menu name can\'t be longer than 1 character.','none');
INSERT INTO `locales_source` VALUES ('459',' modules/menu/menu.admin.inc:514','default','The menu name can\'t be longer than @count characters.','none');
INSERT INTO `locales_source` VALUES ('460',' modules/menu/menu.module:32','default','Enter the title and path for your new menu item.','none');
INSERT INTO `locales_source` VALUES ('461',' modules/menu/menu.admin.inc:501','default','The custom menu %title has been deleted.','none');
INSERT INTO `locales_source` VALUES ('462',' modules/menu/menu.admin.inc:502','default','Deleted custom menu %title and all its menu items.','none');
INSERT INTO `locales_source` VALUES ('463',' modules/menu/menu.admin.inc:618','default','Default menu for content','6.17');
INSERT INTO `locales_source` VALUES ('464',' modules/menu/menu.admin.inc:621','default','Choose the menu to be the default in the menu options in the content authoring form.','6.17');
INSERT INTO `locales_source` VALUES ('465',' modules/menu/menu.module:381','default','Delete this menu item.','6.17');
INSERT INTO `locales_source` VALUES ('466',' modules/menu/menu.module:396','default','The link text corresponding to this item that should appear in the menu. Leave blank if you do not wish to add this post to the menu.','6.17');
INSERT INTO `locales_source` VALUES ('467',' modules/menu/menu.admin.inc:612','default','The menu module allows on-the-fly creation of menu links in the content authoring forms. The following option sets the default menu in which a new link will be added.','6.17');
INSERT INTO `locales_source` VALUES ('468',' modules/menu/menu.admin.inc:642','default','Select what should be displayed as the secondary links. You can choose the same menu for secondary links as for primary links (currently %primary). If you do this, the children of the active primary menu link will be displayed as secondary links.','6.17');
INSERT INTO `locales_source` VALUES ('469',' modules/menu/menu.module:21','default','The menu module provides an interface to control and customize Drupal\'s powerful menu system. Menus are a hierarchical collection of links, or menu items, used to navigate a website, and are positioned and displayed using Drupal\'s flexible block system. By default, three menus are created during installation: <em>Navigation</em>, <em>Primary links</em>, and <em>Secondary links</em>. The <em>Navigation</em> menu contains most links necessary for working with and navigating your site, and is often displayed in either the left or right sidebar. Most Drupal themes also provide support for <em>Primary links</em> and <em>Secondary links</em>, by displaying them in either the header or footer of each page. By default, <em>Primary links</em> and <em>Secondary links</em> contain no menu items but may be configured to contain custom menu items specific to your site.','6.17');
INSERT INTO `locales_source` VALUES ('470',' modules/menu/menu.module:22','default','The <a href=\"@menu\">menus page</a> displays all menus currently available on your site. Select a menu from this list to add or edit a menu item, or to rearrange items within the menu. Create new menus using the <a href=\"@add-menu\">add menu page</a> (the block containing a new menu must also be enabled on the <a href=\"@blocks\">blocks administration page</a>).','6.17');
INSERT INTO `locales_source` VALUES ('471',' modules/menu/menu.module:23','default','For more information, see the online handbook entry for <a href=\"@menu\">Menu module</a>.','6.17');
INSERT INTO `locales_source` VALUES ('472',' modules/menu/menu.module:26','default','Menus are a collection of links (menu items) used to navigate a website. The menus currently available on your site are displayed below. Select a menu from this list to manage its menu items.','6.17');
INSERT INTO `locales_source` VALUES ('473',' modules/menu/menu.install:12','default','The navigation menu is provided by Drupal and is the main interactive menu for any site. It is usually the only menu that contains personalized links for authenticated users, and is often not even visible to anonymous users.','none');
INSERT INTO `locales_source` VALUES ('474',' modules/menu/menu.install:13','default','Primary links are often used at the theme layer to show the major sections of a site. A typical representation for primary links would be tabs along the top.','none');
INSERT INTO `locales_source` VALUES ('475',' modules/menu/menu.install:14','default','Secondary links are often used for pages like legal notices, contact details, and other secondary navigation items that play a lesser role than primary links','none');
INSERT INTO `locales_source` VALUES ('476',' modules/node/node.module:1365','default','Read more','none');
INSERT INTO `locales_source` VALUES ('477',' modules/node/node.module:1119','default','Log','none');
INSERT INTO `locales_source` VALUES ('478',' modules/node/content_types.inc:143','default','Explanation or submission guidelines','6.17');
INSERT INTO `locales_source` VALUES ('479',' modules/node/node.admin.inc:155','default','category','none');
INSERT INTO `locales_source` VALUES ('480',' modules/node/node.module:804','default','The username %name does not exist.','none');
INSERT INTO `locales_source` VALUES ('481',' modules/node/node.module:1852,1904','default','Advanced search','none');
INSERT INTO `locales_source` VALUES ('482',' modules/node/node.admin.inc:151','default','type','6.17');
INSERT INTO `locales_source` VALUES ('483',' modules/node/node.pages.inc:505','default','Are you sure you want to delete %title?','none');
INSERT INTO `locales_source` VALUES ('484',' modules/node/node.module:1768','default','RSS','6.17');
INSERT INTO `locales_source` VALUES ('485',' modules/node/content_types.inc:116','default','Title field label','6.17');
INSERT INTO `locales_source` VALUES ('486',' modules/node/content_types.inc:129','default','Body field label','6.17');
INSERT INTO `locales_source` VALUES ('487',' modules/node/node.module:1554,1564','default','Revisions','none');
INSERT INTO `locales_source` VALUES ('488',' modules/node/node.pages.inc:163','default','Log message','6.17');
INSERT INTO `locales_source` VALUES ('489',' modules/node/content_types.inc:335','default','node','6.17');
INSERT INTO `locales_source` VALUES ('490',' modules/node/node.module:1125','default','access content','6.17');
INSERT INTO `locales_source` VALUES ('491',' modules/node/node.module:1478','default','Create content','6.17');
INSERT INTO `locales_source` VALUES ('492',' plugins/content_types/node_form/node_form_author.inc:22','default','Authoring information','6.17');
INSERT INTO `locales_source` VALUES ('493',' modules/node/node.pages.inc:192','default','Format: %time. Leave blank to use the time of form submission.','6.17');
INSERT INTO `locales_source` VALUES ('494',' modules/node/node.pages.inc:186','default','Leave blank for %anonymous.','6.17');
INSERT INTO `locales_source` VALUES ('495',' modules/node/node.admin.inc:611','default','Are you sure you want to delete these items?','6.17');
INSERT INTO `locales_source` VALUES ('496',' modules/node/node.admin.inc:621','default','The items have been deleted.','6.17');
INSERT INTO `locales_source` VALUES ('497',' modules/node/node.admin.inc:513','default','No items selected.','none');
INSERT INTO `locales_source` VALUES ('498',' modules/node/node.admin.inc:135,492','default','published','6.17');
INSERT INTO `locales_source` VALUES ('499',' plugins/content_types/node_form/node_form_publishing.inc:27','default','Publishing options','6.17');
INSERT INTO `locales_source` VALUES ('500',' rules_admin.sets.inc:87 rules_admin.module:86','default','Revert','none');
INSERT INTO `locales_source` VALUES ('501',' modules/node/node.module:1632,1638,1639','default','Syndicate','6.17');
INSERT INTO `locales_source` VALUES ('502',' modules/node/node.module:1125','default','view revisions','6.17');
INSERT INTO `locales_source` VALUES ('503',' modules/node/node.pages.inc:528','default','Revisions for %title','none');
INSERT INTO `locales_source` VALUES ('504',' modules/node/node.pages.inc:548,554','default','!date by !username','none');
INSERT INTO `locales_source` VALUES ('505',' rules_admin.inc:310 rules_admin.sets.inc:28','default','revert','none');
INSERT INTO `locales_source` VALUES ('506',' modules/node/node.pages.inc:530','default','Revision','none');
INSERT INTO `locales_source` VALUES ('507',' modules/node/node.pages.inc:551','default','current revision','none');
INSERT INTO `locales_source` VALUES ('508',' modules/node/node.admin.inc:33','default','Length of trimmed posts','none');
INSERT INTO `locales_source` VALUES ('509',' modules/node/node.admin.inc:36','default','200 characters','none');
INSERT INTO `locales_source` VALUES ('510',' modules/node/node.admin.inc:37','default','400 characters','none');
INSERT INTO `locales_source` VALUES ('511',' modules/node/node.admin.inc:38','default','600 characters','none');
INSERT INTO `locales_source` VALUES ('512',' modules/node/node.admin.inc:39','default','800 characters','none');
INSERT INTO `locales_source` VALUES ('513',' modules/node/node.admin.inc:40','default','1000 characters','none');
INSERT INTO `locales_source` VALUES ('514',' modules/node/node.admin.inc:41','default','1200 characters','none');
INSERT INTO `locales_source` VALUES ('515',' modules/node/node.admin.inc:42','default','1400 characters','none');
INSERT INTO `locales_source` VALUES ('516',' modules/node/node.admin.inc:43','default','1600 characters','none');
INSERT INTO `locales_source` VALUES ('517',' modules/node/node.admin.inc:44','default','1800 characters','none');
INSERT INTO `locales_source` VALUES ('518',' modules/node/node.admin.inc:45','default','2000 characters','none');
INSERT INTO `locales_source` VALUES ('519',' modules/node/node.admin.inc:47','default','The maximum number of characters used in the trimmed version of a post. Drupal will use this setting to determine at which offset long posts should be trimmed. The trimmed version of a post is typically used as a teaser when displaying the post on the main page, in XML feeds, etc. To disable teasers, set to \'Unlimited\'. Note that this setting will only affect new or updated content and will not affect existing teasers.','none');
INSERT INTO `locales_source` VALUES ('520',' modules/node/node.module:983','default','@type: deleted %title.','none');
INSERT INTO `locales_source` VALUES ('521',' modules/node/node.module:1099','default','Revision of %title from %date','none');
INSERT INTO `locales_source` VALUES ('522',' modules/node/node.module:2692','default','The username of the user to which you would like to assign ownership.','none');
INSERT INTO `locales_source` VALUES ('523',' modules/node/node.module:2731','default','Please enter a valid username.','none');
INSERT INTO `locales_source` VALUES ('524',' modules/node/node.module:1125','default','administer nodes','6.17');
INSERT INTO `locales_source` VALUES ('525',' modules/node/node.admin.inc:136,492','default','not published','6.17');
INSERT INTO `locales_source` VALUES ('526',' modules/node/node.admin.inc:140','default','not sticky','6.17');
INSERT INTO `locales_source` VALUES ('527',' modules/node/node.admin.inc:139','default','sticky','6.17');
INSERT INTO `locales_source` VALUES ('528',' modules/node/node.admin.inc:138','default','not promoted','6.17');
INSERT INTO `locales_source` VALUES ('529',' modules/node/node.admin.inc:137','default','promoted','6.17');
INSERT INTO `locales_source` VALUES ('530',' modules/node/content_types.inc:154','default','Default options','6.17');
INSERT INTO `locales_source` VALUES ('531',' modules/node/content_types.inc:42','default','No content types available.','none');
INSERT INTO `locales_source` VALUES ('532',' modules/node/node.admin.inc:361','default','The update has encountered an error.','none');
INSERT INTO `locales_source` VALUES ('533',' modules/node/node.admin.inc:428','default','1 item successfully processed:','none');
INSERT INTO `locales_source` VALUES ('534',' modules/node/node.admin.inc:428','default','@count items successfully processed:','none');
INSERT INTO `locales_source` VALUES ('535',' modules/node/node.admin.inc:90','default','Publish','6.17');
INSERT INTO `locales_source` VALUES ('536',' modules/node/node.admin.inc:95','default','Unpublish','6.17');
INSERT INTO `locales_source` VALUES ('537',' modules/node/content_types.inc:192','default','Save content type','6.17');
INSERT INTO `locales_source` VALUES ('538',' modules/node/node.pages.inc:574','default','Are you sure you want to revert to the revision from %revision-date?','none');
INSERT INTO `locales_source` VALUES ('539',' modules/node/node.pages.inc:594','default','Are you sure you want to delete the revision from %revision-date?','none');
INSERT INTO `locales_source` VALUES ('540',' modules/node/node.module:1125','default','revert revisions','6.17');
INSERT INTO `locales_source` VALUES ('541',' modules/node/node.pages.inc:601','default','@type: deleted %title revision %revision.','none');
INSERT INTO `locales_source` VALUES ('542',' modules/node/node.pages.inc:438','default','Preview trimmed version','6.17');
INSERT INTO `locales_source` VALUES ('543',' modules/node/node.pages.inc:440','default','Preview full version','6.17');
INSERT INTO `locales_source` VALUES ('544',' modules/node/node.module:791','default','The body of your @type is too short. You need at least %words words.','none');
INSERT INTO `locales_source` VALUES ('545',' modules/node/node.module:795','default','This content has been modified by another user, changes cannot be saved.','6.17');
INSERT INTO `locales_source` VALUES ('546',' modules/node/node.admin.inc:212','default','Show only items where','6.17');
INSERT INTO `locales_source` VALUES ('547',' modules/node/node.pages.inc:466','default','@type: updated %title.','none');
INSERT INTO `locales_source` VALUES ('548',' modules/node/node.pages.inc:462','default','@type: added %title.','none');
INSERT INTO `locales_source` VALUES ('549',' modules/node/content_types.inc:403','default','The content type %name has been deleted.','none');
INSERT INTO `locales_source` VALUES ('550',' modules/node/content_types.inc:404','default','Deleted content type %name.','none');
INSERT INTO `locales_source` VALUES ('551',' modules/node/node.admin.inc:100','default','Promote to front page','6.17');
INSERT INTO `locales_source` VALUES ('552',' modules/node/node.module:1863','default','Containing any of the words','none');
INSERT INTO `locales_source` VALUES ('553',' modules/node/node.module:1869','default','Containing the phrase','none');
INSERT INTO `locales_source` VALUES ('554',' modules/node/node.module:1875','default','Containing none of the words','none');
INSERT INTO `locales_source` VALUES ('555',' modules/node/node.module:1884','default','Only in the category(s)','none');
INSERT INTO `locales_source` VALUES ('556',' modules/node/node.module:1897','default','Only of the type(s)','none');
INSERT INTO `locales_source` VALUES ('557',' modules/node/node.module:1164','default','Content ranking','none');
INSERT INTO `locales_source` VALUES ('558',' modules/node/node.module:1168','default','The following numbers control which properties the content search should favor when ordering the results. Higher numbers mean more influence, zero means the property is ignored. Changing these numbers does not require the search index to be rebuilt. Changes take effect immediately.','none');
INSERT INTO `locales_source` VALUES ('559',' modules/node/node.module:1171','default','Keyword relevance','none');
INSERT INTO `locales_source` VALUES ('560',' modules/node/node.module:1172','default','Recently posted','none');
INSERT INTO `locales_source` VALUES ('561',' modules/node/node.module:1174','default','Number of comments','none');
INSERT INTO `locales_source` VALUES ('562',' modules/node/node.module:1177','default','Number of views','none');
INSERT INTO `locales_source` VALUES ('563',' modules/node/node.module:1331','default','Factor','none');
INSERT INTO `locales_source` VALUES ('564',' modules/node/node.module:2397','default','The content access permissions have been rebuilt.','none');
INSERT INTO `locales_source` VALUES ('565',' modules/node/node.module:2504','default','When either saving a new post or updating an existing post','none');
INSERT INTO `locales_source` VALUES ('566',' modules/node/node.module:2507','default','After saving a new post','none');
INSERT INTO `locales_source` VALUES ('567',' modules/node/node.module:2510','default','After saving an updated post','none');
INSERT INTO `locales_source` VALUES ('568',' modules/node/node.module:2513','default','After deleting a post','none');
INSERT INTO `locales_source` VALUES ('569',' modules/node/node.module:2516','default','When content is viewed by an authenticated user','none');
INSERT INTO `locales_source` VALUES ('570',' modules/node/node.module:2530','default','Publish post','6.17');
INSERT INTO `locales_source` VALUES ('571',' modules/node/node.module:2540','default','Unpublish post','6.17');
INSERT INTO `locales_source` VALUES ('572',' modules/node/node.module:2550','default','Make post sticky','6.17');
INSERT INTO `locales_source` VALUES ('573',' modules/node/node.module:2560','default','Make post unsticky','6.17');
INSERT INTO `locales_source` VALUES ('574',' modules/node/node.module:2570','default','Promote post to front page','6.17');
INSERT INTO `locales_source` VALUES ('575',' modules/node/node.module:2580','default','Remove post from front page','6.17');
INSERT INTO `locales_source` VALUES ('576',' modules/node/node.module:2590','default','Change the author of a post','6.17');
INSERT INTO `locales_source` VALUES ('577',' modules/node/node.module:2601','default','Save post','6.17');
INSERT INTO `locales_source` VALUES ('578',' modules/node/node.module:2609','default','Unpublish post containing keyword(s)','6.17');
INSERT INTO `locales_source` VALUES ('579',' modules/node/node.module:2624','default','Set @type %title to published.','none');
INSERT INTO `locales_source` VALUES ('580',' modules/node/node.module:2633,2768','default','Set @type %title to unpublished.','none');
INSERT INTO `locales_source` VALUES ('581',' modules/node/node.module:2642','default','Set @type %title to sticky.','none');
INSERT INTO `locales_source` VALUES ('582',' modules/node/node.module:2651','default','Set @type %title to unsticky.','none');
INSERT INTO `locales_source` VALUES ('583',' modules/node/node.module:2660','default','Promoted @type %title to front page.','none');
INSERT INTO `locales_source` VALUES ('584',' modules/node/node.module:2669','default','Removed @type %title from front page.','none');
INSERT INTO `locales_source` VALUES ('585',' modules/node/node.module:2678','default','Saved @type %title','none');
INSERT INTO `locales_source` VALUES ('586',' modules/node/node.module:2688','default','Changed owner of @type %title to uid %name.','none');
INSERT INTO `locales_source` VALUES ('587',' modules/node/node.module:2745','default','The post will be unpublished if it contains any of the character sequences above. Use a comma-separated list of character sequences. Example: funny, bungee jumping, \"Company, Inc.\". Character sequences are case-sensitive.','none');
INSERT INTO `locales_source` VALUES ('588',' modules/node/node.admin.inc:146','default','Up to date translation','none');
INSERT INTO `locales_source` VALUES ('589',' modules/node/node.admin.inc:147','default','Outdated translation','none');
INSERT INTO `locales_source` VALUES ('590',' modules/node/node.admin.inc:230','default','<em>and</em> where <strong>%a</strong> is <strong>%b</strong>','none');
INSERT INTO `locales_source` VALUES ('591',' modules/node/node.admin.inc:233','default','<strong>%a</strong> is <strong>%b</strong>','6.17');
INSERT INTO `locales_source` VALUES ('592',' modules/node/node.pages.inc:57','default','Create @name','6.17');
INSERT INTO `locales_source` VALUES ('593',' modules/node/node.module:984','default','@type %title has been deleted.','6.17');
INSERT INTO `locales_source` VALUES ('594',' modules/node/content_types.inc:200,282','default','Delete content type','6.17');
INSERT INTO `locales_source` VALUES ('595',' modules/node/content_types.inc:136','default','Minimum number of words','6.17');
INSERT INTO `locales_source` VALUES ('596',' modules/node/node.pages.inc:149','default','Revision information','6.17');
INSERT INTO `locales_source` VALUES ('597',' modules/node/node.pages.inc:463','default','@type %title has been created.','6.17');
INSERT INTO `locales_source` VALUES ('598',' modules/node/node.pages.inc:467','default','@type %title has been updated.','6.17');
INSERT INTO `locales_source` VALUES ('599',' modules/node/node.pages.inc:477','default','The post could not be saved.','none');
INSERT INTO `locales_source` VALUES ('600',' modules/node/node.module:1780','default','For more information, please refer to the <a href=\"@help\">help section</a>, or the <a href=\"@handbook\">online Drupal handbooks</a>. You may also post at the <a href=\"@forum\">Drupal forum</a>, or view the wide range of <a href=\"@support\">other support options</a> available.','6.17');
INSERT INTO `locales_source` VALUES ('601',' modules/node/node.module:2489','default','Submitted by !username on @datetime','6.17');
INSERT INTO `locales_source` VALUES ('602',' modules/node/node.admin.inc:52','default','Preview post','none');
INSERT INTO `locales_source` VALUES ('603',' modules/node/node.admin.inc:55','default','Must users preview posts before submitting?','none');
INSERT INTO `locales_source` VALUES ('604',' modules/node/node.pages.inc:166','default','An explanation of the additions or updates being made to help other authors understand your motivations.','6.17');
INSERT INTO `locales_source` VALUES ('605',' modules/node/content_types.inc:139','default','The minimum number of words for the body field to be considered valid for this content type. This can be useful to rule out submissions that do not meet the site\'s standards, such as short test posts.','6.17');
INSERT INTO `locales_source` VALUES ('606',' modules/node/content_types.inc:331','default','The content type %name has been updated.','6.17');
INSERT INTO `locales_source` VALUES ('607',' modules/node/content_types.inc:334','default','The content type %name has been added.','6.17');
INSERT INTO `locales_source` VALUES ('608',' modules/node/content_types.inc:75','default','The human-readable name of this content type. This text will be displayed as part of the list on the <em>create content</em> page. It is recommended that this name begin with a capital letter and contain only letters, numbers, and <strong>spaces</strong>. This name must be unique.','6.17');
INSERT INTO `locales_source` VALUES ('609',' modules/node/content_types.inc:86','default','The machine-readable name of this content type. This text will be used for constructing the URL of the <em>create content</em> page for this content type. This name must contain only lowercase letters, numbers, and underscores. Underscores will be converted into hyphens when constructing the URL of the <em>create content</em> page. This name must be unique.','6.17');
INSERT INTO `locales_source` VALUES ('610',' modules/node/content_types.inc:98','default','The machine-readable name of this content type. This field cannot be modified for system-defined content types.','6.17');
INSERT INTO `locales_source` VALUES ('611',' modules/node/content_types.inc:106','default','A brief description of this content type. This text will be displayed as part of the list on the <em>create content</em> page.','6.17');
INSERT INTO `locales_source` VALUES ('612',' modules/node/content_types.inc:111','default','Submission form settings','6.17');
INSERT INTO `locales_source` VALUES ('613',' modules/node/content_types.inc:125','default','This content type does not have a title field.','none');
INSERT INTO `locales_source` VALUES ('614',' modules/node/content_types.inc:132','default','To omit the body field for this content type, remove any text and leave this field blank.','6.17');
INSERT INTO `locales_source` VALUES ('615',' modules/node/content_types.inc:145','default','This text will be displayed at the top of the submission form for this content type. It is useful for helping or instructing your users.','6.17');
INSERT INTO `locales_source` VALUES ('616',' modules/node/content_types.inc:149','default','Workflow settings','6.17');
INSERT INTO `locales_source` VALUES ('617',' modules/node/content_types.inc:162','default','Users with the <em>administer nodes</em> permission will be able to override these options.','6.17');
INSERT INTO `locales_source` VALUES ('618',' modules/node/content_types.inc:231','default','The machine-readable name %type is already taken.','none');
INSERT INTO `locales_source` VALUES ('619',' modules/node/content_types.inc:234','default','The machine-readable name must contain only lowercase letters, numbers, and underscores.','none');
INSERT INTO `locales_source` VALUES ('620',' modules/node/content_types.inc:239','default','Invalid machine-readable name. Please enter a name other than %invalid.','none');
INSERT INTO `locales_source` VALUES ('621',' modules/node/content_types.inc:246','default','The human-readable name %name is already taken.','none');
INSERT INTO `locales_source` VALUES ('622',' modules/node/content_types.inc:326','default','The content type %name has been reset to its default values.','none');
INSERT INTO `locales_source` VALUES ('623',' modules/node/content_types.inc:383','default','Are you sure you want to delete the content type %type?','none');
INSERT INTO `locales_source` VALUES ('624',' modules/node/content_types.inc:335','default','Added content type %name.','none');
INSERT INTO `locales_source` VALUES ('625',' modules/node/content_types.inc:350','default','Changed the content type of 1 post from %old-type to %type.','none');
INSERT INTO `locales_source` VALUES ('626',' modules/node/content_types.inc:350','default','Changed the content type of @count posts from %old-type to %type.','none');
INSERT INTO `locales_source` VALUES ('627',' modules/node/content_types.inc:388','default','<strong>Warning:</strong> there is currently 1 %type post on your site. It may not be able to be displayed or edited correctly, once you have removed this content type.','none');
INSERT INTO `locales_source` VALUES ('628',' modules/node/content_types.inc:388','default','<strong>Warning:</strong> there are currently @count %type posts on your site. They may not be able to be displayed or edited correctly, once you have removed this content type.','none');
INSERT INTO `locales_source` VALUES ('629',' modules/node/node.admin.inc:13','default','If the site is experiencing problems with permissions to content, you may have to rebuild the permissions cache. Possible causes for permission problems are disabling modules or configuration changes to permissions. Rebuilding will remove all privileges to posts, and replace them with permissions based on the current modules and settings.','none');
INSERT INTO `locales_source` VALUES ('630',' modules/node/node.admin.inc:14','default','Rebuilding may take some time if there is a lot of content or complex permission settings. After rebuilding has completed posts will automatically use the new permissions.','none');
INSERT INTO `locales_source` VALUES ('631',' modules/node/node.admin.inc:18','default','Node access status','none');
INSERT INTO `locales_source` VALUES ('632',' modules/node/node.admin.inc:28','default','Number of posts on main page','none');
INSERT INTO `locales_source` VALUES ('633',' modules/node/node.admin.inc:30','default','The default maximum number of posts to display per page on overview pages such as the main page.','none');
INSERT INTO `locales_source` VALUES ('634',' modules/node/node.admin.inc:72','default','Are you sure you want to rebuild the permissions on site content?','none');
INSERT INTO `locales_source` VALUES ('635',' modules/node/node.admin.inc:73','default','This action rebuilds all permissions on site content, and may be a lengthy process. This action cannot be undone.','none');
INSERT INTO `locales_source` VALUES ('636',' modules/node/node.admin.inc:105','default','Demote from front page','6.17');
INSERT INTO `locales_source` VALUES ('637',' modules/node/node.admin.inc:110','default','Make sticky','6.17');
INSERT INTO `locales_source` VALUES ('638',' modules/node/node.admin.inc:115','default','Remove stickiness','6.17');
INSERT INTO `locales_source` VALUES ('639',' modules/node/node.admin.inc:160','default','language','6.17');
INSERT INTO `locales_source` VALUES ('640',' modules/node/node.admin.inc:427','default','An error occurred and processing did not complete.','none');
INSERT INTO `locales_source` VALUES ('641',' modules/node/node.pages.inc:284','default','Show summary in full view','6.17');
INSERT INTO `locales_source` VALUES ('642',' modules/node/node.pages.inc:437','default','The trimmed version of your post shows what your post looks like when promoted to the main page or when exported for syndication.<span class=\"no-js\"> You can insert the delimiter \"&lt;!--break--&gt;\" (without the quotes) to fine-tune where your post gets split.</span>','6.17');
INSERT INTO `locales_source` VALUES ('643',' modules/node/node.pages.inc:580','default','Copy of the revision from %date.','none');
INSERT INTO `locales_source` VALUES ('644',' modules/node/node.pages.inc:588','default','@type %title has been reverted back to the revision from %revision-date.','none');
INSERT INTO `locales_source` VALUES ('645',' modules/node/node.pages.inc:602','default','Revision from %revision-date of @type %title has been deleted.','none');
INSERT INTO `locales_source` VALUES ('646',' modules/node/node.pages.inc:587','default','@type: reverted %title revision %revision.','none');
INSERT INTO `locales_source` VALUES ('647',' modules/node/node.module:35','default','The content access permissions need to be rebuilt.','none');
INSERT INTO `locales_source` VALUES ('648',' modules/node/node.module:38','default','The content access permissions need to be rebuilt. Please visit <a href=\"@node_access_rebuild\">this page</a>.','none');
INSERT INTO `locales_source` VALUES ('649',' modules/node/node.module:45','default','The node module manages content on your site, and stores all posts (regardless of type) as a \"node\". In addition to basic publishing settings, including whether the post has been published, promoted to the site front page, or should remain present (or sticky) at the top of lists, the node module also records basic information about the author of a post. Optional revision control over edits is available. For additional functionality, the node module is often extended by other modules.','6.17');
INSERT INTO `locales_source` VALUES ('650',' modules/node/node.module:46','default','Though each post on your site is a node, each post is also of a particular <a href=\"@content-type\">content type</a>. <a href=\"@content-type\">Content types</a> are used to define the characteristics of a post, including the title and description of the fields displayed on its add and edit pages. Each content type may have different default settings for <em>Publishing options</em> and other workflow controls. By default, the two content types in a standard Drupal installation are <em>Page</em> and <em>Story</em>. Use the <a href=\"@content-type\">content types page</a> to add new or edit existing content types. Additional content types also become available as you enable additional core, contributed and custom modules.','6.17');
INSERT INTO `locales_source` VALUES ('651',' modules/node/node.module:47','default','The administrative <a href=\"@content\">content page</a> allows you to review and manage your site content. The <a href=\"@post-settings\">post settings page</a> sets certain options for the display of posts. The node module makes a number of permissions available for each content type, which may be set by role on the <a href=\"@permissions\">permissions page</a>.','6.17');
INSERT INTO `locales_source` VALUES ('652',' modules/node/node.module:48','default','For more information, see the online handbook entry for <a href=\"@node\">Node module</a>.','6.17');
INSERT INTO `locales_source` VALUES ('653',' modules/node/node.module:53','default','Below is a list of all the content types on your site. All posts that exist on your site are instances of one of these content types.','6.17');
INSERT INTO `locales_source` VALUES ('654',' modules/node/node.module:55','default','To create a new content type, enter the human-readable name, the machine-readable name, and all other relevant fields that are on this page. Once created, users of your site will be able to create posts that are instances of this content type.','6.17');
INSERT INTO `locales_source` VALUES ('655',' modules/node/node.module:57','default','The revisions let you track differences between multiple versions of a post.','none');
INSERT INTO `locales_source` VALUES ('656',' modules/node/node.module:266','default','You specified that the summary should not be shown when this post is displayed in full view. This setting is ignored when the summary is empty.','none');
INSERT INTO `locales_source` VALUES ('657',' modules/node/node.module:270','default','You specified that the summary should not be shown when this post is displayed in full view. This setting has been ignored since you have not defined a summary for the post. (To define a summary, insert the delimiter \"&lt;!--break--&gt;\" (without the quotes) in the Body of the post to indicate the end of the summary and the start of the main content.)','none');
INSERT INTO `locales_source` VALUES ('658',' modules/node/node.module:1369','default','Read the rest of !title.','none');
INSERT INTO `locales_source` VALUES ('659',' modules/node/node.module:1772','default','<h1 class=\"title\">Welcome to your new Drupal website!</h1><p>Please follow these steps to set up and start using your website:</p>','6.17');
INSERT INTO `locales_source` VALUES ('660',' modules/node/node.module:1775','default','<strong>Configure your website</strong> Once logged in, visit the <a href=\"@admin\">administration section</a>, where you can <a href=\"@config\">customize and configure</a> all aspects of your website.','6.17');
INSERT INTO `locales_source` VALUES ('661',' modules/node/node.module:1776','default','<strong>Enable additional functionality</strong> Next, visit the <a href=\"@modules\">module list</a> and enable features which suit your specific needs. You can find additional modules in the <a href=\"@download_modules\">Drupal modules download section</a>.','6.17');
INSERT INTO `locales_source` VALUES ('662',' modules/node/node.module:1777','default','<strong>Customize your website design</strong> To change the \"look and feel\" of your website, visit the <a href=\"@themes\">themes section</a>. You may choose from one of the included themes or download additional themes from the <a href=\"@download_themes\">Drupal themes download section</a>.','6.17');
INSERT INTO `locales_source` VALUES ('663',' modules/node/node.module:1778','default','<strong>Start posting content</strong> Finally, you can <a href=\"@content\">create content</a> for your website. This message will disappear once you have promoted a post to the front page.','6.17');
INSERT INTO `locales_source` VALUES ('664',' modules/node/node.module:2321','default','Rebuilding content access permissions','none');
INSERT INTO `locales_source` VALUES ('665',' modules/node/node.module:2351','default','Content permissions have been rebuilt.','none');
INSERT INTO `locales_source` VALUES ('666',' modules/node/node.module:2401','default','The content access permissions have not been properly rebuilt.','none');
INSERT INTO `locales_source` VALUES ('667',' modules/node/node.module:1125','default','administer content types','6.17');
INSERT INTO `locales_source` VALUES ('668',' modules/node/node.module:1420','default','View, edit, and delete your site\'s content.','6.17');
INSERT INTO `locales_source` VALUES ('669',' modules/node/node.module:1434','default','Post settings','6.17');
INSERT INTO `locales_source` VALUES ('670',' modules/node/node.module:1435','default','Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.','6.17');
INSERT INTO `locales_source` VALUES ('671',' modules/node/node.module:1453','default','Manage posts by content type, including default status, front page promotion, etc.','6.17');
INSERT INTO `locales_source` VALUES ('672',' modules/node/node.module:1464','default','Add content type','6.17');
INSERT INTO `locales_source` VALUES ('673',' modules/node/node.module:1573','default','Revert to earlier revision','none');
INSERT INTO `locales_source` VALUES ('674',' modules/node/node.module:1583','default','Delete earlier revision','none');
INSERT INTO `locales_source` VALUES ('675',' modules/system.rules.inc:88','default','Home','6.17');
INSERT INTO `locales_source` VALUES ('676',' modules/node.rules.inc:191;201','default','Title','6.17');
INSERT INTO `locales_source` VALUES ('677',' plugins/content_types/custom/custom.inc:108','default','Body','6.17');
INSERT INTO `locales_source` VALUES ('678',' modules/user.rules.inc:265','default','user','6.17');
INSERT INTO `locales_source` VALUES ('679',' captcha.admin.inc:137','default','Save configuration','6.17');
INSERT INTO `locales_source` VALUES ('680',' modules/color/color.module:286; modules/node/content_types.inc:208,279,306,325; modules/system/system.admin.inc:263,554; modules/system/system.module:1074,1097,1107; modules/update/update.settings.inc:94','default','Reset to defaults','6.17');
INSERT INTO `locales_source` VALUES ('681',' captcha.admin.inc:59','default','delete','6.17');
INSERT INTO `locales_source` VALUES ('682',' rules_admin.inc:296 rules_admin.sets.inc:16','default','Status','6.17');
INSERT INTO `locales_source` VALUES ('683',' modules/comment/comment.module:1317,1348,1356; modules/user/user.admin.inc:754,810','default','E-mail','6.17');
INSERT INTO `locales_source` VALUES ('684',' captcha.admin.inc:330','default','Delete','6.17');
INSERT INTO `locales_source` VALUES ('685',' captcha.admin.inc:147','default','Operations','6.17');
INSERT INTO `locales_source` VALUES ('686',' rules.api.php:607 modules/node.rules.inc:112;168;176;190 modules/path.rules.inc:58 modules/rules.rules.inc:414 modules/taxonomy.rules.inc:82;96','default','Content','6.17');
INSERT INTO `locales_source` VALUES ('687',' install.php:1049; modules/node/node.module:2708,2717; modules/user/user.admin.inc:134,754,799,916; modules/user/user.module:664,1277,1486','default','Username','6.17');
INSERT INTO `locales_source` VALUES ('688',' pathauto.module:188','default','content','6.17');
INSERT INTO `locales_source` VALUES ('689',' modules/php.rules_forms.inc:18','default','Type','6.17');
INSERT INTO `locales_source` VALUES ('690',' plugins/content_types/node_context/node_author.inc:35','default','Author','6.17');
INSERT INTO `locales_source` VALUES ('691',' modules/forum/forum.module:560; modules/tracker/tracker.pages.inc:65','default','Replies','none');
INSERT INTO `locales_source` VALUES ('692',' plugins/styles/list.inc:20','default','List','6.17');
INSERT INTO `locales_source` VALUES ('693',' token_actions.module:85','default','Subject','none');
INSERT INTO `locales_source` VALUES ('694',' modules/menu/menu.admin.inc:73; modules/menu/menu.module:245','default','disabled','6.17');
INSERT INTO `locales_source` VALUES ('695',' modules/locale/locale.module:111; modules/system/system.module:1214','default','Confirm','6.17');
INSERT INTO `locales_source` VALUES ('696',' rules_admin.rule_forms.inc:807 rules_admin.sets.inc:62;87','default','Cancel','6.17');
INSERT INTO `locales_source` VALUES ('697',' rules_admin.inc:37','default','Description','6.17');
INSERT INTO `locales_source` VALUES ('698',' plugins/access/node_language.inc:39,  plugins/access/site_language.inc:36','default','Language','6.17');
INSERT INTO `locales_source` VALUES ('699',' modules/aggregator/aggregator.module:157; modules/node/node.module:1485','default','RSS feed','6.17');
INSERT INTO `locales_source` VALUES ('700',' plugins/task_handlers/panel_context.inc:428','default','Disabled','6.17');
INSERT INTO `locales_source` VALUES ('701',' plugins/task_handlers/panel_context.inc:432','default','Enabled','6.17');
INSERT INTO `locales_source` VALUES ('702',' plugins/content_types/node_context/node_comments.inc:32','default','Comments','6.17');
INSERT INTO `locales_source` VALUES ('703',' includes/theme.inc:1482; modules/comment/comment.module:1694,1719','default','new','none');
INSERT INTO `locales_source` VALUES ('704',' token_actions.module:144','default','error','6.17');
INSERT INTO `locales_source` VALUES ('705',' modules/taxonomy/taxonomy.module:112; modules/taxonomy/taxonomy.info:0; modules/trigger/trigger.module:76','default','Taxonomy','6.17');
INSERT INTO `locales_source` VALUES ('706',' modules/php.rules_forms.inc:33','default','Yes','6.17');
INSERT INTO `locales_source` VALUES ('707',' modules/php.rules_forms.inc:36','default','No','6.17');
INSERT INTO `locales_source` VALUES ('708',' themes/garland/color/color.inc:8; themes/garland/minnelli/color/color.inc:8','default','Blue Lagoon (Default)','none');
INSERT INTO `locales_source` VALUES ('709',' themes/garland/color/color.inc:9; themes/garland/minnelli/color/color.inc:9','default','Ash','none');
INSERT INTO `locales_source` VALUES ('710',' themes/garland/color/color.inc:10; themes/garland/minnelli/color/color.inc:10','default','Aquamarine','none');
INSERT INTO `locales_source` VALUES ('711',' themes/garland/color/color.inc:11; themes/garland/minnelli/color/color.inc:11','default','Belgian Chocolate','none');
INSERT INTO `locales_source` VALUES ('712',' themes/bluemarine/bluemarine.info:0; themes/garland/color/color.inc:12; themes/garland/minnelli/color/color.inc:12','default','Bluemarine','none');
INSERT INTO `locales_source` VALUES ('713',' themes/garland/color/color.inc:13; themes/garland/minnelli/color/color.inc:13','default','Citrus Blast','none');
INSERT INTO `locales_source` VALUES ('714',' themes/garland/color/color.inc:14; themes/garland/minnelli/color/color.inc:14','default','Cold Day','none');
INSERT INTO `locales_source` VALUES ('715',' themes/garland/color/color.inc:15; themes/garland/minnelli/color/color.inc:15','default','Greenbeam','none');
INSERT INTO `locales_source` VALUES ('716',' themes/garland/color/color.inc:16; themes/garland/minnelli/color/color.inc:16','default','Mediterrano','none');
INSERT INTO `locales_source` VALUES ('717',' themes/garland/color/color.inc:17; themes/garland/minnelli/color/color.inc:17','default','Mercury','none');
INSERT INTO `locales_source` VALUES ('718',' themes/garland/color/color.inc:18; themes/garland/minnelli/color/color.inc:18','default','Nocturnal','none');
INSERT INTO `locales_source` VALUES ('719',' themes/garland/color/color.inc:19; themes/garland/minnelli/color/color.inc:19','default','Olivia','none');
INSERT INTO `locales_source` VALUES ('720',' themes/garland/color/color.inc:20; themes/garland/minnelli/color/color.inc:20','default','Pink Plastic','none');
INSERT INTO `locales_source` VALUES ('721',' themes/garland/color/color.inc:21; themes/garland/minnelli/color/color.inc:21','default','Shiny Tomato','none');
INSERT INTO `locales_source` VALUES ('722',' themes/garland/color/color.inc:22; themes/garland/minnelli/color/color.inc:22','default','Teal Top','none');
INSERT INTO `locales_source` VALUES ('723',' rules.api.php:186 modules/node.rules_forms.inc:18','default','Content types','6.17');
INSERT INTO `locales_source` VALUES ('724',' rules_admin.rule_forms.inc:139 rules_admin.sets.inc:158','default','Categories','6.17');
INSERT INTO `locales_source` VALUES ('725',' modules/aggregator/aggregator.admin.inc:174,338; modules/blogapi/blogapi.module:238,300; modules/book/book.admin.inc:130,236; modules/comment/comment.admin.inc:110; modules/comment/comment.module:708,771; modules/contact/contact.admin.inc:115,121; module','default','view','6.17');
INSERT INTO `locales_source` VALUES ('726',' install.php:289; modules/taxonomy/taxonomy.admin.inc:676','default','Advanced options','none');
INSERT INTO `locales_source` VALUES ('727',' rules_admin.module:147','default','Edit','6.17');
INSERT INTO `locales_source` VALUES ('728',' modules/dblog/dblog.admin.inc:59,142; modules/statistics/statistics.admin.inc:158','default','Date','6.17');
INSERT INTO `locales_source` VALUES ('729',' includes/locale.inc:565,592; modules/locale/locale.module:132; modules/search/search.module:159,1053,1073,169; modules/search/search.info:0','default','Search','6.17');
INSERT INTO `locales_source` VALUES ('730',' modules/dblog/dblog.admin.inc:295,325; modules/menu/menu.admin.inc:593; modules/node/node.admin.inc:250,328; modules/path/path.admin.inc:212; modules/user/user.admin.inc:82,111','default','Reset','6.17');
INSERT INTO `locales_source` VALUES ('731',' rules_admin.rule_forms.inc:807 rules_admin.sets.inc:62;87','default','This action cannot be undone.','6.17');
INSERT INTO `locales_source` VALUES ('732',' token_actions.module:93,156','default','Message','none');
INSERT INTO `locales_source` VALUES ('733',' includes/form.inc:1605; modules/user/user.module:670,1285','default','Password','6.17');
INSERT INTO `locales_source` VALUES ('734',' rules_admin.rule_forms.inc:150;434;498;563','default','Weight','6.17');
INSERT INTO `locales_source` VALUES ('735',' modules/system/system.admin.inc:313,562,936; modules/system/system.module:1111','default','The configuration options have been saved.','6.17');
INSERT INTO `locales_source` VALUES ('736',' modules/comment/comment.module:560; modules/node/node.admin.inc:54; modules/taxonomy/taxonomy.admin.inc:166','default','Required','6.17');
INSERT INTO `locales_source` VALUES ('737',' modules/forum/forum.admin.inc:276; modules/taxonomy/taxonomy.admin.inc:695','default','root','none');
INSERT INTO `locales_source` VALUES ('738',' modules/book/book.admin.inc:218; modules/forum/forum.admin.inc:50,131','default','Parent','6.17');
INSERT INTO `locales_source` VALUES ('739',' captcha.admin.inc:13 image_captcha/image_captcha.admin.inc:128;150','default','none','6.17');
INSERT INTO `locales_source` VALUES ('740',' rules_admin.inc:296 rules_admin.sets.inc:16','default','Category','6.17');
INSERT INTO `locales_source` VALUES ('741',' price.module:110','default','Settings','6.17');
INSERT INTO `locales_source` VALUES ('742',' modules/aggregator/aggregator.module:99; modules/contact/contact.module:59','default','Add category','none');
INSERT INTO `locales_source` VALUES ('743',' rules_admin.sets.inc:16','default','Name','6.17');
INSERT INTO `locales_source` VALUES ('744',' includes/locale.inc:89,2076; modules/aggregator/aggregator.admin.inc:30,41; modules/book/book.admin.inc:237; modules/comment/comment.admin.inc:71; modules/comment/comment.module:830,841; modules/contact/contact.admin.inc:16; modules/menu/menu.admin.inc:9','default','edit','6.17');
INSERT INTO `locales_source` VALUES ('745',' includes/pager.inc:396; modules/book/book-navigation.tpl.php:40','default','Go to previous page','none');
INSERT INTO `locales_source` VALUES ('746',' includes/pager.inc:397; modules/book/book-navigation.tpl.php:46','default','Go to next page','none');
INSERT INTO `locales_source` VALUES ('747',' price.module:92','default','Import','6.17');
INSERT INTO `locales_source` VALUES ('748',' modules/book/book.admin.inc:17; modules/book/book.module:418; modules/book/book.info:0','default','Book','none');
INSERT INTO `locales_source` VALUES ('749',' price.module:101','default','Export','6.17');
INSERT INTO `locales_source` VALUES ('750',' includes/display-edit.inc:213,  plugins/task_handlers/panel_context.inc:112;117;450','default','Preview','6.17');
INSERT INTO `locales_source` VALUES ('751',' captcha.admin.inc:289','default','Save','6.17');
INSERT INTO `locales_source` VALUES ('752',' modules/help/help.module:14; modules/help/help.info:0','default','Help','6.17');
INSERT INTO `locales_source` VALUES ('753',' rules_admin.inc:354','default','Default','6.17');
INSERT INTO `locales_source` VALUES ('754',' page_manager/page_manager.admin.inc:795,  plugins/access/node_access.inc:39','default','Update','6.17');
INSERT INTO `locales_source` VALUES ('755',' modules/locale/locale.module:0; modules/system/system.admin.inc:1524','default','Sunday','none');
INSERT INTO `locales_source` VALUES ('756',' modules/locale/locale.module:0; modules/system/system.admin.inc:1524','default','Monday','none');
INSERT INTO `locales_source` VALUES ('757',' modules/locale/locale.module:0; modules/system/system.admin.inc:1524','default','Tuesday','none');
INSERT INTO `locales_source` VALUES ('758',' modules/locale/locale.module:0; modules/system/system.admin.inc:1524','default','Wednesday','6.17');
INSERT INTO `locales_source` VALUES ('759',' modules/locale/locale.module:0; modules/system/system.admin.inc:1524','default','Thursday','6.17');
INSERT INTO `locales_source` VALUES ('760',' modules/locale/locale.module:0; modules/system/system.admin.inc:1524','default','Friday','6.17');
INSERT INTO `locales_source` VALUES ('761',' modules/locale/locale.module:0; modules/system/system.admin.inc:1524','default','Saturday','none');
INSERT INTO `locales_source` VALUES ('762',' modules/comment/comment.admin.inc:57; modules/statistics/statistics.pages.inc:13','default','Time','none');
INSERT INTO `locales_source` VALUES ('763',' page_manager/plugins/tasks/page.inc:304,  page_manager/plugins/tasks/term_view.inc:133,  plugins/access/node_access.inc:38','default','View','6.17');
INSERT INTO `locales_source` VALUES ('764',' modules/system/system.admin.inc:556; modules/system/system.module:1108','default','The configuration options have been reset to their default values.','none');
INSERT INTO `locales_source` VALUES ('765',' token_actions.module:202','default','URL','none');
INSERT INTO `locales_source` VALUES ('766',' page_manager/page_manager.admin.inc:73;250,  page_manager/plugins/tasks/page.admin.inc:394;1240;1366,  page_manager/plugins/tasks/page.inc:629','default','Path','6.17');
INSERT INTO `locales_source` VALUES ('767',' modules/system/system.module:314; modules/update/update.report.inc:220','default','Modules','6.17');
INSERT INTO `locales_source` VALUES ('768',' modules/menu/menu.info:0','default','Menu','6.17');
INSERT INTO `locales_source` VALUES ('769',' modules/aggregator/aggregator.info:0; modules/blog/blog.info:0; modules/blogapi/blogapi.info:0; modules/book/book.info:0; modules/color/color.info:0; modules/comment/comment.info:0; modules/contact/contact.info:0; modules/dblog/dblog.info:0; modules/foru','default','Core - optional','6.17');
INSERT INTO `locales_source` VALUES ('770',' modules/aggregator/aggregator.admin.inc:30; modules/aggregator/aggregator.pages.inc:485; modules/user/user.admin.inc:193','default','never','none');
INSERT INTO `locales_source` VALUES ('771',' includes/mail.inc:134; modules/contact/contact.admin.inc:115,121,148; modules/contact/contact.pages.inc:146,231','default','mail','none');
INSERT INTO `locales_source` VALUES ('772',' includes/actions.inc:85,331,353,388,396; modules/trigger/trigger.admin.inc:87','default','actions','none');
INSERT INTO `locales_source` VALUES ('773',' modules/aggregator/aggregator.admin.inc:161,174,325,338; modules/aggregator/aggregator.pages.inc:16; modules/aggregator/aggregator.module:607,641,646,715','default','aggregator','none');
INSERT INTO `locales_source` VALUES ('774',' modules/aggregator/aggregator.pages.inc:363; modules/node/node.module:1724','default','read more','none');
INSERT INTO `locales_source` VALUES ('775',' modules/system/system.admin.inc:215; modules/system/system.module:713','default','Screenshot for %theme theme','6.17');
INSERT INTO `locales_source` VALUES ('776',' modules/system/system.admin.inc:215; modules/system/system.module:713','default','no screenshot','6.17');
INSERT INTO `locales_source` VALUES ('777',' modules/statistics/statistics.admin.inc:14; modules/statistics/statistics.pages.inc:46','default','Timestamp','none');
INSERT INTO `locales_source` VALUES ('778',' modules/comment/comment.module:2142; modules/node/node.module:2743','default','Keywords','none');
INSERT INTO `locales_source` VALUES ('779',' modules/statistics/statistics.admin.inc:188; modules/statistics/statistics.module:136','default','Access log settings','none');
INSERT INTO `locales_source` VALUES ('780',' modules/trigger/trigger.admin.inc:77; modules/trigger/trigger.module:114','default','Unassign','none');
INSERT INTO `locales_source` VALUES ('781',' modules/statistics/statistics.info:0','default','Statistics','none');
INSERT INTO `locales_source` VALUES ('782',' modules/blogapi/blogapi.module:760; modules/upload/upload.admin.inc:118','default','Settings for @role','none');
INSERT INTO `locales_source` VALUES ('783',' modules/blogapi/blogapi.module:766; modules/upload/upload.admin.inc:124','default','Permitted file extensions','6.17');
INSERT INTO `locales_source` VALUES ('784',' modules/blogapi/blogapi.module:769; modules/upload/upload.admin.inc:127','default','Extensions that users in this role can upload. Separate extensions with a space and do not include the leading dot.','none');
INSERT INTO `locales_source` VALUES ('785',' includes/locale.inc:517; modules/blogapi/blogapi.module:259; modules/filter/filter.module:466; modules/forum/forum-submitted.tpl.php:27; modules/translation/translation.pages.inc:48','default','n/a','6.17');
INSERT INTO `locales_source` VALUES ('786',' modules/upload/upload.info:0; sites/all/modules/imce/js/imce.js','default','Upload','6.17');
INSERT INTO `locales_source` VALUES ('787',' modules/rules.rules.inc:432 modules/user.rules.inc:98','default','User','6.17');
INSERT INTO `locales_source` VALUES ('788',' token_actions.module:141','default','action','none');
INSERT INTO `locales_source` VALUES ('789',' includes/content.inc:539,  page_manager/page_manager.admin.inc:559','default','Configure','6.17');
INSERT INTO `locales_source` VALUES ('790',' modules/node/node.admin.inc:133; modules/user/user.module:2029','default','status','6.17');
INSERT INTO `locales_source` VALUES ('791',' includes/display-edit.inc:705;874;980;1092;1217;1511;1584;1653;1716;1733,  plugins/layouts/flexible/flexible.inc:703;855','default','Error','6.17');
INSERT INTO `locales_source` VALUES ('792',' modules/contact/contact.module:93,100; modules/contact/contact.info:0','default','Contact','none');
INSERT INTO `locales_source` VALUES ('793',' plugins/access/node_access.inc:23,  plugins/access/node_language.inc:22,  plugins/access/node_type.inc:21,  plugins/content_types/node/node.inc:15','default','Node','6.17');
INSERT INTO `locales_source` VALUES ('794',' modules/book/book.module:349; modules/menu/menu.admin.inc:313; modules/menu/menu.module:407','default','Parent item','6.17');
INSERT INTO `locales_source` VALUES ('795',' modules/menu/menu.admin.inc:324; modules/menu/menu.module:420','default','Optional. In the menu, the heavier items will sink and the lighter items will be positioned nearer the top.','6.17');
INSERT INTO `locales_source` VALUES ('796',' modules/book/book.admin.inc:44,60; modules/book/book.module:57','default','Add child page','none');
INSERT INTO `locales_source` VALUES ('797',' modules/comment/comment.admin.inc:40; modules/node/node.admin.inc:464; modules/user/user.admin.inc:158','default','Update options','6.17');
INSERT INTO `locales_source` VALUES ('798',' modules/poll/poll.module:251; modules/user/user.module:1519','default','Active','6.17');
INSERT INTO `locales_source` VALUES ('799',' plugins/content_types/block/block.inc:21','default','Block','6.17');
INSERT INTO `locales_source` VALUES ('800',' modules/statistics/statistics.admin.inc:15,51; modules/statistics/statistics.pages.inc:47; profiles/default/default.profile:100','default','Page','6.17');
INSERT INTO `locales_source` VALUES ('801',' install.php:1025; modules/system/system.admin.inc:385','default','Site name','6.17');
INSERT INTO `locales_source` VALUES ('802',' includes/common.inc:663; includes/image.inc:95; includes/menu.inc:2356; includes/unicode.inc:151,184','default','php','6.17');
INSERT INTO `locales_source` VALUES ('803',' modules/openid/openid.module:450; modules/user/user.admin.inc:243','default','Only site administrators can create new user accounts.','none');
INSERT INTO `locales_source` VALUES ('804',' modules/system/system.module:499; modules/system/system.install:36','default','PHP','6.17');
INSERT INTO `locales_source` VALUES ('805',' modules/system/system.install:232; modules/update/update.report.inc:84; modules/update/update.module:284','default','Up to date','6.17');
INSERT INTO `locales_source` VALUES ('806',' modules/system/system.install:242; modules/update/update.module:274','default','Out of date','none');
INSERT INTO `locales_source` VALUES ('807',' modules/update/update.info:0','default','Update status','none');
INSERT INTO `locales_source` VALUES ('808',' modules/filter/filter.module:220,221,222,223,224,225; modules/system/system.module:0','default','Header','6.17');
INSERT INTO `locales_source` VALUES ('809',' plugins/layouts/flexible/flexible.inc:120','default','Left sidebar','6.17');
INSERT INTO `locales_source` VALUES ('810',' plugins/layouts/flexible/flexible.inc:146','default','Right sidebar','6.17');
INSERT INTO `locales_source` VALUES ('811',' modules/contact/contact.admin.inc:18,63; modules/system/system.admin.inc:2155','default','Selected','none');
INSERT INTO `locales_source` VALUES ('812',' modules/contact/contact.admin.inc:83; modules/profile/profile.admin.inc:302','default','You must enter a category.','none');
INSERT INTO `locales_source` VALUES ('813',' modules/comment/comment.module:1339,1345,1354; modules/contact/contact.pages.inc:43','default','Your name','none');
INSERT INTO `locales_source` VALUES ('814',' modules/contact/contact.pages.inc:95,200; modules/system/system.module:1336','default','Send e-mail','6.17');
INSERT INTO `locales_source` VALUES ('815',' modules/block/block-admin-display-form.tpl.php:45; modules/system/system.admin.inc:2026; modules/throttle/throttle.module:11; modules/throttle/throttle.info:0','default','Throttle','none');
INSERT INTO `locales_source` VALUES ('816',' modules/filter/filter.admin.inc:69,110; modules/user/user.admin.inc:136,918; modules/user/user.module:1542,998','default','Roles','6.17');
INSERT INTO `locales_source` VALUES ('817',' modules/rules.rules.inc:423','default','Comment','6.17');
INSERT INTO `locales_source` VALUES ('818',' modules/dblog/dblog.admin.inc:166; modules/statistics/statistics.admin.inc:166; modules/user/user.admin.inc:821','default','Hostname','6.17');
INSERT INTO `locales_source` VALUES ('819',' modules/comment/comment.module:1335; modules/node/content_types.inc:157; modules/node/node.pages.inc:210; modules/translation/translation.pages.inc:40','default','Published','6.17');
INSERT INTO `locales_source` VALUES ('820',' rules_admin.rule_forms.inc:20;36','default','Filter','6.17');
INSERT INTO `locales_source` VALUES ('821',' modules/locale/locale.info:0','default','Locale','none');
INSERT INTO `locales_source` VALUES ('822',' modules/node/content_types.inc:158; modules/node/node.pages.inc:215','default','Promoted to front page','6.17');
INSERT INTO `locales_source` VALUES ('823',' modules/node/content_types.inc:159; modules/node/node.pages.inc:220','default','Sticky at top of lists','6.17');
INSERT INTO `locales_source` VALUES ('824',' install.php:1057; modules/system/system.admin.inc:1143; modules/user/user.module:1494','default','E-mail address','6.17');
INSERT INTO `locales_source` VALUES ('825',' modules/poll/poll.pages.inc:35; modules/poll/poll.module:562','default','Vote','none');
INSERT INTO `locales_source` VALUES ('826',' modules/user/user.admin.inc:178; modules/user/user.module:2032','default','blocked','6.17');
INSERT INTO `locales_source` VALUES ('827',' modules/user/user.admin.inc:178; modules/user/user.module:2032','default','active','6.17');
INSERT INTO `locales_source` VALUES ('828',' modules/aggregator/aggregator.pages.inc:292; modules/aggregator/aggregator.module:164','default','OPML feed','none');
INSERT INTO `locales_source` VALUES ('829',' modules/block/block.admin.inc:83; modules/filter/filter.admin.inc:34; modules/system/system.admin.inc:225; modules/system/system.module:1392','default','configure','6.17');
INSERT INTO `locales_source` VALUES ('830',' modules/aggregator/aggregator.pages.inc:227; modules/aggregator/aggregator.module:185,214','default','Categorize','none');
INSERT INTO `locales_source` VALUES ('831',' modules/comment/comment.module:1293,1309; modules/node/node.pages.inc:181','default','Authored by','6.17');
INSERT INTO `locales_source` VALUES ('832',' modules/node/node.admin.inc:613; modules/user/user.module:1920','default','Delete all','6.17');
INSERT INTO `locales_source` VALUES ('833',' modules/system/system.module:603; modules/user/user.module:2226','default','Medium','6.17');
INSERT INTO `locales_source` VALUES ('834',' modules/dblog/dblog.module:79; modules/statistics/statistics.module:127','default','Details','none');
INSERT INTO `locales_source` VALUES ('835',' modules/path/path.admin.inc:31; modules/system/system.info:0','default','System','6.17');
INSERT INTO `locales_source` VALUES ('836',' modules/node/node.admin.inc:35; modules/poll/poll.module:250','default','Unlimited','6.17');
INSERT INTO `locales_source` VALUES ('837',' modules/node/node.admin.inc:582; modules/tracker/tracker.pages.inc:62','default','No posts available.','none');
INSERT INTO `locales_source` VALUES ('838',' includes/file.inc:136; modules/user/user.pages.inc:278,347; modules/user/user.module:1839,2352','default','security','none');
INSERT INTO `locales_source` VALUES ('839',' modules/forum/forum-list.tpl.php:37; modules/forum/forum.info:0','default','Forum','none');
INSERT INTO `locales_source` VALUES ('840',' modules/menu/menu.install:12; modules/user/user.module:698,748','default','Navigation','6.17');
INSERT INTO `locales_source` VALUES ('841',' price.classes.inc:26','default','Color','6.17');
INSERT INTO `locales_source` VALUES ('842',' modules/user/user.pages.inc:125; modules/user/user.module:676,1290,918','default','Log in','6.17');
INSERT INTO `locales_source` VALUES ('843',' modules/blog/blog.module:51; modules/blog/blog.info:0','default','Blog','none');
INSERT INTO `locales_source` VALUES ('844',' modules/trigger/trigger.module:58; modules/user/user.module:579,960','default','Users','6.17');
INSERT INTO `locales_source` VALUES ('845',' modules/dblog/dblog.admin.inc:154; modules/statistics/statistics.admin.inc:154; modules/statistics/statistics.pages.inc:14','default','Referrer','none');
INSERT INTO `locales_source` VALUES ('846',' modules/poll/poll-bar.tpl.php:25; modules/poll/poll.pages.inc:20','default','1 vote','none');
INSERT INTO `locales_source` VALUES ('847',' modules/poll/poll-bar.tpl.php:25; modules/poll/poll.pages.inc:20','default','@count votes','none');
INSERT INTO `locales_source` VALUES ('848',' includes/common.inc:361; modules/system/system.admin.inc:1651','default','@site is currently under maintenance. We should be back shortly. Thank you for your patience.','6.17');
INSERT INTO `locales_source` VALUES ('849',' token.module:79','default','Anonymous','6.17');
INSERT INTO `locales_source` VALUES ('850',' modules/system/system.admin.inc:1043,1088,2112; modules/system/system.module:331,337','default','Uninstall','6.17');
INSERT INTO `locales_source` VALUES ('851',' modules/comment/comment.module:560; modules/node/node.admin.inc:54','default','Optional','6.17');
INSERT INTO `locales_source` VALUES ('852',' modules/profile/profile.info:0','default','Profile','none');
INSERT INTO `locales_source` VALUES ('853',' includes/locale.inc:472; modules/comment/comment.module:1633','default','Save settings','none');
INSERT INTO `locales_source` VALUES ('854',' modules/tracker/tracker.info:0','default','Tracker','none');
INSERT INTO `locales_source` VALUES ('855',' modules/comment/comment.module:1193; modules/node/node.module:809','default','You have to specify a valid date.','none');
INSERT INTO `locales_source` VALUES ('856',' modules/forum/forum.module:761,823; modules/tracker/tracker.pages.inc:48','default','1 new','none');
INSERT INTO `locales_source` VALUES ('857',' modules/forum/forum.module:761,823; modules/tracker/tracker.pages.inc:48','default','@count new','none');
INSERT INTO `locales_source` VALUES ('858',' modules/user/user.admin.inc:726; modules/user/user.module:1025','default','Add rule','6.17');
INSERT INTO `locales_source` VALUES ('859',' modules/filter/filter.admin.inc:153; modules/filter/filter.module:527','default','Formatting guidelines','6.17');
INSERT INTO `locales_source` VALUES ('860',' modules/comment/comment.module:1333; modules/node/node.pages.inc:190','default','Authored on','6.17');
INSERT INTO `locales_source` VALUES ('861',' modules/syslog/syslog.module:31; modules/syslog/syslog.info:0','default','Syslog','none');
INSERT INTO `locales_source` VALUES ('862',' modules/blogapi/blogapi.module:773; modules/upload/upload.admin.inc:131','default','Maximum file size per upload','6.17');
INSERT INTO `locales_source` VALUES ('863',' modules/blogapi/blogapi.module:781; modules/upload/upload.admin.inc:140','default','Total file size per user','none');
INSERT INTO `locales_source` VALUES ('864',' modules/aggregator/aggregator.admin.inc:190; modules/aggregator/aggregator.module:108','default','Remove items','none');
INSERT INTO `locales_source` VALUES ('865',' modules/aggregator/aggregator.admin.inc:228; modules/filter/filter.module:687','default','Allowed HTML tags','none');
INSERT INTO `locales_source` VALUES ('866',' modules/aggregator/aggregator.admin.inc:30,41; modules/aggregator/aggregator.module:925','default','1 item','none');
INSERT INTO `locales_source` VALUES ('867',' modules/aggregator/aggregator.admin.inc:30,41; modules/aggregator/aggregator.module:925','default','@count items','none');
INSERT INTO `locales_source` VALUES ('868',' modules/menu/menu.admin.inc:502,584; modules/node/content_types.inc:404','default','menu','6.17');
INSERT INTO `locales_source` VALUES ('869',' modules/comment/comment.admin.inc:114; modules/node/node.admin.inc:372,424; modules/user/user.admin.inc:223','default','The update has been performed.','6.17');
INSERT INTO `locales_source` VALUES ('870',' includes/theme.inc:1660; modules/user/user.module:832','default','View user profile.','6.17');
INSERT INTO `locales_source` VALUES ('871',' modules/user/user.admin.inc:572; modules/user/user.pages.inc:297,363','default','The changes have been saved.','6.17');
INSERT INTO `locales_source` VALUES ('872',' modules/node/node.admin.inc:247,313; modules/user/user.admin.inc:73,98','default','Refine','6.17');
INSERT INTO `locales_source` VALUES ('873',' modules/node/node.admin.inc:249,325; modules/user/user.admin.inc:78,108','default','Undo','6.17');
INSERT INTO `locales_source` VALUES ('874',' modules/user/user.admin.inc:137,919; modules/user/user.module:634','default','Member for','6.17');
INSERT INTO `locales_source` VALUES ('875',' modules/aggregator/aggregator.admin.inc:30; modules/aggregator/aggregator.pages.inc:482; modules/comment/comment.module:396; modules/statistics/statistics.admin.inc:125; modules/user/user.admin.inc:193','default','@time ago','6.17');
INSERT INTO `locales_source` VALUES ('876',' modules/user/user.pages.inc:280,349,278,347; modules/user/user.module:1839,2352','default','Detected malicious attempt to alter protected user fields.','none');
INSERT INTO `locales_source` VALUES ('877',' includes/locale.inc:2062; modules/locale/locale.module:592,76','default','Languages','6.17');
INSERT INTO `locales_source` VALUES ('878',' modules/node/content_types.inc:160; modules/node/node.pages.inc:158','default','Create new revision','6.17');
INSERT INTO `locales_source` VALUES ('879',' modules/system/system.admin.inc:1501; modules/system/system.module:559','default','Locale settings','6.17');
INSERT INTO `locales_source` VALUES ('880',' modules/user/user.admin.inc:13; modules/user/user.module:680,2504,924','default','Create new account','6.17');
INSERT INTO `locales_source` VALUES ('881',' includes/common.inc:3634; modules/dblog/dblog.admin.inc:37; modules/update/update.report.inc:53,65','default','warning','6.17');
INSERT INTO `locales_source` VALUES ('882',' modules/statistics/statistics.admin.inc:33,64,97,129; modules/statistics/statistics.pages.inc:29,60','default','No statistics available.','none');
INSERT INTO `locales_source` VALUES ('883',' install.php:1020; modules/system/system.module:380','default','Site information','6.17');
INSERT INTO `locales_source` VALUES ('884',' includes/common.inc:3632; modules/dblog/dblog.admin.inc:39','default','critical','none');
INSERT INTO `locales_source` VALUES ('885',' modules/blogapi/blogapi.module:726; modules/upload/upload.admin.inc:86','default','Default permitted file extensions','none');
INSERT INTO `locales_source` VALUES ('886',' modules/poll/poll.pages.inc:34; modules/statistics/statistics.admin.inc:80','default','Visitor','none');
INSERT INTO `locales_source` VALUES ('887',' modules/forum/forum.module:86,93; modules/forum/forum.install:27,115','default','Forums','none');
INSERT INTO `locales_source` VALUES ('888',' modules/statistics/statistics.module:155; modules/tracker/tracker.module:46','default','Track','none');
INSERT INTO `locales_source` VALUES ('889',' modules/poll/poll.info:0','default','Allows your site to capture votes on different topics in the form of multiple choice questions.','6.17');
INSERT INTO `locales_source` VALUES ('890',' modules/comment/comment.module:1335; modules/translation/translation.pages.inc:40','default','Not published','none');
INSERT INTO `locales_source` VALUES ('891',' modules/blogapi/blogapi.module:729; modules/upload/upload.admin.inc:89','default','Default extensions that users can upload. Separate extensions with a space and do not include the leading dot.','none');
INSERT INTO `locales_source` VALUES ('892',' modules/blogapi/blogapi.module:734; modules/upload/upload.admin.inc:93','default','Default maximum file size per upload','none');
INSERT INTO `locales_source` VALUES ('893',' includes/common.inc:1255; modules/blogapi/blogapi.module:739,749; modules/upload/upload.admin.inc:98,107,136,145','default','MB','6.17');
INSERT INTO `locales_source` VALUES ('894',' modules/blogapi/blogapi.module:744; modules/upload/upload.admin.inc:102','default','Default total file size per user','none');
INSERT INTO `locales_source` VALUES ('895',' modules/blogapi/blogapi.module:752; modules/upload/upload.admin.inc:17,110','default','Your PHP settings limit the maximum file size per upload to %size.','none');
INSERT INTO `locales_source` VALUES ('896',' modules/menu/menu.admin.inc:231; modules/menu/menu.module:367','default','Menu settings','6.17');
INSERT INTO `locales_source` VALUES ('897',' modules/statistics/statistics.admin.inc:29; modules/statistics/statistics.pages.inc:25,56','default','details','none');
INSERT INTO `locales_source` VALUES ('898',' modules/system/system.module:276; modules/update/update.report.inc:221','default','Themes','6.17');
INSERT INTO `locales_source` VALUES ('899',' includes/form.inc:2457; modules/node/node.admin.inc:357','default','Processing','6.17');
INSERT INTO `locales_source` VALUES ('900',' modules/node/node.admin.inc:292; modules/user/user.admin.inc:1008','default','is','6.17');
INSERT INTO `locales_source` VALUES ('901',' themes/garland/garland.info:0','default','Tableless, recolorable, multi-column, fluid width theme (default).','6.17');
INSERT INTO `locales_source` VALUES ('902',' modules/block/block.info:0','default','Controls the boxes that are displayed around the main content.','6.17');
INSERT INTO `locales_source` VALUES ('903',' modules/block/block.info:0; modules/filter/filter.info:0; modules/node/node.info:0; modules/system/system.info:0; modules/user/user.info:0','default','Core - required','6.17');
INSERT INTO `locales_source` VALUES ('904',' modules/menu/menu.info:0','default','Allows administrators to customize the site navigation menu.','6.17');
INSERT INTO `locales_source` VALUES ('905',' install.php:1077; modules/system/system.admin.inc:1506','default','Default time zone','none');
INSERT INTO `locales_source` VALUES ('906',' modules/user/user.admin.inc:591; modules/user/user.module:2016','default','@module module','6.17');
INSERT INTO `locales_source` VALUES ('907',' modules/comment/comment.module:1321,1348,1356; modules/profile/profile.module:341','default','The content of this field is kept private and will not be shown publicly.','none');
INSERT INTO `locales_source` VALUES ('908',' modules/comment/comment.module:1871; modules/forum/forum.admin.inc:204','default','Date - newest first','6.17');
INSERT INTO `locales_source` VALUES ('909',' modules/comment/comment.module:1872; modules/forum/forum.admin.inc:204','default','Date - oldest first','6.17');
INSERT INTO `locales_source` VALUES ('910',' modules/comment/comment.module:419,625; modules/node/node.module:144','default','1 comment','none');
INSERT INTO `locales_source` VALUES ('911',' modules/comment/comment.module:419,625; modules/node/node.module:144','default','@count comments','none');
INSERT INTO `locales_source` VALUES ('912',' includes/file.inc:122,234; modules/system/system.module:1291','default','file system','none');
INSERT INTO `locales_source` VALUES ('913',' modules/menu/menu.admin.inc:280; modules/menu/menu.module:394','default','Menu link title','6.17');
INSERT INTO `locales_source` VALUES ('914',' modules/menu/menu.admin.inc:316; modules/menu/menu.module:410','default','The maximum depth for an item and all its children is fixed at !maxdepth. Some menu items may not be available as parents if selecting them would exceed this limit.','6.17');
INSERT INTO `locales_source` VALUES ('915',' modules/menu/menu.admin.inc:339; modules/system/system.admin.inc:1199','default','The menu system stores system paths only, but will use the URL alias for display. %link_path has been stored as %normal_path','6.17');
INSERT INTO `locales_source` VALUES ('916',' modules/menu/menu.admin.inc:363; modules/path/path.admin.inc:143','default','The path \'@link_path\' is either invalid or you do not have access to it.','6.17');
INSERT INTO `locales_source` VALUES ('917',' modules/menu/menu.admin.inc:388; modules/menu/menu.module:311','default','There was an error saving the menu link.','none');
INSERT INTO `locales_source` VALUES ('918',' modules/locale/locale.module:278; modules/node/node.admin.inc:159,224,494','default','Language neutral','6.17');
INSERT INTO `locales_source` VALUES ('919',' modules/openid/openid.pages.inc:42,64; modules/openid/openid.info:0','default','OpenID','none');
INSERT INTO `locales_source` VALUES ('920',' includes/file.inc:109; modules/system/system.install:198','default','The directory %directory does not exist.','6.17');
INSERT INTO `locales_source` VALUES ('921',' modules/throttle/throttle.module:104; modules/user/user.module:789,792','default','1 user','none');
INSERT INTO `locales_source` VALUES ('922',' modules/throttle/throttle.module:104; modules/user/user.module:789,792','default','@count users','none');
INSERT INTO `locales_source` VALUES ('923',' modules/menu/menu.install:13; modules/system/system.admin.inc:392','default','Primary links','6.17');
INSERT INTO `locales_source` VALUES ('924',' modules/node/node.admin.inc:23,73; modules/node/node.module:1442','default','Rebuild permissions','6.17');
INSERT INTO `locales_source` VALUES ('925',' modules/comment/comment.module:1669; modules/openid/openid.module:442; modules/user/user.module:1447,2368','default','Error saving user account.','none');
INSERT INTO `locales_source` VALUES ('926',' modules/contact/contact.pages.inc:63; modules/forum/forum.module:387; modules/taxonomy/taxonomy.module:436','default','- Please choose -','none');
INSERT INTO `locales_source` VALUES ('927',' modules/aggregator/aggregator.info:0','default','Aggregator','none');
INSERT INTO `locales_source` VALUES ('928',' modules/aggregator/aggregator.info:0','default','Aggregates syndicated content (RSS, RDF, and Atom feeds).','6.17');
INSERT INTO `locales_source` VALUES ('929',' install.php:1086; modules/system/system.admin.inc:1667; modules/system/system.module:458','default','Clean URLs','6.17');
INSERT INTO `locales_source` VALUES ('930',' modules/update/update.report.inc:75; modules/update/update.module:268','default','Revoked!','none');
INSERT INTO `locales_source` VALUES ('931',' includes/form.inc:303','default','Validation error, please try again. If this error persists, please contact the site administrator.','none');
INSERT INTO `locales_source` VALUES ('932',' modules/system/system.admin.inc:1234; modules/system/system.module:388','default','Error reporting','6.17');
INSERT INTO `locales_source` VALUES ('933',' modules/node/node.admin.inc:286; modules/user/user.admin.inc:1002','default','and','6.17');
INSERT INTO `locales_source` VALUES ('934',' modules/node/node.admin.inc:286; modules/user/user.admin.inc:1002','default','where','6.17');
INSERT INTO `locales_source` VALUES ('935',' modules/trigger/trigger.admin.inc:164; modules/trigger/trigger.module:415','default','Choose an action','none');
INSERT INTO `locales_source` VALUES ('936',' modules/trigger/trigger.info:0','default','Enables actions to be fired on certain system events, such as when new content is created.','6.17');
INSERT INTO `locales_source` VALUES ('937',' modules/taxonomy/taxonomy.info:0','default','Enables the categorization of content.','6.17');
INSERT INTO `locales_source` VALUES ('938',' modules/contact/contact.admin.inc:157; modules/contact/contact.pages.inc:41','default','You can leave a message using the contact form below.','none');
INSERT INTO `locales_source` VALUES ('939',' modules/system/system.admin.inc:702; modules/update/update.report.inc:192','default','Depends on: !dependencies','6.17');
INSERT INTO `locales_source` VALUES ('940',' modules/system/system.admin.inc:725; modules/update/update.report.inc:202','default','Required by: !required','6.17');
INSERT INTO `locales_source` VALUES ('941',' themes/garland/minnelli/minnelli.info:0','default','Tableless, recolorable, multi-column, fixed width theme.','6.17');
INSERT INTO `locales_source` VALUES ('942',' modules/book/book.admin.inc:36; modules/book/book.module:43','default','add content to books','none');
INSERT INTO `locales_source` VALUES ('943',' modules/book/book.admin.inc:36; modules/book/book.module:43','default','administer book outlines','none');
INSERT INTO `locales_source` VALUES ('944',' modules/blogapi/blogapi.module:748; modules/upload/upload.admin.inc:106','default','The default maximum size of all files a user can have on the site.','none');
INSERT INTO `locales_source` VALUES ('945',' themes/bluemarine/bluemarine.info:0','default','Table-based multi-column theme with a marine and ash color scheme.','6.17');
INSERT INTO `locales_source` VALUES ('946',' modules/tracker/tracker.info:0','default','Enables tracking of recent posts for users.','6.17');
INSERT INTO `locales_source` VALUES ('947',' modules/system/system.admin.inc:166; modules/system/system.module:265','default','Administration theme','6.17');
INSERT INTO `locales_source` VALUES ('948',' install.php:1051; modules/user/user.module:1489','default','Spaces are allowed; punctuation is not allowed except for periods, hyphens, and underscores.','6.17');
INSERT INTO `locales_source` VALUES ('949',' modules/menu/menu.install:14; modules/system/system.admin.inc:393','default','Secondary links','6.17');
INSERT INTO `locales_source` VALUES ('950',' includes/form.inc:705,711; modules/filter/filter.module:546','default','An illegal choice has been detected. Please contact the site administrator.','6.17');
INSERT INTO `locales_source` VALUES ('951',' modules/node/content_types.inc:69; modules/taxonomy/taxonomy.admin.inc:118,658','default','Identification','6.17');
INSERT INTO `locales_source` VALUES ('952',' modules/comment/comment.admin.inc:110; modules/comment/comment.module:708','default','Comment: updated %subject.','none');
INSERT INTO `locales_source` VALUES ('953',' modules/system/system.module:411; modules/system/system.install:184','default','File system','6.17');
INSERT INTO `locales_source` VALUES ('954',' modules/blog/blog.pages.inc:91; modules/blog/blog.module:109','default','!name\'s blog','none');
INSERT INTO `locales_source` VALUES ('955',' includes/locale.inc:578; modules/locale/locale.module:250','default','All languages','none');
INSERT INTO `locales_source` VALUES ('956',' includes/locale.inc:169; modules/locale/locale.module:88','default','Add language','6.17');
INSERT INTO `locales_source` VALUES ('957',' install.php:930,942; includes/install.inc:728','default','Currently using !item !version','none');
INSERT INTO `locales_source` VALUES ('958',' modules/trigger/trigger.info:0','default','Trigger','none');
INSERT INTO `locales_source` VALUES ('959',' modules/blogapi/blogapi.module:800; modules/blogapi/blogapi.info:0','default','Blog API','none');
INSERT INTO `locales_source` VALUES ('960',' modules/blogapi/blogapi.info:0','default','Allows users to post content using applications that support XML-RPC blog APIs.','6.17');
INSERT INTO `locales_source` VALUES ('961',' includes/form.inc:706,712; modules/filter/filter.module:547','default','form','none');
INSERT INTO `locales_source` VALUES ('962',' includes/common.inc:3631; modules/dblog/dblog.admin.inc:40','default','alert','none');
INSERT INTO `locales_source` VALUES ('963',' includes/common.inc:3630; modules/dblog/dblog.admin.inc:41','default','emergency','none');
INSERT INTO `locales_source` VALUES ('964',' modules/poll/poll.module:147,172; modules/poll/poll.info:0','default','Poll','none');
INSERT INTO `locales_source` VALUES ('965',' modules/php/php.info:0','default','PHP filter','none');
INSERT INTO `locales_source` VALUES ('966',' modules/filter/filter.admin.inc:146; modules/filter/filter.module:603','default','More information about formatting options','6.17');
INSERT INTO `locales_source` VALUES ('967',' install.php:737; modules/system/system.admin.inc:1684; modules/system/system.js:0; modules/system/system.js','default','Your server has been successfully tested to support this feature.','none');
INSERT INTO `locales_source` VALUES ('968',' install.php:737; modules/system/system.js:0; modules/system/system.js','default','Your system configuration does not currently support this feature. The <a href=\"http://drupal.org/node/15365\">handbook page on Clean URLs</a> has additional troubleshooting information.','none');
INSERT INTO `locales_source` VALUES ('969',' install.php:737; modules/system/system.js:0; modules/system/system.js','default','Testing clean URLs...','none');
INSERT INTO `locales_source` VALUES ('970',' install.php:1033; modules/system/system.admin.inc:1145','default','The <em>From</em> address in automated e-mails sent during registration and new password requests, and other notifications. (Use an address ending in your site\'s domain to help prevent this e-mail being flagged as spam.)','6.17');
INSERT INTO `locales_source` VALUES ('971',' install.php:1089; modules/system/system.admin.inc:1670','default','This option makes Drupal emit \"clean\" URLs (i.e. without <code>?q=</code> in the URL).','6.17');
INSERT INTO `locales_source` VALUES ('972',' install.php:1098; modules/system/system.install:285','default','Update notifications','6.17');
INSERT INTO `locales_source` VALUES ('973',' includes/database.mysql.inc:26; includes/database.mysqli.inc:29','default','MySQL database','6.17');
INSERT INTO `locales_source` VALUES ('974',' includes/database.mysql.inc:32; includes/database.mysqli.inc:35','default','Your MySQL Server is too old. Drupal requires at least MySQL %version.','none');
INSERT INTO `locales_source` VALUES ('975',' includes/form.inc:712; modules/filter/filter.module:547','default','Illegal choice %choice in %name element.','none');
INSERT INTO `locales_source` VALUES ('976',' modules/blog/blog.info:0','default','Enables keeping easily and regularly updated user web pages or blogs.','6.17');
INSERT INTO `locales_source` VALUES ('977',' modules/book/book.info:0','default','Allows users to structure site pages in a hierarchy or outline.','6.17');
INSERT INTO `locales_source` VALUES ('978',' modules/color/color.info:0','default','Allows the user to change the color scheme of certain themes.','6.17');
INSERT INTO `locales_source` VALUES ('979',' modules/comment/comment.info:0','default','Allows users to comment on and discuss published content.','6.17');
INSERT INTO `locales_source` VALUES ('980',' modules/contact/contact.info:0','default','Enables the use of both personal and site-wide contact forms.','6.17');
INSERT INTO `locales_source` VALUES ('981',' modules/dblog/dblog.module:46; modules/dblog/dblog.info:0','default','Database logging','6.17');
INSERT INTO `locales_source` VALUES ('982',' modules/dblog/dblog.info:0','default','Logs and records system events to the database.','6.17');
INSERT INTO `locales_source` VALUES ('983',' modules/filter/filter.admin.inc:81; modules/filter/filter.module:83','default','Add input format','6.17');
INSERT INTO `locales_source` VALUES ('984',' modules/filter/filter.info:0','default','Handles the filtering of content in preparation for display.','6.17');
INSERT INTO `locales_source` VALUES ('985',' modules/forum/forum.info:0','default','Enables threaded discussions about general topics.','6.17');
INSERT INTO `locales_source` VALUES ('986',' modules/help/help.info:0','default','Manages the display of online help.','6.17');
INSERT INTO `locales_source` VALUES ('987',' modules/locale/locale.info:0','default','Adds language handling functionality and enables the translation of the user interface to languages other than English.','6.17');
INSERT INTO `locales_source` VALUES ('988',' modules/node/node.info:0','default','Allows content to be submitted to the site and displayed on pages.','6.17');
INSERT INTO `locales_source` VALUES ('989',' modules/openid/openid.info:0','default','Allows users to log into your site using OpenID.','6.17');
INSERT INTO `locales_source` VALUES ('990',' modules/path/path.info:0','default','Allows users to rename URLs.','6.17');
INSERT INTO `locales_source` VALUES ('991',' modules/php/php.info:0','default','Allows embedded PHP code/snippets to be evaluated.','6.17');
INSERT INTO `locales_source` VALUES ('992',' modules/ping/ping.info:0','default','Ping','none');
INSERT INTO `locales_source` VALUES ('993',' modules/ping/ping.info:0','default','Alerts other sites when your site has been updated.','6.17');
INSERT INTO `locales_source` VALUES ('994',' modules/poll/poll-results-block.tpl.php:26; modules/poll/poll-results.tpl.php:24','default','Total votes: @votes','none');
INSERT INTO `locales_source` VALUES ('995',' modules/profile/profile.pages.inc:102; modules/profile/profile.module:80','default','User list','none');
INSERT INTO `locales_source` VALUES ('996',' modules/profile/profile.info:0','default','Supports configurable user profiles.','6.17');
INSERT INTO `locales_source` VALUES ('997',' modules/search/search.info:0','default','Enables site-wide keyword searching.','6.17');
INSERT INTO `locales_source` VALUES ('998',' modules/statistics/statistics.info:0','default','Logs access statistics for your site.','6.17');
INSERT INTO `locales_source` VALUES ('999',' modules/syslog/syslog.info:0','default','Logs and records system events to syslog.','6.17');
INSERT INTO `locales_source` VALUES ('1000',' modules/system/system.info:0','default','Handles general site configuration for administrators.','6.17');
INSERT INTO `locales_source` VALUES ('1001',' modules/throttle/throttle.info:0','default','Handles the auto-throttling mechanism, to control site congestion.','6.17');
INSERT INTO `locales_source` VALUES ('1002',' modules/translation/translation.info:0','default','Content translation','none');
INSERT INTO `locales_source` VALUES ('1003',' modules/translation/translation.info:0','default','Allows content to be translated into different languages.','6.17');
INSERT INTO `locales_source` VALUES ('1004',' modules/update/update.info:0','default','Checks the status of available updates for Drupal and your installed modules and themes.','6.17');
INSERT INTO `locales_source` VALUES ('1005',' modules/upload/upload.info:0','default','Allows users to upload and attach files to content.','6.17');
INSERT INTO `locales_source` VALUES ('1006',' modules/user/user.info:0','default','Manages the user registration and login system.','6.17');
INSERT INTO `locales_source` VALUES ('1007',' themes/chameleon/chameleon.info:0','default','Chameleon','none');
INSERT INTO `locales_source` VALUES ('1008',' themes/chameleon/chameleon.info:0','default','Minimalist tabled theme with light colors.','6.17');
INSERT INTO `locales_source` VALUES ('1009',' themes/chameleon/marvin/marvin.info:0','default','Marvin','none');
INSERT INTO `locales_source` VALUES ('1010',' themes/chameleon/marvin/marvin.info:0','default','Boxy tabled theme in all grays.','6.17');
INSERT INTO `locales_source` VALUES ('1011',' themes/garland/garland.info:0','default','Garland','6.17');
INSERT INTO `locales_source` VALUES ('1012',' themes/garland/minnelli/minnelli.info:0','default','Minnelli','6.17');
INSERT INTO `locales_source` VALUES ('1013',' themes/pushbutton/pushbutton.info:0','default','Pushbutton','none');
INSERT INTO `locales_source` VALUES ('1014',' themes/pushbutton/pushbutton.info:0','default','Tabled, multi-column theme in blue and orange tones.','6.17');
INSERT INTO `locales_source` VALUES ('1015',' includes/theme.inc:1678','default','not verified','none');
INSERT INTO `locales_source` VALUES ('1016',' includes/common.inc:2684,2691,2706,2722','default','cron','none');
INSERT INTO `locales_source` VALUES ('1017',' includes/theme.inc:1485','default','updated','6.17');
INSERT INTO `locales_source` VALUES ('1018',' includes/common.inc:417','default','You are not authorized to access this page.','6.17');
INSERT INTO `locales_source` VALUES ('1019',' includes/file.inc:605','default','file','6.17');
INSERT INTO `locales_source` VALUES ('1020',' includes/common.inc:416','default','Access denied','6.17');
INSERT INTO `locales_source` VALUES ('1021',' includes/common.inc:0','default','1 hour','6.17');
INSERT INTO `locales_source` VALUES ('1022',' includes/common.inc:0','default','@count hours','6.17');
INSERT INTO `locales_source` VALUES ('1023',' includes/common.inc:0','default','1 day','6.17');
INSERT INTO `locales_source` VALUES ('1024',' includes/common.inc:0','default','@count days','6.17');
INSERT INTO `locales_source` VALUES ('1025',' includes/locale.inc:125','default','Configuration saved.','none');
INSERT INTO `locales_source` VALUES ('1026',' plugins/content_types/node_context/node_comments.inc:49','default','Mode','6.17');
INSERT INTO `locales_source` VALUES ('1027',' includes/form.inc:2207','default','This field is required.','6.17');
INSERT INTO `locales_source` VALUES ('1028',' includes/locale.inc:93','default','Code','6.17');
INSERT INTO `locales_source` VALUES ('1029',' includes/locale.inc:2508','default','Tonga','6.17');
INSERT INTO `locales_source` VALUES ('1030',' includes/locale.inc:2463','default','Navajo','6.17');
INSERT INTO `locales_source` VALUES ('1031',' plugins/arguments/string.inc:15,  plugins/contexts/string.inc:15','default','String','none');
INSERT INTO `locales_source` VALUES ('1032',' includes/locale.inc:2455','default','Nauru','6.17');
INSERT INTO `locales_source` VALUES ('1033',' includes/theme.inc:1557','default','[<a href=\"@link\">more help...</a>]','6.17');
INSERT INTO `locales_source` VALUES ('1034',' includes/locale.inc:2356','default','Arabic','6.17');
INSERT INTO `locales_source` VALUES ('1035',' includes/locale.inc:2386','default','English','6.17');
INSERT INTO `locales_source` VALUES ('1036',' includes/locale.inc:2396','default','French','6.17');
INSERT INTO `locales_source` VALUES ('1037',' includes/locale.inc:2418','default','Italian','6.17');
INSERT INTO `locales_source` VALUES ('1038',' includes/locale.inc:2388','default','Spanish','6.17');
INSERT INTO `locales_source` VALUES ('1039',' includes/locale.inc:2420','default','Japanese','6.17');
INSERT INTO `locales_source` VALUES ('1040',' includes/locale.inc:2430','default','Korean','6.17');
INSERT INTO `locales_source` VALUES ('1041',' includes/pager.inc:146,396','default','‹ previous','6.17');
INSERT INTO `locales_source` VALUES ('1042',' includes/pager.inc:147,397','default','next ›','6.17');
INSERT INTO `locales_source` VALUES ('1043',' includes/locale.inc:631','default','Language file','6.17');
INSERT INTO `locales_source` VALUES ('1044',' includes/locale.inc:463','default','None.','none');
INSERT INTO `locales_source` VALUES ('1045',' includes/theme.inc:1584','default','Syndicate content','none');
INSERT INTO `locales_source` VALUES ('1046',' includes/form.inc:1635','default','The specified passwords do not match.','none');
INSERT INTO `locales_source` VALUES ('1047',' includes/locale.inc:2394','default','Fiji','6.17');
INSERT INTO `locales_source` VALUES ('1048',' includes/theme.inc:1570','default','XML feed','none');
INSERT INTO `locales_source` VALUES ('1049',' includes/theme.inc:1598','default','<a href=\"@link\" title=\"@title\">more</a>','none');
INSERT INTO `locales_source` VALUES ('1050',' includes/actions.inc:331','default','Action \'%action\' added.','none');
INSERT INTO `locales_source` VALUES ('1051',' includes/actions.inc:357','default','Remove orphaned actions','none');
INSERT INTO `locales_source` VALUES ('1052',' includes/image.gd.inc:33','default','JPEG quality','none');
INSERT INTO `locales_source` VALUES ('1053',' includes/image.gd.inc:38','default','%','none');
INSERT INTO `locales_source` VALUES ('1054',' includes/form.inc:686','default','!name field is required.','6.17');
INSERT INTO `locales_source` VALUES ('1055',' includes/file.inc:604','default','File upload error. Could not move uploaded file.','none');
INSERT INTO `locales_source` VALUES ('1056',' includes/form.inc:1720','default','The specified date is invalid.','none');
INSERT INTO `locales_source` VALUES ('1057',' includes/pager.inc:395','default','Go to first page','none');
INSERT INTO `locales_source` VALUES ('1058',' includes/pager.inc:398','default','Go to last page','none');
INSERT INTO `locales_source` VALUES ('1059',' includes/pager.inc:405','default','Go to page @number','none');
INSERT INTO `locales_source` VALUES ('1060',' includes/locale.inc:93','default','English name','6.17');
INSERT INTO `locales_source` VALUES ('1061',' includes/locale.inc:93','default','Native name','6.17');
INSERT INTO `locales_source` VALUES ('1062',' includes/form.inc:2212,2215','default','!title: !required','6.17');
INSERT INTO `locales_source` VALUES ('1063',' includes/locale.inc:232,242','default','Language code','none');
INSERT INTO `locales_source` VALUES ('1064',' includes/common.inc:3637','default','debug','none');
INSERT INTO `locales_source` VALUES ('1065',' includes/common.inc:1252','default','KB','6.17');
INSERT INTO `locales_source` VALUES ('1066',' includes/common.inc:386','default','Page not found','6.17');
INSERT INTO `locales_source` VALUES ('1067',' includes/common.inc:3636','default','info','none');
INSERT INTO `locales_source` VALUES ('1068',' includes/pager.inc:145,395','default','« first','6.17');
INSERT INTO `locales_source` VALUES ('1069',' includes/pager.inc:148,398','default','last »','6.17');
INSERT INTO `locales_source` VALUES ('1070',' includes/file.inc:121','default','The directory %directory is not writable','none');
INSERT INTO `locales_source` VALUES ('1071',' includes/file.inc:122','default','The directory %directory is not writable, because it does not have the correct permissions set.','none');
INSERT INTO `locales_source` VALUES ('1072',' includes/common.inc:0','default','1 year','none');
INSERT INTO `locales_source` VALUES ('1073',' includes/common.inc:0','default','@count years','6.17');
INSERT INTO `locales_source` VALUES ('1074',' includes/common.inc:0','default','1 week','6.17');
INSERT INTO `locales_source` VALUES ('1075',' includes/common.inc:0','default','@count weeks','6.17');
INSERT INTO `locales_source` VALUES ('1076',' includes/common.inc:0','default','1 min','6.17');
INSERT INTO `locales_source` VALUES ('1077',' includes/common.inc:0','default','@count min','6.17');
INSERT INTO `locales_source` VALUES ('1078',' includes/common.inc:0','default','1 sec','6.17');
INSERT INTO `locales_source` VALUES ('1079',' includes/common.inc:0','default','@count sec','6.17');
INSERT INTO `locales_source` VALUES ('1080',' includes/locale.inc:2363','default','Bulgarian','6.17');
INSERT INTO `locales_source` VALUES ('1081',' includes/locale.inc:2408','default','Croatian','6.17');
INSERT INTO `locales_source` VALUES ('1082',' includes/locale.inc:2376','default','Czech','6.17');
INSERT INTO `locales_source` VALUES ('1083',' includes/locale.inc:2380','default','Danish','6.17');
INSERT INTO `locales_source` VALUES ('1084',' includes/locale.inc:2459','default','Dutch','6.17');
INSERT INTO `locales_source` VALUES ('1085',' includes/locale.inc:2393','default','Finnish','6.17');
INSERT INTO `locales_source` VALUES ('1086',' includes/locale.inc:2381','default','German','6.17');
INSERT INTO `locales_source` VALUES ('1087',' includes/locale.inc:2385','default','Greek','6.17');
INSERT INTO `locales_source` VALUES ('1088',' includes/locale.inc:2405','default','Hebrew','6.17');
INSERT INTO `locales_source` VALUES ('1089',' includes/locale.inc:2409','default','Hungarian','6.17');
INSERT INTO `locales_source` VALUES ('1090',' includes/locale.inc:2413','default','Indonesian','6.17');
INSERT INTO `locales_source` VALUES ('1091',' includes/locale.inc:2471','default','Polish','6.17');
INSERT INTO `locales_source` VALUES ('1092',' includes/locale.inc:2478','default','Romanian','6.17');
INSERT INTO `locales_source` VALUES ('1093',' includes/locale.inc:2479','default','Russian','6.17');
INSERT INTO `locales_source` VALUES ('1094',' includes/locale.inc:2488','default','Slovak','6.17');
INSERT INTO `locales_source` VALUES ('1095',' includes/locale.inc:2498','default','Swedish','6.17');
INSERT INTO `locales_source` VALUES ('1096',' includes/locale.inc:2509','default','Turkish','6.17');
INSERT INTO `locales_source` VALUES ('1097',' includes/file.inc:789','default','The file could not be created.','none');
INSERT INTO `locales_source` VALUES ('1098',' includes/file.inc:589','default','The selected file %name could not be uploaded.','none');
INSERT INTO `locales_source` VALUES ('1099',' includes/file.inc:233','default','The selected file %file could not be uploaded, because the destination %directory is not properly configured.','none');
INSERT INTO `locales_source` VALUES ('1100',' includes/file.inc:249','default','The selected file %file could not be copied, because no file by that name exists. Please check that you supplied the correct filename.','none');
INSERT INTO `locales_source` VALUES ('1101',' includes/file.inc:262,313','default','The selected file %file could not be copied, because a file by that name already exists in the destination.','none');
INSERT INTO `locales_source` VALUES ('1102',' includes/file.inc:267','default','The selected file %file could not be copied.','none');
INSERT INTO `locales_source` VALUES ('1103',' includes/file.inc:354','default','The removal of the original file %file has failed.','none');
INSERT INTO `locales_source` VALUES ('1104',' includes/tablesort.inc:71','default','sort by @s','6.17');
INSERT INTO `locales_source` VALUES ('1105',' includes/actions.inc:85','default','Stack overflow: too many calls to actions_do(). Aborting to prevent infinite recursion.','none');
INSERT INTO `locales_source` VALUES ('1106',' includes/actions.inc:388','default','Action %action saved.','none');
INSERT INTO `locales_source` VALUES ('1107',' includes/actions.inc:396','default','Action %action created.','none');
INSERT INTO `locales_source` VALUES ('1108',' includes/locale.inc:266','default','Path prefix','none');
INSERT INTO `locales_source` VALUES ('1109',' includes/locale.inc:2442','default','Lithuanian','6.17');
INSERT INTO `locales_source` VALUES ('1110',' includes/locale.inc:685','default','File to import not found.','6.17');
INSERT INTO `locales_source` VALUES ('1111',' includes/locale.inc:1100','default','The translation import failed, because the file %filename could not be read.','none');
INSERT INTO `locales_source` VALUES ('1112',' includes/locale.inc:1129','default','The translation file %filename contains an error: \"msgstr\" was expected but not found on line %line.','none');
INSERT INTO `locales_source` VALUES ('1113',' includes/locale.inc:1135','default','The translation file %filename contains an error: \"msgid_plural\" was expected but not found on line %line.','none');
INSERT INTO `locales_source` VALUES ('1114',' includes/locale.inc:1141,1159,1171,1179,1193,1202','default','The translation file %filename contains a syntax error on line %line.','none');
INSERT INTO `locales_source` VALUES ('1115',' includes/locale.inc:1153','default','The translation file %filename contains an error: \"msgid\" is unexpected on line %line.','none');
INSERT INTO `locales_source` VALUES ('1116',' includes/locale.inc:1167','default','The translation file %filename contains an error: \"msgstr[]\" is unexpected on line %line.','none');
INSERT INTO `locales_source` VALUES ('1117',' includes/locale.inc:1187','default','The translation file %filename contains an error: \"msgstr\" is unexpected on line %line.','none');
INSERT INTO `locales_source` VALUES ('1118',' includes/locale.inc:1215','default','The translation file %filename contains an error: there is an unexpected string on line %line.','none');
INSERT INTO `locales_source` VALUES ('1119',' includes/locale.inc:1226','default','The translation file %filename ended unexpectedly at line %line.','none');
INSERT INTO `locales_source` VALUES ('1120',' includes/locale.inc:843','default','Save translations','none');
INSERT INTO `locales_source` VALUES ('1121',' includes/locale.inc:749','default','Export template','none');
INSERT INTO `locales_source` VALUES ('1122',' includes/locale.inc:801','default','Original text','none');
INSERT INTO `locales_source` VALUES ('1123',' includes/file.inc:404','default','For security reasons, your upload has been renamed to %filename.','none');
INSERT INTO `locales_source` VALUES ('1124',' includes/common.inc:3635','default','notice','none');
INSERT INTO `locales_source` VALUES ('1125',' includes/locale.inc:93,278','default','Direction','6.17');
INSERT INTO `locales_source` VALUES ('1126',' includes/form.inc:1639','default','Password field is required.','none');
INSERT INTO `locales_source` VALUES ('1127',' includes/form.inc:1612','default','Confirm password','6.17');
INSERT INTO `locales_source` VALUES ('1128',' includes/locale.inc:2088','default','No strings found for your search.','none');
INSERT INTO `locales_source` VALUES ('1129',' includes/locale.inc:2350','default','Afar','6.17');
INSERT INTO `locales_source` VALUES ('1130',' includes/locale.inc:2492','default','Somali','6.17');
INSERT INTO `locales_source` VALUES ('1131',' includes/locale.inc:2434','default','Komi','6.17');
INSERT INTO `locales_source` VALUES ('1132',' includes/file.inc:135,136','default','Security warning: Couldn\'t write .htaccess file. Please create a .htaccess file in your %directory directory which contains the following lines: <code>!htaccess</code>','none');
INSERT INTO `locales_source` VALUES ('1133',' includes/file.inc:528','default','The file %file could not be saved, because it exceeds %maxsize, the maximum allowed size for uploads.','none');
INSERT INTO `locales_source` VALUES ('1134',' includes/file.inc:533','default','The file %file could not be saved, because the upload did not complete.','none');
INSERT INTO `locales_source` VALUES ('1135',' includes/file.inc:538','default','The file %file could not be saved. An unknown error has occurred.','none');
INSERT INTO `locales_source` VALUES ('1136',' includes/file.inc:659; sites/all/modules/imce/js/imce.js','default','Only files with the following extensions are allowed: %files-allowed.','none');
INSERT INTO `locales_source` VALUES ('1137',' includes/file.inc:688','default','The file is %filesize exceeding the maximum file size of %maxsize.','none');
INSERT INTO `locales_source` VALUES ('1138',' includes/file.inc:693','default','The file is %filesize which would exceed your disk quota of %quota.','none');
INSERT INTO `locales_source` VALUES ('1139',' includes/file.inc:712','default','Only JPEG, PNG and GIF images are allowed.','none');
INSERT INTO `locales_source` VALUES ('1140',' includes/file.inc:747','default','The image was resized to fit within the maximum allowed dimensions of %dimensions pixels.','6.17');
INSERT INTO `locales_source` VALUES ('1141',' includes/file.inc:755','default','The image is too large; the maximum dimensions are %dimensions pixels.','none');
INSERT INTO `locales_source` VALUES ('1142',' includes/file.inc:764','default','The image is too small; the minimum dimensions are %dimensions pixels.','none');
INSERT INTO `locales_source` VALUES ('1143',' includes/file.inc:605','default','Upload error. Could not move uploaded file %file to destination %destination.','none');
INSERT INTO `locales_source` VALUES ('1144',' includes/file.inc:634','default','Its name exceeds the 255 characters limit. Please rename the file and try again.','none');
INSERT INTO `locales_source` VALUES ('1145',' includes/form.inc:706','default','Illegal choice %choice in !name element.','none');
INSERT INTO `locales_source` VALUES ('1146',' includes/locale.inc:460','default','Language negotiation','none');
INSERT INTO `locales_source` VALUES ('1147',' includes/file.inc:234','default','The selected file %file could not be uploaded, because the destination %directory could not be found, or because its permissions do not allow the file to be written.','none');
INSERT INTO `locales_source` VALUES ('1148',' includes/common.inc:663','default','%message in %file on line %line.','none');
INSERT INTO `locales_source` VALUES ('1149',' includes/locale.inc:417','default','Are you sure you want to delete the language %name?','none');
INSERT INTO `locales_source` VALUES ('1150',' includes/locale.inc:436,437','default','The language %locale has been removed.','none');
INSERT INTO `locales_source` VALUES ('1151',' includes/locale.inc:941','default','Are you sure you want to delete the string \"%source\"?','none');
INSERT INTO `locales_source` VALUES ('1152',' includes/locale.inc:941','default','Deleting the string will remove all translations of this string in all languages. This action cannot be undone.','none');
INSERT INTO `locales_source` VALUES ('1153',' includes/locale.inc:437,681,874,1016,1073,1908,1912,2271,2274,2278,2281,2284','default','locale','6.17');
INSERT INTO `locales_source` VALUES ('1154',' includes/image.inc:95','default','The selected image handling toolkit %toolkit can not correctly process %function.','none');
INSERT INTO `locales_source` VALUES ('1155',' includes/locale.inc:2406','default','Hindi','6.17');
INSERT INTO `locales_source` VALUES ('1156',' includes/form.inc:2458','default','Initializing.','6.17');
INSERT INTO `locales_source` VALUES ('1157',' includes/form.inc:2459','default','Remaining @remaining of @total.','6.17');
INSERT INTO `locales_source` VALUES ('1158',' includes/form.inc:2460','default','An error has occurred.','6.17');
INSERT INTO `locales_source` VALUES ('1159',' includes/form.inc:2533','default','Please continue to <a href=\"@error_url\">the error page</a>','6.17');
INSERT INTO `locales_source` VALUES ('1160',' includes/batch.inc:100','default','HTTP POST is required.','none');
INSERT INTO `locales_source` VALUES ('1161',' includes/common.inc:1289','default','0 sec','6.17');
INSERT INTO `locales_source` VALUES ('1162',' includes/locale.inc:680,681','default','The translation import of %filename failed.','none');
INSERT INTO `locales_source` VALUES ('1163',' includes/common.inc:2684','default','Cron has been running for more than an hour and is most likely stuck.','none');
INSERT INTO `locales_source` VALUES ('1164',' includes/common.inc:2691','default','Attempting to re-run cron while it is already running.','none');
INSERT INTO `locales_source` VALUES ('1165',' includes/common.inc:2706','default','Cron run completed.','none');
INSERT INTO `locales_source` VALUES ('1166',' includes/locale.inc:620','default','Already added languages','6.17');
INSERT INTO `locales_source` VALUES ('1167',' includes/locale.inc:164,730','default','Language name','none');
INSERT INTO `locales_source` VALUES ('1168',' includes/locale.inc:2371','default','Catalan','6.17');
INSERT INTO `locales_source` VALUES ('1169',' includes/common.inc:387','default','The requested page could not be found.','6.17');
INSERT INTO `locales_source` VALUES ('1170',' includes/actions.inc:353','default','Removed orphaned action \'%action\' from database.','none');
INSERT INTO `locales_source` VALUES ('1171',' includes/actions.inc:359','default','One orphaned action (%orphans) exists in the actions table. !link','none');
INSERT INTO `locales_source` VALUES ('1172',' includes/actions.inc:359','default','@count orphaned actions (%orphans) exist in the actions table. !link','none');
INSERT INTO `locales_source` VALUES ('1173',' includes/common.inc:359','default','Site off-line','none');
INSERT INTO `locales_source` VALUES ('1174',' includes/common.inc:1257','default','@size @suffix','6.17');
INSERT INTO `locales_source` VALUES ('1175',' includes/common.inc:2722','default','Cron run exceeded the time limit and was aborted.','none');
INSERT INTO `locales_source` VALUES ('1176',' includes/common.inc:1248','default','1 byte','none');
INSERT INTO `locales_source` VALUES ('1177',' includes/common.inc:1248','default','@count bytes','6.17');
INSERT INTO `locales_source` VALUES ('1178',' includes/database.pgsql.inc:23','default','PostgreSQL database','none');
INSERT INTO `locales_source` VALUES ('1179',' includes/database.pgsql.inc:29','default','Your PostgreSQL Server is too old. Drupal requires at least PostgreSQL %version.','none');
INSERT INTO `locales_source` VALUES ('1180',' includes/database.pgsql.inc:406','default','Your PostgreSQL database is set up with the wrong character encoding (%encoding). It is possible it will not work as expected. It is advised to recreate it with UTF-8/Unicode encoding. More information can be found in the <a href=\"@url\">PostgreSQL documentation</a>.','none');
INSERT INTO `locales_source` VALUES ('1181',' includes/file.inc:104','default','The directory %directory has been created.','6.17');
INSERT INTO `locales_source` VALUES ('1182',' includes/file.inc:118','default','The permissions of directory %directory have been changed to make it writable.','none');
INSERT INTO `locales_source` VALUES ('1183',' includes/form.inc:691','default','!name cannot be longer than %max characters but is currently %length characters long.','none');
INSERT INTO `locales_source` VALUES ('1184',' includes/image.gd.inc:18','default','GD2 image manipulation toolkit','none');
INSERT INTO `locales_source` VALUES ('1185',' includes/image.gd.inc:28','default','The GD toolkit is installed and working properly.','none');
INSERT INTO `locales_source` VALUES ('1186',' includes/image.gd.inc:34','default','Define the image quality for JPEG manipulations. Ranges from 0 to 100. Higher values mean better image quality but bigger files.','none');
INSERT INTO `locales_source` VALUES ('1187',' includes/image.gd.inc:45','default','The GD image toolkit requires that the GD module for PHP be installed and configured properly. For more information see <a href=\"@url\">PHP\'s image documentation</a>.','none');
INSERT INTO `locales_source` VALUES ('1188',' includes/image.gd.inc:57','default','JPEG quality must be a number between 0 and 100.','none');
INSERT INTO `locales_source` VALUES ('1189',' includes/locale.inc:51,282','default','Right to left','none');
INSERT INTO `locales_source` VALUES ('1190',' includes/locale.inc:51,282','default','Left to right','6.17');
INSERT INTO `locales_source` VALUES ('1191',' includes/locale.inc:160','default','Predefined language','none');
INSERT INTO `locales_source` VALUES ('1192',' includes/locale.inc:167','default','Select the desired language and click the <em>Add language</em> button. (Use the <em>Custom language</em> options if your desired language does not appear in this list.)','none');
INSERT INTO `locales_source` VALUES ('1193',' includes/locale.inc:179','default','Custom language','none');
INSERT INTO `locales_source` VALUES ('1194',' includes/locale.inc:186','default','Add custom language','none');
INSERT INTO `locales_source` VALUES ('1195',' includes/locale.inc:206','default','Save language','none');
INSERT INTO `locales_source` VALUES ('1196',' includes/locale.inc:248','default','<a href=\"@rfc4646\">RFC 4646</a> compliant language identifier. Language codes typically use a country code, and optionally, a script or regional variant name. <em>Examples: \"en\", \"en-US\" and \"zh-Hant\".</em>','none');
INSERT INTO `locales_source` VALUES ('1197',' includes/locale.inc:252','default','Language name in English','none');
INSERT INTO `locales_source` VALUES ('1198',' includes/locale.inc:256','default','Name of the language in English. Will be available for translation in all languages.','none');
INSERT INTO `locales_source` VALUES ('1199',' includes/locale.inc:259','default','Native language name','none');
INSERT INTO `locales_source` VALUES ('1200',' includes/locale.inc:263','default','Name of the language in the language being added.','none');
INSERT INTO `locales_source` VALUES ('1201',' includes/locale.inc:269','default','Language code or other custom string for pattern matching within the path. With language negotiation set to <em>Path prefix only</em> or <em>Path prefix with language fallback</em>, this site is presented in this language when the Path prefix value matches an element in the path. For the default language, this value may be left blank. <strong>Modifying this value will break existing URLs and should be used with caution in a production environment.</strong> <em>Example: Specifying \"deutsch\" as the path prefix for German results in URLs in the form \"www.example.com/deutsch/node\".</em>','none');
INSERT INTO `locales_source` VALUES ('1202',' includes/locale.inc:272','default','Language domain','none');
INSERT INTO `locales_source` VALUES ('1203',' includes/locale.inc:275','default','Language-specific URL, with protocol. With language negotiation set to <em>Domain name only</em>, the site is presented in this language when the URL accessing the site references this domain. For the default language, this value may be left blank. <strong>This value must include a protocol as part of the string.</strong> <em>Example: Specifying \"http://example.de\" or \"http://de.example.com\" as language domains for German results in URLs in the forms \"http://example.de/node\" and \"http://de.example.com/node\", respectively.</em>','none');
INSERT INTO `locales_source` VALUES ('1204',' includes/locale.inc:280','default','Direction that text in this language is presented.','none');
INSERT INTO `locales_source` VALUES ('1205',' includes/locale.inc:294','default','The language %language (%code) already exists.','none');
INSERT INTO `locales_source` VALUES ('1206',' includes/locale.inc:301','default','Invalid language code.','none');
INSERT INTO `locales_source` VALUES ('1207',' includes/locale.inc:318,324','default','The language %language has been created and can now be used. More information is ava